/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pdf.image;

import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;
import org.apache.pdfbox.contentstream.PDFGraphicsStreamEngine;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.filter.MissingImageReaderException;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.graphics.color.PDPattern;
import org.apache.pdfbox.pdmodel.graphics.form.PDTransparencyGroup;
import org.apache.pdfbox.pdmodel.graphics.image.PDImage;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDAbstractPattern;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDTilingPattern;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.pdmodel.graphics.state.PDSoftMask;
import org.apache.pdfbox.pdmodel.graphics.state.RenderingMode;
import org.apache.pdfbox.tools.imageio.ImageIOUtil;
import org.apache.pdfbox.util.Matrix;
import org.apache.pdfbox.util.Vector;
import org.apache.tika.exception.TikaException;
import org.apache.tika.exception.TikaMemoryLimitException;
import org.apache.tika.exception.ZeroByteFileException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.io.BoundedInputStream;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.metadata.TikaPagedText;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.pdf.PDFParserConfig;
import org.apache.tika.parser.pdf.PDMetadataExtractor;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ImageGraphicsEngine
extends PDFGraphicsStreamEngine {
    protected static final long MAX_IMAGE_LENGTH_BYTES = 0x6400000L;
    protected static final List<String> JPEG = Arrays.asList(COSName.DCT_DECODE.getName(), COSName.DCT_DECODE_ABBREVIATION.getName());
    protected static final List<String> JP2 = Collections.singletonList(COSName.JPX_DECODE.getName());
    protected static final List<String> JB2 = Collections.singletonList(COSName.JBIG2_DECODE.getName());
    final List<IOException> exceptions = new ArrayList<IOException>();
    protected final int pageNumber;
    protected final EmbeddedDocumentExtractor embeddedDocumentExtractor;
    protected final PDFParserConfig pdfParserConfig;
    protected final Map<COSStream, Integer> processedInlineImages;
    protected final AtomicInteger imageCounter;
    protected final Metadata parentMetadata;
    protected final XHTMLContentHandler xhtml;
    protected final ParseContext parseContext;
    protected final boolean extractInlineImageMetadataOnly;
    protected boolean useDirectJPEG = false;

    protected ImageGraphicsEngine(PDPage page, int pageNumber, EmbeddedDocumentExtractor embeddedDocumentExtractor, PDFParserConfig pdfParserConfig, Map<COSStream, Integer> processedInlineImages, AtomicInteger imageCounter, XHTMLContentHandler xhtml, Metadata parentMetadata, ParseContext parseContext) {
        super(page);
        this.pageNumber = pageNumber;
        this.embeddedDocumentExtractor = embeddedDocumentExtractor;
        this.pdfParserConfig = pdfParserConfig;
        this.processedInlineImages = processedInlineImages;
        this.imageCounter = imageCounter;
        this.xhtml = xhtml;
        this.parentMetadata = parentMetadata;
        this.parseContext = parseContext;
        this.extractInlineImageMetadataOnly = pdfParserConfig.isExtractInlineImageMetadataOnly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferedImage writeToBuffer(PDImage pdImage, String suffix, boolean directJPEG, OutputStream out) throws IOException, TikaException {
        if ("jpg".equals(suffix)) {
            String colorSpaceName = pdImage.getColorSpace().getName();
            if (directJPEG || PDDeviceGray.INSTANCE.getName().equals(colorSpaceName) || PDDeviceRGB.INSTANCE.getName().equals(colorSpaceName)) {
                InputStream data = pdImage.createInputStream(JPEG);
                try {
                    ImageGraphicsEngine.copyUpToMaxLength(data, out);
                }
                finally {
                    IOUtils.closeQuietly(data);
                }
                return null;
            }
            BufferedImage image = pdImage.getImage();
            if (image != null) {
                ImageIOUtil.writeImage(image, suffix, out);
            }
            return image;
        }
        if ("jp2".equals(suffix)) {
            String colorSpaceName = pdImage.getColorSpace().getName();
            if (directJPEG || !ImageGraphicsEngine.hasMasks(pdImage) && (PDDeviceGray.INSTANCE.getName().equals(colorSpaceName) || PDDeviceRGB.INSTANCE.getName().equals(colorSpaceName))) {
                InputStream data = pdImage.createInputStream(JP2);
                try {
                    ImageGraphicsEngine.copyUpToMaxLength(data, out);
                }
                finally {
                    IOUtils.closeQuietly(data);
                }
                return null;
            }
            BufferedImage image = pdImage.getImage();
            if (image != null) {
                ImageIOUtil.writeImage(image, "jpeg2000", out);
            }
            return image;
        }
        if ("tif".equals(suffix) && pdImage.getColorSpace().equals(PDDeviceGray.INSTANCE)) {
            BufferedImage image = pdImage.getImage();
            if (image == null) {
                return null;
            }
            int w = image.getWidth();
            int h = image.getHeight();
            BufferedImage bitonalImage = new BufferedImage(w, h, 12);
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    bitonalImage.setRGB(x, y, image.getRGB(x, y));
                }
            }
            ImageIOUtil.writeImage(bitonalImage, suffix, out);
            return image;
        }
        if ("jb2".equals(suffix)) {
            InputStream data = pdImage.createInputStream(JB2);
            try {
                ImageGraphicsEngine.copyUpToMaxLength(data, out);
            }
            finally {
                IOUtils.closeQuietly(data);
            }
        } else {
            BufferedImage image = pdImage.getImage();
            if (image == null) {
                return null;
            }
            ImageIOUtil.writeImage(image, suffix, out);
            return image;
        }
        out.flush();
        return null;
    }

    protected static void copyUpToMaxLength(InputStream is, OutputStream os) throws IOException, TikaException {
        BoundedInputStream bis = new BoundedInputStream(0x6400000L, is);
        IOUtils.copy((InputStream)bis, os);
        if (bis.hasHitBound()) {
            throw new TikaMemoryLimitException("Image size is larger than allowed (104857600)");
        }
    }

    protected static boolean hasMasks(PDImage pdImage) throws IOException {
        if (pdImage instanceof PDImageXObject) {
            PDImageXObject ximg = (PDImageXObject)pdImage;
            return ximg.getMask() != null || ximg.getSoftMask() != null;
        }
        return false;
    }

    public void run() throws IOException {
        PDPage page = this.getPage();
        this.processPage(page);
        PDResources res = page.getResources();
        if (res == null) {
            return;
        }
        for (COSName name : res.getExtGStateNames()) {
            PDSoftMask softMask;
            PDExtendedGraphicsState extendedGraphicsState = res.getExtGState(name);
            if (extendedGraphicsState == null || (softMask = extendedGraphicsState.getSoftMask()) == null) continue;
            try {
                PDTransparencyGroup group = softMask.getGroup();
                if (group == null) continue;
                res.getExtGState(name).copyIntoGraphicsState(this.getGraphicsState());
                this.processSoftMask(group);
            }
            catch (IOException e) {
                this.handleCatchableIOE(e);
            }
        }
    }

    @Override
    public void drawImage(PDImage pdImage) throws IOException {
        int imageNumber = 0;
        if (pdImage instanceof PDImageXObject) {
            PDImageXObject xobject;
            Integer cachedNumber;
            if (pdImage.isStencil()) {
                this.processColor(this.getGraphicsState().getNonStrokingColor());
            }
            if ((cachedNumber = this.processedInlineImages.get((xobject = (PDImageXObject)pdImage).getCOSObject())) != null && this.pdfParserConfig.isExtractUniqueInlineImagesOnly()) {
                return;
            }
            if (cachedNumber == null) {
                imageNumber = this.imageCounter.getAndIncrement();
                this.processedInlineImages.put(xobject.getCOSObject(), imageNumber);
            }
        } else {
            imageNumber = this.imageCounter.getAndIncrement();
        }
        try {
            this.processImage(pdImage, imageNumber);
        }
        catch (TikaException | SAXException e) {
            throw new IOException(e);
        }
        catch (IOException e) {
            this.handleCatchableIOE(e);
        }
    }

    @Override
    public void appendRectangle(Point2D p0, Point2D p1, Point2D p2, Point2D p3) throws IOException {
    }

    @Override
    public void clip(int windingRule) throws IOException {
    }

    @Override
    public void moveTo(float x, float y) throws IOException {
    }

    @Override
    public void lineTo(float x, float y) throws IOException {
    }

    @Override
    public void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) throws IOException {
    }

    @Override
    public Point2D getCurrentPoint() throws IOException {
        return new Point2D.Float(0.0f, 0.0f);
    }

    @Override
    public void closePath() throws IOException {
    }

    @Override
    public void endPath() throws IOException {
    }

    @Override
    protected void showGlyph(Matrix textRenderingMatrix, PDFont font, int code, String unicode, Vector displacement) throws IOException {
        RenderingMode renderingMode = this.getGraphicsState().getTextState().getRenderingMode();
        if (renderingMode.isFill()) {
            this.processColor(this.getGraphicsState().getNonStrokingColor());
        }
        if (renderingMode.isStroke()) {
            this.processColor(this.getGraphicsState().getStrokingColor());
        }
    }

    @Override
    public void strokePath() throws IOException {
        this.processColor(this.getGraphicsState().getStrokingColor());
    }

    @Override
    public void fillPath(int windingRule) throws IOException {
        this.processColor(this.getGraphicsState().getNonStrokingColor());
    }

    @Override
    public void fillAndStrokePath(int windingRule) throws IOException {
        this.processColor(this.getGraphicsState().getNonStrokingColor());
    }

    @Override
    public void shadingFill(COSName shadingName) throws IOException {
    }

    private void processColor(PDColor color) throws IOException {
        PDPattern pattern;
        PDAbstractPattern abstractPattern;
        if (color.getColorSpace() instanceof PDPattern && (abstractPattern = (pattern = (PDPattern)color.getColorSpace()).getPattern(color)) instanceof PDTilingPattern) {
            this.processTilingPattern((PDTilingPattern)abstractPattern, null, null);
        }
    }

    protected void processImage(PDImage pdImage, int imageNumber) throws IOException, TikaException, SAXException {
        Metadata metadata = new Metadata();
        String suffix = this.getSuffix(pdImage, metadata);
        String fileName = "image" + imageNumber + "." + suffix;
        AttributesImpl attr = new AttributesImpl();
        attr.addAttribute("", "src", "src", "CDATA", "embedded:" + fileName);
        attr.addAttribute("", "alt", "alt", "CDATA", fileName);
        this.xhtml.startElement("img", attr);
        this.xhtml.endElement("img");
        metadata.set("resourceName", fileName);
        metadata.set(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE, TikaCoreProperties.EmbeddedResourceType.INLINE.toString());
        metadata.set(TikaPagedText.PAGE_NUMBER, this.pageNumber);
        if (this.extractInlineImageMetadataOnly) {
            this.extractInlineImageMetadataOnly(pdImage, metadata);
            return;
        }
        if (this.embeddedDocumentExtractor.shouldParseEmbedded(metadata)) {
            UnsynchronizedByteArrayOutputStream buffer = new UnsynchronizedByteArrayOutputStream();
            if (pdImage instanceof PDImageXObject) {
                PDMetadataExtractor.extract(((PDImageXObject)pdImage).getMetadata(), metadata, this.parseContext);
            }
            BufferedImage bufferedImage = null;
            try {
                bufferedImage = this.writeToBuffer(pdImage, suffix, this.useDirectJPEG, (OutputStream)buffer);
            }
            catch (MissingImageReaderException e) {
                EmbeddedDocumentUtil.recordException((Throwable)e, (Metadata)this.parentMetadata);
                return;
            }
            catch (IOException e) {
                EmbeddedDocumentUtil.recordEmbeddedStreamException((Throwable)e, (Metadata)metadata);
                return;
            }
            try (TikaInputStream tis = TikaInputStream.get((byte[])buffer.toByteArray());){
                if (bufferedImage != null) {
                    tis.setOpenContainer((Object)bufferedImage);
                }
                this.embeddedDocumentExtractor.parseEmbedded((InputStream)tis, (ContentHandler)new EmbeddedContentHandler((ContentHandler)this.xhtml), metadata, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extractInlineImageMetadataOnly(PDImage pdImage, Metadata metadata) throws IOException, SAXException {
        if (pdImage instanceof PDImageXObject) {
            PDMetadataExtractor.extract(((PDImageXObject)pdImage).getMetadata(), metadata, this.parseContext);
        }
        metadata.set(Metadata.IMAGE_WIDTH, pdImage.getWidth());
        metadata.set(Metadata.IMAGE_LENGTH, pdImage.getHeight());
        ZeroByteFileException.IgnoreZeroByteFileException before = (ZeroByteFileException.IgnoreZeroByteFileException)this.parseContext.get(ZeroByteFileException.IgnoreZeroByteFileException.class);
        try {
            this.parseContext.set(ZeroByteFileException.IgnoreZeroByteFileException.class, (Object)ZeroByteFileException.IGNORE_ZERO_BYTE_FILE_EXCEPTION);
            this.embeddedDocumentExtractor.parseEmbedded((InputStream)TikaInputStream.get((byte[])new byte[0]), (ContentHandler)new EmbeddedContentHandler((ContentHandler)this.xhtml), metadata, false);
        }
        finally {
            this.parseContext.set(ZeroByteFileException.IgnoreZeroByteFileException.class, (Object)before);
        }
    }

    protected String getSuffix(PDImage pdImage, Metadata metadata) throws IOException {
        String suffix = pdImage.getSuffix();
        if (suffix == null || suffix.equals("png")) {
            metadata.set("Content-Type", "image/png");
            suffix = "png";
        } else if (suffix.equals("jpg")) {
            metadata.set("Content-Type", "image/jpeg");
        } else if (suffix.equals("tiff")) {
            metadata.set("Content-Type", "image/tiff");
            suffix = "tif";
        } else if (suffix.equals("jpx")) {
            metadata.set("Content-Type", "image/jp2");
            suffix = "jp2";
        } else if (suffix.equals("jb2")) {
            metadata.set("Content-Type", "image/x-jbig2");
        }
        if (ImageGraphicsEngine.hasMasks(pdImage)) {
            suffix = "png";
        }
        return suffix;
    }

    protected void handleCatchableIOE(IOException e) throws IOException {
        String msg;
        if (this.pdfParserConfig.isCatchIntermediateIOExceptions()) {
            if (e.getCause() instanceof SAXException && e.getCause().getMessage() != null && e.getCause().getMessage().contains("Your document contained more than")) {
                throw e;
            }
            msg = e.getMessage();
            if (msg == null) {
                msg = "IOException, no message";
            }
        } else {
            throw e;
        }
        this.parentMetadata.add(TikaCoreProperties.TIKA_META_EXCEPTION_WARNING, msg);
        this.exceptions.add(e);
    }

    public List<IOException> getExceptions() {
        return this.exceptions;
    }
}

