/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.geo;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.TokenNameFinderModel;
import org.apache.tika.config.Field;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.geo.GeoParserConfig;
import org.apache.tika.parser.geo.GeoTag;
import org.apache.tika.parser.geo.NameEntityExtractor;
import org.apache.tika.parser.geo.gazetteer.GeoGazetteerClient;
import org.apache.tika.parser.geo.gazetteer.Location;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class GeoParser
extends AbstractParser {
    private static final long serialVersionUID = -2241391757440215491L;
    private static final Logger LOG = LoggerFactory.getLogger(GeoParser.class);
    private static final MediaType MEDIA_TYPE = MediaType.application((String)"geotopic");
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MEDIA_TYPE);
    private GeoParserConfig defaultConfig = new GeoParserConfig();
    private GeoGazetteerClient gazetteerClient;
    private boolean initialized;
    private URL modelUrl;
    private NameFinderME nameFinder;
    private boolean available;

    public Set<MediaType> getSupportedTypes(ParseContext parseContext) {
        return SUPPORTED_TYPES;
    }

    public void initialize(GeoParserConfig geoParserConfig) {
        try {
            if (this.modelUrl != null && this.modelUrl.toURI().equals(this.modelUrl.toURI())) {
                return;
            }
        }
        catch (URISyntaxException e1) {
            throw new RuntimeException(e1.getMessage());
        }
        this.modelUrl = geoParserConfig.getNerModelUrl();
        this.gazetteerClient = new GeoGazetteerClient(geoParserConfig);
        boolean bl = this.available = this.modelUrl != null && this.gazetteerClient.checkAvail();
        if (this.available) {
            try {
                TokenNameFinderModel model = new TokenNameFinderModel(this.modelUrl);
                this.nameFinder = new NameFinderME(model);
            }
            catch (Exception e) {
                LOG.warn("Named Entity Extractor setup failed: {}", (Object)e.getMessage(), (Object)e);
                this.available = false;
            }
        }
        this.initialized = true;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        GeoParserConfig geoParserConfig = (GeoParserConfig)context.get(GeoParserConfig.class, (Object)this.defaultConfig);
        this.initialize(geoParserConfig);
        if (!this.isAvailable(geoParserConfig)) {
            return;
        }
        NameEntityExtractor extractor = null;
        try {
            extractor = new NameEntityExtractor(this.nameFinder);
        }
        catch (Exception e) {
            LOG.warn("Named Entity Extractor setup failed: {}", (Object)e.getMessage(), (Object)e);
            return;
        }
        extractor.getAllNameEntitiesfromInput(stream);
        extractor.getBestNameEntity();
        ArrayList<String> locationNameEntities = extractor.locationNameEntities;
        String bestner = extractor.bestNameEntity;
        Map<String, List<Location>> resolvedGeonames = this.searchGeoNames(locationNameEntities);
        GeoTag geotag = new GeoTag();
        geotag.toGeoTag(resolvedGeonames, bestner);
        metadata.add("Geographic_NAME", geotag.location.getName());
        metadata.add("Geographic_LONGITUDE", geotag.location.getLongitude());
        metadata.add("Geographic_LATITUDE", geotag.location.getLatitude());
        for (int i = 0; i < geotag.alternatives.size(); ++i) {
            GeoTag alter = geotag.alternatives.get(i);
            metadata.add("Optional_NAME" + (i + 1), alter.location.getName());
            metadata.add("Optional_LONGITUDE" + (i + 1), alter.location.getLongitude());
            metadata.add("Optional_LATITUDE" + (i + 1), alter.location.getLatitude());
        }
    }

    public Map<String, List<Location>> searchGeoNames(ArrayList<String> locationNameEntities) {
        return this.gazetteerClient.getLocations(locationNameEntities);
    }

    public boolean isAvailable(GeoParserConfig geoParserConfig) {
        if (!this.initialized) {
            this.initialize(geoParserConfig);
        }
        return this.available;
    }

    public String getGazetteerRestEndpoint() {
        return this.defaultConfig.getGazetteerRestEndpoint();
    }

    @Field
    public void setGazetteerRestEndpoint(String gazetteerRestEndpoint) {
        this.defaultConfig.setGazetteerRestEndpoint(gazetteerRestEndpoint);
    }

    public URL getNerModelUrl() {
        return this.defaultConfig.getNerModelUrl();
    }

    @Field
    public void setNerModelUrl(String nerModelUrl) {
        try {
            this.defaultConfig.setNerModelUrl(new URL(nerModelUrl));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("malformed url " + nerModelUrl, e);
        }
    }
}

