/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.eval.core.tokens;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.UAX29URLEmailTokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class URLEmailNormalizingFilterFactory
extends TokenFilterFactory {
    public static final String URL = "___url___";
    public static final String EMAIL = "___email___";
    private static final char[] URL_CHARS = "___url___".toCharArray();
    private static final char[] EMAIL_CHARS = "___email___".toCharArray();

    public URLEmailNormalizingFilterFactory(Map<String, String> args) {
        super(args);
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        return new URLEmailFilter(tokenStream);
    }

    private static class URLEmailFilter
    extends TokenFilter {
        private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
        private final TypeAttribute typeAtt = this.addAttribute(TypeAttribute.class);

        protected URLEmailFilter(TokenStream input) {
            super(input);
        }

        @Override
        public boolean incrementToken() throws IOException {
            if (!this.input.incrementToken()) {
                return false;
            }
            if (this.typeAtt.type() == UAX29URLEmailTokenizer.TOKEN_TYPES[7]) {
                this.termAtt.copyBuffer(URL_CHARS, 0, URL_CHARS.length);
                this.termAtt.setLength(URL_CHARS.length);
            } else if (this.typeAtt.type() == UAX29URLEmailTokenizer.TOKEN_TYPES[8]) {
                this.termAtt.copyBuffer(EMAIL_CHARS, 0, EMAIL_CHARS.length);
                this.termAtt.setLength(EMAIL_CHARS.length);
            }
            return true;
        }
    }
}

