/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.eval.core.textstats;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.tika.eval.core.textstats.TokenCountStatsCalculator;
import org.apache.tika.eval.core.tokens.TokenCounts;

public class TextProfileSignature
implements TokenCountStatsCalculator<String> {
    int minTokenLength = 2;
    float quantRate = 0.01f;
    boolean secondaryLexicographicSorting = true;
    Base32 base32 = new Base32();

    @Override
    public String calculate(TokenCounts tokenCounts) {
        int maxFreq = -1;
        for (Map.Entry<String, MutableInt> e : tokenCounts.getTokens().entrySet()) {
            if (e.getKey().length() < this.minTokenLength || e.getValue().intValue() <= maxFreq) continue;
            maxFreq = e.getValue().intValue();
        }
        int quant = Math.round((float)maxFreq * this.quantRate);
        if (quant < 2) {
            quant = maxFreq > 1 ? 2 : 1;
        }
        ArrayList<Token> profile = new ArrayList<Token>();
        for (Map.Entry<String, MutableInt> e : tokenCounts.getTokens().entrySet()) {
            int quantCnt;
            String token = e.getKey();
            if (token.length() < this.minTokenLength || (quantCnt = e.getValue().intValue() / quant * quant) < quant) continue;
            profile.add(new Token(e.getValue().intValue() / quant * quant, e.getKey()));
        }
        profile.sort(new TokenComparator());
        StringBuffer newText = new StringBuffer();
        int i = 0;
        for (Token t : profile) {
            if (i++ > 0) {
                newText.append("\n");
            }
            newText.append(t.val);
        }
        return this.base32.encodeAsString(DigestUtils.sha256(newText.toString()));
    }

    public void setMinTokenLength(int minTokenLength) {
        this.minTokenLength = minTokenLength;
    }

    public void setQuantRate(float quantRate) {
        this.quantRate = quantRate;
    }

    private class TokenComparator
    implements Comparator<Token> {
        private TokenComparator() {
        }

        @Override
        public int compare(Token t1, Token t2) {
            int diffCnt = t2.cnt - t1.cnt;
            if (diffCnt == 0 && TextProfileSignature.this.secondaryLexicographicSorting) {
                return t1.val.compareTo(t2.val);
            }
            return diffCnt;
        }
    }

    private static class Token {
        public int cnt;
        public String val;

        public Token(int cnt, String val) {
            this.cnt = cnt;
            this.val = val;
        }

        public String toString() {
            return this.val + " " + this.cnt;
        }
    }
}

