/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.cli;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.tika.Tika;
import org.apache.tika.async.cli.TikaAsyncCLI;
import org.apache.tika.batch.BatchProcessDriverCLI;
import org.apache.tika.cli.BatchCommandLineBuilder;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.config.TikaConfigSerializer;
import org.apache.tika.detect.CompositeDetector;
import org.apache.tika.detect.Detector;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.DefaultEmbeddedStreamTranslator;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.EmbeddedStreamTranslator;
import org.apache.tika.fork.ForkParser;
import org.apache.tika.gui.TikaGUI;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.language.detect.LanguageHandler;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.serialization.JsonMetadata;
import org.apache.tika.metadata.serialization.JsonMetadataList;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MediaTypeRegistry;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.CompositeParser;
import org.apache.tika.parser.DigestingParser;
import org.apache.tika.parser.NetworkParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.ParserDecorator;
import org.apache.tika.parser.PasswordProvider;
import org.apache.tika.parser.RecursiveParserWrapper;
import org.apache.tika.parser.digestutils.CommonsDigester;
import org.apache.tika.parser.pdf.PDFParserConfig;
import org.apache.tika.sax.BasicContentHandlerFactory;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.ContentHandlerFactory;
import org.apache.tika.sax.ExpandedTitleContentHandler;
import org.apache.tika.sax.RecursiveParserWrapperHandler;
import org.apache.tika.sax.WriteOutContentHandler;
import org.apache.tika.sax.boilerpipe.BoilerpipeContentHandler;
import org.apache.tika.xmp.XMPMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TikaCLI {
    private static final Logger LOG = LoggerFactory.getLogger(TikaCLI.class);
    private final int MAX_MARK = 0x1400000;
    private final OutputType NO_OUTPUT = new OutputType(){

        @Override
        protected ContentHandler getContentHandler(OutputStream output, Metadata metadata) {
            return new DefaultHandler();
        }
    };
    private final OutputType XML = new OutputType(){

        @Override
        protected ContentHandler getContentHandler(OutputStream output, Metadata metadata) throws Exception {
            return TikaCLI.getTransformerHandler(output, "xml", TikaCLI.this.encoding, TikaCLI.this.prettyPrint);
        }
    };
    private File extractDir = new File(".");
    private ParseContext context;
    private Detector detector;
    private Parser parser;
    private TikaConfig config;
    private String configFilePath;
    private OutputType type = this.XML;
    private boolean recursiveJSON = false;
    private URI networkURI = null;
    private String encoding = null;
    private final OutputType TEXT = new OutputType(){

        @Override
        protected ContentHandler getContentHandler(OutputStream output, Metadata metadata) throws Exception {
            return new BodyContentHandler(TikaCLI.getOutputWriter(output, TikaCLI.this.encoding));
        }
    };
    private final OutputType TEXT_MAIN = new OutputType(){

        @Override
        protected ContentHandler getContentHandler(OutputStream output, Metadata metadata) throws Exception {
            return new BoilerpipeContentHandler(TikaCLI.getOutputWriter(output, TikaCLI.this.encoding));
        }
    };
    private final OutputType TEXT_ALL = new OutputType(){

        @Override
        protected ContentHandler getContentHandler(OutputStream output, Metadata metadata) throws Exception {
            return new WriteOutContentHandler(TikaCLI.getOutputWriter(output, TikaCLI.this.encoding));
        }
    };
    private final OutputType METADATA = new OutputType(){

        @Override
        protected ContentHandler getContentHandler(OutputStream output, Metadata metadata) throws Exception {
            PrintWriter writer = new PrintWriter(TikaCLI.getOutputWriter(output, TikaCLI.this.encoding));
            return new NoDocumentMetHandler(metadata, writer);
        }
    };
    private final OutputType JSON = new OutputType(){

        @Override
        protected ContentHandler getContentHandler(OutputStream output, Metadata metadata) throws Exception {
            PrintWriter writer = new PrintWriter(TikaCLI.getOutputWriter(output, TikaCLI.this.encoding));
            return new NoDocumentJSONMetHandler(metadata, writer);
        }
    };
    private final OutputType XMP = new OutputType(){

        @Override
        protected ContentHandler getContentHandler(OutputStream output, Metadata metadata) throws Exception {
            PrintWriter writer = new PrintWriter(TikaCLI.getOutputWriter(output, TikaCLI.this.encoding));
            return new NoDocumentXMPMetaHandler(metadata, writer);
        }
    };
    private final OutputType LANGUAGE = new OutputType(){

        @Override
        protected ContentHandler getContentHandler(OutputStream output, Metadata metadata) throws Exception {
            final PrintWriter writer = new PrintWriter(TikaCLI.getOutputWriter(output, TikaCLI.this.encoding));
            return new LanguageHandler(){

                @Override
                public void endDocument() {
                    writer.println(this.getLanguage().getLanguage());
                    writer.flush();
                }
            };
        }
    };
    private final OutputType DETECT = new OutputType(){

        @Override
        public void process(InputStream stream, OutputStream output, Metadata metadata) throws Exception {
            PrintWriter writer = new PrintWriter(TikaCLI.getOutputWriter(output, TikaCLI.this.encoding));
            writer.println(TikaCLI.this.detector.detect(stream, metadata).toString());
            writer.flush();
        }
    };
    private String password = System.getenv("TIKA_PASSWORD");
    private DigestingParser.Digester digester = null;
    private boolean asyncMode = false;
    private boolean pipeMode = true;
    private boolean fork = false;
    private boolean prettyPrint;
    private final OutputType HTML = new OutputType(){

        @Override
        protected ContentHandler getContentHandler(OutputStream output, Metadata metadata) throws Exception {
            return new ExpandedTitleContentHandler(TikaCLI.getTransformerHandler(output, "html", TikaCLI.this.encoding, TikaCLI.this.prettyPrint));
        }
    };

    public TikaCLI() {
        this.context = new ParseContext();
    }

    public static void main(String[] args) throws Exception {
        TikaCLI cli = new TikaCLI();
        if (cli.testForHelp(args)) {
            cli.usage();
            return;
        }
        if (cli.testForBatch(args)) {
            String[] batchArgs = BatchCommandLineBuilder.build(args);
            BatchProcessDriverCLI batchDriver = new BatchProcessDriverCLI(batchArgs);
            batchDriver.execute();
            return;
        }
        if (cli.testForAsync(args)) {
            TikaCLI.async(args);
            return;
        }
        if (args.length > 0) {
            for (String arg : args) {
                cli.process(arg);
            }
            if (cli.pipeMode) {
                cli.process("-");
            }
        } else {
            if (System.in.available() == 0) {
                Thread.sleep(100L);
            }
            if (System.in.available() > 0) {
                cli.process("-");
            } else {
                cli.process("--gui");
            }
        }
    }

    private static void async(String[] args) throws Exception {
        String tikaConfigPath = "";
        String config = "--config=";
        for (String arg : args) {
            if (!arg.startsWith(config)) continue;
            tikaConfigPath = arg.substring(config.length());
        }
        TikaAsyncCLI.main(new String[]{tikaConfigPath});
    }

    private static Writer getOutputWriter(OutputStream output, String encoding) throws UnsupportedEncodingException {
        if (encoding != null) {
            return new OutputStreamWriter(output, encoding);
        }
        return new OutputStreamWriter(output, StandardCharsets.UTF_8);
    }

    private static TransformerHandler getTransformerHandler(OutputStream output, String method, String encoding, boolean prettyPrint) throws TransformerConfigurationException {
        SAXTransformerFactory factory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        TransformerHandler handler = factory.newTransformerHandler();
        handler.getTransformer().setOutputProperty("method", method);
        handler.getTransformer().setOutputProperty("indent", prettyPrint ? "yes" : "no");
        if (encoding != null) {
            handler.getTransformer().setOutputProperty("encoding", encoding);
        }
        handler.setResult(new StreamResult(output));
        return handler;
    }

    private boolean testForAsync(String[] args) {
        for (String arg : args) {
            if (!arg.equals("-a") && !arg.equals("--async")) continue;
            return true;
        }
        return false;
    }

    private void extractInlineImagesFromPDFs() {
        if (this.configFilePath == null && this.context.get(PDFParserConfig.class) == null) {
            PDFParserConfig pdfParserConfig = new PDFParserConfig();
            pdfParserConfig.setExtractInlineImages(true);
            String warn = "As a convenience, TikaCLI has turned on extraction of\ninline images for the PDFParser (TIKA-2374).\nAside from the -z option, this is not the default behavior\nin Tika generally or in tika-server.";
            LOG.info(warn);
            this.context.set(PDFParserConfig.class, pdfParserConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(String arg) throws Exception {
        if (arg.equals("-?") || arg.equals("--help")) {
            this.pipeMode = false;
            this.usage();
        } else if (arg.equals("-V") || arg.equals("--version")) {
            this.pipeMode = false;
            this.version();
        } else if (arg.equals("-v") || arg.equals("--verbose")) {
            Configurator.setRootLevel(Level.DEBUG);
        } else if (arg.equals("-g") || arg.equals("--gui")) {
            this.pipeMode = false;
            if (this.configFilePath != null) {
                TikaGUI.main(new String[]{this.configFilePath});
            } else {
                TikaGUI.main(new String[0]);
            }
        } else if (arg.equals("--list-parser") || arg.equals("--list-parsers")) {
            this.pipeMode = false;
            this.displayParsers(false, false);
        } else if (arg.equals("--list-detector") || arg.equals("--list-detectors")) {
            this.pipeMode = false;
            this.displayDetectors();
        } else if (arg.equals("--list-parser-detail") || arg.equals("--list-parser-details")) {
            this.pipeMode = false;
            this.displayParsers(true, false);
        } else if (arg.equals("--list-parser-detail-apt") || arg.equals("--list-parser-details-apt")) {
            this.pipeMode = false;
            this.displayParsers(true, true);
        } else if (arg.equals("--list-met-models")) {
            this.pipeMode = false;
            this.displayMetModels();
        } else if (arg.equals("--list-supported-types")) {
            this.pipeMode = false;
            this.displaySupportedTypes();
        } else if (arg.startsWith("--compare-file-magic=")) {
            this.pipeMode = false;
            this.compareFileMagic(arg.substring("--compare-file-magic=".length()));
        } else if (arg.equals("--dump-minimal-config")) {
            this.pipeMode = false;
            this.dumpConfig(TikaConfigSerializer.Mode.MINIMAL);
        } else if (arg.equals("--dump-current-config")) {
            this.pipeMode = false;
            this.dumpConfig(TikaConfigSerializer.Mode.CURRENT);
        } else if (arg.equals("--dump-static-config")) {
            this.pipeMode = false;
            this.dumpConfig(TikaConfigSerializer.Mode.STATIC);
        } else if (arg.equals("--dump-static-full-config")) {
            this.pipeMode = false;
            this.dumpConfig(TikaConfigSerializer.Mode.STATIC_FULL);
        } else if (!arg.equals("--container-aware") && !arg.equals("--container-aware-detector")) {
            if (arg.equals("-f") || arg.equals("--fork")) {
                this.fork = true;
            } else if (arg.equals("-a") || arg.equals("--async")) {
                this.asyncMode = true;
            } else if (arg.startsWith("--config=")) {
                this.configFilePath = arg.substring("--config=".length());
            } else if (arg.startsWith("--digest=")) {
                this.digester = new CommonsDigester(0x1400000, arg.substring("--digest=".length()));
            } else if (arg.startsWith("-e")) {
                this.encoding = arg.substring("-e".length());
            } else if (arg.startsWith("--encoding=")) {
                this.encoding = arg.substring("--encoding=".length());
            } else if (arg.startsWith("-p") && !arg.equals("-p")) {
                this.password = arg.substring("-p".length());
            } else if (arg.startsWith("--password=")) {
                this.password = arg.substring("--password=".length());
            } else if (arg.equals("-j") || arg.equals("--json")) {
                this.type = this.JSON;
            } else if (arg.equals("-J") || arg.equals("--jsonRecursive")) {
                this.recursiveJSON = true;
            } else if (arg.equals("-y") || arg.equals("--xmp")) {
                this.type = this.XMP;
            } else if (arg.equals("-x") || arg.equals("--xml")) {
                this.type = this.XML;
            } else if (arg.equals("-h") || arg.equals("--html")) {
                this.type = this.HTML;
            } else if (arg.equals("-t") || arg.equals("--text")) {
                this.type = this.TEXT;
            } else if (arg.equals("-T") || arg.equals("--text-main")) {
                this.type = this.TEXT_MAIN;
            } else if (arg.equals("-A") || arg.equals("--text-all")) {
                this.type = this.TEXT_ALL;
            } else if (arg.equals("-m") || arg.equals("--metadata")) {
                this.type = this.METADATA;
            } else if (arg.equals("-l") || arg.equals("--language")) {
                this.type = this.LANGUAGE;
            } else if (arg.equals("-d") || arg.equals("--detect")) {
                this.type = this.DETECT;
            } else if (arg.startsWith("--extract-dir=")) {
                String dirPath = arg.substring("--extract-dir=".length());
                if (dirPath.length() == 0) {
                    dirPath = ".";
                }
                this.extractDir = new File(dirPath);
            } else if (arg.equals("-z") || arg.equals("--extract")) {
                this.extractInlineImagesFromPDFs();
                this.type = this.NO_OUTPUT;
                this.context.set(EmbeddedDocumentExtractor.class, new FileEmbeddedDocumentExtractor());
            } else if (arg.equals("-r") || arg.equals("--pretty-print")) {
                this.prettyPrint = true;
            } else {
                if (arg.equals("-p") || arg.equals("--port") || arg.equals("-s") || arg.equals("--server")) {
                    throw new IllegalArgumentException("As of Tika 2.0, the server option is no longer supported in tika-app.\nSee https://wiki.apache.org/tika/TikaJAXRS for usage.");
                }
                if (arg.startsWith("-c")) {
                    this.networkURI = new URI(arg.substring("-c".length()));
                } else if (arg.startsWith("--client=")) {
                    this.networkURI = new URI(arg.substring("--client=".length()));
                } else {
                    this.pipeMode = false;
                    this.configure();
                    if (arg.equals("-")) {
                        try (TikaInputStream stream = TikaInputStream.get(new CloseShieldInputStream(System.in));){
                            this.type.process(stream, System.out, new Metadata());
                        }
                    }
                    File file = new File(arg);
                    URL url = file.isFile() ? file.toURI().toURL() : new URL(arg);
                    if (this.recursiveJSON) {
                        this.handleRecursiveJson(url, System.out);
                    } else {
                        Metadata metadata = new Metadata();
                        try (TikaInputStream input = TikaInputStream.get(url, metadata);){
                            this.type.process(input, System.out, metadata);
                        }
                        finally {
                            System.out.flush();
                        }
                    }
                }
            }
        }
    }

    private void dumpConfig(TikaConfigSerializer.Mode mode) throws Exception {
        this.configure();
        TikaConfig localConfig = this.config == null ? TikaConfig.getDefaultConfig() : this.config;
        TikaConfigSerializer.serialize(localConfig, mode, new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8), StandardCharsets.UTF_8);
    }

    private void handleRecursiveJson(URL url, OutputStream output) throws IOException, SAXException, TikaException {
        Metadata metadata = new Metadata();
        RecursiveParserWrapper wrapper = new RecursiveParserWrapper(this.parser);
        RecursiveParserWrapperHandler handler = new RecursiveParserWrapperHandler(this.getContentHandlerFactory(this.type), -1, this.config.getMetadataFilter());
        try (TikaInputStream input = TikaInputStream.get(url, metadata);){
            wrapper.parse(input, handler, metadata, this.context);
        }
        JsonMetadataList.setPrettyPrinting(this.prettyPrint);
        var7_7 = null;
        try (Writer writer = TikaCLI.getOutputWriter(output, this.encoding);){
            JsonMetadataList.toJson(handler.getMetadataList(), writer);
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
    }

    private ContentHandlerFactory getContentHandlerFactory(OutputType type) {
        BasicContentHandlerFactory.HANDLER_TYPE handlerType = BasicContentHandlerFactory.HANDLER_TYPE.IGNORE;
        if (type.equals(this.HTML)) {
            handlerType = BasicContentHandlerFactory.HANDLER_TYPE.HTML;
        } else if (type.equals(this.XML)) {
            handlerType = BasicContentHandlerFactory.HANDLER_TYPE.XML;
        } else if (type.equals(this.TEXT)) {
            handlerType = BasicContentHandlerFactory.HANDLER_TYPE.TEXT;
        } else if (type.equals(this.TEXT_MAIN)) {
            handlerType = BasicContentHandlerFactory.HANDLER_TYPE.BODY;
        } else if (type.equals(this.METADATA)) {
            handlerType = BasicContentHandlerFactory.HANDLER_TYPE.IGNORE;
        }
        return new BasicContentHandlerFactory(handlerType, -1);
    }

    private void usage() {
        PrintStream out = System.out;
        out.println("usage: java -jar tika-app.jar [option...] [file...]");
        out.println();
        out.println("Options:");
        out.println("    -?  or --help          Print this usage message");
        out.println("    -v  or --verbose       Print debug level messages");
        out.println("    -V  or --version       Print the Apache Tika version number");
        out.println();
        out.println("    -g  or --gui           Start the Apache Tika GUI");
        out.println("    -f  or --fork          Use Fork Mode for out-of-process extraction");
        out.println();
        out.println("    --config=<tika-config.xml>");
        out.println("        TikaConfig file. Must be specified before -g, -s, -f or the dump-x-config !");
        out.println("    --dump-minimal-config  Print minimal TikaConfig");
        out.println("    --dump-current-config  Print current TikaConfig");
        out.println("    --dump-static-config   Print static config");
        out.println("    --dump-static-full-config  Print static explicit config");
        out.println("");
        out.println("    -x  or --xml           Output XHTML content (default)");
        out.println("    -h  or --html          Output HTML content");
        out.println("    -t  or --text          Output plain text content (body)");
        out.println("    -T  or --text-main     Output plain text content (main content only via boilerpipe handler)");
        out.println("    -A  or --text-all      Output all text content");
        out.println("    -m  or --metadata      Output only metadata");
        out.println("    -j  or --json          Output metadata in JSON");
        out.println("    -y  or --xmp           Output metadata in XMP");
        out.println("    -J  or --jsonRecursive Output metadata and content from all");
        out.println("                           embedded files (choose content type");
        out.println("                           with -x, -h, -t or -m; default is -x)");
        out.println("    -a  or --async         Run Tika in async mode; must specify details in a tikaConfig file");
        out.println("    -l  or --language      Output only language");
        out.println("    -d  or --detect        Detect document type");
        out.println("           --digest=X      Include digest X (md2, md5, sha1,");
        out.println("                               sha256, sha384, sha512");
        out.println("    -eX or --encoding=X    Use output encoding X");
        out.println("    -pX or --password=X    Use document password X");
        out.println("    -z  or --extract       Extract all attachements into current directory");
        out.println("    --extract-dir=<dir>    Specify target directory for -z");
        out.println("    -r  or --pretty-print  For JSON, XML and XHTML outputs, adds newlines and");
        out.println("                           whitespace, for better readability");
        out.println();
        out.println("    --list-parsers");
        out.println("         List the available document parsers");
        out.println("    --list-parser-details");
        out.println("         List the available document parsers and their supported mime types");
        out.println("    --list-parser-details-apt");
        out.println("         List the available document parsers and their supported mime types in apt format.");
        out.println("    --list-detectors");
        out.println("         List the available document detectors");
        out.println("    --list-met-models");
        out.println("         List the available metadata models, and their supported keys");
        out.println("    --list-supported-types");
        out.println("         List all known media types and related information");
        out.println();
        out.println();
        out.println("    --compare-file-magic=<dir>");
        out.println("         Compares Tika's known media types to the File(1) tool's magic directory");
        out.println("Description:");
        out.println("    Apache Tika will parse the file(s) specified on the");
        out.println("    command line and output the extracted text content");
        out.println("    or metadata to standard output.");
        out.println();
        out.println("    Instead of a file name you can also specify the URL");
        out.println("    of a document to be parsed.");
        out.println();
        out.println("    If no file name or URL is specified (or the special");
        out.println("    name \"-\" is used), then the standard input stream");
        out.println("    is parsed. If no arguments were given and no input");
        out.println("    data is available, the GUI is started instead.");
        out.println();
        out.println("- GUI mode");
        out.println();
        out.println("    Use the \"--gui\" (or \"-g\") option to start the");
        out.println("    Apache Tika GUI. You can drag and drop files from");
        out.println("    a normal file explorer to the GUI window to extract");
        out.println("    text content and metadata from the files.");
        out.println();
        out.println("- Batch mode");
        out.println();
        out.println("    Simplest method.");
        out.println("    Specify two directories as args with no other args:");
        out.println("         java -jar tika-app.jar <inputDirectory> <outputDirectory>");
        out.println();
        out.println("Batch Options:");
        out.println("    -i  or --inputDir          Input directory");
        out.println("    -o  or --outputDir         Output directory");
        out.println("    -numConsumers              Number of processing threads");
        out.println("    -bc                        Batch config file");
        out.println("    -maxRestarts               Maximum number of times the ");
        out.println("                               watchdog process will restart the forked process.");
        out.println("    -timeoutThresholdMillis    Number of milliseconds allowed to a parse");
        out.println("                               before the process is terminated and restarted");
        out.println("    -fileList                  List of files to process, with");
        out.println("                               paths relative to the input directory");
        out.println("    -includeFilePat            Regular expression to determine which");
        out.println("                               files to process, e.g. \"(?i)\\.pdf\"");
        out.println("    -excludeFilePat            Regular expression to determine which");
        out.println("                               files to avoid processing, e.g. \"(?i)\\.pdf\"");
        out.println("    -maxFileSizeBytes          Skip files longer than this value");
        out.println();
        out.println("    Control the type of output with -x, -h, -t and/or -J.");
        out.println();
        out.println("    To modify forked process jvm args, prepend \"J\" as in:");
        out.println("    -JXmx4g or -JDlog4j.configuration=file:log4j.xml.");
    }

    private void version() {
        System.out.println(new Tika().toString());
    }

    private boolean testForHelp(String[] args) {
        for (String s2 : args) {
            if (!s2.equals("-?") && !s2.equals("--help")) continue;
            return true;
        }
        return false;
    }

    private boolean testForBatch(String[] args) {
        if (args.length == 2 && !args[0].startsWith("-") && !args[1].startsWith("-")) {
            Path inputCand = Paths.get(args[0], new String[0]);
            Path outputCand = Paths.get(args[1], new String[0]);
            if (Files.isDirectory(inputCand, new LinkOption[0]) && !Files.isRegularFile(outputCand, new LinkOption[0])) {
                return true;
            }
        }
        for (String s2 : args) {
            if (!s2.equals("-inputDir") && !s2.equals("--inputDir") && !s2.equals("-i")) continue;
            return true;
        }
        return false;
    }

    private void configure() throws TikaException, IOException, SAXException {
        if (this.networkURI != null) {
            this.parser = new NetworkParser(this.networkURI);
            this.config = TikaConfig.getDefaultConfig();
        } else {
            this.config = this.configFilePath != null ? new TikaConfig(new File(this.configFilePath)) : TikaConfig.getDefaultConfig();
            this.parser = new AutoDetectParser(this.config);
            if (this.digester != null) {
                this.parser = new DigestingParser(this.parser, this.digester);
                LOG.info("As of Tika 2.5.0, you can set the digester via the AutoDetectParserConfig in tika-config.xml. We plan to remove this commandline option in 2.7.0");
            }
        }
        this.detector = this.config.getDetector();
        this.context.set(Parser.class, this.parser);
        this.context.set(PasswordProvider.class, new SimplePasswordProvider(this.password));
    }

    private void displayMetModels() {
        Class<?>[] modelClasses = Metadata.class.getInterfaces();
        Arrays.sort(modelClasses, Comparator.comparing(Class::getName));
        for (Class<?> modelClass : modelClasses) {
            if (modelClass.getSimpleName().contains("Tika")) continue;
            System.out.println(modelClass.getSimpleName());
            Field[] keyFields = modelClass.getFields();
            Arrays.sort(keyFields, Comparator.comparing(Field::getName));
            for (Field keyField : keyFields) {
                System.out.println(" " + keyField.getName());
            }
        }
    }

    private void displayParsers(boolean includeMimeTypes, boolean aptListFormat) throws TikaException, IOException, SAXException {
        this.configure();
        this.displayParser(this.parser, includeMimeTypes, aptListFormat, 3);
    }

    private void displayParser(Parser p, boolean includeMimeTypes, boolean apt, int i) {
        String decorated = null;
        if (p instanceof ParserDecorator) {
            ParserDecorator pd = (ParserDecorator)p;
            decorated = " (Wrapped by " + pd.getDecorationName() + ")";
            p = pd.getWrappedParser();
        }
        boolean isComposite = p instanceof CompositeParser;
        String name = p.getClass().getName();
        if (apt) {
            name = name.substring(0, name.lastIndexOf(".") + 1) + "{{{./api/" + name.replace(".", "/") + "}" + name.substring(name.lastIndexOf(".") + 1) + "}}";
        } else if (decorated != null) {
            name = name + decorated;
        }
        if (apt && !isComposite || !apt) {
            System.out.println(this.indent(i) + (apt ? "* " : "") + name + (isComposite ? " (Composite Parser):" : ""));
            if (apt) {
                System.out.println();
            }
            if (includeMimeTypes && !isComposite) {
                for (MediaType mt : p.getSupportedTypes(this.context)) {
                    System.out.println(this.indent(i + 3) + (apt ? "* " : "") + mt);
                    if (!apt) continue;
                    System.out.println();
                }
            }
        }
        if (isComposite) {
            Parser[] subParsers;
            for (Parser sp : subParsers = this.sortParsers(this.invertMediaTypeMap(((CompositeParser)p).getParsers()))) {
                this.displayParser(sp, includeMimeTypes, apt, i + (apt ? 0 : 3));
            }
        }
    }

    private void displayDetectors() throws TikaException, IOException, SAXException {
        this.configure();
        this.displayDetector(this.detector, 0);
    }

    private void displayDetector(Detector d, int i) {
        boolean isComposite = d instanceof CompositeDetector;
        String name = d.getClass().getName();
        System.out.println(this.indent(i) + name + (isComposite ? " (Composite Detector):" : ""));
        if (isComposite) {
            List<Detector> subDetectors = ((CompositeDetector)d).getDetectors();
            for (Detector sd : subDetectors) {
                this.displayDetector(sd, i + 2);
            }
        }
    }

    private String indent(int indent) {
        return "                     ".substring(0, indent);
    }

    private Parser[] sortParsers(Map<Parser, Set<MediaType>> parsers) {
        Parser[] sortedParsers = parsers.keySet().toArray(new Parser[0]);
        Arrays.sort(sortedParsers, (p1, p2) -> {
            String name1 = p1.getClass().getName();
            String name2 = p2.getClass().getName();
            return name1.compareTo(name2);
        });
        return sortedParsers;
    }

    private Map<Parser, Set<MediaType>> invertMediaTypeMap(Map<MediaType, Parser> supported) {
        HashMap<Parser, Set<MediaType>> parsers = new HashMap<Parser, Set<MediaType>>();
        for (Map.Entry<MediaType, Parser> e : supported.entrySet()) {
            if (!parsers.containsKey(e.getValue())) {
                parsers.put(e.getValue(), new HashSet());
            }
            ((Set)parsers.get(e.getValue())).add(e.getKey());
        }
        return parsers;
    }

    private void displaySupportedTypes() {
        AutoDetectParser parser = new AutoDetectParser();
        MediaTypeRegistry registry = parser.getMediaTypeRegistry();
        Map<MediaType, Parser> parsers = parser.getParsers();
        for (MediaType type : registry.getTypes()) {
            Parser p;
            System.out.println(type);
            for (MediaType alias : registry.getAliases(type)) {
                System.out.println("  alias:     " + alias);
            }
            MediaType supertype = registry.getSupertype(type);
            if (supertype != null) {
                System.out.println("  supertype: " + supertype);
            }
            if ((p = parsers.get(type)) == null) continue;
            if (p instanceof CompositeParser) {
                p = ((CompositeParser)p).getParsers().get(type);
            }
            System.out.println("  parser:    " + p.getClass().getName());
        }
    }

    private void compareFileMagic(String magicDir) throws Exception {
        TreeSet<String> tikaLacking = new TreeSet<String>();
        TreeSet<String> tikaNoMagic = new TreeSet<String>();
        File dir = new File(magicDir);
        if (!(new File(dir, "elf").exists() && new File(dir, "mime").exists() && new File(dir, "vorbis").exists())) {
            throw new IllegalArgumentException(magicDir + " doesn't seem to hold uncompressed file magic entries");
        }
        HashSet<String> fileMimes = new HashSet<String>();
        for (File mf : dir.listFiles()) {
            String line;
            if (!mf.isFile()) continue;
            BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(mf), StandardCharsets.UTF_8));
            while ((line = r.readLine()) != null) {
                if (!line.startsWith("!:mime") && !line.startsWith("#!:mime")) continue;
                String mime = line.substring(7).trim();
                fileMimes.add(mime);
            }
            r.close();
        }
        TikaConfig config = TikaConfig.getDefaultConfig();
        MimeTypes mimeTypes = config.getMimeRepository();
        MediaTypeRegistry registry = config.getMediaTypeRegistry();
        for (String mime : fileMimes) {
            try {
                MimeType type = mimeTypes.getRegisteredMimeType(mime);
                if (type == null) {
                    tikaLacking.add(mime);
                    continue;
                }
                boolean hasMagic = type.hasMagic();
                if (!hasMagic) {
                    for (MediaType child : registry.getChildTypes(type.getType())) {
                        MimeType childType = mimeTypes.getRegisteredMimeType(child.toString());
                        if (childType == null || !childType.hasMagic()) continue;
                        hasMagic = true;
                    }
                }
                MimeType parentType = type;
                while (parentType != null && !hasMagic) {
                    if (parentType.hasMagic()) {
                        hasMagic = true;
                        continue;
                    }
                    MediaType parent = registry.getSupertype(type.getType());
                    if (parent == MediaType.APPLICATION_XML || parent == MediaType.TEXT_PLAIN || parent == MediaType.OCTET_STREAM) {
                        parent = null;
                    }
                    if (parent != null) {
                        parentType = mimeTypes.getRegisteredMimeType(parent.toString());
                        continue;
                    }
                    parentType = null;
                }
                if (hasMagic) continue;
                tikaNoMagic.add(mime);
            }
            catch (MimeTypeException mimeTypeException) {}
        }
        int tikaTypes = 0;
        int tikaAliases = 0;
        for (MediaType type : registry.getTypes()) {
            ++tikaTypes;
            tikaAliases += registry.getAliases(type).size();
        }
        System.out.println("Tika knows about " + tikaTypes + " unique mime types");
        System.out.println("Tika knows about " + (tikaTypes + tikaAliases) + " mime types including aliases");
        System.out.println("The File Magic directory knows about " + fileMimes.size() + " unique mime types");
        System.out.println();
        System.out.println("The following mime types are known to File but not Tika:");
        for (String mime : tikaLacking) {
            System.out.println("  " + mime);
        }
        System.out.println();
        System.out.println("The following mime types from File have no Tika magic (but their children might):");
        for (String mime : tikaNoMagic) {
            System.out.println("  " + mime);
        }
    }

    private class NoDocumentJSONMetHandler
    extends DefaultHandler {
        protected final Metadata metadata;
        protected PrintWriter writer;

        public NoDocumentJSONMetHandler(Metadata metadata, PrintWriter writer) {
            this.metadata = metadata;
            this.writer = writer;
        }

        @Override
        public void endDocument() throws SAXException {
            try {
                JsonMetadata.setPrettyPrinting(TikaCLI.this.prettyPrint);
                JsonMetadata.toJson(this.metadata, this.writer);
                this.writer.flush();
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }
    }

    private class FileEmbeddedDocumentExtractor
    implements EmbeddedDocumentExtractor {
        private final TikaConfig config = TikaConfig.getDefaultConfig();
        private final EmbeddedStreamTranslator embeddedStreamTranslator = new DefaultEmbeddedStreamTranslator();
        private int count = 0;

        private FileEmbeddedDocumentExtractor() {
        }

        @Override
        public boolean shouldParseEmbedded(Metadata metadata) {
            return true;
        }

        @Override
        public void parseEmbedded(InputStream inputStream, ContentHandler contentHandler, Metadata metadata, boolean outputHtml) throws SAXException, IOException {
            block30: {
                File parent;
                if (!inputStream.markSupported()) {
                    inputStream = TikaInputStream.get(inputStream);
                }
                MediaType contentType = TikaCLI.this.detector.detect(inputStream, metadata);
                String name = metadata.get("resourceName");
                File outputFile = null;
                if (name == null) {
                    name = "file" + this.count++;
                }
                if (!(parent = (outputFile = this.getOutputFile(name, metadata, contentType)).getParentFile()).exists() && !parent.mkdirs()) {
                    throw new IOException("unable to create directory \"" + parent + "\"");
                }
                System.out.println("Extracting '" + name + "' (" + contentType + ") to " + outputFile);
                try (FileOutputStream os = new FileOutputStream(outputFile);){
                    if (this.embeddedStreamTranslator.shouldTranslate(inputStream, metadata)) {
                        try (InputStream translated = this.embeddedStreamTranslator.translate(inputStream, metadata);){
                            IOUtils.copy(translated, (OutputStream)os);
                            break block30;
                        }
                    }
                    IOUtils.copy(inputStream, (OutputStream)os);
                }
                catch (Exception e) {
                    String msg = String.format(Locale.ROOT, "Ignoring unexpected exception trying to save embedded file %s (%s)", name, e.getMessage());
                    LOG.warn(msg, e);
                }
            }
        }

        private File getOutputFile(String name, Metadata metadata, MediaType contentType) {
            File outputFile;
            int prefixLength;
            String normalizedName;
            String relID;
            String ext = this.getExtension(contentType);
            if (name.indexOf(46) == -1 && contentType != null) {
                name = name + ext;
            }
            if ((relID = metadata.get("embeddedRelationshipId")) != null && !name.startsWith(relID)) {
                name = relID + "_" + name;
            }
            if ((normalizedName = FilenameUtils.normalize(name = name.replaceAll("\u0000", " "))) == null) {
                normalizedName = FilenameUtils.getName(name);
            }
            if (normalizedName == null) {
                normalizedName = "file" + this.count++ + ext;
            }
            if ((prefixLength = FilenameUtils.getPrefixLength(normalizedName)) > -1) {
                normalizedName = normalizedName.substring(prefixLength);
            }
            if ((outputFile = new File(TikaCLI.this.extractDir, normalizedName)).exists()) {
                String fileName = FilenameUtils.getName(normalizedName);
                outputFile = new File(TikaCLI.this.extractDir, UUID.randomUUID().toString() + "-" + fileName);
            }
            return outputFile;
        }

        private String getExtension(MediaType contentType) {
            try {
                String ext = this.config.getMimeRepository().forName(contentType.toString()).getExtension();
                if (ext == null) {
                    return ".bin";
                }
                return ext;
            }
            catch (MimeTypeException e) {
                e.printStackTrace();
                return ".bin";
            }
        }
    }

    private class OutputType {
        private OutputType() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(InputStream input, OutputStream output, Metadata metadata) throws Exception {
            Parser p = TikaCLI.this.parser;
            if (TikaCLI.this.fork) {
                p = new ForkParser(TikaCLI.class.getClassLoader(), p);
            }
            ContentHandler handler = this.getContentHandler(output, metadata);
            try {
                NoDocumentMetHandler metHandler;
                p.parse(input, handler, metadata, TikaCLI.this.context);
                if (handler instanceof NoDocumentMetHandler && !(metHandler = (NoDocumentMetHandler)handler).metOutput()) {
                    metHandler.endDocument();
                }
            }
            finally {
                if (TikaCLI.this.fork) {
                    ((ForkParser)p).close();
                }
            }
        }

        protected ContentHandler getContentHandler(OutputStream output, Metadata metadata) throws Exception {
            throw new UnsupportedOperationException();
        }
    }

    private static class SimplePasswordProvider
    implements PasswordProvider,
    Serializable {
        private final String password;

        public SimplePasswordProvider(String password) {
            this.password = password;
        }

        @Override
        public String getPassword(Metadata metadata) {
            return this.password;
        }
    }

    private static class NoDocumentXMPMetaHandler
    extends DefaultHandler {
        protected final Metadata metadata;
        protected PrintWriter writer;

        public NoDocumentXMPMetaHandler(Metadata metadata, PrintWriter writer) {
            this.metadata = metadata;
            this.writer = writer;
        }

        @Override
        public void endDocument() throws SAXException {
            try {
                XMPMetadata xmp = new XMPMetadata(this.metadata);
                String result = xmp.toString();
                this.writer.write(result);
                this.writer.flush();
            }
            catch (TikaException e) {
                throw new SAXException(e);
            }
        }
    }

    private static class NoDocumentMetHandler
    extends DefaultHandler {
        protected final Metadata metadata;
        protected PrintWriter writer;
        private boolean metOutput;

        public NoDocumentMetHandler(Metadata metadata, PrintWriter writer) {
            this.metadata = metadata;
            this.writer = writer;
            this.metOutput = false;
        }

        @Override
        public void endDocument() {
            Object[] names = this.metadata.names();
            Arrays.sort(names);
            this.outputMetadata((String[])names);
            this.writer.flush();
            this.metOutput = true;
        }

        public void outputMetadata(String[] names) {
            for (String name : names) {
                for (String value : this.metadata.getValues(name)) {
                    this.writer.println(name + ": " + value);
                }
            }
        }

        public boolean metOutput() {
            return this.metOutput;
        }
    }
}

