/*
 * Decompiled with CFR 0.152.
 */
package com.optimaize.langdetect.frma;

import com.optimaize.langdetect.cybozu.util.LangProfile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LangProfileReader {
    private static final Pattern FREQ_PATTERN = Pattern.compile("\"freq\" ?: ?\\{(.+?)\\}");
    private static final Pattern N_WORDS_PATTERN = Pattern.compile("\"n_words\" ?: ?\\[(.+?)\\]");
    private static final Pattern NAME_PATTERN = Pattern.compile("\"name\" ?: ?\"(.+?)\"");

    public LangProfile read(File profileFile) throws IOException {
        if (!profileFile.exists()) {
            throw new IOException("No such file: " + profileFile);
        }
        if (!profileFile.canRead()) {
            throw new IOException("Cannot read file: " + profileFile);
        }
        try (FileInputStream input = new FileInputStream(profileFile);){
            LangProfile langProfile = this.read(input);
            return langProfile;
        }
    }

    public LangProfile read(InputStream inputStream) throws IOException {
        StringBuilder buffer = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, Charset.forName("utf-8")));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (buffer.length() > 0) {
                    buffer.append(' ');
                }
                buffer.append(line);
            }
        }
        String storedProfile = buffer.toString();
        LangProfile langProfile = new LangProfile();
        Matcher m3 = FREQ_PATTERN.matcher(storedProfile);
        if (m3.find()) {
            String[] entries;
            for (String entry : entries = m3.group(1).split(",")) {
                String[] keyValue = entry.split(":");
                String label = keyValue[0].trim().replace("\"", "");
                langProfile.getFreq().put(label, Integer.valueOf(keyValue[1]));
            }
        }
        if ((m3 = N_WORDS_PATTERN.matcher(storedProfile)).find()) {
            String[] nWords = m3.group(1).split(",");
            langProfile.setNWords(new int[nWords.length]);
            for (int i = 0; i < nWords.length; ++i) {
                langProfile.getNWords()[i] = Integer.parseInt(nWords[i]);
            }
        }
        if ((m3 = NAME_PATTERN.matcher(storedProfile)).find()) {
            langProfile.setName(m3.group(1));
        }
        return langProfile;
    }
}

