/*
 * Decompiled with CFR 0.152.
 */
package com.jmatio.types;

import com.jmatio.types.MLNumericArray;
import java.nio.ByteBuffer;

public class MLInt8
extends MLNumericArray<Byte> {
    public MLInt8(String name, int[] dims, int type, int attributes) {
        super(name, dims, type, attributes);
    }

    public MLInt8(String name, int[] dims) {
        super(name, dims, 8, 0);
    }

    public MLInt8(String name, Byte[] vals, int m3) {
        super(name, 8, (Number[])vals, m3);
    }

    public MLInt8(String name, byte[][] vals) {
        this(name, MLInt8.byte2DToByte(vals), vals.length);
    }

    public MLInt8(String name, byte[] vals, int m3) {
        this(name, MLInt8.castToByte(vals), m3);
    }

    public byte[][] getArray() {
        byte[][] result = new byte[this.getM()][];
        for (int m3 = 0; m3 < this.getM(); ++m3) {
            result[m3] = new byte[this.getN()];
            for (int n = 0; n < this.getN(); ++n) {
                result[m3][n] = (Byte)this.getReal(m3, n);
            }
        }
        return result;
    }

    private static Byte[] castToByte(byte[] d) {
        Byte[] dest = new Byte[d.length];
        for (int i = 0; i < d.length; ++i) {
            dest[i] = d[i];
        }
        return dest;
    }

    private static Byte[] byte2DToByte(byte[][] dd) {
        Byte[] d = new Byte[dd.length * dd[0].length];
        for (int n = 0; n < dd[0].length; ++n) {
            for (int m3 = 0; m3 < dd.length; ++m3) {
                d[m3 + n * dd.length] = dd[m3][n];
            }
        }
        return d;
    }

    @Override
    public Byte buldFromBytes(byte[] bytes) {
        if (bytes.length != this.getBytesAllocated()) {
            throw new IllegalArgumentException("To build from byte array I need array of size: " + this.getBytesAllocated());
        }
        return bytes[0];
    }

    @Override
    public byte[] getByteArray(Byte value) {
        return new byte[]{value};
    }

    @Override
    public int getBytesAllocated() {
        return 1;
    }

    @Override
    public Class<Byte> getStorageClazz() {
        return Byte.class;
    }

    @Override
    protected Byte get(ByteBuffer buffer, int index) {
        return buffer.get(index);
    }
}

