/*
 * Decompiled with CFR 0.152.
 */
package com.epam.parso.date;

import com.epam.parso.date.NotImplementedException;
import com.epam.parso.date.SasTemporalFormat;
import com.epam.parso.date.SasTemporalUtils;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

enum SasDateFormat implements SasTemporalFormat
{
    DATE(7){

        @Override
        protected String getDatePattern(int width, int precision) {
            switch (width) {
                case 5: 
                case 6: {
                    return "ddMMM";
                }
                case 9: 
                case 10: {
                    return "ddMMMyyyy";
                }
                case 11: {
                    return "dd-MMM-yyyy";
                }
            }
            return "ddMMMyy";
        }

        @Override
        public Function<Double, String> getInternalFormatFunction(int width, int precision) {
            return super.getInternalFormatFunction(width, precision).andThen(String::toUpperCase);
        }
    }
    ,
    DAY(2){

        @Override
        protected String getDatePattern(int width, int precision) {
            return "d";
        }
    }
    ,
    DDMMYY(8){

        @Override
        protected String getDatePattern(int width, int precision) {
            return SasDateFormat.getDDMMYYxwFormatPattern(width, "/");
        }
    }
    ,
    DDMMYYB(8){

        @Override
        protected String getDatePattern(int width, int precision) {
            return SasDateFormat.getDDMMYYxwFormatPattern(width, " ");
        }
    }
    ,
    DDMMYYC(8){

        @Override
        protected String getDatePattern(int width, int precision) {
            return SasDateFormat.getDDMMYYxwFormatPattern(width, ":");
        }
    }
    ,
    DDMMYYD(8){

        @Override
        protected String getDatePattern(int width, int precision) {
            return SasDateFormat.getDDMMYYxwFormatPattern(width, "-");
        }
    }
    ,
    DDMMYYN(8){

        @Override
        protected String getDatePattern(int width, int precision) {
            return SasDateFormat.getDDMMYYxwFormatPattern(width, "");
        }
    }
    ,
    DDMMYYP(8){

        @Override
        protected String getDatePattern(int width, int precision) {
            return SasDateFormat.getDDMMYYxwFormatPattern(width, ".");
        }
    }
    ,
    DDMMYYS(8){

        @Override
        protected String getDatePattern(int width, int precision) {
            return SasDateFormat.getDDMMYYxwFormatPattern(width, "/");
        }
    }
    ,
    MMDDYY(8){

        @Override
        protected String getDatePattern(int width, int precision) {
            return SasDateFormat.getMMDDYYxwFormatPattern(width, "/");
        }
    }
    ,
    MMDDYYB(8){

        @Override
        protected String getDatePattern(int width, int precision) {
            return SasDateFormat.getMMDDYYxwFormatPattern(width, " ");
        }
    }
    ,
    MMDDYYC(8){

        @Override
        protected String getDatePattern(int width, int precision) {
            return SasDateFormat.getMMDDYYxwFormatPattern(width, ":");
        }
    }
    ,
    MMDDYYD(8){

        @Override
        protected String getDatePattern(int width, int precision) {
            return SasDateFormat.getMMDDYYxwFormatPattern(width, "-");
        }
    }
    ,
    MMDDYYN(8){

        @Override
        protected String getDatePattern(int width, int precision) {
            return SasDateFormat.getMMDDYYxwFormatPattern(width, "");
        }
    }
    ,
    MMDDYYP(8){

        @Override
        protected String getDatePattern(int width, int precision) {
            return SasDateFormat.getMMDDYYxwFormatPattern(width, ".");
        }
    }
    ,
    MMDDYYS(8){

        @Override
        protected String getDatePattern(int width, int precision) {
            return SasDateFormat.getMMDDYYxwFormatPattern(width, "/");
        }
    }
    ,
    YYMMDD(8){

        @Override
        protected String getDatePattern(int width, int precision) {
            return SasDateFormat.getYYMMDDxwFormatPattern(width, "-");
        }
    }
    ,
    YYMMDDB(8){

        @Override
        protected String getDatePattern(int width, int precision) {
            return SasDateFormat.getYYMMDDxwFormatPattern(width, " ");
        }
    }
    ,
    YYMMDDC(8){

        @Override
        protected String getDatePattern(int width, int precision) {
            return SasDateFormat.getYYMMDDxwFormatPattern(width, ":");
        }
    }
    ,
    YYMMDDD(8){

        @Override
        protected String getDatePattern(int width, int precision) {
            return SasDateFormat.getYYMMDDxwFormatPattern(width, "-");
        }
    }
    ,
    YYMMDDN(8){

        @Override
        protected String getDatePattern(int width, int precision) {
            return SasDateFormat.getYYMMDDxwFormatPattern(width, "");
        }
    }
    ,
    YYMMDDP(8){

        @Override
        protected String getDatePattern(int width, int precision) {
            return SasDateFormat.getYYMMDDxwFormatPattern(width, ".");
        }
    }
    ,
    YYMMDDS(8){

        @Override
        protected String getDatePattern(int width, int precision) {
            return SasDateFormat.getYYMMDDxwFormatPattern(width, "/");
        }
    }
    ,
    MMYY(7){

        @Override
        protected String getDatePattern(int width, int precision) {
            return SasDateFormat.getMMYYxwFormatPattern(width, "'M'");
        }
    }
    ,
    MMYYC(7){

        @Override
        protected String getDatePattern(int width, int precision) {
            return SasDateFormat.getMMYYxwFormatPattern(width, ":");
        }
    }
    ,
    MMYYD(7){

        @Override
        protected String getDatePattern(int width, int precision) {
            return SasDateFormat.getMMYYxwFormatPattern(width, "-");
        }
    }
    ,
    MMYYN(6){

        @Override
        protected String getDatePattern(int width, int precision) {
            switch (width) {
                case 4: 
                case 5: {
                    return "MMyy";
                }
            }
            return "MMyyyy";
        }
    }
    ,
    MMYYP(7){

        @Override
        protected String getDatePattern(int width, int precision) {
            return SasDateFormat.getMMYYxwFormatPattern(width, ".");
        }
    }
    ,
    MMYYS(7){

        @Override
        protected String getDatePattern(int width, int precision) {
            return SasDateFormat.getMMYYxwFormatPattern(width, "/");
        }
    }
    ,
    YYMM(7){

        @Override
        protected String getDatePattern(int width, int precision) {
            return SasDateFormat.getYYMMxwFormatPattern(width, "'M'");
        }
    }
    ,
    YYMMC(7){

        @Override
        protected String getDatePattern(int width, int precision) {
            return SasDateFormat.getYYMMxwFormatPattern(width, ":");
        }
    }
    ,
    YYMMD(7){

        @Override
        protected String getDatePattern(int width, int precision) {
            return SasDateFormat.getYYMMxwFormatPattern(width, "-");
        }
    }
    ,
    YYMMN(6){

        @Override
        protected String getDatePattern(int width, int precision) {
            switch (width) {
                case 4: 
                case 5: {
                    return "yyMM";
                }
            }
            return "yyyyMM";
        }
    }
    ,
    YYMMP(7){

        @Override
        protected String getDatePattern(int width, int precision) {
            return SasDateFormat.getYYMMxwFormatPattern(width, ".");
        }
    }
    ,
    YYMMS(7){

        @Override
        protected String getDatePattern(int width, int precision) {
            return SasDateFormat.getYYMMxwFormatPattern(width, "/");
        }
    }
    ,
    JULIAN(5){

        @Override
        protected String getDatePattern(int width, int precision) {
            if (width == 7) {
                return "yyyyDDD";
            }
            return "yyDDD";
        }
    }
    ,
    JULDAY(3){

        @Override
        protected String getDatePattern(int width, int precision) {
            return "D";
        }
    }
    ,
    MONTH(2){

        @Override
        protected String getDatePattern(int width, int precision) {
            return "M";
        }

        @Override
        public Function<Double, String> getInternalFormatFunction(int width, int precision) {
            if (width == 1) {
                return sasDays -> {
                    LocalDate date = SasTemporalUtils.sasDaysToLocalDate(sasDays);
                    return String.format("%X", date.getMonthValue());
                };
            }
            return super.getInternalFormatFunction(width, precision).andThen(String::toUpperCase);
        }
    }
    ,
    YEAR(4){

        @Override
        protected String getDatePattern(int width, int precision) {
            switch (width) {
                case 2: 
                case 3: {
                    return "yy";
                }
            }
            return "yyyy";
        }
    }
    ,
    MONYY(5){

        @Override
        protected String getDatePattern(int width, int precision) {
            if (width == 7) {
                return "MMMyyyy";
            }
            return "MMMyy";
        }

        @Override
        public Function<Double, String> getInternalFormatFunction(int width, int precision) {
            return super.getInternalFormatFunction(width, precision).andThen(String::toUpperCase);
        }
    }
    ,
    YYMON(7){

        @Override
        protected String getDatePattern(int width, int precision) {
            switch (width) {
                case 5: 
                case 6: {
                    return "yyMMM";
                }
            }
            return "yyyyMMM";
        }

        @Override
        public Function<Double, String> getInternalFormatFunction(int width, int precision) {
            return super.getInternalFormatFunction(width, precision).andThen(String::toUpperCase);
        }
    }
    ,
    B8601DA(10){

        @Override
        protected String getDatePattern(int width, int precision) {
            return "yyyyMMdd";
        }
    }
    ,
    E8601DA(10){

        @Override
        protected String getDatePattern(int width, int precision) {
            return "yyyy-MM-dd";
        }
    }
    ,
    MONNAME(9){

        @Override
        protected String getDatePattern(int width, int precision) {
            return "MMMM";
        }

        @Override
        public Function<Double, String> getInternalFormatFunction(int width, int precision) {
            return super.getInternalFormatFunction(width, precision).andThen(s2 -> s2.substring(0, Math.min(s2.length(), width)));
        }
    }
    ,
    WEEKDATE(29){

        @Override
        protected String getDatePattern(int width, int precision) {
            switch (width) {
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    return "EEE";
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    return "EEEE";
                }
                case 15: 
                case 16: {
                    return "EEE, MMM d, yy";
                }
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    return "EEE, MMM d, yyyy";
                }
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: {
                    return "EEEE, MMM d, yyyy";
                }
            }
            return "EEEE, MMMM d, yyyy";
        }
    }
    ,
    WEEKDATX(29){

        @Override
        protected String getDatePattern(int width, int precision) {
            switch (width) {
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    return "EEE";
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    return "EEEE";
                }
                case 15: 
                case 16: {
                    return "EEE, d MMM yy";
                }
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    return "EEE, d MMM yyyy";
                }
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: {
                    return "EEEE, d MMM yyyy";
                }
            }
            return "EEEE, d MMMM yyyy";
        }
    }
    ,
    WEEKDAY(1){

        @Override
        protected String getDatePattern(int width, int precision) {
            return "e";
        }
    }
    ,
    DOWNAME(9){

        @Override
        protected String getDatePattern(int width, int precision) {
            return "EEEE";
        }

        @Override
        public Function<Double, String> getInternalFormatFunction(int width, int precision) {
            return super.getInternalFormatFunction(width, precision).andThen(s2 -> s2.substring(0, Math.min(s2.length(), width)));
        }
    }
    ,
    WORDDATE(18){

        @Override
        protected String getDatePattern(int width, int precision) {
            switch (width) {
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    return "MMM";
                }
                case 9: 
                case 10: 
                case 11: {
                    return "MMMM";
                }
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    return "MMM d, yyyy";
                }
            }
            return "MMMM d, yyyy";
        }
    }
    ,
    WORDDATX(18){

        @Override
        protected String getDatePattern(int width, int precision) {
            switch (width) {
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    return "MMM";
                }
                case 9: 
                case 10: 
                case 11: {
                    return "MMMM";
                }
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    return "d MMM yyyy";
                }
            }
            return "d MMMM yyyy";
        }
    }
    ,
    QTR(0){

        @Override
        protected String getDatePattern(int width, int precision) {
            return null;
        }

        @Override
        public Function<Double, String> getInternalFormatFunction(int width, int precision) {
            throw new NotImplementedException();
        }
    };

    private static final Logger LOGGER;
    private final int defaultWidth;

    private static String getDDMMYYxwFormatPattern(int width, String separator) {
        switch (width) {
            case 2: 
            case 3: {
                return "dd";
            }
            case 4: {
                return "ddMM";
            }
            case 5: {
                return "dd" + separator + "MM";
            }
            case 6: 
            case 7: {
                return "ddMMyy";
            }
            case 10: {
                return "dd" + separator + "MM" + separator + "yyyy";
            }
        }
        if (separator.isEmpty()) {
            return "ddMMyyyy";
        }
        return "dd" + separator + "MM" + separator + "yy";
    }

    private static String getMMDDYYxwFormatPattern(int width, String separator) {
        switch (width) {
            case 2: 
            case 3: {
                return "MM";
            }
            case 4: {
                return "MMdd";
            }
            case 5: {
                return "MM" + separator + "dd";
            }
            case 6: 
            case 7: {
                return "MMddyy";
            }
            case 10: {
                return "MM" + separator + "dd" + separator + "yyyy";
            }
        }
        if (separator.isEmpty()) {
            return "MMddyyyy";
        }
        return "MM" + separator + "dd" + separator + "yy";
    }

    private static String getYYMMDDxwFormatPattern(int width, String separator) {
        switch (width) {
            case 2: 
            case 3: {
                return "yy";
            }
            case 4: {
                return "yyMM";
            }
            case 5: {
                return "yy" + separator + "MM";
            }
            case 6: 
            case 7: {
                return "yyMMdd";
            }
            case 10: {
                return "yyyy" + separator + "MM" + separator + "dd";
            }
        }
        if (separator.isEmpty()) {
            return "yyyyMMdd";
        }
        return "yy" + separator + "MM" + separator + "dd";
    }

    private static String getMMYYxwFormatPattern(int width, String separator) {
        switch (width) {
            case 5: 
            case 6: {
                return "MM" + separator + "yy";
            }
        }
        return "MM" + separator + "yyyy";
    }

    private static String getYYMMxwFormatPattern(int width, String separator) {
        switch (width) {
            case 5: 
            case 6: {
                return "yy" + separator + "MM";
            }
        }
        return "yyyy" + separator + "MM";
    }

    private SasDateFormat(int defaultWidth) {
        this.defaultWidth = defaultWidth;
    }

    @Override
    public final int getDefaultWidth() {
        return this.defaultWidth;
    }

    protected abstract String getDatePattern(int var1, int var2);

    @Override
    public final Function<Double, String> getFallbackFormatFunction(int width, int precision) {
        LOGGER.warn("Note that {}{}.{} format is not yet supported, using DATE. instead.", this.name(), width > 0 ? Integer.valueOf(width) : "", precision > 0 ? Integer.valueOf(precision) : "");
        return DATE.getInternalFormatFunction(7, 0);
    }

    @Override
    public Function<Double, String> getInternalFormatFunction(int width, int precision) {
        String datePattern = this.getDatePattern(width, precision);
        DateTimeFormatter formatter = SasTemporalUtils.createDateTimeFormatterFromPattern(datePattern);
        return sasDays -> {
            LocalDate date = SasTemporalUtils.sasDaysToLocalDate(sasDays);
            return formatter.format(date);
        };
    }

    static {
        LOGGER = LoggerFactory.getLogger(SasDateFormat.class);
    }
}

