/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import org.apache.sis.internal.referencing.ExtendedPrecisionMatrix;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.parameter.DefaultParameterValue;
import org.apache.sis.parameter.Parameterized;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.matrix.NoninvertibleMatrixException;
import org.apache.sis.referencing.operation.transform.ConcatenatedTransform;
import org.apache.sis.referencing.operation.transform.ContextualParameter;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;

public class ContextualParameters
extends Parameters
implements Serializable {
    private static final long serialVersionUID = 6769546741493459341L;
    private final ParameterDescriptorGroup descriptor;
    private Matrix normalize;
    private Matrix denormalize;
    private ParameterValue<?>[] values;
    private ContextualParameters inverse;
    private boolean isFrozen;

    @Deprecated
    public ContextualParameters(OperationMethod operationMethod) {
        ArgumentChecks.ensureNonNull("method", operationMethod);
        this.descriptor = operationMethod.getParameters();
        this.normalize = ContextualParameters.linear("sourceDimensions", operationMethod.getSourceDimensions());
        this.denormalize = ContextualParameters.linear("targetDimensions", operationMethod.getTargetDimensions());
        this.values = new ParameterValue[this.descriptor.descriptors().size()];
    }

    public ContextualParameters(ParameterDescriptorGroup parameterDescriptorGroup, int n, int n2) {
        ArgumentChecks.ensureNonNull("descriptor", parameterDescriptorGroup);
        ArgumentChecks.ensureStrictlyPositive("srcDim", n);
        ArgumentChecks.ensureStrictlyPositive("tgtDim", n2);
        this.descriptor = parameterDescriptorGroup;
        this.normalize = Matrices.create(++n, n, ExtendedPrecisionMatrix.IDENTITY);
        this.denormalize = Matrices.create(++n2, n2, ExtendedPrecisionMatrix.IDENTITY);
        this.values = new ParameterValue[parameterDescriptorGroup.descriptors().size()];
    }

    private ContextualParameters(ParameterDescriptorGroup parameterDescriptorGroup, ContextualParameters contextualParameters, BiPredicate<Parameters, ParameterValue<?>> biPredicate) {
        this.descriptor = parameterDescriptorGroup;
        this.inverse = contextualParameters;
        this.normalize = contextualParameters.getMatrix(MatrixRole.INVERSE_DENORMALIZATION);
        this.denormalize = contextualParameters.getMatrix(MatrixRole.INVERSE_NORMALIZATION);
        if (biPredicate == null) {
            this.values = contextualParameters.values;
        } else {
            List<GeneralParameterDescriptor> list = parameterDescriptorGroup.descriptors();
            ParameterValue[] parameterValueArray = new ParameterValue[list.size()];
            int n = 0;
            for (int i = 0; i < parameterValueArray.length; ++i) {
                ContextualParameter contextualParameter = new ContextualParameter((ParameterDescriptor)list.get(i));
                if (!biPredicate.test(contextualParameters, contextualParameter)) continue;
                parameterValueArray[n++] = contextualParameter;
            }
            this.values = ArraysExt.resize(parameterValueArray, n);
        }
        this.isFrozen = true;
    }

    private static MatrixSIS linear(String string, Integer n) {
        if (n == null) {
            throw new IllegalArgumentException(Errors.format((short)89, string));
        }
        int n2 = n + 1;
        return Matrices.create(n2, n2, ExtendedPrecisionMatrix.IDENTITY);
    }

    final synchronized ContextualParameters inverse(ParameterDescriptorGroup parameterDescriptorGroup, BiPredicate<Parameters, ParameterValue<?>> biPredicate) {
        if (this.inverse == null) {
            if (!this.isFrozen) {
                this.freeze();
            }
            this.inverse = new ContextualParameters(parameterDescriptorGroup, this, biPredicate);
        }
        assert (this.inverse.descriptor == parameterDescriptorGroup);
        return this.inverse;
    }

    @Override
    public final ParameterDescriptorGroup getDescriptor() {
        return this.descriptor;
    }

    private void ensureModifiable() throws IllegalStateException {
        assert (Thread.holdsLock(this));
        if (this.isFrozen) {
            throw new IllegalStateException(Errors.format((short)153, this.getClass()));
        }
    }

    private MatrixSIS toMatrixSIS(Matrix matrix) {
        return this.isFrozen ? Matrices.unmodifiable(matrix) : (MatrixSIS)matrix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final MatrixSIS getMatrix(MatrixRole matrixRole) {
        ContextualParameters contextualParameters;
        Matrix matrix;
        Cloneable cloneable = this;
        synchronized (cloneable) {
            switch (matrixRole) {
                default: {
                    throw new AssertionError((Object)matrixRole);
                }
                case NORMALIZATION: {
                    return this.toMatrixSIS(this.normalize);
                }
                case DENORMALIZATION: {
                    return this.toMatrixSIS(this.denormalize);
                }
                case INVERSE_NORMALIZATION: {
                    matrixRole = MatrixRole.DENORMALIZATION;
                    matrix = this.normalize;
                    break;
                }
                case INVERSE_DENORMALIZATION: {
                    matrixRole = MatrixRole.NORMALIZATION;
                    matrix = this.denormalize;
                }
            }
            contextualParameters = this.inverse;
        }
        if (contextualParameters != null) {
            cloneable = contextualParameters.getMatrix(matrixRole);
        } else {
            try {
                cloneable = Matrices.inverse(matrix);
            }
            catch (NoninvertibleMatrixException noninvertibleMatrixException) {
                throw new IllegalStateException(Errors.format((short)5, (Object)matrixRole), noninvertibleMatrixException);
            }
        }
        return Matrices.unmodifiable((Matrix)((Object)cloneable));
    }

    public synchronized MatrixSIS normalizeGeographicInputs(double d) {
        this.ensureModifiable();
        DoubleDouble doubleDouble = DoubleDouble.createDegreesToRadians();
        DoubleDouble doubleDouble2 = null;
        if (d != 0.0) {
            doubleDouble2 = DoubleDouble.createAndGuessError(-d);
            doubleDouble2.multiply(doubleDouble);
        }
        MatrixSIS matrixSIS = (MatrixSIS)this.normalize;
        matrixSIS.convertBefore(0, doubleDouble, doubleDouble2);
        matrixSIS.convertBefore(1, doubleDouble, null);
        return matrixSIS;
    }

    public synchronized MatrixSIS denormalizeGeographicOutputs(double d) {
        this.ensureModifiable();
        DoubleDouble doubleDouble = DoubleDouble.createRadiansToDegrees();
        MatrixSIS matrixSIS = (MatrixSIS)this.denormalize;
        matrixSIS.convertAfter(0, doubleDouble, d != 0.0 ? Double.valueOf(d) : null);
        matrixSIS.convertAfter(1, doubleDouble, null);
        return matrixSIS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MathTransform completeTransform(MathTransformFactory mathTransformFactory, MathTransform mathTransform) throws FactoryException {
        MathTransform mathTransform2;
        MathTransform mathTransform3;
        ContextualParameters contextualParameters = this;
        synchronized (contextualParameters) {
            if (!this.isFrozen) {
                this.freeze();
            }
            mathTransform3 = mathTransformFactory.createAffineTransform(this.normalize);
            mathTransform2 = mathTransformFactory.createAffineTransform(this.denormalize);
            Matrix matrix = MathTransforms.getMatrix(mathTransform3);
            if (matrix != null) {
                this.normalize = matrix;
            }
            if ((matrix = MathTransforms.getMatrix(mathTransform2)) != null) {
                this.denormalize = matrix;
            }
        }
        if (mathTransform == null) {
            return null;
        }
        return mathTransformFactory.createConcatenatedTransform(mathTransformFactory.createConcatenatedTransform(mathTransform3, mathTransform), mathTransform2);
    }

    private void freeze() {
        this.isFrozen = true;
        IdentityHashMap identityHashMap = new IdentityHashMap(this.values.length);
        for (ParameterValue<?> parameterValue : this.values) {
            if (parameterValue == null) break;
            ParameterDescriptor<?> parameterDescriptor = (parameterValue = DefaultParameterValue.unmodifiable(parameterValue)).getDescriptor();
            if (identityHashMap.put(parameterDescriptor, parameterValue) == null) continue;
            throw new IllegalStateException(Errors.format((short)27, parameterDescriptor.getName()));
        }
        this.values = new ParameterValue[identityHashMap.size()];
        assert (this.descriptor.descriptors().containsAll(identityHashMap.keySet()));
        Iterator<GeneralParameterDescriptor> iterator = this.descriptor.descriptors().iterator();
        int n = 0;
        while (n < this.values.length) {
            ParameterValue parameterValue = (ParameterValue)identityHashMap.get(iterator.next());
            if (parameterValue == null) continue;
            this.values[n++] = parameterValue;
        }
    }

    @Override
    public synchronized ParameterValue<?> parameter(String string) throws ParameterNotFoundException {
        GeneralParameterDescriptor generalParameterDescriptor = this.descriptor.descriptor(string);
        if (!(generalParameterDescriptor instanceof ParameterDescriptor)) {
            throw this.parameterNotFound(string);
        }
        for (int i = 0; i < this.values.length; ++i) {
            ParameterValue<?> parameterValue = this.values[i];
            if (parameterValue == null) {
                parameterValue = new ContextualParameter((ParameterDescriptor)generalParameterDescriptor);
                this.values[i] = parameterValue;
                return parameterValue;
            }
            if (parameterValue.getDescriptor() != generalParameterDescriptor) continue;
            return parameterValue;
        }
        if (this.isFrozen) {
            return ((ParameterDescriptor)generalParameterDescriptor).createValue();
        }
        throw new ParameterNotFoundException(Errors.format((short)134, this.descriptor.getName()), string);
    }

    @Override
    public synchronized List<GeneralParameterValue> values() {
        int n;
        for (n = this.values.length; n != 0 && this.values[n - 1] == null; --n) {
        }
        return UnmodifiableArrayList.wrap(this.values, 0, n);
    }

    @Override
    public List<ParameterValueGroup> groups(String string) {
        throw this.parameterNotFound(string);
    }

    @Override
    public ParameterValueGroup addGroup(String string) {
        throw this.parameterNotFound(string);
    }

    private ParameterNotFoundException parameterNotFound(String string) {
        return new ParameterNotFoundException(Resources.format((short)61, this.descriptor.getName(), string), string);
    }

    @Override
    public synchronized ContextualParameters clone() {
        ParameterValue<?> parameterValue;
        ParameterValue<?>[] parameterValueArray = Arrays.copyOf(this.values, this.descriptor.descriptors().size());
        for (int i = 0; i < parameterValueArray.length && (parameterValue = parameterValueArray[i]) != null; ++i) {
            parameterValueArray[i] = parameterValueArray[i].clone();
        }
        ContextualParameters contextualParameters = (ContextualParameters)super.clone();
        contextualParameters.values = parameterValueArray;
        contextualParameters.normalize = this.normalize.clone();
        contextualParameters.denormalize = this.denormalize.clone();
        return contextualParameters;
    }

    public synchronized int hashCode() {
        return this.normalize.hashCode() + 31 * this.denormalize.hashCode() ^ Arrays.hashCode(this.values) ^ 0x111EE98D;
    }

    public synchronized boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            ContextualParameters contextualParameters = (ContextualParameters)object;
            return Objects.equals(this.descriptor, contextualParameters.descriptor) && Objects.equals(this.normalize, contextualParameters.normalize) && Objects.equals(this.denormalize, contextualParameters.denormalize) && Arrays.equals(this.values, contextualParameters.values);
        }
        return false;
    }

    final int beforeFormat(List<Object> list, int n, boolean bl) {
        Object object;
        MatrixSIS matrixSIS;
        Object object2;
        Matrix matrix = null;
        Matrix matrix2 = null;
        if (n != 0 && (object2 = list.get(n - 1)) instanceof MathTransform) {
            matrix = MathTransforms.getMatrix((MathTransform)object2);
        }
        if (n + 1 < list.size() && (object2 = list.get(n + 1)) instanceof MathTransform) {
            matrix2 = MathTransforms.getMatrix((MathTransform)object2);
        }
        boolean bl2 = matrix != null;
        boolean bl3 = matrix2 != null;
        try {
            matrixSIS = this.getMatrix(bl ? MatrixRole.DENORMALIZATION : MatrixRole.INVERSE_NORMALIZATION);
        }
        catch (IllegalStateException illegalStateException) {
            ContextualParameters.unexpectedException(illegalStateException);
            return n;
        }
        if (bl2) {
            matrixSIS = matrixSIS.multiply(matrix);
        }
        matrix = Matrices.isIdentity(matrixSIS, 8.999280057595393E-8) ? null : matrixSIS;
        try {
            matrixSIS = this.getMatrix(bl ? MatrixRole.NORMALIZATION : MatrixRole.INVERSE_DENORMALIZATION);
        }
        catch (IllegalStateException illegalStateException) {
            ContextualParameters.unexpectedException(illegalStateException);
            return n;
        }
        if (bl3) {
            matrixSIS = Matrices.multiply(matrix2, matrixSIS);
        }
        Matrix matrix3 = matrix2 = Matrices.isIdentity(matrixSIS, 8.999280057595393E-8) ? null : matrixSIS;
        if (matrix == null) {
            if (bl2) {
                object = list.remove(--n);
                assert (object instanceof LinearTransform);
            }
        } else if (bl2) {
            object = list.set(n - 1, matrix);
            assert (object instanceof LinearTransform);
        } else {
            list.add(n++, matrix);
        }
        list.set(n, new WKT(bl));
        if (matrix2 == null) {
            if (bl3) {
                object = list.remove(n + 1);
                assert (object instanceof LinearTransform);
            }
        } else if (bl3) {
            object = list.set(n + 1, matrix2);
            assert (object instanceof LinearTransform);
        } else {
            list.add(n + 1, matrix2);
        }
        return n;
    }

    private static void unexpectedException(IllegalStateException illegalStateException) {
        Logging.unexpectedException(Logging.getLogger("org.apache.sis.io.wkt"), ConcatenatedTransform.class, "formatTo", illegalStateException.getCause());
    }

    public static enum MatrixRole {
        NORMALIZATION,
        INVERSE_NORMALIZATION,
        DENORMALIZATION,
        INVERSE_DENORMALIZATION;

    }

    private final class WKT
    extends FormattableObject
    implements Parameterized {
        private final boolean inverse;

        WKT(boolean bl) {
            this.inverse = bl;
        }

        @Override
        public ParameterDescriptorGroup getParameterDescriptors() {
            return ContextualParameters.this.getDescriptor();
        }

        @Override
        public ParameterValueGroup getParameterValues() {
            return ContextualParameters.this;
        }

        @Override
        protected String formatTo(Formatter formatter) {
            if (this.inverse) {
                formatter.newLine();
                formatter.append(new WKT(false));
                return "Inverse_MT";
            }
            WKTUtilities.appendParamMT(ContextualParameters.this, formatter);
            return "Param_MT";
        }
    }
}

