/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.referencing.provider.AbstractProvider;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.transform.PoleRotation;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.util.FactoryException;

@XmlTransient
public final class SouthPoleRotation
extends AbstractProvider {
    private static final long serialVersionUID = -5970630604222205521L;
    static final ParameterDescriptor<Double> POLE_LATITUDE;
    static final ParameterDescriptor<Double> POLE_LONGITUDE;
    static final ParameterDescriptor<Double> AXIS_ANGLE;
    public static final ParameterDescriptorGroup PARAMETERS;

    public SouthPoleRotation() {
        super(2, 2, PARAMETERS);
    }

    public Class<? extends Conversion> getOperationType() {
        return Conversion.class;
    }

    @Override
    public MathTransform createMathTransform(MathTransformFactory mathTransformFactory, ParameterValueGroup parameterValueGroup) throws FactoryException {
        Parameters parameters = Parameters.castOrWrap(parameterValueGroup);
        return PoleRotation.rotateSouthPole(mathTransformFactory, parameters.getValue(POLE_LATITUDE), parameters.getValue(POLE_LONGITUDE), parameters.getValue(AXIS_ANGLE));
    }

    static {
        ParameterBuilder parameterBuilder = ((ParameterBuilder)new ParameterBuilder().setCodeSpace(Citations.NETCDF, "NetCDF")).setRequired(true);
        POLE_LATITUDE = ((ParameterBuilder)((ParameterBuilder)parameterBuilder.addName(Citations.SIS, "Latitude of rotated pole")).addName("grid_south_pole_latitude")).createBounded(-90.0, 90.0, Double.NaN, Units.DEGREE);
        POLE_LONGITUDE = ((ParameterBuilder)((ParameterBuilder)parameterBuilder.addName(Citations.SIS, "Longitude of rotated pole")).addName("grid_south_pole_longitude")).createBounded(-180.0, 180.0, Double.NaN, Units.DEGREE);
        AXIS_ANGLE = ((ParameterBuilder)((ParameterBuilder)parameterBuilder.setRequired(false).addName(Citations.SIS, "Axis rotation")).addName("grid_south_pole_angle")).createBounded(-180.0, 180.0, 0.0, Units.DEGREE);
        PARAMETERS = ((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)parameterBuilder.setRequired(true).addName(Citations.SIS, "South pole rotation")).addName(Citations.WMO, "Rotated Latitude/longitude")).addName("rotated_latlon_grib")).createGroup(POLE_LATITUDE, POLE_LONGITUDE, AXIS_ANGLE);
    }
}

