/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.sis.coverage.CannotEvaluateException;
import org.apache.sis.coverage.grid.CoordinateOperationFinder;
import org.apache.sis.coverage.grid.GridClippingMode;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridCoverage2D;
import org.apache.sis.coverage.grid.GridCoverageProcessor;
import org.apache.sis.coverage.grid.GridEvaluator;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.GridRoundingMode;
import org.apache.sis.geometry.AbstractEnvelope;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.image.DataType;
import org.apache.sis.image.ImageProcessor;
import org.apache.sis.internal.coverage.SampleDimensions;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.referencing.DirectPositionView;
import org.apache.sis.internal.referencing.ExtendedPrecisionMatrix;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.TransformSeparator;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

final class ResampledGridCoverage
extends GridCoverage {
    private static final int BIDIMENSIONAL = 2;
    final GridCoverage source;
    private final MathTransform toSourceCorner;
    private final MathTransform toSourceCenter;
    private final long[] toSourceDimensions;
    private final ImageProcessor imageProcessor;
    private final int supportSizeX;
    private final int supportSizeY;

    private ResampledGridCoverage(GridCoverage gridCoverage, GridGeometry gridGeometry, MathTransform mathTransform, MathTransform mathTransform2, CoordinateOperationFinder coordinateOperationFinder, ImageProcessor imageProcessor) {
        super(gridCoverage, gridGeometry);
        this.source = gridCoverage;
        this.toSourceCorner = mathTransform;
        this.toSourceCenter = mathTransform2;
        this.toSourceDimensions = ResampledGridCoverage.findDependentDimensions(mathTransform2, gridGeometry);
        imageProcessor = imageProcessor.clone();
        imageProcessor.setFillValues(SampleDimensions.backgrounds(this.getSampleDimensions()));
        coordinateOperationFinder.setAccuracyOf(imageProcessor);
        this.imageProcessor = GridCoverageProcessor.unique(imageProcessor);
        Dimension dimension = this.imageProcessor.getInterpolation().getSupportSize();
        this.supportSizeX = dimension.width;
        this.supportSizeY = dimension.height;
    }

    private static long[] findDependentDimensions(MathTransform mathTransform, GridGeometry gridGeometry) {
        int n = mathTransform.getSourceDimensions();
        if (n <= 2) {
            return null;
        }
        Matrix matrix = MathTransforms.getMatrix(mathTransform);
        if (matrix == null) {
            try {
                matrix = mathTransform.derivative(new DirectPositionView.Double(gridGeometry.getExtent().getPointOfInterest()));
            }
            catch (TransformException transformException) {
                GridCoverageProcessor.recoverableException("resample", transformException);
                return null;
            }
        }
        int n2 = mathTransform.getTargetDimensions();
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (matrix.getElement(j, i) == 0.0) continue;
                if (j >= 64) {
                    throw GridGeometry.excessiveDimension(mathTransform);
                }
                int n3 = i;
                lArray[n3] = lArray[n3] | 1L << j;
            }
        }
        return lArray;
    }

    private GridCoverage specialize(boolean bl) throws TransformException {
        MathTransform mathTransform;
        GridExtent gridExtent = this.gridGeometry.getExtent();
        if (gridExtent.getDimension() < 2 || gridExtent.getSubDimension() > 2) {
            return this;
        }
        if (!bl && this.toSourceCorner instanceof LinearTransform && (mathTransform = this.gridGeometry.getGridToCRS(PixelInCell.CELL_CORNER)) instanceof LinearTransform) {
            GridGeometry gridGeometry;
            GridGeometry gridGeometry2 = this.source.getGridGeometry();
            if (gridGeometry2.equals(gridGeometry = new GridGeometry(gridExtent = gridGeometry2.getExtent(), PixelInCell.CELL_CORNER, mathTransform = MathTransforms.concatenate(this.toSourceCorner.inverse(), mathTransform), this.getCoordinateReferenceSystem()), ComparisonMode.APPROXIMATE)) {
                return this.source;
            }
            return new GridCoverage2D(this.source, gridGeometry, gridExtent, this.source.render(null));
        }
        return new GridCoverage2D(this.source, this.gridGeometry, gridExtent, this.render(null));
    }

    static boolean equivalent(GridGeometry gridGeometry, GridGeometry gridGeometry2) {
        return !(ResampledGridCoverage.isDefined(gridGeometry, gridGeometry2, 4) && !Utilities.equalsIgnoreMetadata(gridGeometry.getExtent(), gridGeometry2.getExtent()) || ResampledGridCoverage.isDefined(gridGeometry, gridGeometry2, 1) && !Utilities.equalsIgnoreMetadata(gridGeometry.getCoordinateReferenceSystem(), gridGeometry2.getCoordinateReferenceSystem()) || ResampledGridCoverage.isDefined(gridGeometry, gridGeometry2, 8) && !Utilities.equalsIgnoreMetadata(gridGeometry.getGridToCRS(PixelInCell.CELL_CORNER), gridGeometry2.getGridToCRS(PixelInCell.CELL_CORNER)) && !Utilities.equalsIgnoreMetadata(gridGeometry.getGridToCRS(PixelInCell.CELL_CENTER), gridGeometry2.getGridToCRS(PixelInCell.CELL_CENTER)) || ResampledGridCoverage.isDefined(gridGeometry, gridGeometry2, 2) && !ResampledGridCoverage.isDefined(gridGeometry, gridGeometry2, 12) && !gridGeometry.equalsApproximately(gridGeometry2.envelope));
    }

    private static boolean isDefined(GridGeometry gridGeometry, GridGeometry gridGeometry2, int n) {
        return gridGeometry2.isDefined(n) && gridGeometry.isDefined(n);
    }

    static GridCoverage create(GridCoverage gridCoverage, GridGeometry gridGeometry, ImageProcessor imageProcessor) throws FactoryException, TransformException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Serializable serializable;
        MathTransform mathTransform;
        GridExtent gridExtent;
        GridGeometry gridGeometry2 = gridCoverage.getGridGeometry();
        CoordinateOperationFinder coordinateOperationFinder = new CoordinateOperationFinder(gridGeometry2, gridGeometry);
        coordinateOperationFinder.verifyPresenceOfCRS(true);
        MathTransform mathTransform2 = coordinateOperationFinder.gridToCRS();
        MathTransform mathTransform3 = coordinateOperationFinder.inverse();
        coordinateOperationFinder.setAnchor(PixelInCell.CELL_CENTER);
        MathTransform mathTransform4 = coordinateOperationFinder.gridToCRS();
        MathTransform mathTransform5 = coordinateOperationFinder.inverse();
        boolean bl = gridGeometry.isDefined(4);
        GridExtent gridExtent2 = gridExtent = bl ? gridGeometry.getExtent() : null;
        if (gridGeometry.isDefined(8)) {
            bl = true;
            mathTransform = gridGeometry.getGridToCRS(PixelInCell.CELL_CENTER);
            if (gridExtent == null) {
                gridExtent = ResampledGridCoverage.targetExtent(gridGeometry2.getExtent(), mathTransform2, gridGeometry.getGridToCRS(PixelInCell.CELL_CORNER).inverse(), false);
            }
        } else {
            Object object5;
            int n;
            int n2;
            serializable = gridGeometry2.getExtent();
            object4 = ((GridExtent)serializable).getPointOfInterest();
            object3 = new double[mathTransform4.getTargetDimensions()];
            object2 = MatrixSIS.castOrCopy(MathTransforms.derivativeAndTransform(mathTransform4, object4, 0, object3, 0));
            object = ((MatrixSIS)object2).multiply((double[])object4);
            MatrixSIS matrixSIS = ((MatrixSIS)object2).normalizeColumns();
            int n3 = object2.getNumRow();
            int n4 = gridGeometry.getDimension();
            int n5 = Math.min(matrixSIS.getNumCol(), Math.min(n3, n4));
            MatrixSIS matrixSIS2 = Matrices.create(n4 + 1, n3 + 1, ExtendedPrecisionMatrix.ZERO);
            int[] nArray = n4 > n3 && gridExtent != null ? gridExtent.getSubspaceDimensions(n3) : null;
            while (true) {
                double d = -1.0;
                n2 = -1;
                int n6 = -1;
                for (n = 0; n < n5; ++n) {
                    int n7 = nArray != null ? nArray[n] : n;
                    for (int i = 0; i < n3; ++i) {
                        double d2 = Math.abs(((MatrixSIS)object2).getElement(i, n7));
                        if (!(d2 > d)) continue;
                        d = d2;
                        n6 = i;
                        n2 = n7;
                    }
                }
                if (n2 < 0) break;
                for (n = 0; n < n3; ++n) {
                    object2.setElement(n, n2, Double.NaN);
                }
                for (n = 0; n < n4; ++n) {
                    object2.setElement(n6, n, Double.NaN);
                }
                DoubleDouble doubleDouble = DoubleDouble.castOrCopy(matrixSIS.getNumber(0, n2));
                doubleDouble.inverseDivide(1.0);
                matrixSIS2.setNumber(n2, n6, doubleDouble);
                doubleDouble.multiply((double)(object[n6] - object3[n6]));
                matrixSIS2.setNumber(n2, n3, doubleDouble);
            }
            matrixSIS2.setElement(n4, n3, 1.0);
            GridExtent gridExtent3 = ResampledGridCoverage.targetExtent((GridExtent)serializable, mathTransform2, MathTransforms.linear(matrixSIS2), true);
            if (gridExtent == null) {
                if (gridExtent3.startsAtZero()) {
                    gridExtent = gridExtent3;
                } else {
                    object5 = new long[n4 * 2];
                    for (n2 = 0; n2 < n4; ++n2) {
                        object5[n2 + n4] = gridExtent3.getSize(n2) - 1L;
                    }
                    gridExtent = new GridExtent(gridExtent3, (long[])object5);
                }
            }
            object5 = new DoubleDouble();
            DoubleDouble doubleDouble = new DoubleDouble();
            DoubleDouble doubleDouble2 = new DoubleDouble();
            for (n = 0; n < n4; ++n) {
                doubleDouble2.set(gridExtent.getSize(n));
                ((DoubleDouble)object5).set(gridExtent3.getSize(n));
                ((DoubleDouble)object5).inverseDivide(doubleDouble2);
                doubleDouble2.set(gridExtent.getLow(n));
                doubleDouble.set(-gridExtent3.getLow(n));
                doubleDouble.multiply((DoubleDouble)object5);
                doubleDouble.add(doubleDouble2);
                matrixSIS2.convertAfter(n, (Number)object5, doubleDouble);
            }
            mathTransform = MathTransforms.linear(matrixSIS2.inverse());
        }
        serializable = gridGeometry;
        object4 = (Object)ComparisonMode.IGNORE_METADATA;
        if (!gridGeometry.isDefined(13)) {
            object3 = coordinateOperationFinder.getTargetCRS();
            serializable = new GridGeometry(gridExtent, PixelInCell.CELL_CENTER, mathTransform, (CoordinateReferenceSystem)object3);
            object4 = (Object)ComparisonMode.APPROXIMATE;
            if (gridGeometry.isDefined(2)) {
                object2 = ((GridGeometry)serializable).getGridToCRS(PixelInCell.CELL_CORNER);
                object = new GeneralEnvelope(((GridGeometry)serializable).getEnvelope());
                ((GeneralEnvelope)object).intersect(gridGeometry.getEnvelope());
                object = Envelopes.transform(object2.inverse(), (Envelope)object);
                gridExtent = new GridExtent((AbstractEnvelope)object, GridRoundingMode.NEAREST, GridClippingMode.STRICT, null, null, gridExtent, null);
                serializable = new GridGeometry(gridExtent, PixelInCell.CELL_CENTER, mathTransform, (CoordinateReferenceSystem)object3);
                bl = true;
            }
        }
        if (gridGeometry2.equals(serializable, (ComparisonMode)((Object)object4))) {
            return gridCoverage;
        }
        object3 = ((GridGeometry)serializable).getGridToCRS(PixelInCell.CELL_CORNER);
        return new ResampledGridCoverage(gridCoverage, (GridGeometry)serializable, MathTransforms.concatenate((MathTransform)object3, mathTransform3), MathTransforms.concatenate(mathTransform, mathTransform5), coordinateOperationFinder, imageProcessor).specialize(bl);
    }

    private static GridExtent targetExtent(GridExtent gridExtent, MathTransform mathTransform, MathTransform mathTransform2, boolean bl) throws TransformException {
        MathTransform mathTransform3 = MathTransforms.concatenate(mathTransform, mathTransform2);
        GeneralEnvelope generalEnvelope = gridExtent.toCRS(mathTransform3, mathTransform3, null);
        if (bl) {
            double[] dArray = new double[generalEnvelope.getDimension()];
            Arrays.fill(dArray, 0.5);
            generalEnvelope.translate(dArray);
        }
        return new GridExtent(generalEnvelope, GridRoundingMode.NEAREST, GridClippingMode.STRICT, null, null, null, null);
    }

    @Override
    public RenderedImage render(GridExtent gridExtent) {
        MathTransform mathTransform;
        GridExtent gridExtent2;
        int n;
        int n2;
        Object object;
        if (gridExtent == null) {
            gridExtent = this.gridGeometry.getExtent();
        }
        try {
            int n3;
            object = gridExtent.getSubspaceDimensions(2);
            n2 = Math.toIntExact(gridExtent.getSize(object[0]));
            n = Math.toIntExact(gridExtent.getSize(object[1]));
            GeneralEnvelope generalEnvelope = gridExtent.toCRS(this.toSourceCorner, this.toSourceCenter, null);
            int n4 = generalEnvelope.getDimension();
            if (generalEnvelope.isEmpty()) {
                GridExtent gridExtent3 = this.source.gridGeometry.getExtent();
                for (n3 = 0; n3 < n4; ++n3) {
                    double d = generalEnvelope.getMinimum(n3);
                    double d2 = generalEnvelope.getMaximum(n3);
                    if (Double.isNaN(d)) {
                        d = gridExtent3.getLow(n3);
                    }
                    if (Double.isNaN(d2)) {
                        d2 = gridExtent3.getHigh(n3);
                    }
                    generalEnvelope.setRange(n3, d, d2);
                }
            }
            int n5 = 0;
            n3 = 1;
            if (this.toSourceDimensions != null) {
                int n6;
                long l = 0L;
                for (int n7 : object) {
                    l |= this.toSourceDimensions[n7];
                }
                n5 = Long.numberOfTrailingZeros(l);
                n3 = Long.numberOfTrailingZeros(l & (1L << n5 ^ 0xFFFFFFFFFFFFFFFFL));
                if (n3 >= n4) {
                    if (n5 >= n4) {
                        n5 = 0;
                    }
                    n3 = n5 != 0 ? 0 : 1;
                    l = 1L << n5 | 1L << n3;
                }
                l ^= 0xFFFFFFFFFFFFFFFFL;
                while ((n6 = Long.numberOfTrailingZeros(l)) < n4) {
                    double d = generalEnvelope.getMedian(n6);
                    if (Double.isFinite(d)) {
                        generalEnvelope.setRange(n6, d, d);
                    }
                    l &= 1L << n6 ^ 0xFFFFFFFFFFFFFFFFL;
                }
            }
            int[] nArray = new int[n4];
            nArray[n5] = this.supportSizeX;
            nArray[n3] = this.supportSizeY;
            gridExtent2 = new GridExtent(generalEnvelope, GridRoundingMode.ENCLOSING, null, nArray, null, null, null);
            TransformSeparator transformSeparator = new TransformSeparator(this.toSourceCenter);
            transformSeparator.addSourceDimensions((int)object);
            transformSeparator.addTargetDimensions(n5, n3);
            transformSeparator.setSourceExpandable(true);
            MathTransform mathTransform2 = transformSeparator.separate();
            int[] nArray2 = transformSeparator.getSourceDimensions();
            if (nArray2.length > 2) {
                MatrixSIS matrixSIS = Matrices.createZero(nArray2.length + 1, 3);
                matrixSIS.setElement(nArray2.length, 2, 1.0);
                for (int n7 = 0; n7 < nArray2.length; ++n7) {
                    int n8 = nArray2[n7];
                    int n9 = Arrays.binarySearch(object, n8);
                    if (n9 >= 0) {
                        matrixSIS.setElement(n7, n9, 1.0);
                        continue;
                    }
                    long l = gridExtent.getLow(n8);
                    if (l == gridExtent.getHigh(n8)) {
                        matrixSIS.setElement(n7, 2, l);
                        continue;
                    }
                    throw new CannotEvaluateException(Resources.format((short)63, gridExtent.getAxisIdentification(n8, n8)));
                }
                mathTransform2 = MathTransforms.concatenate(MathTransforms.linear(matrixSIS), mathTransform2);
            }
            LinearTransform linearTransform = MathTransforms.translation(gridExtent.getLow(object[0]), gridExtent.getLow(object[1]));
            LinearTransform linearTransform2 = MathTransforms.translation(Math.negateExact(gridExtent2.getLow(n5)), Math.negateExact(gridExtent2.getLow(n3)));
            mathTransform = MathTransforms.concatenate(linearTransform, mathTransform2, linearTransform2);
        }
        catch (ArithmeticException | TransformException | FactoryException exception) {
            throw new CannotEvaluateException(exception.getLocalizedMessage(), exception);
        }
        object = this.source.render(gridExtent2);
        return this.imageProcessor.resample((RenderedImage)object, new Rectangle(n2, n), mathTransform);
    }

    @Override
    final DataType getBandType() {
        return this.source.getBandType();
    }

    @Override
    public GridEvaluator evaluator() {
        return this.source.evaluator();
    }
}

