/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.eval.app.reports;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.tika.eval.app.ExtractComparer;
import org.apache.tika.eval.app.ExtractProfiler;
import org.apache.tika.eval.app.db.H2Util;
import org.apache.tika.eval.app.db.JDBCUtil;
import org.apache.tika.eval.app.reports.Report;
import org.apache.tika.eval.app.reports.XLSXHREFFormatter;
import org.apache.tika.eval.app.reports.XLSXNumFormatter;
import org.apache.tika.eval.app.reports.XSLXCellFormatter;
import org.apache.tika.utils.XMLReaderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResultsReporter {
    private static final Logger LOG = LoggerFactory.getLogger(ResultsReporter.class);
    private static Options OPTIONS = new Options();
    List<String> before = new ArrayList<String>();
    List<String> after = new ArrayList<String>();
    List<Report> reports = new ArrayList<Report>();

    public static void USAGE() {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp(80, "java -jar tika-eval-x.y.jar Report -db mydb [-rd myreports] [-rf myreports.xml]", "Tool: Report", OPTIONS, "Note: for h2 db, do not include the .mv.db at the end of the db name.");
    }

    public static ResultsReporter build(Path p) throws Exception {
        Document doc;
        ResultsReporter r = new ResultsReporter();
        DocumentBuilder docBuilder = XMLReaderUtils.getDocumentBuilder();
        try (InputStream is = Files.newInputStream(p, new OpenOption[0]);){
            doc = docBuilder.parse(is);
        }
        Element docElement = doc.getDocumentElement();
        assert (docElement.getNodeName().equals("reports"));
        NodeList children = docElement.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if ("before".equals(n.getNodeName())) {
                for (String before : ResultsReporter.getSql(n)) {
                    r.addBefore(before);
                }
                continue;
            }
            if ("after".equals(n.getNodeName())) {
                for (String after : ResultsReporter.getSql(n)) {
                    r.addAfter(after);
                }
                continue;
            }
            if (!"report".equals(n.getNodeName())) continue;
            Report report = ResultsReporter.buildReport(n);
            r.addReport(report);
        }
        return r;
    }

    private static Report buildReport(Node n) {
        NodeList children = n.getChildNodes();
        Report r = new Report();
        NamedNodeMap attrs = n.getAttributes();
        r.includeSql = Boolean.parseBoolean(attrs.getNamedItem("includeSql").getNodeValue());
        r.reportFilename = attrs.getNamedItem("reportFilename").getNodeValue();
        r.reportName = attrs.getNamedItem("reportName").getNodeValue();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            if ("sql".equals(child.getNodeName())) {
                if (r.sql != null) {
                    throw new IllegalArgumentException("Can only have one sql statement per report");
                }
                r.sql = child.getTextContent();
                continue;
            }
            if ("colformats".equals(child.getNodeName())) {
                r.cellFormatters = ResultsReporter.getCellFormatters(child);
                continue;
            }
            throw new IllegalArgumentException("Not expecting to see:" + child.getNodeName());
        }
        return r;
    }

    private static Map<String, XSLXCellFormatter> getCellFormatters(Node n) {
        NodeList children = n.getChildNodes();
        HashMap<String, XSLXCellFormatter> ret = new HashMap<String, XSLXCellFormatter>();
        for (int i = 0; i < children.getLength(); ++i) {
            XLSXHREFFormatter f;
            Node baseNode;
            String base;
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            NamedNodeMap attrs = child.getAttributes();
            String columnName = attrs.getNamedItem("name").getNodeValue();
            assert (!ret.containsKey(columnName));
            String type = attrs.getNamedItem("type").getNodeValue();
            if ("numberFormatter".equals(type)) {
                String format = attrs.getNamedItem("format").getNodeValue();
                XLSXNumFormatter f2 = new XLSXNumFormatter(format);
                ret.put(columnName, f2);
                continue;
            }
            if ("urlLink".equals(type)) {
                base = "";
                baseNode = attrs.getNamedItem("base");
                if (baseNode != null) {
                    base = baseNode.getNodeValue();
                }
                f = new XLSXHREFFormatter(base, HyperlinkType.URL);
                ret.put(columnName, f);
                continue;
            }
            if (!"fileLink".equals(type)) continue;
            base = "";
            baseNode = attrs.getNamedItem("base");
            if (baseNode != null) {
                base = baseNode.getNodeValue();
            }
            f = new XLSXHREFFormatter(base, HyperlinkType.FILE);
            ret.put(columnName, f);
        }
        return ret;
    }

    private static List<String> getSql(Node n) {
        ArrayList<String> ret = new ArrayList<String>();
        NodeList children = n.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            ret.add(child.getTextContent());
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) throws Exception {
        DefaultParser defaultCLIParser = new DefaultParser();
        CommandLine commandLine = null;
        try {
            commandLine = defaultCLIParser.parse(OPTIONS, args);
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            ResultsReporter.USAGE();
            return;
        }
        JDBCUtil dbUtil = null;
        if (commandLine.hasOption("db")) {
            Path db;
            String dbString = commandLine.getOptionValue("db");
            if (dbString.endsWith(".mv.db")) {
                dbString = dbString.substring(0, dbString.length() - 6);
                LOG.debug("trimming .mv.db from db name");
            }
            if (!H2Util.databaseExists(db = Paths.get(dbString, new String[0]))) {
                throw new RuntimeException("I'm sorry, but I couldn't find this h2 database: " + db);
            }
            dbUtil = new H2Util(db);
        } else if (commandLine.hasOption("jdbc")) {
            String driverClass = null;
            if (commandLine.hasOption("jdbcdriver")) {
                driverClass = commandLine.getOptionValue("jdbcdriver");
            }
            dbUtil = new JDBCUtil(commandLine.getOptionValue("jdbc"), driverClass);
        } else {
            System.err.println("Must specify either -db for the default in-memory h2 database\nor -jdbc for a full jdbc connection string");
            ResultsReporter.USAGE();
            return;
        }
        try (Connection c = dbUtil.getConnection();){
            Path tmpReportsFile = null;
            try {
                ResultsReporter resultsReporter = null;
                String reportsFile = commandLine.getOptionValue("rf");
                if (reportsFile == null) {
                    tmpReportsFile = ResultsReporter.getDefaultReportsConfig(c);
                    resultsReporter = ResultsReporter.build(tmpReportsFile);
                } else {
                    resultsReporter = ResultsReporter.build(Paths.get(reportsFile, new String[0]));
                }
                Path reportsRootDirectory = Paths.get(commandLine.getOptionValue("rd", "reports"), new String[0]);
                if (Files.isDirectory(reportsRootDirectory, new LinkOption[0])) {
                    LOG.warn("'Reports' directory exists.  Will overwrite existing reports.");
                }
                resultsReporter.execute(c, reportsRootDirectory);
                if (tmpReportsFile == null) return;
            }
            catch (Throwable throwable) {
                if (tmpReportsFile == null) throw throwable;
                Files.delete(tmpReportsFile);
                throw throwable;
            }
            Files.delete(tmpReportsFile);
            return;
        }
    }

    private static Path getDefaultReportsConfig(Connection c) throws IOException, SQLException {
        DatabaseMetaData md = c.getMetaData();
        String internalPath = null;
        try (ResultSet rs = md.getTables(null, null, "%", null);){
            while (rs.next()) {
                String tName = rs.getString(3);
                if (ExtractComparer.CONTENTS_TABLE_B.getName().equalsIgnoreCase(tName)) {
                    internalPath = "/comparison-reports.xml";
                } else {
                    if (!ExtractProfiler.PROFILE_TABLE.getName().equalsIgnoreCase(tName)) continue;
                    internalPath = "/profile-reports.xml";
                }
                break;
            }
        }
        if (internalPath == null) {
            throw new RuntimeException("Couldn't determine if this database was a 'profiler' or 'comparison' db");
        }
        Path tmp = Files.createTempFile("tmp-tika-reports", ".xml", new FileAttribute[0]);
        Files.copy(ResultsReporter.class.getResourceAsStream(internalPath), tmp, StandardCopyOption.REPLACE_EXISTING);
        return tmp;
    }

    private void addBefore(String b) {
        this.before.add(b);
    }

    private void addAfter(String a) {
        this.after.add(a);
    }

    private void addReport(Report r) {
        this.reports.add(r);
    }

    public void execute(Connection c, Path reportsDirectory) throws IOException, SQLException {
        try (Statement st = c.createStatement();){
            for (String sql : this.before) {
                LOG.info("processing before: {}", (Object)sql);
                st.execute(sql);
            }
            for (Report r : this.reports) {
                r.writeReport(c, reportsDirectory);
            }
            for (String sql : this.after) {
                LOG.info("processing after: {}", (Object)sql);
                st.execute(sql);
            }
        }
    }

    static {
        OPTIONS.addOption("rd", "reportsDir", true, "directory for the reports. If not specified, will write to 'reports'BEWARE: Will overwrite existing reports without warning!").addOption("rf", "reportsFile", true, "xml specifying sql to call for the reports.If not specified, will use default reports in resources/tika-eval-*-config.xml").addOption("db", true, "default database (in memory H2). Specify a file name for the H2 database.").addOption("jdbc", true, "EXPERT: full jdbc connection string. Specify this or use -db <h2db_name>").addOption("jdbcdriver", true, "EXPERT: specify the jdbc driver class if all else fails").addOption("tablePrefix", true, "EXPERT: if not using the default tables, specify your table name prefix");
    }
}

