/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.eval.app.batch;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.tika.batch.FileResource;
import org.apache.tika.batch.FileResourceConsumer;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.eval.app.AbstractProfiler;
import org.apache.tika.eval.app.batch.DBConsumersManager;
import org.apache.tika.eval.app.db.Cols;
import org.apache.tika.eval.app.db.JDBCUtil;
import org.apache.tika.eval.app.db.MimeBuffer;
import org.apache.tika.eval.app.db.TableInfo;
import org.apache.tika.eval.app.io.DBWriter;
import org.apache.tika.eval.app.io.ExtractReader;
import org.apache.tika.eval.app.io.ExtractReaderException;
import org.apache.tika.eval.app.io.IDBWriter;
import org.apache.tika.util.PropsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EvalConsumerBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(EvalConsumerBuilder.class);
    protected ArrayBlockingQueue<FileResource> queue;
    Map<String, String> localAttrs;
    JDBCUtil dbUtil;
    AtomicInteger initialized = new AtomicInteger(0);
    private MimeBuffer mimeBuffer;

    public MimeBuffer init(ArrayBlockingQueue<FileResource> queue, Map<String, String> localAttrs, JDBCUtil dbUtil, boolean forceDrop) throws IOException, SQLException {
        if (this.initialized.getAndIncrement() > 0) {
            throw new RuntimeException("Can only init a consumer builder once!");
        }
        this.queue = queue;
        this.localAttrs = localAttrs;
        this.dbUtil = dbUtil;
        this.updateTableInfosWithPrefixes(localAttrs);
        JDBCUtil.CREATE_TABLE createRegularTable = forceDrop ? JDBCUtil.CREATE_TABLE.DROP_IF_EXISTS : JDBCUtil.CREATE_TABLE.THROW_EX_IF_EXISTS;
        JDBCUtil.CREATE_TABLE createRefTable = forceDrop ? JDBCUtil.CREATE_TABLE.DROP_IF_EXISTS : JDBCUtil.CREATE_TABLE.SKIP_IF_EXISTS;
        dbUtil.createTables(this.getNonRefTableInfos(), createRegularTable);
        dbUtil.createTables(this.getRefTableInfos(), createRefTable);
        this.mimeBuffer = new MimeBuffer(dbUtil.getConnection(), this.getMimeTable(), TikaConfig.getDefaultConfig());
        this.populateRefTables();
        return this.mimeBuffer;
    }

    public abstract FileResourceConsumer build() throws IOException, SQLException;

    protected abstract void updateTableInfosWithPrefixes(Map<String, String> var1);

    protected abstract List<TableInfo> getRefTableInfos();

    protected abstract List<TableInfo> getNonRefTableInfos();

    protected abstract TableInfo getMimeTable();

    protected abstract void addErrorLogTablePairs(DBConsumersManager var1);

    public void populateRefTables() throws IOException, SQLException {
        boolean refTablesPopulated = true;
        try {
            Connection connection = this.dbUtil.getConnection();
            for (TableInfo tableInfo : this.getRefTableInfos()) {
                int rows = 0;
                Throwable throwable = null;
                try (ResultSet rs = connection.createStatement().executeQuery("select * from " + tableInfo.getName());){
                    while (rs.next()) {
                        ++rows;
                    }
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    throw throwable2;
                }
                if (rows != 0) continue;
                refTablesPopulated = false;
                break;
            }
        }
        catch (SQLException connection) {
            // empty catch block
        }
        if (refTablesPopulated) {
            LOG.info("ref tables are already populated");
            return;
        }
        IDBWriter writer = this.getDBWriter(this.getRefTableInfos());
        HashMap<Cols, String> m = new HashMap<Cols, String>();
        for (AbstractProfiler.PARSE_ERROR_TYPE pARSE_ERROR_TYPE : AbstractProfiler.PARSE_ERROR_TYPE.values()) {
            m.clear();
            m.put(Cols.PARSE_ERROR_ID, Integer.toString(pARSE_ERROR_TYPE.ordinal()));
            m.put(Cols.PARSE_ERROR_DESCRIPTION, pARSE_ERROR_TYPE.name());
            writer.writeRow(AbstractProfiler.REF_PARSE_ERROR_TYPES, m);
        }
        for (Enum enum_ : AbstractProfiler.EXCEPTION_TYPE.values()) {
            m.clear();
            m.put(Cols.PARSE_EXCEPTION_ID, Integer.toString(enum_.ordinal()));
            m.put(Cols.PARSE_EXCEPTION_DESCRIPTION, enum_.name());
            writer.writeRow(AbstractProfiler.REF_PARSE_EXCEPTION_TYPES, m);
        }
        for (Enum enum_ : ExtractReaderException.TYPE.values()) {
            m.clear();
            m.put(Cols.EXTRACT_EXCEPTION_ID, Integer.toString(enum_.ordinal()));
            m.put(Cols.EXTRACT_EXCEPTION_DESCRIPTION, enum_.name());
            writer.writeRow(AbstractProfiler.REF_EXTRACT_EXCEPTION_TYPES, m);
        }
        writer.close();
    }

    protected IDBWriter getDBWriter(List<TableInfo> tableInfos) throws IOException, SQLException {
        Connection conn = this.dbUtil.getConnection();
        return new DBWriter(conn, tableInfos, this.dbUtil, this.mimeBuffer);
    }

    ExtractReader.ALTER_METADATA_LIST getAlterMetadata(Map<String, String> localAttrs) {
        ExtractReader.ALTER_METADATA_LIST alterExtractList;
        String alterExtractString = localAttrs.get("alterExtract");
        if (alterExtractString == null || alterExtractString.equalsIgnoreCase("as_is")) {
            alterExtractList = ExtractReader.ALTER_METADATA_LIST.AS_IS;
        } else if (alterExtractString.equalsIgnoreCase("first_only")) {
            alterExtractList = ExtractReader.ALTER_METADATA_LIST.FIRST_ONLY;
        } else if (alterExtractString.equalsIgnoreCase("concatenate_content")) {
            alterExtractList = ExtractReader.ALTER_METADATA_LIST.CONCATENATE_CONTENT_INTO_FIRST;
        } else {
            throw new RuntimeException("options for alterExtract: as_is, first_only, concatenate_content. I don't understand:" + alterExtractString);
        }
        return alterExtractList;
    }

    protected ExtractReader buildExtractReader(Map<String, String> localAttrs) {
        long minExtractLength = PropsUtil.getLong(localAttrs.get("minExtractLength"), -1L);
        long maxExtractLength = PropsUtil.getLong(localAttrs.get("maxExtractLength"), -1L);
        ExtractReader.ALTER_METADATA_LIST alterExtractList = this.getAlterMetadata(localAttrs);
        return new ExtractReader(alterExtractList, minExtractLength, maxExtractLength);
    }

    FileResourceConsumer parameterizeProfiler(AbstractProfiler abstractProfiler) {
        int maxTokens;
        int maxContentLengthForLangId;
        int maxContentLength = PropsUtil.getInt(this.localAttrs.get("maxContentLength"), -2);
        if (maxContentLength > -2) {
            abstractProfiler.setMaxContentLength(maxContentLength);
        }
        if ((maxContentLengthForLangId = PropsUtil.getInt(this.localAttrs.get("maxContentLengthForLangId"), -2).intValue()) > -2) {
            abstractProfiler.setMaxContentLengthForLangId(maxContentLengthForLangId);
        }
        if ((maxTokens = PropsUtil.getInt(this.localAttrs.get("maxTokens"), -2).intValue()) > -2) {
            abstractProfiler.setMaxTokens(maxTokens);
        }
        return abstractProfiler;
    }
}

