/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.eval.app;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.ParseException;
import org.apache.tika.batch.fs.FSBatchProcessCLI;
import org.apache.tika.eval.app.ExtractComparer;
import org.apache.tika.eval.app.ExtractProfiler;
import org.apache.tika.eval.app.FileProfiler;
import org.apache.tika.eval.app.reports.ResultsReporter;
import org.h2.tools.Console;

public class TikaEvalCLI {
    static final String[] tools = new String[]{"Profile", "FileProfile", "Compare", "Report", "StartDB"};

    private static String specifyTools() {
        StringBuilder sb = new StringBuilder();
        sb.append("Must specify one of the following tools in the first parameter:\n");
        for (String s : tools) {
            sb.append(s).append("\n");
        }
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        TikaEvalCLI cli = new TikaEvalCLI();
        if (args.length == 0) {
            System.err.println(TikaEvalCLI.specifyTools());
            return;
        }
        cli.execute(args);
    }

    private void execute(String[] args) throws Exception {
        String tool = args[0];
        String[] subsetArgs = new String[args.length - 1];
        System.arraycopy(args, 1, subsetArgs, 0, args.length - 1);
        switch (tool) {
            case "Report": {
                this.handleReport(subsetArgs);
                break;
            }
            case "Compare": {
                this.handleCompare(subsetArgs);
                break;
            }
            case "Profile": {
                this.handleProfile(subsetArgs);
                break;
            }
            case "StartDB": {
                this.handleStartDB(subsetArgs);
                break;
            }
            case "FileProfile": {
                this.handleProfileFiles(subsetArgs);
                break;
            }
            default: {
                System.out.println(TikaEvalCLI.specifyTools());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleProfileFiles(String[] subsetArgs) throws Exception {
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(subsetArgs));
        boolean containsBC = false;
        Object inputDir = null;
        for (String arg : argList) {
            if (!arg.equals("-bc")) continue;
            containsBC = true;
            break;
        }
        Path tmpBCConfig = null;
        try {
            tmpBCConfig = Files.createTempFile("tika-eval-profiler", ".xml", new FileAttribute[0]);
            if (!containsBC) {
                try (InputStream is = this.getClass().getResourceAsStream("/tika-eval-file-profiler-config.xml");){
                    Files.copy(is, tmpBCConfig, StandardCopyOption.REPLACE_EXISTING);
                }
                argList.add("-bc");
                argList.add(tmpBCConfig.toAbsolutePath().toString());
            }
            String[] updatedArgs = argList.toArray(new String[0]);
            DefaultParser defaultCLIParser = new DefaultParser();
            try {
                CommandLine commandLine = defaultCLIParser.parse(FileProfiler.OPTIONS, updatedArgs);
                if (commandLine.hasOption("db") && commandLine.hasOption("jdbc")) {
                    System.out.println("Please specify either the default -db or the full -jdbc, not both");
                    ExtractProfiler.USAGE();
                    return;
                }
            }
            catch (ParseException e) {
                System.out.println(e.getMessage() + "\n");
                FileProfiler.USAGE();
                return;
            }
            if (tmpBCConfig != null && Files.isRegularFile(tmpBCConfig, new LinkOption[0])) {
                tmpBCConfig.toFile().deleteOnExit();
            }
            FSBatchProcessCLI.main(updatedArgs);
        }
        finally {
            if (tmpBCConfig != null && Files.isRegularFile(tmpBCConfig, new LinkOption[0])) {
                Files.delete(tmpBCConfig);
            }
        }
    }

    private void handleStartDB(String[] args) throws SQLException {
        ArrayList<String> argList = new ArrayList<String>();
        argList.add("-web");
        Console.main(argList.toArray(new String[0]));
        try {
            while (true) {
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleProfile(String[] subsetArgs) throws Exception {
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(subsetArgs));
        boolean containsBC = false;
        String inputDir = null;
        String extracts = null;
        String alterExtract = null;
        block28: for (int i = 0; i < argList.size(); ++i) {
            String arg = (String)argList.get(i);
            switch (arg) {
                case "-bc": {
                    containsBC = true;
                    continue block28;
                }
                case "-inputDir": {
                    if (i + 1 >= argList.size()) {
                        System.err.println("Must specify directory after -inputDir");
                        ExtractProfiler.USAGE();
                        return;
                    }
                    inputDir = (String)argList.get(i + 1);
                    ++i;
                    continue block28;
                }
                case "-extracts": {
                    if (i + 1 >= argList.size()) {
                        System.err.println("Must specify directory after -extracts");
                        ExtractProfiler.USAGE();
                        return;
                    }
                    extracts = (String)argList.get(i + 1);
                    ++i;
                    continue block28;
                }
                case "-alterExtract": {
                    if (i + 1 >= argList.size()) {
                        System.err.println("Must specify type 'as_is', 'first_only' or 'concatenate_content' after -alterExtract");
                        ExtractComparer.USAGE();
                        return;
                    }
                    alterExtract = (String)argList.get(i + 1);
                    ++i;
                }
            }
        }
        if (!(alterExtract == null || alterExtract.equals("as_is") || alterExtract.equals("concatenate_content") || alterExtract.equals("first_only"))) {
            System.out.println("Sorry, I don't understand:" + alterExtract + ". The values must be one of: as_is, first_only, concatenate_content");
            ExtractProfiler.USAGE();
            return;
        }
        if (extracts == null && inputDir != null) {
            argList.add("-extracts");
            argList.add(inputDir);
        } else if (inputDir == null && extracts != null) {
            argList.add("-inputDir");
            argList.add(extracts);
        }
        Path tmpBCConfig = null;
        try {
            tmpBCConfig = Files.createTempFile("tika-eval-profiler", ".xml", new FileAttribute[0]);
            if (!containsBC) {
                InputStream is = this.getClass().getResourceAsStream("/tika-eval-profiler-config.xml");
                Object object = null;
                try {
                    Files.copy(is, tmpBCConfig, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (is != null) {
                        if (object != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            is.close();
                        }
                    }
                }
                argList.add("-bc");
                argList.add(tmpBCConfig.toAbsolutePath().toString());
            }
            String[] updatedArgs = argList.toArray(new String[0]);
            DefaultParser defaultCLIParser = new DefaultParser();
            try {
                CommandLine commandLine = defaultCLIParser.parse(ExtractProfiler.OPTIONS, updatedArgs);
                if (commandLine.hasOption("db") && commandLine.hasOption("jdbc")) {
                    System.out.println("Please specify either the default -db or the full -jdbc, not both");
                    ExtractProfiler.USAGE();
                    return;
                }
            }
            catch (ParseException e) {
                System.out.println(e.getMessage() + "\n");
                ExtractProfiler.USAGE();
                return;
            }
            if (tmpBCConfig != null && Files.isRegularFile(tmpBCConfig, new LinkOption[0])) {
                tmpBCConfig.toFile().deleteOnExit();
            }
            FSBatchProcessCLI.main(updatedArgs);
        }
        finally {
            if (tmpBCConfig != null && Files.isRegularFile(tmpBCConfig, new LinkOption[0])) {
                Files.delete(tmpBCConfig);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCompare(String[] subsetArgs) throws Exception {
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(subsetArgs));
        boolean containsBC = false;
        String inputDir = null;
        String extractsA = null;
        String alterExtract = null;
        block28: for (int i = 0; i < argList.size(); ++i) {
            String arg = (String)argList.get(i);
            switch (arg) {
                case "-bc": {
                    containsBC = true;
                    continue block28;
                }
                case "-inputDir": {
                    if (i + 1 >= argList.size()) {
                        System.err.println("Must specify directory after -inputDir");
                        ExtractComparer.USAGE();
                        return;
                    }
                    inputDir = (String)argList.get(i + 1);
                    ++i;
                    continue block28;
                }
                case "-extractsA": {
                    if (i + 1 >= argList.size()) {
                        System.err.println("Must specify directory after -extractsA");
                        ExtractComparer.USAGE();
                        return;
                    }
                    extractsA = (String)argList.get(i + 1);
                    ++i;
                    continue block28;
                }
                case "-alterExtract": {
                    if (i + 1 >= argList.size()) {
                        System.err.println("Must specify type 'as_is', 'first_only' or 'concatenate_content' after -alterExtract");
                        ExtractComparer.USAGE();
                        return;
                    }
                    alterExtract = (String)argList.get(i + 1);
                    ++i;
                }
            }
        }
        if (!(alterExtract == null || alterExtract.equals("as_is") || alterExtract.equals("concatenate_content") || alterExtract.equals("first_only"))) {
            System.out.println("Sorry, I don't understand:" + alterExtract + ". The values must be one of: as_is, first_only, concatenate_content");
            ExtractComparer.USAGE();
            return;
        }
        if (inputDir == null && extractsA != null) {
            argList.add("-inputDir");
            argList.add(extractsA);
        }
        Path tmpBCConfig = null;
        try {
            tmpBCConfig = Files.createTempFile("tika-eval", ".xml", new FileAttribute[0]);
            if (!containsBC) {
                InputStream is = this.getClass().getResourceAsStream("/tika-eval-comparison-config.xml");
                Object object = null;
                try {
                    Files.copy(is, tmpBCConfig, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (is != null) {
                        if (object != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            is.close();
                        }
                    }
                }
                argList.add("-bc");
                argList.add(tmpBCConfig.toAbsolutePath().toString());
            }
            String[] updatedArgs = argList.toArray(new String[0]);
            DefaultParser defaultCLIParser = new DefaultParser();
            try {
                CommandLine commandLine = defaultCLIParser.parse(ExtractComparer.OPTIONS, updatedArgs);
                if (commandLine.hasOption("db") && commandLine.hasOption("jdbc")) {
                    System.out.println("Please specify either the default -db or the full -jdbc, not both");
                    ExtractComparer.USAGE();
                    return;
                }
            }
            catch (ParseException e) {
                System.out.println(e.getMessage() + "\n");
                ExtractComparer.USAGE();
                return;
            }
            if (tmpBCConfig != null && Files.isRegularFile(tmpBCConfig, new LinkOption[0])) {
                tmpBCConfig.toFile().deleteOnExit();
            }
            FSBatchProcessCLI.main(updatedArgs);
        }
        finally {
            if (tmpBCConfig != null && Files.isRegularFile(tmpBCConfig, new LinkOption[0])) {
                Files.delete(tmpBCConfig);
            }
        }
    }

    private void handleReport(String[] subsetArgs) throws Exception {
        ResultsReporter.main(subsetArgs);
    }
}

