/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.icu;

import com.ibm.icu.text.FilteredNormalizer2;
import com.ibm.icu.text.Normalizer2;
import com.ibm.icu.text.UnicodeSet;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.icu.ICUFoldingFilter;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class ICUFoldingFilterFactory
extends TokenFilterFactory {
    public static final String NAME = "icuFolding";
    private final Normalizer2 normalizer;

    public ICUFoldingFilterFactory(Map<String, String> args) {
        super(args);
        UnicodeSet set;
        Normalizer2 normalizer = ICUFoldingFilter.NORMALIZER;
        String filter = this.get(args, "filter");
        if (filter != null && !(set = new UnicodeSet(filter)).isEmpty()) {
            set.freeze();
            normalizer = new FilteredNormalizer2(normalizer, set);
        }
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
        this.normalizer = normalizer;
    }

    @Override
    public TokenStream create(TokenStream input) {
        return new ICUFoldingFilter(input, this.normalizer);
    }

    @Override
    public TokenStream normalize(TokenStream input) {
        return this.create(input);
    }
}

