/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.resources;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;

public class KeyConstants {
    private final Class<?> keysClass;
    private transient String[] keys;

    protected KeyConstants() {
        this.keysClass = this.getClass();
    }

    KeyConstants(Class<?> clazz) {
        this.keysClass = clazz;
    }

    final synchronized String[] getKeyNames() {
        if (this.keys == null) {
            String[] stringArray;
            int n = 0;
            try {
                Field[] fieldArray = this.keysClass.getFields();
                stringArray = new String[fieldArray.length];
                for (Field field : fieldArray) {
                    if (!Modifier.isStatic(field.getModifiers()) || field.getType() != Short.TYPE) continue;
                    int n2 = Short.toUnsignedInt((Short)field.get(null)) - 1;
                    if (n2 >= n && (n = n2 + 1) > stringArray.length) {
                        stringArray = Arrays.copyOf(stringArray, n * 2);
                    }
                    stringArray[n2] = field.getName();
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                stringArray = CharSequences.EMPTY_ARRAY;
            }
            this.keys = ArraysExt.resize(stringArray, n);
        }
        return this.keys;
    }

    final String getKeyName(short s2) {
        String string;
        int n = Short.toUnsignedInt(s2) - 1;
        String[] stringArray = this.getKeyNames();
        if (n >= 0 && n < stringArray.length && (string = stringArray[n]) != null) {
            return string;
        }
        return String.valueOf(s2);
    }

    final short getKeyValue(String string) throws NoSuchFieldException, IllegalAccessException {
        return (Short)this.keysClass.getField(string).get(null);
    }
}

