/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.util.EnumMap;
import java.util.regex.Pattern;
import org.apache.sis.internal.referencing.Formulas;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.referencing.provider.LambertConformal1SP;
import org.apache.sis.internal.referencing.provider.LambertConformal2SP;
import org.apache.sis.internal.referencing.provider.LambertConformalMichigan;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.Latitude;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.projection.ConformalProjection;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.apache.sis.referencing.operation.projection.ProjectionVariant;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;

public class LambertConicConformal
extends ConformalProjection {
    private static final long serialVersionUID = -8786460743797422415L;
    final double n;
    final double \u03b8_bound;

    static Number belgeA() {
        return new DoubleDouble(-1.420431363598774E-4, -1.1777378450498224E-20);
    }

    public LambertConicConformal(OperationMethod operationMethod, Parameters parameters) {
        this(LambertConicConformal.initializer(operationMethod, parameters));
    }

    private static Initializer initializer(OperationMethod operationMethod, Parameters parameters) {
        Variant variant = (Variant)LambertConicConformal.variant((OperationMethod)operationMethod, (ProjectionVariant[])Variant.values(), (ProjectionVariant)Variant.TWO_PARALLELS);
        EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>> enumMap = new EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>>(NormalizedProjection.ParameterRole.class);
        ParameterDescriptor<Double> parameterDescriptor = LambertConformal1SP.SCALE_FACTOR;
        NormalizedProjection.ParameterRole parameterRole = NormalizedProjection.ParameterRole.FALSE_EASTING;
        switch (variant) {
            case WEST: {
                parameterRole = NormalizedProjection.ParameterRole.FALSE_WESTING;
            }
            case ONE_PARALLEL: {
                enumMap.put(parameterRole, LambertConformal1SP.FALSE_EASTING);
                enumMap.put(NormalizedProjection.ParameterRole.FALSE_NORTHING, LambertConformal1SP.FALSE_NORTHING);
                enumMap.put(NormalizedProjection.ParameterRole.CENTRAL_MERIDIAN, LambertConformal1SP.LONGITUDE_OF_ORIGIN);
                break;
            }
            case MICHIGAN: {
                parameterDescriptor = LambertConformalMichigan.SCALE_FACTOR;
            }
            case BELGIUM: 
            case TWO_PARALLELS: {
                enumMap.put(parameterRole, LambertConformal2SP.EASTING_AT_FALSE_ORIGIN);
                enumMap.put(NormalizedProjection.ParameterRole.FALSE_NORTHING, LambertConformal2SP.NORTHING_AT_FALSE_ORIGIN);
                enumMap.put(NormalizedProjection.ParameterRole.CENTRAL_MERIDIAN, LambertConformal2SP.LONGITUDE_OF_FALSE_ORIGIN);
                break;
            }
            default: {
                throw new AssertionError(variant);
            }
        }
        enumMap.put(NormalizedProjection.ParameterRole.SCALE_FACTOR, parameterDescriptor);
        return new Initializer(operationMethod, parameters, enumMap, variant);
    }

    private LambertConicConformal(Initializer initializer) {
        super(initializer);
        Variant variant = (Variant)initializer.variant;
        double d = initializer.getAndStore(variant.is1SP ? LambertConformal1SP.LATITUDE_OF_ORIGIN : LambertConformal2SP.LATITUDE_OF_FALSE_ORIGIN);
        double d2 = initializer.getAndStore(LambertConformal2SP.STANDARD_PARALLEL_1, d);
        double d3 = initializer.getAndStore(LambertConformal2SP.STANDARD_PARALLEL_2, d2);
        if (Math.abs(d2 + d3) < 8.999280057595393E-8) {
            throw new IllegalArgumentException(Resources.format((short)31, new Latitude(d2), new Latitude(d3)));
        }
        boolean bl = MathFunctions.isPositive(d);
        if (bl) {
            d = -d;
            d2 = -d2;
            d3 = -d3;
        }
        d = Math.toRadians(d);
        d2 = Math.toRadians(d2);
        d3 = Math.toRadians(d3);
        double d4 = Math.sin(d2);
        double d5 = initializer.scaleAt\u03c6(d4, Math.cos(d2));
        double d6 = this.exp\u03a8(d2, this.eccentricity * d4);
        if (Math.abs(d2 - d3) >= 1.5706706731410455E-9) {
            double d7 = Math.sin(d3);
            double d8 = initializer.scaleAt\u03c6(d7, Math.cos(d3));
            double d9 = this.exp\u03a8(d3, this.eccentricity * d7);
            this.n = Math.log(d5 / d8) / Math.log(d6 / d9);
        } else {
            this.n = -d4;
        }
        DoubleDouble doubleDouble = new DoubleDouble(this.n);
        doubleDouble.multiply(Math.pow(d6, this.n));
        doubleDouble.inverseDivideGuessError(d5);
        if (!bl) {
            doubleDouble.negate();
        }
        DoubleDouble doubleDouble2 = null;
        if (d != Math.copySign(1.5707963267948966, -this.n)) {
            doubleDouble2 = new DoubleDouble(doubleDouble);
            doubleDouble2.multiply(Math.pow(this.exp\u03a8(d, this.eccentricity * Math.sin(d)), this.n));
        }
        DoubleDouble doubleDouble3 = new DoubleDouble(this.n);
        DoubleDouble doubleDouble4 = null;
        if (bl) {
            doubleDouble4 = new DoubleDouble(-1.0);
        } else {
            doubleDouble3.negate();
        }
        MatrixSIS matrixSIS = this.context.getMatrix(ContextualParameters.MatrixRole.NORMALIZATION);
        MatrixSIS matrixSIS2 = this.context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
        matrixSIS.convertAfter(0, doubleDouble3, variant == Variant.BELGIUM ? LambertConicConformal.belgeA() : null);
        matrixSIS.convertAfter(1, doubleDouble4, null);
        matrixSIS2.convertBefore(0, doubleDouble, null);
        doubleDouble.negate();
        matrixSIS2.convertBefore(1, doubleDouble, doubleDouble2);
        this.\u03b8_bound = initializer.boundOfScaledLongitude(doubleDouble3);
    }

    LambertConicConformal(LambertConicConformal lambertConicConformal) {
        super(lambertConicConformal);
        this.n = lambertConicConformal.n;
        this.\u03b8_bound = lambertConicConformal.\u03b8_bound;
    }

    @Override
    final String[] getInternalParameterNames() {
        return new String[]{"n"};
    }

    @Override
    final double[] getInternalParameterValues() {
        return new double[]{this.n};
    }

    @Override
    public MathTransform createMapProjection(MathTransformFactory mathTransformFactory) throws FactoryException {
        LambertConicConformal lambertConicConformal = this;
        if (this.eccentricity == 0.0 && this.getClass() == LambertConicConformal.class) {
            lambertConicConformal = new Spherical(this);
        }
        return this.context.completeTransform(mathTransformFactory, lambertConicConformal);
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws ProjectionException {
        double d;
        double d2;
        double d3 = LambertConicConformal.wraparoundScaledLongitude(dArray[n], this.\u03b8_bound);
        double d4 = dArray[n + 1];
        double d5 = Math.abs(d4);
        double d6 = Math.sin(d3);
        double d7 = Math.cos(d3);
        if (d5 < 1.5707963267948966) {
            d2 = Math.sin(d4);
            d = Math.pow(this.exp\u03a8(d4, this.eccentricity * d2), this.n);
        } else if (d5 < 1.5707963283655673) {
            d2 = 1.0;
            d = d4 * this.n >= 0.0 ? Double.POSITIVE_INFINITY : 0.0;
        } else {
            d2 = Double.NaN;
            d = Double.NaN;
        }
        double d8 = d * d6;
        double d9 = d * d7;
        if (dArray2 != null) {
            dArray2[n2] = d8;
            dArray2[n2 + 1] = d9;
        }
        if (!bl) {
            return null;
        }
        double d10 = d2 != 1.0 ? this.n * this.dy_d\u03c6(d2, Math.cos(d4)) * d : d;
        return new Matrix2(d9, d10 * d6, -d8, d10 * d7);
    }

    @Override
    protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
        double d = dArray[n];
        double d2 = dArray[n + 1];
        dArray2[n2] = Math.atan2(d, d2);
        dArray2[n2 + 1] = -this.\u03c6(Math.pow(Formulas.fastHypot(d, d2), 1.0 / this.n));
    }

    private static enum Variant implements ProjectionVariant
    {
        BELGIUM(".*\\bBelgium\\b.*", "9803", false),
        MICHIGAN(".*\\bMichigan\\b.*", "1051", false),
        WEST(".*\\bWest\\b.*", "9826", true),
        ONE_PARALLEL(".*\\b1SP\\b.*", "9801", true),
        TWO_PARALLELS(".*\\b2SP\\b.*", "9802", false);

        private final Pattern operationName;
        private final String identifier;
        final boolean is1SP;

        private Variant(String string2, String string3, boolean bl) {
            this.operationName = Pattern.compile(string2, 2);
            this.identifier = string3;
            this.is1SP = bl;
        }

        @Override
        public Pattern getOperationNamePattern() {
            return this.operationName;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }
    }

    static final class Spherical
    extends LambertConicConformal {
        private static final long serialVersionUID = -8077690516096472987L;

        protected Spherical(LambertConicConformal lambertConicConformal) {
            super(lambertConicConformal);
        }

        @Override
        public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) {
            double d = Spherical.wraparoundScaledLongitude(dArray[n], this.\u03b8_bound);
            double d2 = dArray[n + 1];
            double d3 = Math.abs(d2);
            double d4 = Math.sin(d);
            double d5 = Math.cos(d);
            double d6 = d3 < 1.5707963267948966 ? Math.pow(Math.tan(0.7853981633974483 + 0.5 * d2), this.n) : (d3 < 1.5707963283655673 ? (d2 * this.n >= 0.0 ? Double.POSITIVE_INFINITY : 0.0) : Double.NaN);
            double d7 = d6 * d4;
            double d8 = d6 * d5;
            if (dArray2 != null) {
                dArray2[n2] = d7;
                dArray2[n2 + 1] = d8;
            }
            if (!bl) {
                return null;
            }
            double d9 = d3 < 1.5707963267948966 ? this.n * d6 / Math.cos(d2) : Double.NaN;
            return new Matrix2(d8, d9 * d4, -d7, d9 * d5);
        }

        @Override
        protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) {
            double d = dArray[n];
            double d2 = dArray[n + 1];
            double d3 = Math.hypot(d, d2);
            dArray2[n2] = Math.atan2(d, d2);
            dArray2[n2 + 1] = 1.5707963267948966 - 2.0 * Math.atan(Math.pow(1.0 / d3, 1.0 / this.n));
        }
    }
}

