/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.measure.IncommensurableException;
import org.apache.sis.internal.referencing.CoordinateOperations;
import org.apache.sis.internal.referencing.DeferredCoordinateOperation;
import org.apache.sis.internal.referencing.EllipsoidalHeightCombiner;
import org.apache.sis.internal.referencing.PositionalAccuracyConstant;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.referencing.provider.Affine;
import org.apache.sis.internal.system.Semaphores;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.factory.GeodeticAuthorityFactory;
import org.apache.sis.referencing.factory.IdentifiedObjectFinder;
import org.apache.sis.referencing.factory.InvalidGeodeticParameterException;
import org.apache.sis.referencing.factory.MissingFactoryResourceException;
import org.apache.sis.referencing.factory.NoSuchAuthorityFactoryException;
import org.apache.sis.referencing.operation.AbstractCoordinateOperation;
import org.apache.sis.referencing.operation.CRSPair;
import org.apache.sis.referencing.operation.CoordinateOperationContext;
import org.apache.sis.referencing.operation.CoordinateOperationFinder;
import org.apache.sis.referencing.operation.CoordinateOperationSorter;
import org.apache.sis.referencing.operation.DefaultCoordinateOperationFactory;
import org.apache.sis.referencing.operation.DefaultOperationMethod;
import org.apache.sis.referencing.operation.InverseOperationMethod;
import org.apache.sis.referencing.operation.SubTypes;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Deprecable;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.operation.ConcatenatedOperation;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.FactoryException;
import org.opengis.util.NoSuchIdentifierException;

class CoordinateOperationRegistry {
    static final Identifier IDENTITY = CoordinateOperationRegistry.createIdentifier((short)101);
    static final Identifier CONSTANTS = CoordinateOperationRegistry.createIdentifier((short)233);
    static final Identifier AXIS_CHANGES = CoordinateOperationRegistry.createIdentifier((short)12);
    static final Identifier ELLIPSOID_CHANGE = CoordinateOperationRegistry.createIdentifier((short)73);
    static final Identifier DATUM_SHIFT = CoordinateOperationRegistry.createIdentifier((short)54);
    static final Identifier GEOCENTRIC_CONVERSION = CoordinateOperationRegistry.createIdentifier((short)87);
    private static final Identifier INVERSE_OPERATION = CoordinateOperationRegistry.createIdentifier((short)108);
    private final IdentifiedObjectFinder codeFinder;
    protected final CoordinateOperationAuthorityFactory registry;
    protected final CoordinateOperationFactory factory;
    final DefaultCoordinateOperationFactory factorySIS;
    protected Extent areaOfInterest;
    protected double desiredAccuracy;
    boolean stopAtFirst;
    private Predicate<CoordinateOperation> filter;
    private final Map<CoordinateReferenceSystem, List<String>> authorityCodes;

    private static Identifier createIdentifier(short s2) {
        return new NamedIdentifier(Citations.SIS, Vocabulary.formatInternational(s2));
    }

    CoordinateOperationRegistry(CoordinateOperationAuthorityFactory coordinateOperationAuthorityFactory, CoordinateOperationFactory coordinateOperationFactory, CoordinateOperationContext coordinateOperationContext) throws FactoryException {
        ArgumentChecks.ensureNonNull("factory", coordinateOperationFactory);
        this.registry = coordinateOperationAuthorityFactory;
        this.factory = coordinateOperationFactory;
        this.factorySIS = coordinateOperationFactory instanceof DefaultCoordinateOperationFactory ? (DefaultCoordinateOperationFactory)coordinateOperationFactory : CoordinateOperations.factory();
        Map map = Collections.emptyMap();
        IdentifiedObjectFinder identifiedObjectFinder = null;
        if (coordinateOperationAuthorityFactory != null) {
            if (coordinateOperationAuthorityFactory instanceof GeodeticAuthorityFactory) {
                identifiedObjectFinder = ((GeodeticAuthorityFactory)((Object)coordinateOperationAuthorityFactory)).newIdentifiedObjectFinder();
            } else {
                try {
                    identifiedObjectFinder = IdentifiedObjects.newFinder(Citations.toCodeSpace(coordinateOperationAuthorityFactory.getAuthority()));
                }
                catch (NoSuchAuthorityFactoryException noSuchAuthorityFactoryException) {
                    CoordinateOperationRegistry.recoverableException("<init>", noSuchAuthorityFactoryException);
                }
            }
            if (identifiedObjectFinder != null) {
                map = new IdentityHashMap(5);
            }
        }
        this.codeFinder = identifiedObjectFinder;
        this.authorityCodes = map;
        if (coordinateOperationContext != null) {
            this.areaOfInterest = coordinateOperationContext.getAreaOfInterest();
            this.desiredAccuracy = coordinateOperationContext.getDesiredAccuracy();
            this.filter = coordinateOperationContext.getOperationFilter();
        }
    }

    final <T extends IdentifiedObject> T toAuthorityDefinition(Class<T> clazz, T t) throws FactoryException {
        if (this.codeFinder != null) {
            this.codeFinder.setIgnoringAxes(false);
            this.codeFinder.setSearchDomain(IdentifiedObjectFinder.Domain.VALID_DATASET);
            IdentifiedObject identifiedObject = this.codeFinder.findSingleton(t);
            if (Utilities.equalsIgnoreMetadata(t, identifiedObject)) {
                return (T)((IdentifiedObject)clazz.cast(identifiedObject));
            }
        }
        return t;
    }

    private List<String> findCode(CoordinateReferenceSystem coordinateReferenceSystem) throws FactoryException {
        List<String> list = this.authorityCodes.get(coordinateReferenceSystem);
        if (list == null) {
            if (this.codeFinder == null) {
                return Collections.emptyList();
            }
            list = new ArrayList<String>();
            this.codeFinder.setIgnoringAxes(true);
            this.codeFinder.setSearchDomain(CoordinateOperationRegistry.isEasySearch(coordinateReferenceSystem) ? IdentifiedObjectFinder.Domain.EXHAUSTIVE_VALID_DATASET : IdentifiedObjectFinder.Domain.VALID_DATASET);
            int n = 0;
            Citation citation = this.registry.getAuthority();
            for (IdentifiedObject identifiedObject : this.codeFinder.find(coordinateReferenceSystem)) {
                Identifier identifier = IdentifiedObjects.getIdentifier(identifiedObject, citation);
                if (identifier == null) continue;
                String string = identifier.getCode();
                if (Utilities.deepEquals(identifiedObject, coordinateReferenceSystem, ComparisonMode.APPROXIMATE)) {
                    list.add(n++, string);
                    continue;
                }
                list.add(string);
            }
            this.authorityCodes.put(coordinateReferenceSystem, list);
        }
        return list;
    }

    private static boolean isEasySearch(CoordinateReferenceSystem coordinateReferenceSystem) {
        if (coordinateReferenceSystem instanceof GeneralDerivedCRS) {
            return false;
        }
        if (coordinateReferenceSystem instanceof CompoundCRS) {
            for (CoordinateReferenceSystem coordinateReferenceSystem2 : ((CompoundCRS)coordinateReferenceSystem).getComponents()) {
                if (CoordinateOperationRegistry.isEasySearch(coordinateReferenceSystem2)) continue;
                return false;
            }
        }
        return true;
    }

    public List<CoordinateOperation> createOperations(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) throws FactoryException {
        SingleCRS singleCRS = null;
        SingleCRS singleCRS2 = null;
        boolean bl = false;
        boolean bl2 = false;
        for (Decomposition decomposition : Decomposition.values()) {
            Object object;
            CoordinateReferenceSystem coordinateReferenceSystem3 = coordinateReferenceSystem;
            CoordinateReferenceSystem coordinateReferenceSystem4 = coordinateReferenceSystem2;
            if (decomposition.source) {
                if (!bl) {
                    bl = true;
                    singleCRS = Decomposition.horizontal(coordinateReferenceSystem);
                }
                coordinateReferenceSystem3 = singleCRS;
            }
            if (decomposition.target) {
                if (!bl2) {
                    bl2 = true;
                    singleCRS2 = Decomposition.horizontal(coordinateReferenceSystem2);
                }
                coordinateReferenceSystem4 = singleCRS2;
            }
            if (coordinateReferenceSystem3 == null || coordinateReferenceSystem4 == null) continue;
            try {
                List<CoordinateOperation> list = this.search(coordinateReferenceSystem3, coordinateReferenceSystem4);
                if (list == null) continue;
                if (decomposition.source | decomposition.target) {
                    int n = list.size();
                    while (--n >= 0) {
                        object = list.get(n);
                        if ((object = this.propagateVertical(coordinateReferenceSystem, coordinateReferenceSystem2, (CoordinateOperation)object, decomposition)) != null) {
                            object = this.complete((CoordinateOperation)object, coordinateReferenceSystem, coordinateReferenceSystem2);
                            list.set(n, (CoordinateOperation)object);
                            continue;
                        }
                        list.remove(n);
                    }
                }
                if (list.isEmpty()) continue;
                return list;
            }
            catch (IllegalArgumentException | IncommensurableException exception) {
                String string = Resources.format((short)5, new CRSPair(coordinateReferenceSystem, coordinateReferenceSystem2));
                object = exception.getLocalizedMessage();
                if (object != null) {
                    string = string + ' ' + (String)object;
                }
                throw new FactoryException(string, exception);
            }
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private List<CoordinateOperation> search(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) throws IllegalArgumentException, IncommensurableException, FactoryException {
        List<String> list = this.findCode(coordinateReferenceSystem);
        if (list.isEmpty()) {
            return null;
        }
        List<String> list2 = this.findCode(coordinateReferenceSystem2);
        if (list2.isEmpty()) {
            return null;
        }
        ArrayList<CoordinateOperation> arrayList = new ArrayList<CoordinateOperation>();
        boolean bl = false;
        boolean bl2 = false;
        for (String object : list) {
            block13: for (String string : list2) {
                Set<CoordinateOperation> set;
                boolean bl3;
                block28: {
                    block29: {
                        if (object.equals(string)) {
                            return null;
                        }
                        bl3 = Semaphores.queryAndSet(2);
                        set = this.registry.createFromCoordinateReferenceSystemCodes(object, string);
                        boolean bl4 = Containers.isNullOrEmpty(set);
                        if (!bl4) break block28;
                        if (!bl) break block29;
                        Semaphores.clear(2, bl3);
                        continue;
                    }
                    set = this.registry.createFromCoordinateReferenceSystemCodes(string, object);
                    if (Containers.isNullOrEmpty(set)) {
                        continue;
                    }
                }
                try {
                    try {
                        if (!bl) {
                            bl = true;
                            arrayList.clear();
                        }
                    }
                    catch (MissingFactoryResourceException | NoSuchAuthorityCodeException factoryException) {
                        CoordinateOperationRegistry.log(null, factoryException);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    Semaphores.clear(2, bl3);
                    continue;
                }
                {
                    try {
                        for (CoordinateOperation coordinateOperation : set) {
                            if (coordinateOperation == null) continue;
                            if (coordinateOperation instanceof Deprecable && ((Deprecable)((Object)coordinateOperation)).isDeprecated()) {
                                if (!bl2 && !arrayList.isEmpty()) continue block13;
                                bl2 = true;
                            } else if (bl2) {
                                bl2 = false;
                                arrayList.clear();
                            }
                            arrayList.add(coordinateOperation);
                        }
                    }
                    catch (BackingStoreException backingStoreException) {
                        throw backingStoreException.unwrapOrRethrow(FactoryException.class);
                    }
                }
            }
        }
        CoordinateOperationSorter.sort(arrayList, Extents.getGeographicBoundingBox(this.areaOfInterest));
        Iterator<String> iterator = arrayList.listIterator();
        while (iterator.hasNext()) {
            void var9_17;
            block30: {
                CoordinateOperation coordinateOperation = (CoordinateOperation)iterator.next();
                try {
                    void var9_15;
                    CoordinateOperation coordinateOperation2;
                    void var9_13;
                    if (coordinateOperation instanceof DeferredCoordinateOperation) {
                        CoordinateOperation coordinateOperation3 = ((DeferredCoordinateOperation)coordinateOperation).create();
                    }
                    if (var9_13 instanceof SingleOperation && var9_13.getMathTransform() == null && (coordinateOperation2 = this.fromDefiningConversion((SingleOperation)var9_13, bl ? coordinateReferenceSystem : coordinateReferenceSystem2, bl ? coordinateReferenceSystem2 : coordinateReferenceSystem)) == null) {
                        iterator.remove();
                        continue;
                    }
                    if (bl) break block30;
                    CoordinateOperation coordinateOperation4 = this.inverse((CoordinateOperation)var9_15);
                }
                catch (MissingFactoryResourceException | NoninvertibleTransformException exception) {
                    CoordinateOperationRegistry.log(null, exception);
                    iterator.remove();
                    continue;
                }
            }
            CoordinateOperation coordinateOperation = this.complete((CoordinateOperation)var9_17, coordinateReferenceSystem, coordinateReferenceSystem2);
            if (this.filter == null || this.filter.test(coordinateOperation)) {
                if (this.stopAtFirst) {
                    arrayList.clear();
                    arrayList.add(coordinateOperation);
                    break;
                }
                iterator.set((String)((Object)coordinateOperation));
                continue;
            }
            iterator.remove();
        }
        return arrayList;
    }

    final CoordinateOperation inverse(SingleOperation singleOperation) throws NoninvertibleTransformException, FactoryException {
        CoordinateReferenceSystem coordinateReferenceSystem = singleOperation.getSourceCRS();
        CoordinateReferenceSystem coordinateReferenceSystem2 = singleOperation.getTargetCRS();
        MathTransform mathTransform = singleOperation.getMathTransform().inverse();
        OperationMethod operationMethod = InverseOperationMethod.create(singleOperation.getMethod(), this.factorySIS);
        Map<String, Object> map = CoordinateOperationRegistry.properties(INVERSE_OPERATION);
        InverseOperationMethod.properties(singleOperation, map);
        Class clazz = null;
        if (singleOperation instanceof Transformation) {
            clazz = Transformation.class;
        } else if (singleOperation instanceof Conversion) {
            clazz = Conversion.class;
        }
        return this.createFromMathTransform(map, coordinateReferenceSystem2, coordinateReferenceSystem, mathTransform, operationMethod, null, clazz);
    }

    private CoordinateOperation inverse(CoordinateOperation coordinateOperation) throws NoninvertibleTransformException, FactoryException {
        if (SubTypes.isSingleOperation(coordinateOperation)) {
            return this.inverse((SingleOperation)coordinateOperation);
        }
        if (coordinateOperation instanceof ConcatenatedOperation) {
            List<SingleOperation> list = ((ConcatenatedOperation)coordinateOperation).getOperations();
            CoordinateOperation[] coordinateOperationArray = new CoordinateOperation[list.size()];
            int n = 0;
            while (n < coordinateOperationArray.length) {
                CoordinateOperation coordinateOperation2 = this.inverse((CoordinateOperation)list.get(n));
                if (coordinateOperation2 == null) {
                    return null;
                }
                coordinateOperationArray[coordinateOperationArray.length - ++n] = coordinateOperation2;
            }
            return this.factory.createConcatenatedOperation(CoordinateOperationRegistry.properties(INVERSE_OPERATION), coordinateOperationArray);
        }
        return null;
    }

    private CoordinateOperation complete(CoordinateOperation coordinateOperation, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) throws IllegalArgumentException, IncommensurableException, FactoryException {
        CoordinateReferenceSystem coordinateReferenceSystem3 = coordinateOperation.getSourceCRS();
        CoordinateReferenceSystem coordinateReferenceSystem4 = coordinateOperation.getTargetCRS();
        MathTransformFactory mathTransformFactory = this.factorySIS.getMathTransformFactory();
        MathTransform mathTransform = CoordinateOperationRegistry.swapAndScaleAxes(coordinateReferenceSystem, coordinateReferenceSystem3, mathTransformFactory);
        MathTransform mathTransform2 = CoordinateOperationRegistry.swapAndScaleAxes(coordinateReferenceSystem4, coordinateReferenceSystem2, mathTransformFactory);
        if (mathTransform != null) {
            coordinateReferenceSystem3 = coordinateReferenceSystem;
        }
        if (mathTransform2 != null) {
            coordinateReferenceSystem4 = coordinateReferenceSystem2;
        }
        return this.transform(coordinateReferenceSystem3, mathTransform, coordinateOperation, mathTransform2, coordinateReferenceSystem4, mathTransformFactory);
    }

    private static MathTransform swapAndScaleAxes(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, MathTransformFactory mathTransformFactory) throws IllegalArgumentException, IncommensurableException, FactoryException {
        assert (ReferencingUtilities.getDimension(coordinateReferenceSystem) != ReferencingUtilities.getDimension(coordinateReferenceSystem2) || Utilities.deepEquals(coordinateReferenceSystem, coordinateReferenceSystem2, ComparisonMode.ALLOW_VARIANT));
        Matrix matrix = CoordinateSystems.swapAndScaleAxes(coordinateReferenceSystem.getCoordinateSystem(), coordinateReferenceSystem2.getCoordinateSystem());
        return matrix.isIdentity() ? null : mathTransformFactory.createAffineTransform(matrix);
    }

    private CoordinateOperation transform(CoordinateReferenceSystem coordinateReferenceSystem, MathTransform mathTransform, CoordinateOperation coordinateOperation, MathTransform mathTransform2, CoordinateReferenceSystem coordinateReferenceSystem2, MathTransformFactory mathTransformFactory) throws IllegalArgumentException, FactoryException {
        Object object;
        if ((mathTransform == null || mathTransform.isIdentity()) && (mathTransform2 == null || mathTransform2.isIdentity())) {
            return coordinateOperation;
        }
        if (coordinateOperation instanceof ConcatenatedOperation) {
            object = ((ConcatenatedOperation)coordinateOperation).getOperations();
            CoordinateOperation[] coordinateOperationArray = object.toArray(new CoordinateOperation[object.size()]);
            switch (coordinateOperationArray.length) {
                case 0: {
                    break;
                }
                case 1: {
                    coordinateOperation = coordinateOperationArray[0];
                    break;
                }
                default: {
                    int n = coordinateOperationArray.length - 1;
                    CoordinateOperation coordinateOperation2 = coordinateOperationArray[0];
                    CoordinateOperation coordinateOperation3 = coordinateOperationArray[n];
                    coordinateOperationArray[0] = this.transform(coordinateReferenceSystem, mathTransform, coordinateOperation2, null, coordinateOperation2.getTargetCRS(), mathTransformFactory);
                    coordinateOperationArray[n] = this.transform(coordinateOperation3.getSourceCRS(), null, coordinateOperation3, mathTransform2, coordinateReferenceSystem2, mathTransformFactory);
                    return this.factory.createConcatenatedOperation(CoordinateOperationRegistry.derivedFrom(coordinateOperation), coordinateOperationArray);
                }
            }
        }
        object = coordinateOperation.getMathTransform();
        if (mathTransform != null) {
            object = mathTransformFactory.createConcatenatedTransform(mathTransform, (MathTransform)object);
        }
        if (mathTransform2 != null) {
            object = mathTransformFactory.createConcatenatedTransform((MathTransform)object, mathTransform2);
        }
        assert (!object.equals(coordinateOperation.getMathTransform())) : object;
        return this.recreate(coordinateOperation, coordinateReferenceSystem, coordinateReferenceSystem2, (MathTransform)object, null);
    }

    private CoordinateOperation recreate(CoordinateOperation coordinateOperation, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, MathTransform mathTransform, OperationMethod operationMethod) throws IllegalArgumentException, FactoryException {
        CoordinateReferenceSystem coordinateReferenceSystem3 = coordinateOperation.getSourceCRS();
        if (Utilities.equalsApproximately(coordinateReferenceSystem, coordinateReferenceSystem3)) {
            coordinateReferenceSystem = coordinateReferenceSystem3;
        }
        if (Utilities.equalsApproximately(coordinateReferenceSystem2, coordinateReferenceSystem3 = coordinateOperation.getTargetCRS())) {
            coordinateReferenceSystem2 = coordinateReferenceSystem3;
        }
        HashMap hashMap = new HashMap(CoordinateOperationRegistry.derivedFrom(coordinateOperation));
        hashMap.put("operationType", ReferencingUtilities.getInterface(CoordinateOperation.class, coordinateOperation));
        if (SubTypes.isSingleOperation(coordinateOperation)) {
            SingleOperation singleOperation = (SingleOperation)coordinateOperation;
            hashMap.put("parameters", singleOperation.getParameterValues());
            if (operationMethod == null) {
                int n = mathTransform.getSourceDimensions();
                int n2 = mathTransform.getTargetDimensions();
                operationMethod = singleOperation.getMethod();
                try {
                    operationMethod = DefaultOperationMethod.redimension(operationMethod, n, n2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    try {
                        operationMethod = this.factorySIS.getOperationMethod(operationMethod.getName().getCode());
                        operationMethod = DefaultOperationMethod.redimension(operationMethod, n, n2);
                    }
                    catch (IllegalArgumentException | NoSuchIdentifierException exception) {
                        illegalArgumentException.addSuppressed(exception);
                        throw illegalArgumentException;
                    }
                }
            }
        }
        return this.factorySIS.createSingleOperation(hashMap, coordinateReferenceSystem, coordinateReferenceSystem2, AbstractCoordinateOperation.getInterpolationCRS(coordinateOperation), operationMethod, mathTransform);
    }

    private CoordinateOperation fromDefiningConversion(SingleOperation singleOperation, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) throws FactoryException {
        ParameterValueGroup parameterValueGroup = singleOperation.getParameterValues();
        if (parameterValueGroup != null) {
            MathTransformFactory mathTransformFactory;
            CoordinateReferenceSystem coordinateReferenceSystem3 = singleOperation.getSourceCRS();
            if (Utilities.equalsApproximately(coordinateReferenceSystem, coordinateReferenceSystem3)) {
                coordinateReferenceSystem = coordinateReferenceSystem3;
            }
            if (Utilities.equalsApproximately(coordinateReferenceSystem2, coordinateReferenceSystem3 = singleOperation.getTargetCRS())) {
                coordinateReferenceSystem2 = coordinateReferenceSystem3;
            }
            if ((mathTransformFactory = this.factorySIS.getMathTransformFactory()) instanceof DefaultMathTransformFactory) {
                MathTransform mathTransform = ((DefaultMathTransformFactory)mathTransformFactory).createParameterizedTransform(parameterValueGroup, ReferencingUtilities.createTransformContext(coordinateReferenceSystem, coordinateReferenceSystem2, null));
                return this.factorySIS.createSingleOperation(IdentifiedObjects.getProperties(singleOperation, new String[0]), coordinateReferenceSystem, coordinateReferenceSystem2, null, singleOperation.getMethod(), mathTransform);
            }
        } else {
            CoordinateOperationRegistry.log(Resources.forLocale(null).getLogRecord(Level.WARNING, (short)74, IdentifiedObjects.getIdentifierOrName(singleOperation)), null);
        }
        return null;
    }

    private CoordinateOperation propagateVertical(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, CoordinateOperation coordinateOperation, Decomposition decomposition) throws IllegalArgumentException, FactoryException {
        ArrayList<CoordinateOperation> arrayList = new ArrayList<CoordinateOperation>();
        if (coordinateOperation instanceof ConcatenatedOperation) {
            arrayList.addAll(((ConcatenatedOperation)coordinateOperation).getOperations());
        } else {
            arrayList.add(coordinateOperation);
        }
        if (decomposition.source && !this.propagateVertical(coordinateReferenceSystem, coordinateReferenceSystem2, arrayList.listIterator(), true) || decomposition.target && !this.propagateVertical(coordinateReferenceSystem, coordinateReferenceSystem2, arrayList.listIterator(arrayList.size()), false)) {
            return null;
        }
        switch (arrayList.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (CoordinateOperation)arrayList.get(0);
            }
        }
        return this.factory.createConcatenatedOperation(CoordinateOperationRegistry.derivedFrom(coordinateOperation), arrayList.toArray(new CoordinateOperation[arrayList.size()]));
    }

    private boolean propagateVertical(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, ListIterator<CoordinateOperation> listIterator, boolean bl) throws IllegalArgumentException, FactoryException {
        CoordinateReferenceSystem coordinateReferenceSystem3;
        CoordinateOperation coordinateOperation;
        CoordinateReferenceSystem coordinateReferenceSystem4;
        while ((bl ? listIterator.hasNext() : listIterator.hasPrevious()) && (coordinateReferenceSystem4 = (coordinateOperation = bl ? listIterator.next() : listIterator.previous()).getSourceCRS()) instanceof GeodeticCRS && (coordinateReferenceSystem3 = coordinateOperation.getTargetCRS()) instanceof GeodeticCRS && coordinateReferenceSystem4.getCoordinateSystem() instanceof EllipsoidalCS && coordinateReferenceSystem3.getCoordinateSystem() instanceof EllipsoidalCS) {
            boolean bl2;
            Matrix matrix = MathTransforms.getMatrix(coordinateOperation.getMathTransform());
            if (matrix == null) {
                MathTransform mathTransform;
                MathTransformFactory mathTransformFactory;
                if (!SubTypes.isSingleOperation(coordinateOperation) || !((mathTransformFactory = this.factorySIS.getMathTransformFactory()) instanceof DefaultMathTransformFactory)) break;
                if (bl) {
                    coordinateReferenceSystem4 = this.toGeodetic3D(coordinateReferenceSystem4, coordinateReferenceSystem);
                } else {
                    coordinateReferenceSystem3 = this.toGeodetic3D(coordinateReferenceSystem3, coordinateReferenceSystem2);
                }
                try {
                    mathTransform = ((DefaultMathTransformFactory)mathTransformFactory).createParameterizedTransform(((SingleOperation)coordinateOperation).getParameterValues(), ReferencingUtilities.createTransformContext(coordinateReferenceSystem4, coordinateReferenceSystem3, null));
                }
                catch (InvalidGeodeticParameterException invalidGeodeticParameterException) {
                    CoordinateOperationRegistry.log(null, invalidGeodeticParameterException);
                    break;
                }
                listIterator.set(this.recreate(coordinateOperation, coordinateReferenceSystem4, coordinateReferenceSystem3, mathTransform, mathTransformFactory.getLastMethodUsed()));
                return true;
            }
            int n = matrix.getNumRow();
            int n2 = matrix.getNumCol();
            boolean bl3 = bl2 = n2 == 3 && n == 3;
            if (!bl2 && !(bl ? n2 == 3 && n == 4 : n2 == 4 && n == 3)) break;
            if ((matrix = Matrices.resizeAffine(matrix, 4, 4)).isIdentity()) {
                listIterator.remove();
            } else {
                MathTransform mathTransform = this.factorySIS.getMathTransformFactory().createAffineTransform(matrix);
                listIterator.set(this.recreate(coordinateOperation, this.toGeodetic3D(coordinateReferenceSystem4, coordinateReferenceSystem), this.toGeodetic3D(coordinateReferenceSystem3, coordinateReferenceSystem2), mathTransform, null));
            }
            if (bl2) continue;
            return true;
        }
        return false;
    }

    private CoordinateReferenceSystem toGeodetic3D(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) throws FactoryException {
        assert (coordinateReferenceSystem instanceof GeodeticCRS && coordinateReferenceSystem.getCoordinateSystem() instanceof EllipsoidalCS) : coordinateReferenceSystem;
        if (coordinateReferenceSystem.getCoordinateSystem().getDimension() != 2) {
            return coordinateReferenceSystem;
        }
        if (coordinateReferenceSystem.getClass() == coordinateReferenceSystem2.getClass() && coordinateReferenceSystem2.getCoordinateSystem().getDimension() == 3 && Utilities.equalsIgnoreMetadata(((SingleCRS)coordinateReferenceSystem).getDatum(), ((SingleCRS)coordinateReferenceSystem2).getDatum())) {
            return coordinateReferenceSystem2;
        }
        EllipsoidalHeightCombiner ellipsoidalHeightCombiner = new EllipsoidalHeightCombiner(this.factorySIS.getCRSFactory(), this.factorySIS.getCSFactory(), this.factory);
        return this.toAuthorityDefinition(CoordinateReferenceSystem.class, ellipsoidalHeightCombiner.createCompoundCRS(CoordinateOperationRegistry.derivedFrom(coordinateReferenceSystem), coordinateReferenceSystem, CommonCRS.Vertical.ELLIPSOIDAL.crs()));
    }

    private static Map<String, ?> derivedFrom(IdentifiedObject identifiedObject) {
        return IdentifiedObjects.getProperties(identifiedObject, "identifiers");
    }

    static Map<String, Object> properties(Identifier identifier) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
        hashMap.put("name", identifier);
        if (identifier == DATUM_SHIFT || identifier == ELLIPSOID_CHANGE) {
            hashMap.put("coordinateOperationAccuracy", new PositionalAccuracy[]{identifier == DATUM_SHIFT ? PositionalAccuracyConstant.DATUM_SHIFT_APPLIED : PositionalAccuracyConstant.DATUM_SHIFT_OMITTED});
        }
        return hashMap;
    }

    final CoordinateOperation createFromMathTransform(Map<String, Object> map, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, MathTransform mathTransform, OperationMethod operationMethod, ParameterValueGroup parameterValueGroup, Class<? extends CoordinateOperation> clazz) throws FactoryException {
        Object object;
        if (mathTransform instanceof CoordinateOperation && Objects.equals((object = (CoordinateOperation)((Object)mathTransform)).getSourceCRS(), coordinateReferenceSystem) && Objects.equals(object.getTargetCRS(), coordinateReferenceSystem2) && Objects.equals(object.getMathTransform(), mathTransform) && (operationMethod == null || !(object instanceof SingleOperation) || Objects.equals(((SingleOperation)object).getMethod(), operationMethod))) {
            return object;
        }
        if (clazz == null) {
            Class clazz2 = clazz = map.containsKey("coordinateOperationAccuracy") ? Transformation.class : Conversion.class;
        }
        if (operationMethod == null) {
            object = MathTransforms.getMatrix(mathTransform);
            if (object != null) {
                operationMethod = Affine.getProvider(mathTransform.getSourceDimensions(), mathTransform.getTargetDimensions(), Matrices.isAffine((Matrix)object));
            } else {
                ParameterDescriptorGroup parameterDescriptorGroup = AbstractCoordinateOperation.getParameterDescriptors(mathTransform);
                if (parameterDescriptorGroup != null) {
                    ReferenceIdentifier referenceIdentifier = parameterDescriptorGroup.getName();
                    if (referenceIdentifier != null) {
                        operationMethod = this.factorySIS.getOperationMethod(referenceIdentifier.getCode());
                    }
                    if (operationMethod == null) {
                        operationMethod = this.factorySIS.createOperationMethod(map, coordinateReferenceSystem.getCoordinateSystem().getDimension(), coordinateReferenceSystem2.getCoordinateSystem().getDimension(), parameterDescriptorGroup);
                    }
                }
            }
        }
        if (parameterValueGroup != null) {
            map.put("parameters", parameterValueGroup);
        }
        map.put("operationType", clazz);
        if (Conversion.class.isAssignableFrom(clazz) && mathTransform.isIdentity()) {
            map.replace("name", AXIS_CHANGES, IDENTITY);
        }
        return this.factorySIS.createSingleOperation(map, coordinateReferenceSystem, coordinateReferenceSystem2, null, operationMethod, mathTransform);
    }

    private static void log(LogRecord logRecord, Exception exception) {
        if (logRecord == null) {
            logRecord = new LogRecord(Level.WARNING, exception.getLocalizedMessage());
        }
        logRecord.setLoggerName("org.apache.sis.referencing.operation");
        if (exception instanceof NoninvertibleTransformException) {
            logRecord.setThrown(exception);
        }
        Logging.log(CoordinateOperationFinder.class, "createOperations", logRecord);
    }

    static void recoverableException(String string, Exception exception) {
        Logging.recoverableException(Logging.getLogger("org.apache.sis.referencing.operation"), CoordinateOperationFinder.class, string, exception);
    }

    private static enum Decomposition {
        NONE(false, false),
        HORIZONTAL_TARGET(false, true),
        HORIZONTAL(true, true),
        HORIZONTAL_SOURCE(true, false);

        final boolean source;
        final boolean target;

        private Decomposition(boolean bl, boolean bl2) {
            this.source = bl;
            this.target = bl2;
        }

        static SingleCRS horizontal(CoordinateReferenceSystem coordinateReferenceSystem) {
            SingleCRS singleCRS;
            if (coordinateReferenceSystem instanceof SingleCRS && (singleCRS = CRS.getHorizontalComponent(coordinateReferenceSystem)) != coordinateReferenceSystem) {
                return singleCRS;
            }
            return null;
        }
    }
}

