/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Objects;
import javax.measure.IncommensurableException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.gml.Measure;
import org.apache.sis.internal.jaxb.gml.MeasureList;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.ElementKind;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.parameter.IntegerList;
import org.apache.sis.parameter.UnmodifiableParameterValue;
import org.apache.sis.parameter.Verifier;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.LenientComparable;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.ObjectConverters;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.InvalidParameterTypeException;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;

@XmlType(name="ParameterValueType", propOrder={"xmlValue", "descriptor"})
@XmlRootElement(name="ParameterValue")
public class DefaultParameterValue<T>
extends FormattableObject
implements ParameterValue<T>,
LenientComparable,
Serializable,
Cloneable {
    private static final long serialVersionUID = -5837826787089486776L;
    private ParameterDescriptor<T> descriptor;
    protected T value;
    protected Unit<?> unit;

    public DefaultParameterValue(ParameterDescriptor<T> parameterDescriptor) {
        ArgumentChecks.ensureNonNull("descriptor", parameterDescriptor);
        this.descriptor = parameterDescriptor;
        this.value = parameterDescriptor.getDefaultValue();
        this.unit = parameterDescriptor.getUnit();
    }

    public DefaultParameterValue(ParameterValue<T> parameterValue) {
        ArgumentChecks.ensureNonNull("parameter", parameterValue);
        this.descriptor = parameterValue.getDescriptor();
        this.value = parameterValue.getValue();
        this.unit = parameterValue.getUnit();
    }

    @Override
    @XmlElement(name="operationParameter", required=true)
    public ParameterDescriptor<T> getDescriptor() {
        return this.descriptor;
    }

    @Override
    public Unit<?> getUnit() {
        return this.unit;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public boolean booleanValue() throws IllegalStateException {
        T t = this.getValue();
        if (t instanceof Boolean) {
            return (Boolean)t;
        }
        throw this.missingOrIncompatibleValue(t);
    }

    @Override
    public int intValue() throws IllegalStateException {
        int n;
        T t = this.getValue();
        if (t instanceof Number && (double)(n = ((Number)t).intValue()) == ((Number)t).doubleValue()) {
            return n;
        }
        throw this.missingOrIncompatibleValue(t);
    }

    @Override
    public int[] intValueList() throws IllegalStateException {
        T t = this.getValue();
        if (t instanceof int[]) {
            return (int[])((int[])t).clone();
        }
        throw this.missingOrIncompatibleValue(t);
    }

    @Override
    public double doubleValue() throws IllegalStateException {
        T t = this.getValue();
        if (t instanceof Number) {
            return ((Number)t).doubleValue();
        }
        throw this.missingOrIncompatibleValue(t);
    }

    @Override
    public double[] doubleValueList() throws IllegalStateException {
        T t = this.getValue();
        if (t instanceof double[]) {
            return (double[])((double[])t).clone();
        }
        throw this.missingOrIncompatibleValue(t);
    }

    private UnitConverter getConverterTo(Unit<?> unit) {
        Unit<?> unit2 = this.getUnit();
        if (unit2 == null) {
            throw new IllegalStateException(Resources.format((short)65, Verifier.getDisplayName(this.descriptor)));
        }
        ArgumentChecks.ensureNonNull("unit", unit);
        short s2 = Verifier.getUnitMessageID(unit2);
        if (Verifier.getUnitMessageID(unit) != s2) {
            throw new IllegalArgumentException(Errors.format(s2, unit));
        }
        try {
            return unit2.getConverterToAny(unit);
        }
        catch (IncommensurableException incommensurableException) {
            throw new IllegalArgumentException(Errors.format((short)66, unit2, unit), incommensurableException);
        }
    }

    @Override
    public double doubleValue(Unit<?> unit) throws IllegalArgumentException, IllegalStateException {
        double d = this.doubleValue();
        return this.getConverterTo(unit).convert(d);
    }

    @Override
    public double[] doubleValueList(Unit<?> unit) throws IllegalArgumentException, IllegalStateException {
        UnitConverter unitConverter = this.getConverterTo(unit);
        double[] dArray = this.doubleValueList();
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = unitConverter.convert(dArray[i]);
        }
        return dArray;
    }

    @Override
    public String stringValue() throws IllegalStateException {
        T t = this.getValue();
        if (t instanceof CharSequence) {
            return t.toString();
        }
        throw this.missingOrIncompatibleValue(t);
    }

    @Override
    public URI valueFile() throws IllegalStateException {
        T t = this.getValue();
        if (t instanceof URI) {
            return (URI)t;
        }
        if (t instanceof File) {
            return ((File)t).toURI();
        }
        if (t instanceof Path) {
            return ((Path)t).toUri();
        }
        URISyntaxException uRISyntaxException = null;
        if (t instanceof URL) {
            try {
                return ((URL)t).toURI();
            }
            catch (URISyntaxException uRISyntaxException2) {
                uRISyntaxException = uRISyntaxException2;
            }
        }
        String string = Verifier.getDisplayName(this.descriptor);
        if (t != null) {
            throw new InvalidParameterTypeException(this.getClassTypeError(), string);
        }
        throw new IllegalStateException(Resources.format((short)44, string), uRISyntaxException);
    }

    private static boolean isFile(Object object) {
        return object instanceof URI || object instanceof URL || object instanceof File || object instanceof Path;
    }

    private boolean isOrNeedFile(Object object) {
        if (object instanceof String) {
            Class<T> clazz = this.descriptor.getValueClass();
            return clazz == URI.class || clazz == URL.class || Path.class.isAssignableFrom(clazz) || File.class.isAssignableFrom(clazz);
        }
        return DefaultParameterValue.isFile(object);
    }

    private IllegalStateException missingOrIncompatibleValue(Object object) {
        String string = Verifier.getDisplayName(this.descriptor);
        if (object != null) {
            return new InvalidParameterTypeException(this.getClassTypeError(), string);
        }
        return new IllegalStateException(Resources.format((short)44, string));
    }

    private String getClassTypeError() {
        return Resources.format((short)22, this.descriptor != null ? this.descriptor.getValueClass() : "?");
    }

    private static Number cast(Number number, Class<?> clazz) {
        Object obj;
        if (clazz == Double.class && number instanceof Float) {
            return DecimalFunctions.floatToDouble(number.floatValue());
        }
        if (Number.class.isAssignableFrom(clazz) && Numerics.equals(((Number)(obj = Numbers.cast(number, clazz))).doubleValue(), number.doubleValue())) {
            return obj;
        }
        return number;
    }

    @Override
    public void setValue(Object object) throws InvalidParameterValueException {
        block13: {
            Class<T> clazz;
            if (object != null && !(clazz = this.descriptor.getValueClass()).isInstance(object)) {
                if (object instanceof Number) {
                    object = DefaultParameterValue.cast((Number)object, clazz);
                } else if (this.isOrNeedFile(object)) {
                    try {
                        object = ObjectConverters.convert(object, clazz);
                    }
                    catch (UnconvertibleObjectException unconvertibleObjectException) {
                        Logging.recoverableException(Logging.getLogger("org.apache.sis.referencing.operation"), DefaultParameterValue.class, "setValue", unconvertibleObjectException);
                    }
                } else {
                    Class<?> clazz2 = clazz.getComponentType();
                    if (clazz2 != null) {
                        Object[] objectArray;
                        if (object.getClass().isArray()) {
                            objectArray = object;
                        } else {
                            Object[] objectArray2 = new Object[1];
                            objectArray = objectArray2;
                            objectArray2[0] = object;
                        }
                        Object[] objectArray3 = objectArray;
                        int n = Array.getLength(objectArray3);
                        if (n > 0) {
                            Object object2 = Array.newInstance(clazz2, n);
                            clazz2 = Numbers.primitiveToWrapper(clazz2);
                            for (int i = 0; i < n; ++i) {
                                Object object3 = Array.get(objectArray3, i);
                                if (object3 == null) continue;
                                if (object3 instanceof Number && clazz2.isInstance(object3 = DefaultParameterValue.cast((Number)object3, clazz2))) {
                                    Array.set(object2, i, object3);
                                    continue;
                                }
                                break block13;
                            }
                            object = object2;
                        }
                    }
                }
            }
        }
        this.setValue(object, this.unit);
    }

    @Override
    public void setValue(boolean bl) throws InvalidParameterValueException {
        this.setValue(bl, this.unit);
    }

    @Override
    public void setValue(int n) throws InvalidParameterValueException {
        Number number = n;
        Number number2 = DefaultParameterValue.cast(number, this.descriptor.getValueClass());
        if (number2.intValue() == n) {
            number = number2;
        }
        this.setValue(number, this.unit);
    }

    private static Number wrap(double d, Class<?> clazz) throws IllegalArgumentException {
        if (Number.class.isAssignableFrom(clazz)) {
            return Numbers.wrap(d, clazz);
        }
        return Numerics.valueOf(d);
    }

    @Override
    public void setValue(double d) throws InvalidParameterValueException {
        Number number;
        try {
            number = DefaultParameterValue.wrap(d, this.descriptor.getValueClass());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw (InvalidParameterValueException)new InvalidParameterValueException(illegalArgumentException.getLocalizedMessage(), Verifier.getDisplayName(this.descriptor), d).initCause(illegalArgumentException);
        }
        this.setValue(number, this.unit);
    }

    @Override
    public void setValue(double d, Unit<?> unit) throws InvalidParameterValueException {
        Number number;
        try {
            number = DefaultParameterValue.wrap(d, this.descriptor.getValueClass());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw (InvalidParameterValueException)new InvalidParameterValueException(illegalArgumentException.getLocalizedMessage(), Verifier.getDisplayName(this.descriptor), d).initCause(illegalArgumentException);
        }
        this.setValue(number, unit);
    }

    @Override
    public void setValue(double[] dArray, Unit<?> unit) throws InvalidParameterValueException {
        this.setValue((Object)dArray, unit);
    }

    protected void setValue(Object object, Unit<?> unit) throws InvalidParameterValueException {
        T t = Verifier.ensureValidValue(this.descriptor, object, unit);
        if (object != null) {
            this.validate(t);
            this.value = object;
        } else {
            this.value = this.descriptor.getDefaultValue();
        }
        this.unit = unit;
    }

    protected void validate(T t) throws InvalidParameterValueException {
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (object != null) {
            if (comparisonMode == ComparisonMode.STRICT) {
                if (this.getClass() == object.getClass()) {
                    DefaultParameterValue defaultParameterValue = (DefaultParameterValue)object;
                    return Objects.equals(this.descriptor, defaultParameterValue.descriptor) && Objects.deepEquals(this.value, defaultParameterValue.value) && Objects.equals(this.unit, defaultParameterValue.unit);
                }
            } else if (object instanceof ParameterValue) {
                ParameterValue parameterValue = (ParameterValue)object;
                return Utilities.deepEquals(this.getDescriptor(), parameterValue.getDescriptor(), comparisonMode) && Utilities.deepEquals(this.getValue(), parameterValue.getValue(), comparisonMode) && Utilities.deepEquals(this.getUnit(), parameterValue.getUnit(), comparisonMode);
            }
        }
        return false;
    }

    @Override
    public final boolean equals(Object object) {
        return this.equals(object, ComparisonMode.STRICT);
    }

    public int hashCode() {
        int n = 37 * this.descriptor.hashCode();
        if (this.value != null) {
            n += this.value.hashCode();
        }
        if (this.unit != null) {
            n += 31 * this.unit.hashCode();
        }
        return n;
    }

    @Override
    public DefaultParameterValue<T> clone() {
        try {
            return (DefaultParameterValue)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    public static <T> DefaultParameterValue<T> unmodifiable(ParameterValue<T> parameterValue) {
        return UnmodifiableParameterValue.create(parameterValue);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        GeneralParameterDescriptor generalParameterDescriptor = this.getDescriptor();
        WKTUtilities.appendName(generalParameterDescriptor, formatter, ElementKind.PARAMETER);
        Convention convention = formatter.getConvention();
        boolean bl = convention.majorVersion() == 1;
        Unit<?> unit = this.getUnit();
        if (unit == null) {
            T t = this.getValue();
            if (!bl && DefaultParameterValue.isFile(t)) {
                formatter.append(t.toString(), null);
                return "ParameterFile";
            }
            formatter.appendAny(t);
        } else {
            double d;
            boolean bl2;
            Unit<?> unit2;
            if (generalParameterDescriptor == null || (unit2 = generalParameterDescriptor.getUnit()) == null) {
                unit2 = unit;
            }
            unit2 = formatter.toContextualUnit(unit2);
            if (bl) {
                unit = unit2;
                bl2 = true;
            } else {
                if (convention != Convention.INTERNAL) {
                    unit = WKTUtilities.toFormattable(unit);
                }
                bl2 = unit.equals(unit2);
            }
            try {
                d = this.doubleValue(unit);
            }
            catch (IllegalStateException illegalStateException) {
                if (generalParameterDescriptor != null) {
                    formatter.setInvalidWKT(generalParameterDescriptor, (Exception)illegalStateException);
                } else {
                    formatter.setInvalidWKT(DefaultParameterValue.class, (Exception)illegalStateException);
                }
                d = Double.NaN;
            }
            formatter.append(d);
            if (!bl2 && !Double.isNaN(d)) {
                bl2 = Numerics.equals(d, this.doubleValue(unit2));
            }
            if (bl2 && convention != Convention.INTERNAL) {
                boolean bl3 = bl2 = convention.isSimplified() && DefaultParameterValue.hasContextualUnit(formatter);
            }
            if (!bl2) {
                if (!bl) {
                    formatter.append(unit);
                } else if (!bl2) {
                    if (generalParameterDescriptor != null) {
                        formatter.setInvalidWKT(generalParameterDescriptor, null);
                    } else {
                        formatter.setInvalidWKT(DefaultParameterValue.class, null);
                    }
                }
            }
        }
        return "Parameter";
    }

    private static boolean hasContextualUnit(Formatter formatter) {
        return formatter.hasContextualUnit(1) || formatter.hasContextualUnit(2);
    }

    private DefaultParameterValue() {
    }

    final void setDescriptor(ParameterDescriptor<T> parameterDescriptor) {
        this.descriptor = parameterDescriptor;
        assert (this.value == null || parameterDescriptor.getValueClass().isInstance(this.value)) : this;
    }

    @XmlElements(value={@XmlElement(name="value", type=Measure.class), @XmlElement(name="integerValue", type=Integer.class), @XmlElement(name="booleanValue", type=Boolean.class), @XmlElement(name="stringValue", type=String.class), @XmlElement(name="valueFile", type=URI.class), @XmlElement(name="integerValueList", type=IntegerList.class), @XmlElement(name="valueList", type=MeasureList.class)})
    private Object getXmlValue() {
        T t = this.getValue();
        if (t != null) {
            if (t instanceof Number) {
                int n;
                Number number = (Number)t;
                if (Numbers.isInteger(number.getClass()) && (n = number.intValue()) >= 0 && (double)n == number.doubleValue()) {
                    return n;
                }
                return new Measure(((Number)t).doubleValue(), this.getUnit());
            }
            if (t instanceof CharSequence) {
                return t.toString();
            }
            if (DefaultParameterValue.isFile(t)) {
                return ObjectConverters.convert(t, URI.class);
            }
            Class<?> clazz = Numbers.primitiveToWrapper(t.getClass().getComponentType());
            if (clazz != null && Number.class.isAssignableFrom(clazz)) {
                if (Numbers.isInteger(clazz)) {
                    return new IntegerList(t);
                }
                return new MeasureList(t, clazz, this.getUnit());
            }
        }
        return t;
    }

    private void setXmlValue(Object object) {
        if (this.value == null && this.unit == null) {
            if (object instanceof Measure) {
                Measure measure = (Measure)object;
                object = measure.value;
                this.unit = measure.unit;
            } else if (object instanceof MeasureList) {
                MeasureList measureList = (MeasureList)object;
                object = measureList.toArray();
                this.unit = measureList.unit;
            } else if (object instanceof IntegerList) {
                object = ((IntegerList)object).toArray();
            }
            this.value = this.descriptor != null ? ObjectConverters.convert(object, this.descriptor.getValueClass()) : object;
        } else {
            MetadataUtilities.propertyAlreadySet(DefaultParameterValue.class, "setXmlValue", "value");
        }
    }
}

