/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.content;

import javax.measure.Unit;
import javax.measure.quantity.Length;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.jaxb.gco.GO_Real;
import org.apache.sis.internal.jaxb.gco.UnitAdapter;
import org.apache.sis.internal.jaxb.gmi.MI_Band;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.metadata.iso.content.DefaultSampleDimension;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.content.Band;
import org.opengis.metadata.content.BandDefinition;
import org.opengis.metadata.content.PolarizationOrientation;
import org.opengis.metadata.content.TransferFunctionType;

@XmlType(name="MD_Band_Type", propOrder={"boundMax", "boundMin", "boundUnits", "peakResponse", "toneGradation", "bandBoundaryDefinition", "nominalSpatialResolution", "transferFunctionType", "transmittedPolarization", "detectedPolarization"})
@XmlRootElement(name="MD_Band")
@XmlSeeAlso(value={MI_Band.class})
public class DefaultBand
extends DefaultSampleDimension
implements Band {
    private static final long serialVersionUID = -2474871120376144737L;
    private Double boundMin;
    private Double boundMax;
    private Unit<Length> boundUnits;
    private BandDefinition bandBoundaryDefinition;
    private Double peakResponse;
    private Integer toneGradation;
    private PolarizationOrientation transmittedPolarization;
    private PolarizationOrientation detectedPolarization;

    public DefaultBand() {
    }

    public DefaultBand(Band band) {
        super(band);
        if (band != null) {
            if (band instanceof DefaultBand) {
                DefaultBand defaultBand = (DefaultBand)band;
                this.boundMin = defaultBand.getBoundMin();
                this.boundMax = defaultBand.getBoundMax();
                this.boundUnits = defaultBand.getBoundUnits();
            }
            this.peakResponse = band.getPeakResponse();
            this.toneGradation = band.getToneGradation();
            this.bandBoundaryDefinition = band.getBandBoundaryDefinition();
            this.transmittedPolarization = band.getTransmittedPolarization();
            this.detectedPolarization = band.getDetectedPolarization();
        }
    }

    public static DefaultBand castOrCopy(Band band) {
        if (band == null || band instanceof DefaultBand) {
            return (DefaultBand)band;
        }
        return new DefaultBand(band);
    }

    @ValueRange(minimum=0.0)
    @XmlElement(name="boundMin")
    @XmlJavaTypeAdapter(value=GO_Real.Since2014.class)
    @UML(identifier="boundMin", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Double getBoundMin() {
        return this.boundMin;
    }

    public void setBoundMin(Double d) {
        this.checkWritePermission(this.boundMin);
        if (MetadataUtilities.ensurePositive(DefaultBand.class, "boundMin", false, d)) {
            this.boundMin = d;
        }
    }

    @ValueRange(minimum=0.0)
    @XmlElement(name="boundMax")
    @XmlJavaTypeAdapter(value=GO_Real.Since2014.class)
    @UML(identifier="boundMax", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Double getBoundMax() {
        return this.boundMax;
    }

    public void setBoundMax(Double d) {
        this.checkWritePermission(this.boundMax);
        if (MetadataUtilities.ensurePositive(DefaultBand.class, "boundMax", false, d)) {
            this.boundMax = d;
        }
    }

    @XmlElement(name="boundUnits")
    @XmlJavaTypeAdapter(value=UnitAdapter.Since2014.class)
    @UML(identifier="boundUnits", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Unit<Length> getBoundUnits() {
        return this.boundUnits;
    }

    public void setBoundUnits(Unit<Length> unit) {
        this.checkWritePermission(this.boundUnits);
        this.boundUnits = unit;
    }

    @Override
    @XmlElement(name="bandBoundaryDefinition")
    public BandDefinition getBandBoundaryDefinition() {
        return this.bandBoundaryDefinition;
    }

    public void setBandBoundaryDefinition(BandDefinition bandDefinition) {
        this.checkWritePermission(this.bandBoundaryDefinition);
        this.bandBoundaryDefinition = bandDefinition;
    }

    @Override
    public Unit<Length> getUnits() {
        Unit<?> unit = super.getUnits();
        return unit != null ? unit.asType(Length.class) : null;
    }

    @Override
    public void setUnits(Unit<?> unit) {
        super.setUnits(unit != null ? unit.asType(Length.class) : null);
    }

    @Override
    @ValueRange(minimum=0.0)
    @XmlElement(name="peakResponse")
    public Double getPeakResponse() {
        return this.peakResponse;
    }

    public void setPeakResponse(Double d) {
        this.checkWritePermission(this.peakResponse);
        if (MetadataUtilities.ensurePositive(DefaultBand.class, "peakResponse", false, d)) {
            this.peakResponse = d;
        }
    }

    @Override
    @ValueRange(minimum=0.0)
    @XmlElement(name="toneGradation")
    public Integer getToneGradation() {
        return this.toneGradation;
    }

    public void setToneGradation(Integer n) {
        this.checkWritePermission(this.toneGradation);
        if (MetadataUtilities.ensurePositive(DefaultBand.class, "toneGradation", false, n)) {
            this.toneGradation = n;
        }
    }

    @Override
    @ValueRange(minimum=0.0, isMinIncluded=false)
    @XmlElement(name="nominalSpatialResolution")
    public Double getNominalSpatialResolution() {
        return super.getNominalSpatialResolution();
    }

    @Override
    public void setNominalSpatialResolution(Double d) {
        super.setNominalSpatialResolution(d);
    }

    @Override
    @XmlElement(name="transferFunctionType")
    public TransferFunctionType getTransferFunctionType() {
        return super.getTransferFunctionType();
    }

    @Override
    public void setTransferFunctionType(TransferFunctionType transferFunctionType) {
        super.setTransferFunctionType(transferFunctionType);
    }

    @Override
    @XmlElement(name="transmittedPolarisation")
    public PolarizationOrientation getTransmittedPolarization() {
        return this.transmittedPolarization;
    }

    public void setTransmittedPolarization(PolarizationOrientation polarizationOrientation) {
        this.checkWritePermission(this.transmittedPolarization);
        this.transmittedPolarization = polarizationOrientation;
    }

    @Override
    @XmlElement(name="detectedPolarisation")
    public PolarizationOrientation getDetectedPolarization() {
        return this.detectedPolarization;
    }

    public void setDetectedPolarization(PolarizationOrientation polarizationOrientation) {
        this.checkWritePermission(this.detectedPolarization);
        this.detectedPolarization = polarizationOrientation;
    }
}

