/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf;

import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.internal.netcdf.Resources;
import org.apache.sis.internal.storage.StoreUtilities;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.apache.sis.util.resources.IndexedResourceBundle;

public abstract class NamedElement {
    protected NamedElement() {
    }

    public abstract String getName();

    public String getGroupName() {
        return null;
    }

    protected static String listNames(NamedElement[] namedElementArray, int n, String string) {
        StringJoiner stringJoiner = new StringJoiner(string);
        for (int i = 0; i < n; ++i) {
            stringJoiner.add(namedElementArray[i].getName());
        }
        return stringJoiner.toString();
    }

    protected static boolean similar(CharSequence charSequence, CharSequence charSequence2) {
        return CharSequences.equalsFiltered(charSequence, charSequence2, Characters.Filter.UNICODE_IDENTIFIER, true);
    }

    static void warning(StoreListeners storeListeners, Class<?> clazz, String string, Exception exception, IndexedResourceBundle indexedResourceBundle, short s2, Object ... objectArray) {
        if (indexedResourceBundle == null) {
            indexedResourceBundle = Resources.forLocale(storeListeners.getLocale());
        }
        LogRecord logRecord = indexedResourceBundle.getLogRecord(Level.WARNING, s2, objectArray);
        logRecord.setLoggerName("org.apache.sis.storage.netcdf");
        logRecord.setSourceClassName(clazz.getCanonicalName());
        logRecord.setSourceMethodName(string);
        if (exception != null) {
            logRecord.setThrown(exception);
        }
        storeListeners.warning(logRecord, StoreUtilities.removeStackTraceInLogs());
    }

    public String toString() {
        return Strings.bracket(this.getClass().getSimpleName(), (Object)this.getName());
    }
}

