/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.filter.sqlmm;

import java.util.Collection;
import java.util.EnumMap;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.builder.AttributeTypeBuilder;
import org.apache.sis.feature.builder.FeatureTypeBuilder;
import org.apache.sis.feature.builder.PropertyTypeBuilder;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Optimization;
import org.apache.sis.internal.feature.FeatureExpression;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.filter.Node;
import org.apache.sis.internal.filter.sqlmm.SQLMM;
import org.apache.sis.util.iso.Names;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.LocalName;
import org.opengis.util.ScopedName;

abstract class SpatialFunction<R>
extends Node
implements FeatureExpression<R, Object>,
Optimization.OnExpression<R, Object> {
    private static final long serialVersionUID = 6933519274722660893L;
    private static final LocalName SCOPE = Names.createLocalName("ISO", null, "sqlmm");
    final SQLMM operation;
    private static final EnumMap<SQLMM, ScopedName> NAMES = new EnumMap(SQLMM.class);

    SpatialFunction(SQLMM sQLMM, Expression<? super R, ?>[] expressionArray) {
        String string;
        this.operation = sQLMM;
        int n = expressionArray.length;
        byte by = sQLMM.minParamCount;
        if (n < by) {
            string = n == 0 ? Errors.format((short)29, "parameters") : Errors.format((short)127, by, n);
        } else {
            byte by2 = sQLMM.maxParamCount;
            if (n > by2) {
                string = Errors.format((short)129, by2, n);
            } else {
                return;
            }
        }
        throw new IllegalArgumentException(string);
    }

    abstract Geometries<?> getGeometryLibrary();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ScopedName getFunctionName() {
        EnumMap<SQLMM, ScopedName> enumMap = NAMES;
        synchronized (enumMap) {
            return NAMES.computeIfAbsent(this.operation, SpatialFunction::createName);
        }
    }

    private static ScopedName createName(SQLMM sQLMM) {
        return Names.createScopedName(SCOPE, null, sQLMM.name());
    }

    @Override
    protected final Collection<?> getChildren() {
        return this.getParameters();
    }

    public String getSyntax() {
        byte by = this.operation.minParamCount;
        int n = this.operation.maxParamCount;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getFunctionName().tip()).append('(');
        for (int i = 0; i < n; ++i) {
            if (i == by) {
                stringBuilder.append('[');
            }
            if (i != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("param").append(i + 1);
        }
        if (n > by) {
            stringBuilder.append(']');
        }
        return stringBuilder.append(')').toString();
    }

    @Override
    public final Class<?> getValueClass() {
        return this.operation.getReturnType(this.getGeometryLibrary());
    }

    @Override
    public final <N> Expression<R, N> toValueType(Class<N> clazz) {
        if (clazz.isAssignableFrom(this.getValueClass())) {
            return this;
        }
        throw new ClassCastException(Errors.format((short)8, this.getFunctionName(), clazz));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public PropertyTypeBuilder expectedType(DefaultFeatureType defaultFeatureType, FeatureTypeBuilder featureTypeBuilder) {
        AttributeTypeBuilder<?> attributeTypeBuilder;
        if (this.operation.isGeometryInOut()) {
            Geometries geometries;
            PropertyTypeBuilder propertyTypeBuilder;
            FeatureExpression featureExpression = FeatureExpression.castOrCopy(this.getParameters().get(0));
            if (featureExpression == null || !((propertyTypeBuilder = featureExpression.expectedType(defaultFeatureType, featureTypeBuilder)) instanceof AttributeTypeBuilder) || (geometries = Geometries.implementation((attributeTypeBuilder = (AttributeTypeBuilder<?>)propertyTypeBuilder).getValueClass())) == null) throw new IllegalArgumentException(Resources.format((short)52));
            attributeTypeBuilder = attributeTypeBuilder.setValueClass(this.operation.getReturnType(geometries));
            return attributeTypeBuilder.setName(this.getFunctionName());
        } else {
            attributeTypeBuilder = featureTypeBuilder.addAttribute(this.getValueClass());
        }
        return attributeTypeBuilder.setName(this.getFunctionName());
    }
}

