/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature.j2d;

import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.sis.internal.feature.j2d.FlatShape;
import org.apache.sis.internal.feature.j2d.Polyline;
import org.apache.sis.internal.referencing.j2d.IntervalRectangle;

final class MultiPolylines
extends FlatShape {
    private final Polyline[] polylines;

    public MultiPolylines(Polyline[] polylineArray) {
        super(new IntervalRectangle());
        this.polylines = polylineArray;
        this.bounds.setRect(polylineArray[0].bounds);
        for (int i = 1; i < polylineArray.length; ++i) {
            this.bounds.add(polylineArray[i].bounds);
        }
    }

    @Override
    public boolean contains(double d, double d2) {
        if (this.bounds.contains(d, d2)) {
            for (Polyline polyline : this.polylines) {
                if (!polyline.contains(d, d2)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean intersects(double d, double d2, double d3, double d4) {
        if (this.bounds.intersects(d, d2, d3, d4)) {
            for (Polyline polyline : this.polylines) {
                if (!polyline.intersects(d, d2, d3, d4)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean intersects(Rectangle2D rectangle2D) {
        if (this.bounds.intersects(rectangle2D)) {
            for (Polyline polyline : this.polylines) {
                if (!polyline.intersects(rectangle2D)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean contains(double d, double d2, double d3, double d4) {
        if (this.bounds.contains(d, d2, d3, d4)) {
            for (Polyline polyline : this.polylines) {
                if (!polyline.contains(d, d2, d3, d4)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean contains(Rectangle2D rectangle2D) {
        if (this.bounds.contains(rectangle2D)) {
            for (Polyline polyline : this.polylines) {
                if (!polyline.contains(rectangle2D)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform) {
        Iterator<Polyline> iterator = Arrays.asList(this.polylines).iterator();
        return iterator.hasNext() ? new Polyline.Iter(affineTransform, iterator.next(), iterator) : new Polyline.Iter();
    }

    @Override
    public FlatShape fastClip(Rectangle2D rectangle2D) {
        if (this.bounds.intersects(rectangle2D)) {
            Polyline[] polylineArray = new Polyline[this.polylines.length];
            int n = 0;
            for (Polyline polyline : this.polylines) {
                if (!polyline.bounds.intersects(rectangle2D)) continue;
                polylineArray[n++] = polyline;
            }
            if (n != 0) {
                if (n == this.polylines.length) {
                    return this;
                }
                return new MultiPolylines(Arrays.copyOf(polylineArray, n));
            }
        }
        return null;
    }
}

