/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature.j2d;

import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.io.ObjectStreamException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.feature.GeometryType;
import org.apache.sis.internal.feature.GeometryWrapper;
import org.apache.sis.internal.feature.j2d.PointWrapper;
import org.apache.sis.internal.feature.j2d.Wrapper;
import org.apache.sis.internal.referencing.j2d.AbstractShape;
import org.apache.sis.internal.referencing.j2d.ShapeUtilities;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.math.Vector;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.util.UnsupportedImplementationException;

public final class Factory
extends Geometries<Shape> {
    private static final long serialVersionUID = 2196319174347241786L;
    public static final Factory INSTANCE = new Factory();

    @Override
    protected Object readResolve() throws ObjectStreamException {
        return INSTANCE;
    }

    private Factory() {
        super(GeometryLibrary.JAVA2D, Shape.class, Point2D.class, Shape.class, Shape.class);
    }

    @Override
    public GeometryWrapper<Shape> castOrWrap(Object object) {
        if (object == null || object instanceof Wrapper) {
            return (Wrapper)object;
        }
        if (object instanceof PointWrapper) {
            return (PointWrapper)object;
        }
        if (object instanceof Point2D) {
            return new PointWrapper((Point2D)object);
        }
        return new Wrapper((Shape)object);
    }

    @Override
    protected GeometryWrapper<Shape> createWrapper(Shape shape) {
        return new Wrapper(shape);
    }

    @Override
    public boolean supportSinglePrecision() {
        return true;
    }

    @Override
    public Object createPoint(float f, float f2) {
        return new Point2D.Float(f, f2);
    }

    @Override
    public Object createPoint(double d, double d2) {
        return new Point2D.Double(d, d2);
    }

    @Override
    public Object createPoint(double d, double d2, double d3) {
        throw new UnsupportedOperationException();
    }

    private static Path2D createPath(boolean bl, int n) {
        return bl ? new Path2D.Float(1, n) : new Path2D.Double(1, n);
    }

    @Override
    public Shape createPolyline(boolean bl, int n, Vector ... vectorArray) {
        double d;
        double d2;
        double d3;
        double d4;
        if (n != 2) {
            throw new UnsupportedOperationException(Factory.unsupported(n));
        }
        int n2 = 0;
        boolean bl2 = true;
        Object object = vectorArray;
        int n3 = ((Vector[])object).length;
        for (int i = 0; i < n3; ++i) {
            Vector vector = object[i];
            if (vector == null) continue;
            n2 = Math.addExact(n2, vector.size());
            if (!bl2) continue;
            bl2 = vector.isSinglePrecision();
        }
        if (!((n2 /= 2) != 2 || vectorArray.length != 1 || Double.isNaN(d4 = ((Vector)(object = vectorArray[0])).doubleValue(0)) || Double.isNaN(d3 = ((Vector)object).doubleValue(1)) || Double.isNaN(d2 = ((Vector)object).doubleValue(2)) || Double.isNaN(d = ((Vector)object).doubleValue(3)))) {
            Line2D line2D = bl2 ? new Line2D.Float() : new Line2D.Double();
            line2D.setLine(d4, d3, d2, d);
            return line2D;
        }
        object = Factory.createPath(bl2, n2);
        n3 = 0;
        for (Vector vector : vectorArray) {
            int n4 = vector.size();
            int n5 = 0;
            while (n5 < n4) {
                double d5 = vector.doubleValue(n5++);
                double d6 = vector.doubleValue(n5++);
                if (Double.isNaN(d5) || Double.isNaN(d6)) {
                    if (bl) {
                        ((Path2D)object).closePath();
                    }
                    n3 = 0;
                    continue;
                }
                if (n3 != 0) {
                    ((Path2D)object).lineTo(d5, d6);
                    continue;
                }
                ((Path2D)object).moveTo(d5, d6);
                n3 = 1;
            }
        }
        if (bl) {
            ((Path2D)object).closePath();
        }
        return ShapeUtilities.toPrimitive((Shape)object);
    }

    @Override
    public GeometryWrapper<Shape> createMultiPolygon(Object[] objectArray) {
        boolean bl;
        if (objectArray.length == 1) {
            return new Wrapper((Shape)Factory.unwrap(objectArray[0]));
        }
        Shape[] shapeArray = new Shape[objectArray.length];
        for (bl = false; bl < objectArray.length; bl += 1) {
            shapeArray[bl] = (Shape)Factory.unwrap(objectArray[bl]);
        }
        bl = true;
        for (Shape shape : shapeArray) {
            if (AbstractShape.isFloat(shape)) continue;
            bl = false;
            break;
        }
        Path2D path2D = Factory.createPath(bl, 20);
        for (Shape shape : shapeArray) {
            path2D.append(shape, false);
        }
        return new Wrapper(path2D);
    }

    @Override
    public GeometryWrapper<Shape> createFromComponents(GeometryType geometryType, Object object) {
        List<Object> list = object instanceof Collection ? (List<Object>)object : Arrays.asList((Object[])object);
        Object object2 = (Shape)CollectionsExt.singletonOrNull(list);
        if (object2 == null) {
            Object object3;
            boolean bl = true;
            Object object4 = list.iterator();
            while (object4.hasNext() && (bl = AbstractShape.isFloat(object3 = object4.next()))) {
            }
            object4 = Factory.createPath(bl, 20);
            if (geometryType.isCollection()) {
                for (Object e : list) {
                    ((Path2D)object4).append((Shape)e, false);
                }
            } else {
                object3 = list.iterator();
                if (object3.hasNext()) {
                    Point2D point2D = (Point2D)object3.next();
                    ((Path2D)object4).moveTo(point2D.getX(), point2D.getY());
                    while (object3.hasNext()) {
                        Point2D point2D2 = (Point2D)object3.next();
                        ((Path2D)object4).lineTo(point2D2.getX(), point2D2.getY());
                    }
                    if (geometryType == GeometryType.POLYGON) {
                        ((Path2D)object4).closePath();
                    }
                }
            }
            object2 = object4;
        }
        return new Wrapper((Shape)object2);
    }

    @Override
    public GeometryWrapper<Shape> parseWKT(String string) {
        throw new UnsupportedImplementationException(Factory.unsupported("parseWKT"));
    }

    @Override
    public GeometryWrapper<Shape> parseWKB(ByteBuffer byteBuffer) {
        throw new UnsupportedImplementationException(Factory.unsupported("parseWKB"));
    }
}

