/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature;

import java.net.URL;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import org.apache.sis.util.resources.IndexedResourceBundle;
import org.apache.sis.util.resources.KeyConstants;
import org.apache.sis.util.resources.ResourceInternationalString;
import org.opengis.util.InternationalString;

public final class Resources
extends IndexedResourceBundle {
    public Resources(URL uRL) {
        super(uRL);
    }

    @Override
    protected KeyConstants getKeyConstants() {
        return Keys.INSTANCE;
    }

    public static Resources forLocale(Locale locale) throws MissingResourceException {
        return Resources.getBundle(Resources.class, locale);
    }

    public static Resources forProperties(Map<?, ?> map) throws MissingResourceException {
        return Resources.forLocale(Resources.getLocale(map));
    }

    public static String format(short s2) throws MissingResourceException {
        return Resources.forLocale(null).getString(s2);
    }

    public static String format(short s2, Object object) throws MissingResourceException {
        return Resources.forLocale(null).getString(s2, object);
    }

    public static String format(short s2, Object object, Object object2) throws MissingResourceException {
        return Resources.forLocale(null).getString(s2, object, object2);
    }

    public static String format(short s2, Object object, Object object2, Object object3) throws MissingResourceException {
        return Resources.forLocale(null).getString(s2, object, object2, object3);
    }

    public static String format(short s2, Object object, Object object2, Object object3, Object object4) throws MissingResourceException {
        return Resources.forLocale(null).getString(s2, object, object2, object3, object4);
    }

    public static InternationalString formatInternational(short s2, Object ... objectArray) {
        return new International(s2, objectArray);
    }

    public static final class Keys
    extends KeyConstants {
        static final Keys INSTANCE = new Keys();
        public static final short AbstractFeatureType_1 = 1;
        public static final short CanNotAssignCharacteristics_1 = 2;
        public static final short CanNotBuildGridCoverage = 3;
        public static final short CanNotComputeTile_2 = 4;
        public static final short CanNotCreateTwoDimensionalCRS_1 = 5;
        public static final short CanNotEnumerateValuesInRange_1 = 6;
        public static final short CanNotInstantiateProperty_1 = 7;
        public static final short CanNotMapToGridDimensions = 8;
        public static final short CanNotProcessTile_2 = 9;
        public static final short CanNotSetCharacteristics_2 = 10;
        public static final short CanNotSetDerivedGridProperty_1 = 11;
        public static final short CanNotSetPropertyValue_1 = 12;
        public static final short CanNotSimplifyTransferFunction_1 = 13;
        public static final short CanNotUpdateTile_2 = 14;
        public static final short CanNotVisit_2 = 77;
        public static final short CategoryRangeOverlap_4 = 15;
        public static final short CharacteristicsAlreadyExists_2 = 16;
        public static final short CharacteristicsNotFound_2 = 17;
        public static final short DependencyNotFound_3 = 18;
        public static final short EmptyImage = 19;
        public static final short EmptyTileOrImageRegion = 20;
        public static final short GridCoordinateOutsideCoverage_4 = 21;
        public static final short GridEnvelopeMustBeNDimensional_1 = 22;
        public static final short GridEnvelopeOutsideCoverage_5 = 23;
        public static final short IllegalCategoryRange_2 = 24;
        public static final short IllegalCharacteristicsType_3 = 25;
        public static final short IllegalFeatureType_3 = 26;
        public static final short IllegalGridEnvelope_3 = 27;
        public static final short IllegalGridGeometryComponent_1 = 28;
        public static final short IllegalPropertyType_2 = 29;
        public static final short IllegalPropertyValueClass_3 = 30;
        public static final short IllegalTransferFunction_1 = 31;
        public static final short ImageAllowsTransparency = 32;
        public static final short ImageHasAlphaChannel = 33;
        public static final short ImageIsOpaque = 34;
        public static final short IncompatibleTile_2 = 35;
        public static final short InsufficientBufferCapacity_3 = 36;
        public static final short IterationIsFinished = 38;
        public static final short IterationNotStarted = 39;
        public static final short MismatchedBandCount_2 = 40;
        public static final short MismatchedBandSize = 41;
        public static final short MismatchedDataType = 42;
        public static final short MismatchedImageLocation = 43;
        public static final short MismatchedImageSize_3 = 44;
        public static final short MismatchedPropertyType_1 = 45;
        public static final short MismatchedSampleModel = 46;
        public static final short MismatchedTileGrid = 47;
        public static final short MismatchedValueClass_3 = 48;
        public static final short NoCategoryForValue_1 = 49;
        public static final short NoNDimensionalSlice_3 = 50;
        public static final short NonLinearInDimensions_1 = 51;
        public static final short NotAGeometryAtFirstExpression = 52;
        public static final short NotASingleton_1 = 53;
        public static final short NotStrictlyOrderedDimensions = 54;
        public static final short OperationRequiresSingleBand = 55;
        public static final short OptionalLibraryNotFound_2 = 56;
        public static final short OutOfIteratorDomain_2 = 57;
        public static final short PointOutsideCoverageDomain_1 = 37;
        public static final short PropertyAlreadyExists_2 = 58;
        public static final short PropertyNotFound_2 = 59;
        public static final short TileErrorFlagSet_2 = 60;
        public static final short TileNotWritable_2 = 61;
        public static final short TooManyQualitatives = 62;
        public static final short TransformDependsOnDimension_1 = 63;
        public static final short UnavailableGeometryLibrary_1 = 64;
        public static final short UnconvertibleGridCoordinate_2 = 65;
        public static final short UnconvertibleSampleValues = 66;
        public static final short UnexpectedNumberOfBands_2 = 67;
        public static final short UnexpectedNumberOfComponents_4 = 68;
        public static final short UnknownDataType_1 = 69;
        public static final short UnknownFunction_1 = 70;
        public static final short UnresolvedFeatureName_1 = 71;
        public static final short UnspecifiedCRS = 72;
        public static final short UnspecifiedGridExtent = 73;
        public static final short UnspecifiedRasterData = 74;
        public static final short UnspecifiedTransform = 75;
        public static final short UnsupportedGeometryObject_1 = 76;
        public static final short UnsupportedSampleType_3 = 78;

        private Keys() {
        }
    }

    private static final class International
    extends ResourceInternationalString {
        private static final long serialVersionUID = -667435900917846518L;

        International(short s2) {
            super(s2);
        }

        International(short s2, Object object) {
            super(s2, object);
        }

        @Override
        protected KeyConstants getKeyConstants() {
            return Keys.INSTANCE;
        }

        @Override
        protected IndexedResourceBundle getBundle(Locale locale) {
            return Resources.forLocale(locale);
        }
    }
}

