/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature;

import java.util.Iterator;
import java.util.Objects;
import java.util.OptionalInt;
import javax.measure.IncommensurableException;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.feature.AbstractGeometry;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.feature.GeometryType;
import org.apache.sis.internal.feature.SpatialOperationContext;
import org.apache.sis.internal.filter.sqlmm.SQLMM;
import org.apache.sis.internal.geoapi.filter.DistanceOperatorName;
import org.apache.sis.internal.geoapi.filter.SpatialOperatorName;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.util.Classes;
import org.apache.sis.util.NullArgumentException;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Geometry;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public abstract class GeometryWrapper<G>
extends AbstractGeometry
implements Geometry {
    protected GeometryWrapper() {
    }

    public abstract Geometries<G> factory();

    public abstract Object implementation();

    public OptionalInt getSRID() {
        return OptionalInt.empty();
    }

    public abstract CoordinateReferenceSystem getCoordinateReferenceSystem();

    public abstract void setCoordinateReferenceSystem(CoordinateReferenceSystem var1);

    public abstract GeneralEnvelope getEnvelope();

    public abstract DirectPosition getCentroid();

    public abstract double[] getPointCoordinates();

    public abstract double[] getAllCoordinates();

    protected abstract G mergePolylines(Iterator<?> var1);

    public final boolean predicate(DistanceOperatorName distanceOperatorName, GeometryWrapper<G> geometryWrapper, Quantity<Length> quantity, SpatialOperationContext spatialOperationContext) {
        GeometryWrapper[] geometryWrapperArray = new GeometryWrapper[]{this, geometryWrapper};
        try {
            if (spatialOperationContext.transform(geometryWrapperArray)) {
                double d = quantity.getValue().doubleValue();
                Unit<?> unit = ReferencingUtilities.getUnit(spatialOperationContext.commonCRS);
                if (unit != null) {
                    d = quantity.getUnit().getConverterToAny(unit).convert(d);
                }
                return geometryWrapperArray[0].predicateSameCRS(distanceOperatorName, geometryWrapperArray[1], d);
            }
        }
        catch (IncommensurableException | TransformException | FactoryException exception) {
            throw new IllegalArgumentException(exception);
        }
        return SpatialOperationContext.negativeResult(distanceOperatorName);
    }

    public final boolean predicate(SpatialOperatorName spatialOperatorName, GeometryWrapper<G> geometryWrapper, SpatialOperationContext spatialOperationContext) {
        GeometryWrapper[] geometryWrapperArray = new GeometryWrapper[]{this, geometryWrapper};
        try {
            if (spatialOperationContext.transform(geometryWrapperArray)) {
                return geometryWrapperArray[0].predicateSameCRS(spatialOperatorName, geometryWrapperArray[1]);
            }
        }
        catch (IncommensurableException | TransformException | FactoryException exception) {
            throw new IllegalArgumentException(exception);
        }
        return SpatialOperationContext.negativeResult(spatialOperatorName);
    }

    public final Object operation(SQLMM sQLMM) {
        assert (sQLMM.geometryCount() == 1 && sQLMM.maxParamCount == 1) : sQLMM;
        Object object = this.operationSameCRS(sQLMM, null, null);
        assert (this.isInstance(sQLMM, object)) : object;
        return object;
    }

    public final Object operation(SQLMM sQLMM, GeometryWrapper<G> geometryWrapper) throws TransformException {
        assert (sQLMM.geometryCount() == 2 && sQLMM.maxParamCount == 2) : sQLMM;
        Object object = this.operationSameCRS(sQLMM, this.toSameCRS(geometryWrapper), null);
        assert (this.isInstance(sQLMM, object)) : object;
        return object;
    }

    public final Object operationWithArgument(SQLMM sQLMM, Object object) {
        assert (sQLMM.geometryCount() == 1 && sQLMM.maxParamCount == 2) : sQLMM;
        if (object == null && sQLMM.minParamCount > 1) {
            throw new NullArgumentException(Errors.format((short)113, "arg1"));
        }
        Object object2 = this.operationSameCRS(sQLMM, null, object);
        assert (this.isInstance(sQLMM, object2)) : object2;
        return object2;
    }

    public final Object operationWithArgument(SQLMM sQLMM, GeometryWrapper<G> geometryWrapper, Object object) throws TransformException {
        assert (sQLMM.geometryCount() == 2 && sQLMM.maxParamCount == 3) : sQLMM;
        if (object == null && sQLMM.minParamCount > 2) {
            throw new NullArgumentException(Errors.format((short)113, "arg2"));
        }
        Object object2 = this.operationSameCRS(sQLMM, this.toSameCRS(geometryWrapper), object);
        assert (this.isInstance(sQLMM, object2)) : object2;
        return object2;
    }

    private GeometryWrapper<G> toSameCRS(GeometryWrapper<G> geometryWrapper) throws TransformException {
        if (this.isSameCRS(geometryWrapper)) {
            return geometryWrapper;
        }
        CoordinateReferenceSystem coordinateReferenceSystem = this.getCoordinateReferenceSystem();
        return coordinateReferenceSystem != null ? geometryWrapper.transform(coordinateReferenceSystem) : this;
    }

    private boolean isInstance(SQLMM sQLMM, Object object) {
        return object == null || sQLMM.getReturnType(this.factory()).isInstance(object);
    }

    protected boolean predicateSameCRS(SpatialOperatorName spatialOperatorName, GeometryWrapper<G> geometryWrapper) {
        throw new UnsupportedOperationException(Geometries.unsupported(spatialOperatorName.name()));
    }

    protected boolean predicateSameCRS(DistanceOperatorName distanceOperatorName, GeometryWrapper<G> geometryWrapper, double d) {
        throw new UnsupportedOperationException(Geometries.unsupported(distanceOperatorName.name()));
    }

    protected Object operationSameCRS(SQLMM sQLMM, GeometryWrapper<G> geometryWrapper, Object object) {
        throw new UnsupportedOperationException(Geometries.unsupported(sQLMM.name()));
    }

    public GeometryWrapper<G> toGeometryType(GeometryType geometryType) {
        Object object;
        Class<?> clazz = this.factory().getGeometryClass(geometryType);
        if (clazz.isInstance(object = this.implementation())) {
            return this;
        }
        throw new UnconvertibleObjectException(Errors.format((short)7, object.getClass(), clazz));
    }

    public GeometryWrapper<G> transform(CoordinateOperation coordinateOperation, boolean bl) throws FactoryException, TransformException {
        throw new UnsupportedOperationException(Geometries.unsupported("transform"));
    }

    public GeometryWrapper<G> transform(CoordinateReferenceSystem coordinateReferenceSystem) throws TransformException {
        if (coordinateReferenceSystem == null) {
            return this;
        }
        throw new UnsupportedOperationException(Geometries.unsupported("transform"));
    }

    public abstract boolean isSameCRS(GeometryWrapper<G> var1);

    public abstract String formatWKT(double var1);

    public final boolean equals(Object object) {
        return object != null && object.getClass().equals(this.getClass()) && Objects.equals(((GeometryWrapper)object).implementation(), this.implementation());
    }

    public final int hashCode() {
        return ~Objects.hashCode(this.implementation());
    }

    public final String toString() {
        Class<?> clazz = this.implementation().getClass();
        Class<?> clazz2 = clazz.getEnclosingClass();
        String string = Classes.getShortName(clazz2 != null ? clazz2 : clazz);
        GeneralEnvelope generalEnvelope = this.getEnvelope();
        if (generalEnvelope != null) {
            String string2 = generalEnvelope.toString();
            string = string + string2.substring(string2.indexOf(40));
        }
        return string;
    }
}

