/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry;

import org.apache.sis.geometry.AbstractEnvelope;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.geometry.ImmutableEnvelope;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.referencing.WraparoundAxesFinder;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.logging.Logging;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class WraparoundAdjustment {
    private final ImmutableEnvelope domainOfValidity;
    private AbstractEnvelope shiftableDomain;
    private GeographicBoundingBox geographicDomain;
    private boolean geographicDomainKnown;
    private CoordinateReferenceSystem inputCRS;
    private final CoordinateReferenceSystem resultCRS;
    private MathTransform inputToResult;
    private final MathTransform domainToInput;
    private MathTransform inputToShiftable;
    private MathTransform shiftableToResult;
    private double[] periods;

    public WraparoundAdjustment(Envelope envelope, CoordinateReferenceSystem coordinateReferenceSystem) {
        ArgumentChecks.ensureNonNull("domain", envelope);
        this.domainOfValidity = ImmutableEnvelope.castOrCopy(envelope);
        this.resultCRS = coordinateReferenceSystem != null ? coordinateReferenceSystem : this.domainOfValidity.getCoordinateReferenceSystem();
        this.domainToInput = null;
    }

    public WraparoundAdjustment(Envelope envelope, MathTransform mathTransform, MathTransform mathTransform2) {
        ArgumentChecks.ensureNonNull("domain", envelope);
        this.domainOfValidity = ImmutableEnvelope.castOrCopy(envelope);
        if (mathTransform == null) {
            mathTransform = MathTransforms.identity(this.domainOfValidity.getDimension());
        }
        if (mathTransform2 == null) {
            mathTransform2 = MathTransforms.identity(mathTransform.getTargetDimensions());
        }
        this.domainToInput = mathTransform;
        this.inputToResult = mathTransform2;
        this.resultCRS = null;
    }

    private CoordinateOperation findOperation(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) throws TransformException {
        if (!this.geographicDomainKnown && !Utilities.equalsIgnoreMetadata(coordinateReferenceSystem, coordinateReferenceSystem2)) {
            try {
                this.geographicDomainKnown = true;
                this.geographicDomain = ReferencingServices.getInstance().setBounds(this.domainOfValidity, null, null);
            }
            catch (TransformException transformException) {
                Logging.ignorableException(Logging.getLogger("org.apache.sis.referencing.operation"), WraparoundAdjustment.class, "<init>", transformException);
            }
        }
        try {
            return CRS.findOperation(coordinateReferenceSystem, coordinateReferenceSystem2, this.geographicDomain);
        }
        catch (FactoryException factoryException) {
            throw new TransformException(factoryException.getMessage(), factoryException);
        }
    }

    private boolean initialize(CoordinateReferenceSystem coordinateReferenceSystem) throws TransformException {
        if (coordinateReferenceSystem == null && (coordinateReferenceSystem = this.domainOfValidity.getCoordinateReferenceSystem()) == null && this.domainToInput == null) {
            this.inputToResult = MathTransforms.identity(this.domainOfValidity.getDimension());
        }
        if (coordinateReferenceSystem != this.inputCRS) {
            this.inputCRS = coordinateReferenceSystem;
            this.periods = null;
            this.inputToShiftable = null;
            this.shiftableToResult = null;
            this.shiftableDomain = this.domainOfValidity;
            if (this.domainToInput == null) {
                this.inputToResult = coordinateReferenceSystem != null && this.resultCRS != null ? this.findOperation(coordinateReferenceSystem, this.resultCRS).getMathTransform() : MathTransforms.identity(coordinateReferenceSystem != null ? ReferencingUtilities.getDimension(coordinateReferenceSystem) : this.domainOfValidity.getDimension());
            }
            if (coordinateReferenceSystem != null) {
                WraparoundAxesFinder wraparoundAxesFinder = new WraparoundAxesFinder(coordinateReferenceSystem);
                this.inputToShiftable = wraparoundAxesFinder.preferredToSpecified.inverse();
                this.periods = wraparoundAxesFinder.periods();
                if (this.periods != null) {
                    this.transformDomain(wraparoundAxesFinder.preferredCRS);
                }
            }
        }
        return this.periods != null;
    }

    private void transformDomain(CoordinateReferenceSystem coordinateReferenceSystem) throws TransformException {
        if (this.domainToInput != null) {
            MathTransform mathTransform = MathTransforms.concatenate(this.domainToInput, this.inputToShiftable);
            if (!mathTransform.isIdentity()) {
                this.shiftableDomain = Envelopes.transform(mathTransform, (Envelope)this.domainOfValidity);
            }
        } else {
            CoordinateOperation coordinateOperation = this.findOperation(this.domainOfValidity.getCoordinateReferenceSystem(), coordinateReferenceSystem);
            MathTransform mathTransform = coordinateOperation.getMathTransform();
            if (!mathTransform.isIdentity()) {
                this.shiftableDomain = Envelopes.transform(coordinateOperation, (Envelope)this.domainOfValidity);
            }
        }
    }

    private MathTransform toResult(boolean bl) throws TransformException {
        if (bl) {
            if (this.shiftableToResult == null) {
                this.shiftableToResult = MathTransforms.concatenate(this.inputToShiftable.inverse(), this.inputToResult);
            }
            return this.shiftableToResult;
        }
        return this.inputToResult;
    }

    public GeneralEnvelope shift(Envelope envelope) throws TransformException {
        Object object;
        Object object2;
        boolean bl = false;
        if (this.initialize(envelope.getCoordinateReferenceSystem())) {
            GeneralEnvelope generalEnvelope;
            if (this.inputToShiftable.isIdentity()) {
                generalEnvelope = null;
                object2 = envelope.getLowerCorner();
                object = envelope.getUpperCorner();
            } else {
                generalEnvelope = Envelopes.transform(this.inputToShiftable, envelope);
                object2 = generalEnvelope.getLowerCorner();
                object = generalEnvelope.getUpperCorner();
            }
            for (int i = 0; i < this.periods.length; ++i) {
                boolean bl2;
                double d;
                double d2 = this.periods[i];
                if (!(d2 > 0.0)) continue;
                double d3 = object2.getOrdinate(i);
                double d4 = object.getOrdinate(i);
                double d5 = 0.0;
                double d6 = 0.0;
                double d7 = d4 - d3;
                if (MathFunctions.isNegative(d7)) {
                    d = d7 == 0.0 ? -1.0 : Math.floor(d7 / d2);
                    if (Math.abs(d3 + (d7 = d * d2)) < Math.abs(d4 - d7)) {
                        d5 = d;
                    } else {
                        d6 = -d;
                    }
                }
                d = this.shiftableDomain.getMinimum(i);
                double d8 = this.shiftableDomain.getMaximum(i);
                double d9 = (d - d3) / d2 - d5;
                double d10 = (d8 - d4) / d2 - d6;
                boolean bl3 = d9 > 0.0;
                boolean bl4 = bl2 = d10 < 0.0;
                if (bl3 != bl2) {
                    double d11;
                    double d12 = (d - d4) / d2 - d6;
                    double d13 = (d8 - d3) / d2 - d5;
                    if (bl3) {
                        d11 = Math.min(Math.floor(d13), Math.max(Math.floor(d9), Math.ceil(d12)));
                        d6 = d11 + 1.0 < d13 ? (d6 += Math.ceil(d10)) : (d6 += d11);
                        d5 += d11;
                    } else {
                        d11 = Math.max(Math.ceil(d12), Math.min(Math.ceil(d10), Math.floor(d13)));
                        d5 = d11 - 1.0 > d12 ? (d5 += Math.floor(d9)) : (d5 += d11);
                        d6 += d11;
                    }
                }
                if (d5 == 0.0 && d6 == 0.0) continue;
                bl = true;
                if (generalEnvelope == null) {
                    generalEnvelope = new GeneralEnvelope(envelope);
                }
                envelope = generalEnvelope;
                generalEnvelope.setRange(i, d3 + d5 * d2, d4 + d6 * d2);
            }
        }
        if ((object2 = this.toResult(bl)) != null) {
            object = Envelopes.transform((MathTransform)object2, envelope);
            ((GeneralEnvelope)object).setCoordinateReferenceSystem(this.resultCRS);
            return object;
        }
        return GeneralEnvelope.castOrCopy(envelope);
    }

    public DirectPosition shift(DirectPosition object) throws TransformException {
        Object object2;
        boolean bl = false;
        if (this.initialize(object.getCoordinateReferenceSystem())) {
            object2 = this.inputToShiftable.isIdentity() ? object : this.inputToShiftable.transform((DirectPosition)object, null);
            for (int i = 0; i < this.periods.length; ++i) {
                double d = this.periods[i];
                if (!(d > 0.0)) continue;
                double d2 = object2.getOrdinate(i);
                double d3 = this.shiftableDomain.getMinimum(i) - d2;
                if (d3 > 0.0) {
                    d3 = Math.ceil(d3 / d);
                } else {
                    d3 = this.shiftableDomain.getMaximum(i) - d2;
                    if (!(d3 < 0.0)) continue;
                    d3 = Math.floor(d3 / d);
                }
                if (d3 == 0.0) continue;
                bl = true;
                if (object2 == object) {
                    object2 = new GeneralDirectPosition((DirectPosition)object);
                }
                object = object2;
                object2.setOrdinate(i, d2 + d3 * d);
            }
        }
        if ((object2 = this.toResult(bl)) != null) {
            object = object2.transform((DirectPosition)object, this.resultCRS != null ? new GeneralDirectPosition(this.resultCRS) : null);
        }
        return object;
    }
}

