/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.awt.image.RenderedImage;
import java.util.Arrays;
import org.apache.sis.coverage.BandedCoverage;
import org.apache.sis.coverage.CannotEvaluateException;
import org.apache.sis.coverage.PointOutsideCoverageException;
import org.apache.sis.coverage.grid.DisjointExtentException;
import org.apache.sis.coverage.grid.FractionalGridCoordinates;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.internal.referencing.DirectPositionView;
import org.apache.sis.internal.referencing.WraparoundAxesFinder;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.logging.Logging;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class GridEvaluator
implements BandedCoverage.Evaluator {
    private final GridCoverage coverage;
    private CoordinateReferenceSystem sourceCRS;
    private MathTransform sourceToGrid;
    private FractionalGridCoordinates.Position position;
    double[] values;
    private boolean nullIfOutside;
    private long wraparoundAxes;
    private double[] wraparoundExtent;
    private MathTransform gridToWraparound;
    private double[] periods;

    protected GridEvaluator(GridCoverage gridCoverage) {
        ArgumentChecks.ensureNonNull("coverage", gridCoverage);
        this.coverage = gridCoverage;
    }

    @Override
    public GridCoverage getCoverage() {
        return this.coverage;
    }

    public boolean isWraparoundEnabled() {
        return this.wraparoundAxes != 0L;
    }

    public void setWraparoundEnabled(boolean bl) {
        this.wraparoundAxes = 0L;
        if (bl) {
            try {
                WraparoundAxesFinder wraparoundAxesFinder = new WraparoundAxesFinder(this.coverage.getCoordinateReferenceSystem());
                this.periods = wraparoundAxesFinder.periods();
                if (this.periods != null) {
                    int n;
                    GridGeometry gridGeometry = this.coverage.getGridGeometry();
                    GridExtent gridExtent = gridGeometry.getExtent();
                    MathTransform mathTransform = gridGeometry.getGridToCRS(PixelInCell.CELL_CENTER);
                    this.gridToWraparound = MathTransforms.concatenate(mathTransform, wraparoundAxesFinder.preferredToSpecified.inverse());
                    Matrix matrix = this.gridToWraparound.derivative(new DirectPositionView.Double(gridExtent.getPointOfInterest()));
                    int n2 = this.periods.length;
                    while (--n2 >= 0) {
                        if (!(this.periods[n2] > 0.0)) continue;
                        int n3 = Math.min(matrix.getNumCol(), 64);
                        while (--n3 >= 0) {
                            if (matrix.getElement(n2, n3) == 0.0) continue;
                            this.wraparoundAxes |= 1L << n3;
                        }
                    }
                    this.wraparoundExtent = new double[Long.bitCount(this.wraparoundAxes) << 1];
                    long l = this.wraparoundAxes;
                    int n4 = 0;
                    do {
                        n = Long.numberOfTrailingZeros(l);
                        this.wraparoundExtent[n4++] = gridExtent.getLow(n);
                        this.wraparoundExtent[n4++] = gridExtent.getHigh(n);
                    } while ((l &= 1L << n ^ 0xFFFFFFFFFFFFFFFFL) != 0L);
                    assert (this.wraparoundExtent.length == n4) : n4;
                }
            }
            catch (TransformException transformException) {
                GridEvaluator.recoverableException("setWraparoundEnabled", transformException);
            }
        }
    }

    @Override
    public boolean isNullIfOutside() {
        return this.nullIfOutside;
    }

    @Override
    public void setNullIfOutside(boolean bl) {
        this.nullIfOutside = bl;
    }

    @Override
    public double[] apply(DirectPosition directPosition) throws CannotEvaluateException {
        GridGeometry gridGeometry = this.coverage.gridGeometry;
        long[] lArray = new long[gridGeometry.getDimension()];
        Arrays.fill(lArray, 1L);
        try {
            FractionalGridCoordinates.Position position = this.toGridPosition(directPosition);
            try {
                GridExtent gridExtent = position.toExtent(gridGeometry.extent, lArray, this.nullIfOutside);
                if (gridExtent != null) {
                    return this.evaluate(this.coverage.render(gridExtent), 0, 0);
                }
            }
            catch (ArithmeticException | IndexOutOfBoundsException | DisjointExtentException runtimeException) {
                if (!this.nullIfOutside) {
                    throw (PointOutsideCoverageException)new PointOutsideCoverageException(position.pointOutsideCoverage(gridGeometry.extent)).initCause(runtimeException);
                }
            }
        }
        catch (PointOutsideCoverageException pointOutsideCoverageException) {
            throw pointOutsideCoverageException;
        }
        catch (RuntimeException | TransformException exception) {
            throw new CannotEvaluateException(exception.getMessage(), exception);
        }
        return null;
    }

    final double[] evaluate(RenderedImage renderedImage, int n, int n2) {
        int n3 = ImageUtilities.pixelToTileX(renderedImage, n);
        int n4 = ImageUtilities.pixelToTileY(renderedImage, n2);
        this.values = renderedImage.getTile(n3, n4).getPixel(n, n2, this.values);
        return this.values;
    }

    public FractionalGridCoordinates toGridCoordinates(DirectPosition directPosition) throws TransformException {
        ArgumentChecks.ensureNonNull("point", directPosition);
        return new FractionalGridCoordinates(this.toGridPosition(directPosition));
    }

    final FractionalGridCoordinates.Position toGridPosition(DirectPosition directPosition) throws TransformException {
        block16: {
            int n;
            long l;
            Object object;
            Object object2;
            CoordinateReferenceSystem coordinateReferenceSystem = directPosition.getCoordinateReferenceSystem();
            if (coordinateReferenceSystem != this.sourceCRS || this.sourceToGrid == null) {
                object2 = this.coverage.getGridGeometry();
                object = ((GridGeometry)object2).getGridToCRS(PixelInCell.CELL_CENTER).inverse();
                if (coordinateReferenceSystem != null) {
                    try {
                        CoordinateOperation coordinateOperation = CRS.findOperation(coordinateReferenceSystem, this.coverage.getCoordinateReferenceSystem(), ((GridGeometry)object2).geographicBBox());
                        object = MathTransforms.concatenate(coordinateOperation.getMathTransform(), (MathTransform)object);
                    }
                    catch (FactoryException factoryException) {
                        throw new TransformException(factoryException.getMessage(), factoryException);
                    }
                }
                this.position = new FractionalGridCoordinates.Position(object.getTargetDimensions());
                this.sourceCRS = coordinateReferenceSystem;
                this.sourceToGrid = object;
            }
            if ((object2 = this.sourceToGrid.transform(directPosition, this.position)) != this.position) {
                object = this.position.coordinates;
                System.arraycopy(object2.getCoordinate(), 0, object, 0, ((Object)object).length);
            }
            if ((l = this.wraparoundAxes) == 0L) break block16;
            double[] dArray = this.position.coordinates;
            long l2 = 0L;
            int n2 = 0;
            do {
                block18: {
                    double d;
                    block17: {
                        double d2;
                        double d3;
                        if ((d3 = dArray[n = Long.numberOfTrailingZeros(l)]) < (d = this.wraparoundExtent[n2++])) break block17;
                        d = this.wraparoundExtent[n2];
                        if (!(d3 > d2)) break block18;
                    }
                    if (l2 == 0L) {
                        int n3 = dArray.length;
                        dArray = Arrays.copyOf(dArray, 2 * Math.max(n3, this.gridToWraparound.getTargetDimensions()));
                        System.arraycopy(dArray, 0, dArray, n3, n3);
                    }
                    dArray[n] = d;
                    l2 |= 1L << n;
                }
                ++n2;
            } while ((l &= 1L << n ^ 0xFFFFFFFFFFFFFFFFL) != 0L);
            assert (this.wraparoundExtent.length == n2) : n2;
            if (l2 != 0L) {
                double d;
                this.gridToWraparound.transform(dArray, 0, dArray, 0, 2);
                n = this.gridToWraparound.getTargetDimensions();
                int n4 = this.periods.length;
                while (--n4 >= 0) {
                    d = this.periods[n4];
                    if (!(d > 0.0)) continue;
                    int n5 = n4 + n;
                    double d4 = dArray[n4] - dArray[n5];
                    d4 = Math.copySign(Math.ceil(Math.abs(d4) / d), d4) * d;
                    int n6 = n5;
                    dArray[n6] = dArray[n6] + d4;
                }
                this.gridToWraparound.inverse().transform(dArray, n, dArray, 0, 1);
                n2 = 0;
                do {
                    if (!((d = dArray[n4 = Long.numberOfTrailingZeros(l2)]) < this.wraparoundExtent[n2++])) {
                        int n7 = n2++;
                        if (!(d > this.wraparoundExtent[n7])) continue;
                    }
                    return this.position;
                } while ((l2 &= 1L << n4 ^ 0xFFFFFFFFFFFFFFFFL) != 0L);
                System.arraycopy(dArray, 0, this.position.coordinates, 0, this.position.coordinates.length);
            }
        }
        return this.position;
    }

    private static void recoverableException(String string, TransformException transformException) {
        Logging.recoverableException(Logging.getLogger("org.apache.sis.raster"), GridEvaluator.class, string, transformException);
    }
}

