/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.util.List;
import org.apache.sis.coverage.CannotEvaluateException;
import org.apache.sis.coverage.PointOutsideCoverageException;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.FractionalGridCoordinates;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridEvaluator;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.IllegalGridGeometryException;
import org.apache.sis.coverage.grid.ImageRenderer;
import org.apache.sis.image.DataType;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.jdk9.JDK9;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.operation.TransformException;

public class BufferedGridCoverage
extends GridCoverage {
    protected final DataBuffer data;

    public BufferedGridCoverage(GridGeometry gridGeometry, List<? extends SampleDimension> list, DataBuffer dataBuffer) {
        super(gridGeometry, list);
        this.data = dataBuffer;
        ArgumentChecks.ensureNonNull("data", dataBuffer);
        int n = list.size();
        int n2 = dataBuffer.getNumBanks();
        if (n2 != 1 && n2 != n) {
            throw new IllegalArgumentException(Resources.format((short)40, n2, n));
        }
        GridExtent gridExtent = gridGeometry.getExtent();
        long l = BufferedGridCoverage.getSampleCount(gridExtent, n);
        long l2 = JDK9.multiplyFull(dataBuffer.getSize(), n2);
        if (l2 < l) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < gridExtent.getDimension(); ++i) {
                if (i != 0) {
                    stringBuilder.append(" \u00d7 ");
                }
                stringBuilder.append(gridExtent.getSize(i));
            }
            throw new IllegalGridGeometryException(Resources.format((short)36, stringBuilder, n, l - l2));
        }
    }

    public BufferedGridCoverage(GridGeometry gridGeometry, List<? extends SampleDimension> list, int n) {
        super(gridGeometry, list);
        int n2 = Math.toIntExact(BufferedGridCoverage.getSampleCount(gridGeometry.getExtent(), list.size()));
        switch (n) {
            case 0: {
                this.data = new DataBufferByte(n2);
                break;
            }
            case 2: {
                this.data = new DataBufferShort(n2);
                break;
            }
            case 1: {
                this.data = new DataBufferUShort(n2);
                break;
            }
            case 3: {
                this.data = new DataBufferInt(n2);
                break;
            }
            case 4: {
                this.data = new DataBufferFloat(n2);
                break;
            }
            case 5: {
                this.data = new DataBufferDouble(n2);
                break;
            }
            default: {
                throw new IllegalArgumentException(Errors.format((short)149, n));
            }
        }
    }

    private static long getSampleCount(GridExtent gridExtent, long l) {
        int n = gridExtent.getDimension();
        while (--n >= 0) {
            l = Math.multiplyExact(l, gridExtent.getSize(n));
        }
        return l;
    }

    @Override
    final DataType getBandType() {
        return DataType.forDataBufferType(this.data.getDataType());
    }

    @Override
    public GridEvaluator evaluator() {
        return new CellAccessor(this);
    }

    @Override
    public RenderedImage render(GridExtent gridExtent) {
        ImageRenderer imageRenderer = new ImageRenderer(this, gridExtent);
        try {
            imageRenderer.setData(this.data);
            return imageRenderer.createImage();
        }
        catch (RasterFormatException | ArithmeticException | IllegalArgumentException runtimeException) {
            throw new CannotEvaluateException(runtimeException.getMessage(), runtimeException);
        }
    }

    private static class CellAccessor
    extends GridEvaluator {
        private final DataBuffer data;
        private final long[] lower;
        private final long[] sizes;
        private final boolean banded;

        CellAccessor(BufferedGridCoverage bufferedGridCoverage) {
            super(bufferedGridCoverage);
            this.data = bufferedGridCoverage.data;
            GridExtent gridExtent = bufferedGridCoverage.getGridGeometry().getExtent();
            this.lower = new long[gridExtent.getDimension()];
            this.sizes = new long[this.lower.length + 1];
            this.sizes[0] = this.data.getNumBanks();
            for (int i = 0; i < this.lower.length; ++i) {
                this.lower[i] = gridExtent.getLow(i);
                this.sizes[i + 1] = gridExtent.getSize(i);
            }
            this.banded = this.sizes[0] > 1L;
            this.values = new double[bufferedGridCoverage.getSampleDimensions().size()];
        }

        @Override
        public double[] apply(DirectPosition directPosition) throws CannotEvaluateException {
            int n;
            int n2;
            Object object;
            try {
                object = this.toGridPosition(directPosition);
                n2 = this.lower.length;
                long l = this.sizes[n2];
                long l2 = 0L;
                while (--n2 >= 0) {
                    long l3 = this.lower[n2];
                    long l4 = ((FractionalGridCoordinates)object).getCoordinateValue(n2);
                    if (l4 < l3 || (l4 -= l3) >= l) {
                        if (this.isNullIfOutside()) {
                            return null;
                        }
                        throw new PointOutsideCoverageException(((FractionalGridCoordinates)object).pointOutsideCoverage(this.getCoverage().gridGeometry.extent));
                    }
                    l = this.sizes[n2];
                    l2 = (l2 + l4) * l;
                }
                n = Math.toIntExact(l2);
            }
            catch (ArithmeticException | TransformException exception) {
                throw new CannotEvaluateException(exception.getMessage(), exception);
            }
            object = this.values;
            if (this.banded) {
                for (n2 = 0; n2 < ((Object)object).length; ++n2) {
                    object[n2] = this.data.getElemDouble(n2, n);
                }
            } else {
                for (n2 = 0; n2 < ((Object)object).length; ++n2) {
                    object[n2] = this.data.getElemDouble(n2 + n);
                }
            }
            return object;
        }
    }
}

