/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import javax.sql.DataSource;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.StoreUtilities;
import org.apache.sis.internal.storage.io.ChannelDataInput;
import org.apache.sis.internal.storage.io.ChannelFactory;
import org.apache.sis.internal.storage.io.ChannelImageInputStream;
import org.apache.sis.internal.storage.io.IOUtilities;
import org.apache.sis.internal.storage.io.InputStreamAdapter;
import org.apache.sis.internal.storage.io.RewindableLineReader;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.io.InvalidSeekException;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.ForwardOnlyStorageException;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ObjectConverters;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.collection.DefaultTreeTable;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;

public class StorageConnector
implements Serializable {
    private static final long serialVersionUID = 2524083964906593093L;
    static final int DEFAULT_BUFFER_SIZE = 8192;
    static final int MINIMAL_BUFFER_SIZE = 256;
    private static final byte CASCADE_ON_CLOSE = 1;
    private static final byte CASCADE_ON_RESET = 2;
    private static final byte CLEAR_ON_RESET = 4;
    private static final Map<Class<?>, Opener<?>> OPENERS = new IdentityHashMap(13);
    private final Object storage;
    private transient String name;
    private transient String extension;
    private Map<OptionKey<?>, Object> options;
    private transient Map<Class<?>, Coupled> views;

    private static <T> void add(Class<T> clazz, Opener<T> opener) {
        if (OPENERS.put(clazz, opener) != null) {
            throw new AssertionError(clazz);
        }
    }

    public StorageConnector(Object object) {
        ArgumentChecks.ensureNonNull("storage", object);
        this.storage = object;
    }

    public <T> T getOption(OptionKey<T> optionKey) {
        ArgumentChecks.ensureNonNull("key", optionKey);
        return optionKey.getValueFrom(this.options);
    }

    public <T> void setOption(OptionKey<T> optionKey, T t) {
        ArgumentChecks.ensureNonNull("key", optionKey);
        this.options = optionKey.setValueInto(this.options, t);
    }

    public Object getStorage() throws DataStoreException {
        this.reset();
        return this.storage;
    }

    public String getStorageName() {
        if (this.name == null) {
            this.name = IOUtilities.filename(this.storage);
            if (this.name == null) {
                this.name = Classes.getShortClassName(this.storage);
            }
        }
        return this.name;
    }

    public String getFileExtension() {
        if (this.extension == null) {
            this.extension = IOUtilities.extension(this.storage);
        }
        return this.extension;
    }

    public <T> T getStorageAs(Class<T> clazz) throws IllegalArgumentException, DataStoreException {
        Object obj;
        ArgumentChecks.ensureNonNull("type", clazz);
        if (this.views != null && this.views.isEmpty()) {
            throw new IllegalStateException(Resources.format((short)56));
        }
        Coupled coupled = this.getView(clazz);
        if (this.reset(coupled)) {
            return clazz.cast(coupled.view);
        }
        if (clazz.isInstance(this.storage)) {
            Reader reader;
            Object object = this.storage;
            this.reset();
            int n = 0;
            if (clazz == InputStream.class) {
                InputStream inputStream = (InputStream)object;
                if (!inputStream.markSupported()) {
                    object = clazz.cast(new BufferedInputStream(inputStream));
                    n = 6;
                }
            } else if (clazz == Reader.class && !(reader = (Reader)object).markSupported()) {
                object = clazz.cast(new LineNumberReader(reader));
                n = 6;
            }
            this.addView(clazz, object, null, (byte)n);
            return (T)object;
        }
        Opener<?> opener = OPENERS.get(clazz);
        if (opener == null) {
            T t;
            try {
                t = ObjectConverters.convert(this.storage, clazz);
            }
            catch (UnconvertibleObjectException unconvertibleObjectException) {
                if (!OPENERS.containsKey(clazz)) {
                    throw unconvertibleObjectException;
                }
                Logging.recoverableException(StoreUtilities.LOGGER, StorageConnector.class, "getStorageAs", unconvertibleObjectException);
                t = null;
            }
            this.addView(clazz, t);
            return t;
        }
        try {
            obj = opener.open(this);
        }
        catch (DataStoreException dataStoreException) {
            throw dataStoreException;
        }
        catch (Exception exception) {
            short s2 = 9;
            if (exception instanceof NoSuchFileException) {
                s2 = 39;
            }
            throw new DataStoreException(Errors.format(s2, this.getStorageName()), exception);
        }
        return clazz.cast(obj);
    }

    private boolean reset(Coupled coupled) throws DataStoreException {
        boolean bl;
        if (coupled == null) {
            return false;
        }
        try {
            bl = coupled.reset();
        }
        catch (IOException iOException) {
            throw new ForwardOnlyStorageException(Resources.format((short)18, this.getStorageName()), iOException);
        }
        if (bl) {
            coupled.invalidateSources();
            coupled.invalidateUsages();
        }
        return coupled.isValid;
    }

    private void reset() throws DataStoreException {
        if (this.views != null && !this.views.isEmpty() && !this.reset(this.views.get(null))) {
            throw new ForwardOnlyStorageException(Resources.format((short)18, this.getStorageName()));
        }
    }

    private ChannelDataInput createChannelDataInput(boolean bl) throws IOException, DataStoreException {
        ChannelFactory channelFactory;
        this.reset();
        if (this.storage instanceof InputStream) {
            ((InputStream)this.storage).mark(8192);
        }
        if ((channelFactory = ChannelFactory.prepare(this.storage, this.getOption(OptionKey.URL_ENCODING), false, this.getOption(OptionKey.OPEN_OPTIONS))) == null) {
            return null;
        }
        String string = this.getStorageName();
        ReadableByteChannel readableByteChannel = channelFactory.readable(string, null);
        this.addView(ReadableByteChannel.class, readableByteChannel, null, channelFactory.isCoupled() ? (byte)2 : 0);
        ByteBuffer byteBuffer = this.getOption(OptionKey.BYTE_BUFFER);
        if (byteBuffer == null) {
            byteBuffer = ByteBuffer.allocateDirect(8192);
        }
        ChannelDataInput channelDataInput = bl ? new ChannelImageInputStream(string, readableByteChannel, byteBuffer, false) : new ChannelDataInput(string, readableByteChannel, byteBuffer, false);
        this.addView(ChannelDataInput.class, channelDataInput, ReadableByteChannel.class, (byte)2);
        if (channelFactory.canOpen()) {
            this.addView(ChannelFactory.class, channelFactory);
        }
        return channelDataInput;
    }

    private DataInput createDataInput() throws IOException, DataStoreException {
        DataInput dataInput;
        Coupled coupled = this.getView(ChannelDataInput.class);
        ChannelDataInput channelDataInput = this.reset(coupled) ? (ChannelDataInput)coupled.view : this.createChannelDataInput(true);
        if (channelDataInput != null) {
            coupled = this.getView(ChannelDataInput.class);
            if (channelDataInput instanceof DataInput) {
                dataInput = (DataInput)((Object)channelDataInput);
            } else {
                dataInput = new ChannelImageInputStream(channelDataInput);
                coupled.view = dataInput;
            }
            this.views.put(DataInput.class, coupled);
        } else {
            this.reset();
            dataInput = ImageIO.createImageInputStream(this.storage);
            this.addView(DataInput.class, dataInput, null, (byte)3);
        }
        return dataInput;
    }

    private ByteBuffer createByteBuffer() throws IOException, DataStoreException {
        ChannelDataInput channelDataInput = this.getStorageAs(ChannelDataInput.class);
        ByteBuffer byteBuffer = null;
        if (channelDataInput != null) {
            byteBuffer = channelDataInput.buffer.asReadOnlyBuffer();
        } else {
            ImageInputStream imageInputStream = this.getStorageAs(ImageInputStream.class);
            if (imageInputStream != null) {
                imageInputStream.mark();
                byte[] byArray = new byte[256];
                int n = imageInputStream.read(byArray);
                imageInputStream.reset();
                if (n >= 1) {
                    byteBuffer = ByteBuffer.wrap(byArray).order(imageInputStream.getByteOrder());
                    byteBuffer.limit(n);
                }
            }
        }
        this.addView(ByteBuffer.class, byteBuffer);
        return byteBuffer;
    }

    final boolean prefetch() throws DataStoreException {
        try {
            Coupled coupled = this.getView(ChannelDataInput.class);
            if (coupled != null) {
                this.reset(coupled);
                return coupled.isValid && ((ChannelDataInput)coupled.view).prefetch() > 0;
            }
            coupled = this.getView(ImageInputStream.class);
            if (this.reset(coupled)) {
                ByteBuffer byteBuffer;
                ImageInputStream imageInputStream = (ImageInputStream)coupled.view;
                coupled = this.getView(ByteBuffer.class);
                if (this.reset(coupled) && (byteBuffer = (ByteBuffer)coupled.view) != null) {
                    int n = byteBuffer.limit();
                    long l = imageInputStream.getStreamPosition();
                    imageInputStream.seek(Math.addExact(l, (long)n));
                    int n2 = imageInputStream.read(byteBuffer.array(), n, byteBuffer.capacity() - n);
                    imageInputStream.seek(l);
                    if (n2 > 0) {
                        byteBuffer.limit(n + n2);
                        return true;
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new DataStoreException(Errors.format((short)12, this.getStorageName()), iOException);
        }
        return false;
    }

    private ImageInputStream createImageInputStream() throws DataStoreException {
        Class<DataInput> clazz = DataInput.class;
        DataInput dataInput = this.getStorageAs(clazz);
        if (dataInput instanceof ImageInputStream) {
            this.views.put(ImageInputStream.class, this.views.get(clazz));
            return (ImageInputStream)dataInput;
        }
        this.addView(ImageInputStream.class, null);
        return null;
    }

    private InputStream createInputStream() throws IOException, DataStoreException {
        Class<DataInput> clazz = DataInput.class;
        DataInput dataInput = this.getStorageAs(clazz);
        if (dataInput instanceof InputStream) {
            this.views.put(InputStream.class, this.views.get(clazz));
            return (InputStream)((Object)dataInput);
        }
        if (dataInput instanceof ImageInputStream) {
            InputStreamAdapter inputStreamAdapter = new InputStreamAdapter((ImageInputStream)dataInput);
            this.addView(InputStream.class, inputStreamAdapter, clazz, (byte)(this.getView(clazz).cascade & 2));
            return inputStreamAdapter;
        }
        this.addView(InputStream.class, null);
        return null;
    }

    private Reader createReader() throws IOException, DataStoreException {
        InputStream inputStream = this.getStorageAs(InputStream.class);
        if (inputStream == null) {
            this.addView(Reader.class, null);
            return null;
        }
        inputStream.mark(8192);
        RewindableLineReader rewindableLineReader = new RewindableLineReader(inputStream, this.getOption(OptionKey.ENCODING));
        this.addView(Reader.class, rewindableLineReader, InputStream.class, (byte)6);
        return rewindableLineReader;
    }

    private Connection createConnection() throws SQLException {
        if (this.storage instanceof DataSource) {
            Connection connection = ((DataSource)this.storage).getConnection();
            this.addView(Connection.class, connection, null, (byte)0);
            return connection;
        }
        return null;
    }

    private String createString() {
        return IOUtilities.toString(this.storage);
    }

    private <T> void addView(Class<T> clazz, T t) {
        this.addView(clazz, t, null, (byte)0);
    }

    private <T> void addView(Class<T> clazz, T t, Class<?> clazz2, byte by) {
        Coupled coupled;
        if (this.views == null) {
            this.views = new IdentityHashMap();
            this.views.put(null, new Coupled(this.storage));
        }
        if ((coupled = this.views.get(clazz)) == null) {
            if (t == this.storage) {
                coupled = this.views.get(null);
                coupled.invalidateUsages();
            } else {
                coupled = new Coupled(by != 0 ? this.views.get(clazz2) : null, by);
            }
            this.views.put(clazz, coupled);
        } else {
            assert (coupled.view == null || coupled.view == t) : coupled;
            assert (coupled.cascade == by) : by;
            assert (coupled.wrapperFor == (by != 0 ? this.views.get(clazz2) : null)) : coupled;
            coupled.invalidateUsages();
        }
        coupled.view = t;
        coupled.isValid = true;
        coupled.invalidateSources();
    }

    private Coupled getView(Class<?> clazz) {
        return this.views != null ? this.views.get(clazz) : null;
    }

    /*
     * WARNING - void declaration
     */
    public void closeAllExcept(Object object) throws DataStoreException {
        if (this.views == null) {
            this.views = Collections.emptyMap();
            if (this.storage != object && this.storage instanceof AutoCloseable) {
                try {
                    ((AutoCloseable)this.storage).close();
                }
                catch (DataStoreException dataStoreException) {
                    throw dataStoreException;
                }
                catch (Exception exception) {
                    throw new DataStoreException(exception);
                }
            }
            return;
        }
        IdentityHashMap<AutoCloseable, Boolean> identityHashMap = new IdentityHashMap<AutoCloseable, Boolean>(this.views.size());
        for (Coupled coupled : this.views.values()) {
            void object2;
            Coupled coupled2;
            Object object3 = coupled.view;
            if (object3 != object) {
                if (!(object3 instanceof AutoCloseable)) continue;
                identityHashMap.putIfAbsent((AutoCloseable)object3, Boolean.TRUE);
                continue;
            }
            coupled.protect(identityHashMap);
            do {
                if (!((object3 = object2.view) instanceof AutoCloseable)) continue;
                identityHashMap.put((AutoCloseable)object3, Boolean.FALSE);
            } while ((coupled2 = object2.wrapperFor) != null);
        }
        Object object4 = identityHashMap.values().iterator();
        while (object4.hasNext()) {
            if (!Boolean.FALSE.equals(object4.next())) continue;
            object4.remove();
        }
        if (!identityHashMap.isEmpty()) {
            block8: for (Coupled coupled : this.views.values()) {
                void var4_11;
                Coupled coupled3;
                if (coupled.cascadeOnClose() || !identityHashMap.containsKey(coupled.view)) continue;
                while ((coupled3 = var4_11.wrapperFor) != null) {
                    identityHashMap.remove(coupled3.view);
                    if (!coupled3.cascadeOnClose()) continue;
                    continue block8;
                }
            }
        }
        this.views = Collections.emptyMap();
        object4 = null;
        for (Object object3 : identityHashMap.keySet()) {
            try {
                object3.close();
            }
            catch (Exception exception) {
                if (object4 == null) {
                    object4 = exception instanceof DataStoreException ? (DataStoreException)exception : new DataStoreException(exception);
                    continue;
                }
                ((Throwable)object4).addSuppressed(exception);
            }
        }
        if (object4 != null) {
            throw object4;
        }
    }

    public String toString() {
        Object object;
        DefaultTreeTable defaultTreeTable = new DefaultTreeTable(TableColumn.NAME, TableColumn.VALUE);
        TreeTable.Node node = defaultTreeTable.getRoot();
        node.setValue(TableColumn.NAME, Classes.getShortClassName(this));
        node.setValue(TableColumn.VALUE, this.getStorageName());
        if (this.options != null) {
            object = node.newChild();
            object.setValue(TableColumn.NAME, "options");
            object.setValue(TableColumn.VALUE, this.options);
        }
        if ((object = this.getView(null)) != null) {
            ((Coupled)object).append(node.newChild(), this.views);
        }
        return ((Object)defaultTreeTable).toString();
    }

    static {
        StorageConnector.add(String.class, StorageConnector::createString);
        StorageConnector.add(ByteBuffer.class, StorageConnector::createByteBuffer);
        StorageConnector.add(DataInput.class, StorageConnector::createDataInput);
        StorageConnector.add(ImageInputStream.class, StorageConnector::createImageInputStream);
        StorageConnector.add(InputStream.class, StorageConnector::createInputStream);
        StorageConnector.add(Reader.class, StorageConnector::createReader);
        StorageConnector.add(Connection.class, StorageConnector::createConnection);
        StorageConnector.add(ChannelDataInput.class, storageConnector -> storageConnector.createChannelDataInput(false));
        StorageConnector.add(ChannelFactory.class, storageConnector -> null);
        StorageConnector.add(URI.class, null);
        StorageConnector.add(URL.class, null);
        StorageConnector.add(File.class, null);
        StorageConnector.add(Path.class, null);
    }

    private static final class Coupled {
        Object view;
        final Coupled wrapperFor;
        private Coupled[] wrappedBy;
        final byte cascade;
        boolean isValid;

        Coupled(Object object) {
            this.view = object;
            this.wrapperFor = null;
            this.cascade = 0;
            this.isValid = true;
        }

        Coupled(Coupled coupled, byte by) {
            this.wrapperFor = coupled;
            this.cascade = by;
            if (coupled != null) {
                Coupled[] coupledArray = coupled.wrappedBy;
                int n = coupledArray != null ? coupledArray.length : 0;
                Coupled[] coupledArray2 = new Coupled[n + 1];
                if (n != 0) {
                    System.arraycopy(coupledArray, 0, coupledArray2, 0, n);
                }
                coupledArray2[n] = this;
                coupled.wrappedBy = coupledArray2;
            }
        }

        final boolean cascadeOnClose() {
            return (this.cascade & 1) != 0;
        }

        final boolean cascadeOnReset() {
            return (this.cascade & 2) != 0;
        }

        final void invalidateSources() {
            boolean bl = this.cascadeOnReset();
            Coupled coupled = this.wrapperFor;
            while (bl) {
                coupled.isValid = false;
                bl = coupled.cascadeOnReset();
                coupled = coupled.wrapperFor;
            }
        }

        final void invalidateUsages() {
            if (this.wrappedBy != null) {
                for (Coupled coupled : this.wrappedBy) {
                    if (!coupled.cascadeOnReset()) continue;
                    coupled.isValid = false;
                    coupled.invalidateUsages();
                }
            }
        }

        final void protect(Map<AutoCloseable, Boolean> map) {
            if (this.wrappedBy != null) {
                for (Coupled coupled : this.wrappedBy) {
                    if (coupled.cascadeOnClose()) continue;
                    if (coupled.view instanceof AutoCloseable) {
                        map.put((AutoCloseable)coupled.view, Boolean.FALSE);
                    }
                    coupled.protect(map);
                }
            }
        }

        final boolean reset() throws IOException {
            if (this.isValid) {
                return false;
            }
            if (this.cascadeOnReset()) {
                this.wrapperFor.reset();
            }
            if ((this.cascade & 4) != 0) {
                this.view = null;
                return true;
            }
            if (this.view instanceof InputStream) {
                ((InputStream)this.view).reset();
            } else if (this.view instanceof Reader) {
                ((Reader)this.view).reset();
            } else if (this.view instanceof ChannelDataInput) {
                ChannelDataInput channelDataInput = (ChannelDataInput)this.view;
                channelDataInput.buffer.limit(0);
                channelDataInput.setStreamPosition(0L);
            } else if (this.view instanceof Channel) {
                String string = null;
                if (this.wrappedBy != null) {
                    for (Coupled coupled : this.wrappedBy) {
                        if (!(coupled.view instanceof ChannelDataInput)) continue;
                        ChannelDataInput channelDataInput = (ChannelDataInput)coupled.view;
                        if (this.view instanceof SeekableByteChannel) {
                            ((SeekableByteChannel)this.view).position(channelDataInput.channelOffset);
                            return true;
                        }
                        string = channelDataInput.filename;
                    }
                }
                if (string == null) {
                    string = Classes.getShortClassName(this.view);
                }
                throw new InvalidSeekException(Resources.format((short)13, string));
            }
            this.isValid = true;
            return true;
        }

        public String toString() {
            return Strings.toString(this.getClass(), "view", Classes.getShortClassName(this.view), "wrapperFor", this.wrapperFor != null ? Classes.getShortClassName(this.wrapperFor.view) : null, "cascade", this.cascade, "isValid", this.isValid);
        }

        final void append(TreeTable.Node node, Map<Class<?>, Coupled> map) {
            Class<?> clazz = null;
            for (Map.Entry<Class<?>, Coupled> entry : map.entrySet()) {
                Class<?> clazz2;
                if (entry.getValue() != this || (clazz2 = Classes.findCommonClass(clazz, entry.getKey())) == Object.class) continue;
                clazz = clazz2;
            }
            node.setValue(TableColumn.NAME, Classes.getShortName(clazz));
            node.setValue(TableColumn.VALUE, Classes.getShortClassName(this.view));
            if (this.wrappedBy != null) {
                for (Coupled coupled : this.wrappedBy) {
                    coupled.append(node.newChild(), map);
                }
            }
        }
    }

    @FunctionalInterface
    private static interface Opener<T> {
        public T open(StorageConnector var1) throws Exception;
    }
}

