/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.referencing.provider.GeocentricAffine;
import org.apache.sis.internal.system.Semaphores;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.parameter.Parameterized;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.AbstractLinearTransform;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.operation.transform.ConcatenatedTransform1D;
import org.apache.sis.referencing.operation.transform.ConcatenatedTransform2D;
import org.apache.sis.referencing.operation.transform.ConcatenatedTransformDirect;
import org.apache.sis.referencing.operation.transform.ConcatenatedTransformDirect1D;
import org.apache.sis.referencing.operation.transform.ConcatenatedTransformDirect2D;
import org.apache.sis.referencing.operation.transform.IterationStrategy;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

class ConcatenatedTransform
extends AbstractMathTransform
implements Serializable {
    private static final long serialVersionUID = 5772066656987558634L;
    private static final double IDENTITY_TOLERANCE = 1.0E-16;
    protected final MathTransform transform1;
    protected final MathTransform transform2;
    private MathTransform inverse;

    protected ConcatenatedTransform(MathTransform mathTransform, MathTransform mathTransform2) {
        this.transform1 = mathTransform;
        this.transform2 = mathTransform2;
        if (!this.isValid()) {
            throw new IllegalArgumentException(Resources.format((short)3, ConcatenatedTransform.getName(mathTransform), ConcatenatedTransform.getName(mathTransform2)));
        }
    }

    public static MathTransform create(MathTransform mathTransform, MathTransform mathTransform2, MathTransformFactory mathTransformFactory) throws FactoryException, MismatchedDimensionException {
        int n;
        int n2 = mathTransform.getTargetDimensions();
        if (n2 != (n = mathTransform2.getSourceDimensions())) {
            throw new MismatchedDimensionException(Resources.format((short)3, ConcatenatedTransform.getName(mathTransform), ConcatenatedTransform.getName(mathTransform2)) + ' ' + Errors.format((short)80, n2, n));
        }
        MathTransform mathTransform3 = ConcatenatedTransform.tryOptimized(mathTransform, mathTransform2, mathTransformFactory);
        if (mathTransform3 != null) {
            return mathTransform3;
        }
        int n3 = mathTransform.getSourceDimensions();
        int n4 = mathTransform2.getTargetDimensions();
        if (n3 == 1 && n4 == 1) {
            if (mathTransform instanceof MathTransform1D && mathTransform2 instanceof MathTransform1D) {
                return new ConcatenatedTransformDirect1D((MathTransform1D)mathTransform, (MathTransform1D)mathTransform2);
            }
            return new ConcatenatedTransform1D(mathTransform, mathTransform2);
        }
        if (n3 == 2 && n4 == 2) {
            if (mathTransform instanceof MathTransform2D && mathTransform2 instanceof MathTransform2D) {
                return new ConcatenatedTransformDirect2D((MathTransform2D)mathTransform, (MathTransform2D)mathTransform2);
            }
            return new ConcatenatedTransform2D(mathTransform, mathTransform2);
        }
        if (n3 == n2 && n4 == n) {
            return new ConcatenatedTransformDirect(mathTransform, mathTransform2);
        }
        return new ConcatenatedTransform(mathTransform, mathTransform2);
    }

    private static MathTransform tryOptimized(MathTransform mathTransform, MathTransform mathTransform2, MathTransformFactory mathTransformFactory) throws FactoryException {
        MathTransform mathTransform3;
        if (mathTransform.isIdentity()) {
            return mathTransform2;
        }
        if (mathTransform2.isIdentity()) {
            return mathTransform;
        }
        int n = 0;
        MathTransform mathTransform4 = null;
        boolean bl = false;
        if (mathTransform instanceof AbstractMathTransform) {
            mathTransform3 = ((AbstractMathTransform)mathTransform).tryConcatenate(false, mathTransform2, mathTransformFactory);
            bl = true;
            if (mathTransform3 != null) {
                n = ConcatenatedTransform.getStepCount(mathTransform3);
                mathTransform4 = mathTransform3;
            }
        }
        if (mathTransform2 instanceof AbstractMathTransform) {
            mathTransform3 = ((AbstractMathTransform)mathTransform2).tryConcatenate(true, mathTransform, mathTransformFactory);
            bl = true;
            if (mathTransform3 != null) {
                if (mathTransform4 == null || ConcatenatedTransform.getStepCount(mathTransform3) < n) {
                    return mathTransform3;
                }
                mathTransform4 = mathTransform3;
            }
        }
        if (mathTransform4 != null) {
            return mathTransform4;
        }
        if (!bl && (ConcatenatedTransform.isInverseEquals(mathTransform, mathTransform2) || ConcatenatedTransform.isInverseEquals(mathTransform2, mathTransform))) {
            assert (mathTransform.getSourceDimensions() == mathTransform2.getTargetDimensions());
            assert (mathTransform.getTargetDimensions() == mathTransform2.getSourceDimensions());
            return MathTransforms.identity(mathTransform.getSourceDimensions());
        }
        mathTransform3 = ConcatenatedTransform.multiply(mathTransform, mathTransform2, mathTransformFactory);
        if (mathTransform3 instanceof AbstractLinearTransform) {
            AbstractLinearTransform abstractLinearTransform = (AbstractLinearTransform)mathTransform3;
            if (abstractLinearTransform.inverse == null) {
                try {
                    MathTransform mathTransform5 = ConcatenatedTransform.multiply(mathTransform2.inverse(), mathTransform.inverse(), mathTransformFactory);
                    if (mathTransform5 != null) {
                        if (mathTransform5.isIdentity()) {
                            return mathTransform5;
                        }
                        if (mathTransform5 instanceof LinearTransform) {
                            abstractLinearTransform.inverse = (LinearTransform)mathTransform5;
                        }
                    }
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    Logging.recoverableException(Logging.getLogger("org.apache.sis.referencing.operation"), ConcatenatedTransform.class, "create", noninvertibleTransformException);
                }
            }
        }
        return mathTransform3;
    }

    private static MathTransform multiply(MathTransform mathTransform, MathTransform mathTransform2, MathTransformFactory mathTransformFactory) throws FactoryException {
        Matrix matrix;
        Matrix matrix2 = MathTransforms.getMatrix(mathTransform);
        if (matrix2 != null && (matrix = MathTransforms.getMatrix(mathTransform2)) != null) {
            MatrixSIS matrixSIS = Matrices.multiply(matrix, matrix2);
            if (Matrices.isIdentity(matrixSIS, 1.0E-16)) {
                return MathTransforms.identity(matrixSIS.getNumRow() - 1);
            }
            if (mathTransformFactory != null) {
                return mathTransformFactory.createAffineTransform(matrixSIS);
            }
            return MathTransforms.linear(matrixSIS);
        }
        return null;
    }

    private static String getName(MathTransform mathTransform) {
        String string;
        ParameterValueGroup parameterValueGroup = null;
        if (mathTransform instanceof AbstractMathTransform) {
            parameterValueGroup = ((AbstractMathTransform)mathTransform).getContextualParameters();
        }
        if (parameterValueGroup == null && mathTransform instanceof Parameterized) {
            parameterValueGroup = ((Parameterized)((Object)mathTransform)).getParameterValues();
        }
        if (parameterValueGroup != null && (string = Strings.trimOrNull(parameterValueGroup.getDescriptor().getName().getCode())) != null) {
            return string;
        }
        return Classes.getShortClassName(mathTransform);
    }

    boolean isValid() {
        return this.transform1.getTargetDimensions() == this.transform2.getSourceDimensions();
    }

    @Override
    public final int getSourceDimensions() {
        return this.transform1.getSourceDimensions();
    }

    @Override
    public final int getTargetDimensions() {
        return this.transform2.getTargetDimensions();
    }

    private int getStepCount() {
        return ConcatenatedTransform.getStepCount(this.transform1) + ConcatenatedTransform.getStepCount(this.transform2);
    }

    private static int getStepCount(MathTransform mathTransform) {
        if (mathTransform.isIdentity()) {
            return 0;
        }
        if (!(mathTransform instanceof ConcatenatedTransform)) {
            return 1;
        }
        return ((ConcatenatedTransform)mathTransform).getStepCount();
    }

    public final List<MathTransform> getSteps() {
        ArrayList<MathTransform> arrayList = new ArrayList<MathTransform>(5);
        this.getSteps(arrayList);
        return arrayList;
    }

    private List<Object> getPseudoSteps() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        this.getSteps(arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            Object e = arrayList.get(i);
            if (!(e instanceof AbstractMathTransform)) continue;
            i = ((AbstractMathTransform)e).beforeFormat(arrayList, i, false);
        }
        Matrix matrix = null;
        int n = arrayList.size();
        while (--n >= 0) {
            Object e = arrayList.get(n);
            if (e instanceof Matrix) {
                if (matrix != null) {
                    MatrixSIS matrixSIS = Matrices.multiply(matrix, (Matrix)e);
                    if (matrixSIS.isIdentity()) {
                        arrayList.subList(n, n + 2).clear();
                        matrix = null;
                        continue;
                    }
                    arrayList.set(n, MathTransforms.linear(matrixSIS));
                    arrayList.remove(n + 1);
                    matrix = matrixSIS;
                    continue;
                }
                matrix = (Matrix)e;
                continue;
            }
            matrix = null;
        }
        GeocentricAffine.asDatumShift(arrayList);
        return arrayList;
    }

    private void getSteps(List<? super MathTransform> list) {
        if (this.transform1 instanceof ConcatenatedTransform) {
            ((ConcatenatedTransform)this.transform1).getSteps(list);
        } else {
            list.add(this.transform1);
        }
        if (this.transform2 instanceof ConcatenatedTransform) {
            ((ConcatenatedTransform)this.transform2).getSteps(list);
        } else {
            list.add(this.transform2);
        }
    }

    private Parameterized getParameterised() {
        Parameterized parameterized = null;
        List<Object> list = this.getPseudoSteps();
        if (list.size() == 1 || Semaphores.query(8)) {
            for (Object object : list) {
                if (object instanceof Matrix || object instanceof LinearTransform) continue;
                if (parameterized == null && object instanceof Parameterized) {
                    parameterized = (Parameterized)object;
                    continue;
                }
                return null;
            }
        }
        return parameterized;
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        Parameterized parameterized = this.getParameterised();
        return parameterized != null ? parameterized.getParameterDescriptors() : null;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        Parameterized parameterized = this.getParameterised();
        return parameterized != null ? parameterized.getParameterValues() : null;
    }

    @Override
    public DirectPosition transform(DirectPosition directPosition, DirectPosition directPosition2) throws TransformException {
        assert (this.isValid());
        return this.transform2.transform(this.transform1.transform(directPosition, null), directPosition2);
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws TransformException {
        int n3;
        double[] dArray3;
        int n4;
        assert (this.isValid());
        int n5 = this.transform2.getSourceDimensions();
        if (n5 > (n4 = this.transform2.getTargetDimensions())) {
            dArray3 = new double[n5];
            n3 = 0;
        } else {
            dArray3 = dArray2;
            n3 = n2;
        }
        if (bl) {
            Matrix matrix = MathTransforms.derivativeAndTransform(this.transform1, dArray, n, dArray3, n3);
            Matrix matrix2 = MathTransforms.derivativeAndTransform(this.transform2, dArray3, n3, dArray2, n2);
            return Matrices.multiply(matrix2, matrix);
        }
        this.transform1.transform(dArray, n, dArray3, n3, 1);
        this.transform2.transform(dArray3, n3, dArray2, n2, 1);
        return null;
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) throws TransformException {
        int n4;
        assert (this.isValid());
        int n5 = this.transform2.getSourceDimensions();
        if (n5 <= (n4 = this.transform2.getTargetDimensions())) {
            this.transform1.transform(dArray, n, dArray2, n2, n3);
            this.transform2.transform(dArray2, n2, dArray2, n2, n3);
            return;
        }
        if (n3 <= 0) {
            return;
        }
        boolean bl = false;
        int n6 = this.transform1.getSourceDimensions();
        int n7 = n3;
        int n8 = n7 * n5;
        if (n8 > 512) {
            n7 = Math.max(1, 512 / n5);
            if (dArray == dArray2) {
                switch (IterationStrategy.suggest(n, n7 * n6, n2, n7 * n4, n3)) {
                    default: {
                        n7 = n3;
                        break;
                    }
                    case ASCENDING: {
                        break;
                    }
                    case DESCENDING: {
                        int n9 = n3 - n7;
                        n += n9 * n6;
                        n6 = -n6;
                        n2 += n9 * n4;
                        n4 = -n4;
                        bl = true;
                        break;
                    }
                }
            }
            n8 = n7 * n5;
        }
        double[] dArray3 = new double[n8];
        do {
            if (!bl && n7 > n3) {
                n7 = n3;
            }
            this.transform1.transform(dArray, n, dArray3, 0, n7);
            this.transform2.transform(dArray3, 0, dArray2, n2, n7);
            if (bl && n7 > (n3 -= n7)) {
                n7 = n3;
            }
            n += n7 * n6;
            n2 += n7 * n4;
        } while (n3 != 0);
    }

    @Override
    public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) throws TransformException {
        assert (this.isValid());
        if (n3 <= 0) {
            return;
        }
        boolean bl = false;
        int n4 = this.transform1.getSourceDimensions();
        int n5 = this.transform1.getTargetDimensions();
        int n6 = n3;
        int n7 = this.transform2.getTargetDimensions();
        int n8 = Math.max(n7, n5);
        int n9 = n6 * n8;
        if (n9 > 512) {
            n6 = Math.max(1, 512 / n8);
            if (fArray == fArray2) {
                switch (IterationStrategy.suggest(n, n6 * n4, n2, n6 * n7, n3)) {
                    default: {
                        n6 = n3;
                        break;
                    }
                    case ASCENDING: {
                        break;
                    }
                    case DESCENDING: {
                        int n10 = n3 - n6;
                        n += n10 * n4;
                        n4 = -n4;
                        n2 += n10 * n7;
                        n7 = -n7;
                        bl = true;
                        break;
                    }
                }
            }
            n9 = n6 * n8;
        }
        double[] dArray = new double[n9];
        do {
            if (!bl && n6 > n3) {
                n6 = n3;
            }
            this.transform1.transform(fArray, n, dArray, 0, n6);
            this.transform2.transform(dArray, 0, fArray2, n2, n6);
            if (bl && n6 > (n3 -= n6)) {
                n6 = n3;
            }
            n += n6 * n4;
            n2 += n6 * n7;
        } while (n3 != 0);
    }

    @Override
    public void transform(double[] dArray, int n, float[] fArray, int n2, int n3) throws TransformException {
        assert (this.isValid());
        if (n3 <= 0) {
            return;
        }
        int n4 = this.transform1.getSourceDimensions();
        int n5 = this.transform1.getTargetDimensions();
        int n6 = n3;
        int n7 = this.transform2.getTargetDimensions();
        int n8 = Math.max(n7, n5);
        int n9 = n6 * n8;
        if (n9 > 512) {
            n6 = Math.max(1, 512 / n8);
            n9 = n6 * n8;
        }
        double[] dArray2 = new double[n9];
        do {
            if (n6 > n3) {
                n6 = n3;
            }
            this.transform1.transform(dArray, n, dArray2, 0, n6);
            this.transform2.transform(dArray2, 0, fArray, n2, n6);
            n += n6 * n4;
            n2 += n6 * n7;
        } while ((n3 -= n6) != 0);
    }

    @Override
    public void transform(float[] fArray, int n, double[] dArray, int n2, int n3) throws TransformException {
        int n4;
        assert (this.isValid());
        int n5 = this.transform2.getSourceDimensions();
        if (n5 <= (n4 = this.transform2.getTargetDimensions())) {
            this.transform1.transform(fArray, n, dArray, n2, n3);
            this.transform2.transform(dArray, n2, dArray, n2, n3);
            return;
        }
        if (n3 <= 0) {
            return;
        }
        int n6 = n3;
        int n7 = n6 * n5;
        if (n7 > 512) {
            n6 = Math.max(1, 512 / n5);
            n7 = n6 * n5;
        }
        double[] dArray2 = new double[n7];
        int n8 = this.getSourceDimensions();
        do {
            if (n6 > n3) {
                n6 = n3;
            }
            this.transform1.transform(fArray, n, dArray2, 0, n6);
            this.transform2.transform(dArray2, 0, dArray, n2, n6);
            n += n6 * n8;
            n2 += n6 * n4;
        } while ((n3 -= n6) != 0);
    }

    @Override
    public Matrix derivative(DirectPosition directPosition) throws TransformException {
        Matrix matrix = this.transform1.derivative(directPosition);
        Matrix matrix2 = this.transform2.derivative(this.transform1.transform(directPosition, null));
        return Matrices.multiply(matrix2, matrix);
    }

    @Override
    public synchronized MathTransform inverse() throws NoninvertibleTransformException {
        assert (this.isValid());
        if (this.inverse == null) {
            try {
                this.inverse = ConcatenatedTransform.create(this.transform2.inverse(), this.transform1.inverse(), null);
                ConcatenatedTransform.setInverse(this.inverse, this);
            }
            catch (FactoryException factoryException) {
                throw new NoninvertibleTransformException(Resources.format((short)53), factoryException);
            }
        }
        return this.inverse;
    }

    static void setInverse(MathTransform mathTransform, MathTransform mathTransform2) {
        if (mathTransform instanceof ConcatenatedTransform) {
            assert (((ConcatenatedTransform)mathTransform).inverse == null);
            ((ConcatenatedTransform)mathTransform).inverse = mathTransform2;
        }
    }

    @Override
    protected MathTransform tryConcatenate(boolean bl, MathTransform mathTransform, MathTransformFactory mathTransformFactory) throws FactoryException {
        if (bl) {
            MathTransform mathTransform2 = ConcatenatedTransform.tryOptimized(mathTransform, this.transform1, mathTransformFactory);
            if (mathTransform2 != null) {
                return ConcatenatedTransform.create(mathTransform2, this.transform2, mathTransformFactory);
            }
        } else {
            MathTransform mathTransform3 = ConcatenatedTransform.tryOptimized(this.transform2, mathTransform, mathTransformFactory);
            if (mathTransform3 != null) {
                return ConcatenatedTransform.create(this.transform1, mathTransform3, mathTransformFactory);
            }
        }
        return null;
    }

    @Override
    public boolean isIdentity() {
        return this.transform1.isIdentity() && this.transform2.isIdentity();
    }

    @Override
    protected int computeHashCode() {
        return super.computeHashCode() ^ this.getSteps().hashCode();
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (object instanceof ConcatenatedTransform) {
            ConcatenatedTransform concatenatedTransform = (ConcatenatedTransform)object;
            return Utilities.deepEquals(this.getSteps(), concatenatedTransform.getSteps(), comparisonMode);
        }
        return false;
    }

    @Override
    protected String formatTo(Formatter formatter) {
        List<Object> list = formatter.getConvention() == Convention.INTERNAL ? this.getSteps() : this.getPseudoSteps();
        if (list.size() == 1) {
            return formatter.delegateTo(list.get(0));
        }
        for (Object object : list) {
            formatter.newLine();
            if (object instanceof FormattableObject) {
                formatter.append((FormattableObject)object);
                continue;
            }
            if (object instanceof MathTransform) {
                formatter.append((MathTransform)object);
                continue;
            }
            formatter.append(MathTransforms.linear((Matrix)object));
        }
        return "Concat_MT";
    }
}

