/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory.sql;

import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.sis.internal.metadata.sql.SQLUtilities;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.factory.IdentifiedObjectFinder;
import org.apache.sis.referencing.factory.sql.EPSGDataAccess;
import org.apache.sis.referencing.factory.sql.TableInfo;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.logging.Logging;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.util.FactoryException;

final class EPSGCodeFinder
extends IdentifiedObjectFinder {
    private final EPSGDataAccess dao;
    private Class<? extends IdentifiedObject> declaredType;

    EPSGCodeFinder(EPSGDataAccess ePSGDataAccess) {
        super(ePSGDataAccess.owner);
        this.dao = ePSGDataAccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<IdentifiedObject> find(IdentifiedObject identifiedObject) throws FactoryException {
        boolean bl = this.dao.quiet;
        this.dao.quiet = true;
        try {
            Set<IdentifiedObject> set = super.find(identifiedObject);
            return set;
        }
        finally {
            this.dao.quiet = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends IdentifiedObject> Condition dependencies(String string, Class<T> clazz, T t, boolean bl) throws FactoryException {
        if (t != null) {
            Set<IdentifiedObject> set;
            Class<? extends IdentifiedObject> clazz2 = this.declaredType;
            boolean bl2 = this.isIgnoringAxes();
            try {
                this.setIgnoringAxes(bl | bl2);
                this.declaredType = clazz;
                set = this.find(t);
            }
            finally {
                this.declaredType = clazz2;
                this.setIgnoringAxes(bl2);
            }
            LinkedHashSet<Number> linkedHashSet = new LinkedHashSet<Number>(Containers.hashMapCapacity(set.size()));
            for (IdentifiedObject identifiedObject : set) {
                Identifier identifier = IdentifiedObjects.getIdentifier(identifiedObject, Citations.EPSG);
                if (identifier == null) continue;
                try {
                    linkedHashSet.add(Integer.parseInt(identifier.getCode()));
                }
                catch (NumberFormatException numberFormatException) {
                    Logging.recoverableException(Logging.getLogger("org.apache.sis.referencing.factory"), EPSGCodeFinder.class, "getCodeCandidates", numberFormatException);
                }
            }
            if (!linkedHashSet.isEmpty()) {
                return new Condition(string, linkedHashSet);
            }
        }
        return null;
    }

    private boolean isInstance(Class<? extends IdentifiedObject> clazz, IdentifiedObject identifiedObject) {
        return (this.declaredType == null || clazz.isAssignableFrom(this.declaredType)) && clazz.isInstance(identifiedObject);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    protected Set<String> getCodeCandidates(IdentifiedObject var1_1) throws FactoryException {
        block61: {
            block63: {
                block62: {
                    if (!this.isInstance(CoordinateReferenceSystem.class, var1_1)) break block62;
                    var2_2 = TableInfo.CRS;
                    if (!this.isInstance(CompoundCRS.class, var1_1) || (var4_3 = ((CompoundCRS)var1_1).getComponents()) == null) ** GOTO lbl-1000
                    switch (var4_3.size()) {
                        case 1: {
                            return this.getCodeCandidates(var4_3.get(0));
                        }
                        case 2: {
                            var3_4 = new Condition[2];
                            for (var5_5 = 0; var5_5 <= 1; ++var5_5) {
                                var3_4[var5_5] = this.dependencies(var5_5 == 0 ? "CMPD_HORIZCRS_CODE" : "CMPD_VERTCRS_CODE", CoordinateReferenceSystem.class, (CoordinateReferenceSystem)var4_3.get(var5_5), false);
                                if (var3_4[var5_5] != null) continue;
                                return Collections.emptySet();
                            }
                            break block63;
                        }
                        default: lbl-1000:
                        // 2 sources

                        {
                            if (var1_1 instanceof GeneralDerivedCRS) {
                                var4_3 = this.dependencies("SOURCE_GEOGCRS_CODE", CoordinateReferenceSystem.class, ((GeneralDerivedCRS)var1_1).getBaseCRS(), true);
                            } else if (var1_1 instanceof GeodeticCRS) {
                                var4_3 = this.dependencies("DATUM_CODE", GeodeticDatum.class, ((GeodeticCRS)var1_1).getDatum(), true);
                            } else if (var1_1 instanceof VerticalCRS) {
                                var4_3 = this.dependencies("DATUM_CODE", VerticalDatum.class, ((VerticalCRS)var1_1).getDatum(), true);
                            } else if (var1_1 instanceof TemporalCRS) {
                                var4_3 = this.dependencies("DATUM_CODE", TemporalDatum.class, ((TemporalCRS)var1_1).getDatum(), true);
                            } else if (var1_1 instanceof SingleCRS) {
                                var4_3 = this.dependencies("DATUM_CODE", Datum.class, ((SingleCRS)var1_1).getDatum(), true);
                            } else {
                                return Collections.emptySet();
                            }
                            if (var4_3 == null) {
                                return Collections.emptySet();
                            }
                            var3_4 = new Condition[]{var4_3};
                            break;
                        }
                    }
                    break block63;
                }
                if (this.isInstance(Datum.class, var1_1)) {
                    var2_2 = TableInfo.DATUM;
                    if (this.isInstance(GeodeticDatum.class, var1_1)) {
                        var3_4 = new Condition[]{this.dependencies("ELLIPSOID_CODE", Ellipsoid.class, ((GeodeticDatum)var1_1).getEllipsoid(), true), Condition.NAME};
                        if (var3_4[0] == null) {
                            return Collections.emptySet();
                        }
                    } else {
                        if (this.isInstance(VerticalDatum.class, var1_1) && (var4_3 = ((VerticalDatum)var1_1).getVerticalDatumType()) != null && !var4_3.equals(EPSGDataAccess.VERTICAL_DATUM_TYPE)) {
                            return Collections.emptySet();
                        }
                        var3_4 = new Condition[]{Condition.NAME};
                    }
                } else if (this.isInstance(Ellipsoid.class, var1_1)) {
                    var2_2 = TableInfo.ELLIPSOID;
                    var3_4 = new Condition[]{new FloatCondition("SEMI_MAJOR_AXIS", ((Ellipsoid)var1_1).getSemiMajorAxis())};
                } else {
                    return super.getCodeCandidates(var1_1);
                }
            }
            var4_3 = new StringBuilder(350);
            if (ArraysExt.containsIdentity(var3_4, Condition.NAME)) {
                var5_6 = new LinkedHashSet<String>();
                var5_6.add(EPSGCodeFinder.toDatumPattern(var1_1.getName().getCode(), (StringBuilder)var4_3));
                for (Object var8_9 : var1_1.getAlias()) {
                    var5_6.add(EPSGCodeFinder.toDatumPattern(var8_9.tip().toString(), (StringBuilder)var4_3));
                }
                var4_3.setLength(0);
                var4_3.append("SELECT OBJECT_CODE FROM [Alias] WHERE OBJECT_TABLE_NAME='").append(var2_2.unquoted()).append("' AND ");
                EPSGCodeFinder.appendFilterByName(var5_6, "ALIAS", (StringBuilder)var4_3);
                var6_11 = this.dao.translator.apply(var4_3.toString());
                var4_3.setLength(0);
            } else {
                var5_6 = null;
                var6_11 = null;
            }
            var4_3.append("SELECT ").append(var2_2.codeColumn).append(" FROM ").append(var2_2.table);
            var2_2.where(var1_1.getClass(), (StringBuilder)var4_3);
            var7_8 = false;
            for (Object var11_20 : var3_4) {
                var7_8 |= var11_20.appendToWhere((StringBuilder)var4_3, var7_8);
            }
            var8_9 = this.dao.connection.createStatement();
            try {
                if (var5_6 != null) {
                    if (var7_8) {
                        var4_3.append(" AND ");
                    }
                    var7_8 = false;
                    EPSGCodeFinder.appendFilterByName(var5_6, var2_2.nameColumn, (StringBuilder)var4_3);
                    var9_13 = var8_9.executeQuery(var6_11);
                    try {
                        while (var9_13.next()) {
                            var10_16 = var9_13.getInt(1);
                            if (var9_13.wasNull()) continue;
                            if (!var7_8) {
                                var7_8 = true;
                                var4_3.append(" OR ").append(var2_2.codeColumn).append(" IN (");
                            } else {
                                var4_3.append(',');
                            }
                            var4_3.append(var10_16);
                        }
                    }
                    finally {
                        if (var9_13 != null) {
                            var9_13.close();
                        }
                    }
                    if (var7_8) {
                        var4_3.append(')');
                    }
                }
                var4_3.append(this.getSearchDomain() == IdentifiedObjectFinder.Domain.ALL_DATASET ? " ORDER BY ABS(DEPRECATED), " : " AND DEPRECATED=0 ORDER BY ");
                for (Object var12_25 : var3_4) {
                    var12_25.appendToOrderBy((StringBuilder)var4_3);
                }
                var4_3.append(var2_2.codeColumn);
                var9_14 = new LinkedHashSet<E>();
                var10_18 = var8_9.executeQuery(this.dao.translator.apply(var4_3.toString()));
                try {
                    while (var10_18.next()) {
                        var9_14.add(var10_18.getString(1));
                    }
                }
                finally {
                    if (var10_18 != null) {
                        var10_18.close();
                    }
                }
                var9_14.remove(null);
                if (var9_14.size() > 1) {
                    var10_18 = var9_14.toArray();
                    if (this.dao.sort(var2_2.unquoted(), var10_18)) {
                        var9_14.clear();
                        for (Object var14_29 : var10_18) {
                            var9_14.add((String)var14_29);
                        }
                    }
                }
                var10_18 = var9_14;
                if (var8_9 == null) break block61;
            }
            catch (Throwable var9_15) {
                try {
                    if (var8_9 != null) {
                        try {
                            var8_9.close();
                        }
                        catch (Throwable var10_19) {
                            var9_15.addSuppressed(var10_19);
                        }
                    }
                    throw var9_15;
                }
                catch (SQLException var8_10) {
                    throw this.dao.databaseFailure(Identifier.class, (Comparable<?>)String.valueOf(CollectionsExt.first(var3_4[0].values)), var8_10);
                }
            }
            var8_9.close();
        }
        return var10_18;
    }

    private static String toDatumPattern(String string, StringBuilder stringBuilder) {
        int n;
        int n2 = 0;
        if (string.startsWith("D_")) {
            n2 = "D_".length();
        }
        if ((n = string.indexOf(40)) < 0) {
            n = string.length();
        }
        n = CharSequences.skipTrailingWhitespaces(string, n2, n);
        stringBuilder.setLength(0);
        SQLUtilities.toLikePattern(string, n2, n, true, true, stringBuilder);
        return stringBuilder.toString();
    }

    private static void appendFilterByName(Set<String> set, String string, StringBuilder stringBuilder) {
        String string2 = "(";
        for (String string3 : set) {
            stringBuilder.append(string2).append("LOWER(").append(string).append(") LIKE '").append(string3).append('\'');
            string2 = " OR ";
        }
        stringBuilder.append(')');
    }

    private static class Condition {
        static final Condition NAME = new Condition("NAME", Collections.emptySet());
        final String column;
        final Set<Number> values;

        Condition(String string, Set<Number> set) {
            this.column = string;
            this.values = set;
        }

        boolean appendToWhere(StringBuilder stringBuilder, boolean bl) {
            if (this.values.isEmpty()) {
                return false;
            }
            if (bl) {
                stringBuilder.append(" AND ");
            }
            stringBuilder.append(this.column);
            if (this.values.size() == 1) {
                stringBuilder.append('=').append(CollectionsExt.first(this.values));
            } else {
                stringBuilder.append(" IN (");
                for (Number number : this.values) {
                    stringBuilder.append(number).append(',');
                }
                stringBuilder.setCharAt(stringBuilder.length() - 1, ')');
            }
            return true;
        }

        void appendToOrderBy(StringBuilder stringBuilder) {
        }

        public final String toString() {
            StringBuilder stringBuilder = new StringBuilder(50);
            this.appendToWhere(stringBuilder, false);
            return stringBuilder.toString();
        }
    }

    private static final class FloatCondition
    extends Condition {
        FloatCondition(String string, double d) {
            super(string, Collections.singleton(d));
        }

        @Override
        boolean appendToWhere(StringBuilder stringBuilder, boolean bl) {
            if (bl) {
                stringBuilder.append(" AND ");
            }
            double d = ((Number)this.values.iterator().next()).doubleValue();
            double d2 = Math.abs(1.5696105811844188E-9 * d);
            stringBuilder.append(this.column).append(">=").append(d - d2).append(" AND ").append(this.column).append("<=").append(d + d2);
            return true;
        }

        @Override
        void appendToOrderBy(StringBuilder stringBuilder) {
            double d = ((Number)this.values.iterator().next()).doubleValue();
            stringBuilder.append("ABS(").append(this.column).append('-').append(d).append("), ");
        }
    }
}

