/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.system;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Messages;

public enum DataDirectory {
    DATABASES,
    DATUM_CHANGES,
    DOMAINS_OF_VALIDITY,
    SCHEMAS,
    TESTS;

    public static final String ENV = "SIS_DATA";
    private static short lastWarning;
    private static Path rootDirectory;
    private Path directory;

    public static void quiet() {
        lastWarning = (short)16;
    }

    private static void warning(Exception exception, short s2, Object ... objectArray) {
        if (s2 != lastWarning) {
            lastWarning = s2;
            DataDirectory.log(Level.WARNING, exception, s2, objectArray);
        }
    }

    private static void log(Level level, Exception exception, short s2, Object ... objectArray) {
        LogRecord logRecord = Messages.getResources(null).getLogRecord(level, s2, objectArray);
        logRecord.setLoggerName("org.apache.sis.system");
        if (exception != null) {
            logRecord.setThrown(exception);
        }
        Logging.log(null, null, logRecord);
    }

    public static String getenv() throws SecurityException {
        return AccessController.doPrivileged(() -> System.getenv(ENV));
    }

    public static synchronized boolean isUndefined() {
        if (rootDirectory == null) {
            try {
                return DataDirectory.getenv() == null;
            }
            catch (SecurityException securityException) {
                Logging.recoverableException(Logging.getLogger("org.apache.sis.system"), DataDirectory.class, "isUndefined", securityException);
            }
        }
        return false;
    }

    public static synchronized Path getRootDirectory() {
        block8: {
            if (rootDirectory == null) {
                try {
                    String string = DataDirectory.getenv();
                    if (string == null || string.isEmpty()) {
                        DataDirectory.warning(null, (short)16, ENV);
                        break block8;
                    }
                    try {
                        Path path = Paths.get(string, new String[0]);
                        if (!Files.isDirectory(path, new LinkOption[0])) {
                            DataDirectory.warning(null, (short)12, ENV, path);
                            break block8;
                        }
                        if (!Files.isReadable(path)) {
                            DataDirectory.warning(null, (short)15, ENV, path);
                            break block8;
                        }
                        DataDirectory.log(Level.CONFIG, null, (short)18, ENV, path);
                        rootDirectory = path;
                    }
                    catch (InvalidPathException invalidPathException) {
                        DataDirectory.warning(invalidPathException, (short)12, ENV, string);
                    }
                }
                catch (SecurityException securityException) {
                    DataDirectory.warning(securityException, (short)14, ENV);
                }
            }
        }
        return rootDirectory;
    }

    public synchronized Path getDirectory() {
        Path path;
        if (this.directory == null && (path = DataDirectory.getRootDirectory()) != null) {
            StringBuilder stringBuilder = new StringBuilder(this.name());
            for (int i = 1; i < stringBuilder.length(); ++i) {
                char c = stringBuilder.charAt(i);
                if (c == '_') {
                    stringBuilder.deleteCharAt(i);
                    continue;
                }
                stringBuilder.setCharAt(i, Character.toLowerCase(c));
            }
            String string = stringBuilder.toString();
            Path path2 = path.resolve(string).normalize();
            try {
                if (Files.isDirectory(path2, new LinkOption[0])) {
                    this.directory = path2;
                } else if (Files.isWritable(path)) {
                    try {
                        this.directory = Files.createDirectory(path2, new FileAttribute[0]);
                    }
                    catch (IOException iOException) {
                        DataDirectory.warning(iOException, (short)17, ENV, path);
                    }
                } else {
                    DataDirectory.warning(null, (short)17, ENV, path);
                }
            }
            catch (SecurityException securityException) {
                DataDirectory.warning(securityException, (short)13, ENV, string);
            }
        }
        return this.directory;
    }

    public Path resolve(Path path) {
        Path path2;
        if (path != null && !path.isAbsolute() && (path2 = this.getDirectory()) != null) {
            return path2.resolve(path);
        }
        return path;
    }
}

