/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf.ucar;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.sis.internal.netcdf.Dimension;

final class DimensionWrapper
extends Dimension {
    private final ucar.nc2.Dimension netcdf;

    static List<Dimension> wrap(Collection<ucar.nc2.Dimension> collection) {
        return collection.stream().map(DimensionWrapper::new).collect(Collectors.toList());
    }

    static ucar.nc2.Dimension[] unwrap(Dimension[] dimensionArray) {
        ucar.nc2.Dimension[] dimensionArray2 = new ucar.nc2.Dimension[dimensionArray.length];
        for (int i = 0; i < dimensionArray2.length; ++i) {
            dimensionArray2[i] = ((DimensionWrapper)dimensionArray[i]).netcdf;
        }
        return dimensionArray2;
    }

    DimensionWrapper(ucar.nc2.Dimension dimension) {
        this.netcdf = dimension;
    }

    @Override
    public String getName() {
        return this.netcdf.getShortName();
    }

    @Override
    public long length() {
        return this.netcdf.getLength();
    }

    @Override
    protected boolean isUnlimited() {
        return this.netcdf.isUnlimited();
    }

    public boolean equals(Object object) {
        return object instanceof DimensionWrapper && this.netcdf.equals(((DimensionWrapper)object).netcdf);
    }

    public int hashCode() {
        return ~this.netcdf.hashCode();
    }
}

