/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.filter;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.logging.Logger;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Filter;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.feature.GeometryWrapper;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.filter.GeometryConverter;
import org.apache.sis.util.collection.DefaultTreeTable;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.iso.Names;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.util.LocalName;
import org.opengis.util.ScopedName;

public abstract class Node
implements Serializable {
    private static final long serialVersionUID = -749201100175374658L;
    private static final LocalName SCOPE = Names.createLocalName("Apache", null, "sis");

    protected Node() {
    }

    protected static <T> DefaultAttributeType<T> createType(Class<T> clazz, Object object) {
        return new DefaultAttributeType<Object>(Collections.singletonMap("name", object), clazz, 1, 1, null, null);
    }

    protected char symbol() {
        return '\u0000';
    }

    private Object getDisplayName() {
        if (this instanceof Expression) {
            return ((Expression)((Object)this)).getFunctionName();
        }
        if (this instanceof Filter) {
            return ((Filter)((Object)this)).getOperatorType();
        }
        return this.getClass().getSimpleName();
    }

    protected static ScopedName createName(String string) {
        return Names.createScopedName(SCOPE, null, string);
    }

    protected static <R, G> Expression<R, GeometryWrapper<G>> toGeometryWrapper(Geometries<G> geometries, Expression<R, ?> expression) {
        if (expression instanceof GeometryConverter) {
            if (geometries.equals(((GeometryConverter)expression).library)) {
                return (GeometryConverter)expression;
            }
            throw new IllegalArgumentException();
        }
        return new GeometryConverter<R, G>(geometries, expression);
    }

    protected static <R, G> Expression<? super R, ?> unwrap(Expression<R, GeometryWrapper<G>> expression) {
        if (expression instanceof GeometryConverter) {
            return ((GeometryConverter)expression).expression;
        }
        return expression;
    }

    protected static <G> Geometries<G> getGeometryLibrary(Expression<?, GeometryWrapper<G>> expression) {
        if (expression instanceof GeometryConverter) {
            return ((GeometryConverter)expression).library;
        }
        throw new IllegalArgumentException(Resources.format((short)52));
    }

    protected abstract Collection<?> getChildren();

    private void toTree(TreeTable.Node node, Map<Object, Boolean> map) {
        node.setValue(TableColumn.VALUE, this.getDisplayName());
        for (Object obj : this.getChildren()) {
            String string;
            TreeTable.Node node2 = node.newChild();
            if (obj instanceof Node) {
                if (map.putIfAbsent(obj, Boolean.TRUE) == null) {
                    ((Node)obj).toTree(node2, map);
                    continue;
                }
                string = Vocabulary.format((short)46);
            } else {
                string = String.valueOf(obj);
            }
            node2.setValue(TableColumn.VALUE, string);
        }
    }

    public final String toString() {
        DefaultTreeTable defaultTreeTable = new DefaultTreeTable(TableColumn.VALUE);
        this.toTree(defaultTreeTable.getRoot(), new IdentityHashMap<Object, Boolean>());
        return defaultTreeTable.toString();
    }

    public int hashCode() {
        return this.getClass().hashCode() + 37 * this.getChildren().hashCode();
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            return this.getChildren().equals(((Node)object).getChildren());
        }
        return false;
    }

    protected final void warning(Exception exception, boolean bl) {
        String string;
        Logger logger = Logging.getLogger("org.apache.sis.filter");
        String string2 = string = this instanceof Predicate ? "test" : "apply";
        if (bl) {
            Logging.recoverableException(logger, this.getClass(), string, exception);
        } else {
            Logging.unexpectedException(logger, this.getClass(), string, exception);
        }
    }
}

