/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Shape;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.stream.Collector;
import org.apache.sis.image.AnnotatedImage;
import org.apache.sis.image.PixelIterator;
import org.apache.sis.math.Statistics;
import org.apache.sis.util.resources.Vocabulary;

final class StatisticsCalculator
extends AnnotatedImage {
    StatisticsCalculator(RenderedImage renderedImage, Shape shape, boolean bl, boolean bl2) {
        super(renderedImage, shape, bl, bl2);
    }

    @Override
    protected String getComputedPropertyName() {
        return "org.apache.sis.Statistics";
    }

    private static Statistics[] createAccumulator(int n) {
        Statistics[] statisticsArray = new Statistics[n];
        for (int i = 0; i < n; ++i) {
            statisticsArray[i] = new Statistics(Vocabulary.formatInternational((short)15, (Object)i));
        }
        return statisticsArray;
    }

    private void compute(Statistics[] statisticsArray, PixelIterator pixelIterator) {
        double[] dArray = null;
        while (pixelIterator.next()) {
            if (this.areaOfInterest != null && !this.areaOfInterest.contains(pixelIterator.x, pixelIterator.y)) continue;
            dArray = pixelIterator.getPixel(dArray);
            for (int i = 0; i < statisticsArray.length; ++i) {
                statisticsArray[i].accept(dArray[i]);
            }
        }
    }

    @Override
    protected Object computeSequentially() {
        PixelIterator pixelIterator = new PixelIterator.Builder().setRegionOfInterest(this.boundsOfInterest).create(this.source);
        Statistics[] statisticsArray = StatisticsCalculator.createAccumulator(pixelIterator.getNumBands());
        this.compute(statisticsArray, pixelIterator);
        return statisticsArray;
    }

    @Override
    protected Object cloneProperty(String string, Object object) {
        Statistics[] statisticsArray = (Statistics[])((Statistics[])object).clone();
        for (int i = 0; i < statisticsArray.length; ++i) {
            statisticsArray[i] = statisticsArray[i].clone();
        }
        return statisticsArray;
    }

    protected Collector<Raster, Statistics[], Statistics[]> collector() {
        return Collector.of(this::createAccumulator, this::compute, StatisticsCalculator::combine, new Collector.Characteristics[0]);
    }

    private Statistics[] createAccumulator() {
        return StatisticsCalculator.createAccumulator(this.source.getSampleModel().getNumBands());
    }

    private static Statistics[] combine(Statistics[] statisticsArray, Statistics[] statisticsArray2) {
        for (int i = 0; i < statisticsArray2.length; ++i) {
            statisticsArray[i].combine(statisticsArray2[i]);
        }
        return statisticsArray;
    }

    private void compute(Statistics[] statisticsArray, Raster raster) {
        this.compute(statisticsArray, new PixelIterator.Builder().setRegionOfInterest(this.boundsOfInterest).create(raster));
    }
}

