/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog.parser.jdom;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import thredds.catalog.InvDocumentation;
import thredds.catalog.query.DqcConvertIF;
import thredds.catalog.query.DqcFactory;
import thredds.catalog.query.ListChoice;
import thredds.catalog.query.Location;
import thredds.catalog.query.Query;
import thredds.catalog.query.QueryCapability;
import thredds.catalog.query.SelectGeoRegion;
import thredds.catalog.query.SelectList;
import thredds.catalog.query.SelectRange;
import thredds.catalog.query.SelectRangeDate;
import thredds.catalog.query.SelectService;
import thredds.catalog.query.SelectStation;
import thredds.catalog.query.Selector;
import thredds.catalog.query.Station;

public class DqcConvert4
implements DqcConvertIF {
    public static boolean debugURL = false;
    public static boolean debugXML = false;
    public static boolean debugDBurl = false;
    public static boolean debugXMLopen = false;
    public static boolean showParsedXML = false;
    public static boolean showXMLoutput = false;
    protected static final Namespace defNS = Namespace.getNamespace("http://www.unidata.ucar.edu/namespaces/thredds/queryCapability/v0.4");
    protected static final Namespace xlinkNS = Namespace.getNamespace("xlink", "http://www.w3.org/1999/xlink");
    private DqcFactory factory;
    private URI docURI;

    @Override
    public QueryCapability parseXML(DqcFactory fac, Document jdomDoc, URI uri) throws IOException {
        this.factory = fac;
        this.docURI = uri;
        if (showParsedXML) {
            XMLOutputter xmlOut = new XMLOutputter();
            System.out.println("*** DqcConvert3/showParsedXML = \n" + xmlOut.outputString(jdomDoc) + "\n*******");
        }
        QueryCapability qc = this.readQC(jdomDoc.getRootElement());
        if (showXMLoutput) {
            System.out.println("*** DqcConvert3/showXMLoutput");
            this.writeXML(qc, System.out);
        }
        return qc;
    }

    private ListChoice readChoice(QueryCapability qc, Selector parent, Element elem) {
        String name = elem.getAttributeValue("name");
        String value = elem.getAttributeValue("value");
        ListChoice c = new ListChoice(parent, name, value, null);
        List<Element> children = elem.getChildren();
        for (int j = 0; j < children.size(); ++j) {
            Element child = children.get(j);
            String childName = child.getName();
            if (!childName.equals("selectList")) continue;
            c.addNestedSelector(this.readSelectList(qc, child));
        }
        Element descElem = elem.getChild("description", defNS);
        if (descElem != null) {
            c.setDescription(this.readDocumentation(descElem));
        }
        return c;
    }

    private Element writeChoice(ListChoice c) {
        Element elem = new Element("choice", defNS);
        elem.setAttribute("name", c.getName());
        elem.setAttribute("value", c.getValue());
        if (c.getDescription() != null) {
            elem.addContent(this.writeDocumentation(c.getDescription(), "description"));
        }
        ArrayList selectors = c.getNestedSelectors();
        for (int i = 0; i < selectors.size(); ++i) {
            Selector s2 = (Selector)selectors.get(i);
            if (!(s2 instanceof SelectList)) continue;
            elem.addContent(this.writeSelectList((SelectList)s2));
        }
        return elem;
    }

    protected InvDocumentation readDocumentation(Element s2) {
        String href = s2.getAttributeValue("href", xlinkNS);
        String title = s2.getAttributeValue("title", xlinkNS);
        String type = s2.getAttributeValue("type");
        String content = s2.getTextNormalize();
        URI uriResolved = null;
        if (href != null) {
            try {
                uriResolved = this.docURI.resolve(href);
            }
            catch (Exception e) {
                this.factory.appendErr(" ** Invalid documentation href = " + href + " " + e.getMessage() + "\n");
            }
        }
        return new InvDocumentation(href, uriResolved, title, type, content);
    }

    private Element writeDocumentation(InvDocumentation doc, String name) {
        String inline;
        Element docElem = new Element(name, defNS);
        if (doc.getType() != null) {
            docElem.setAttribute("type", doc.getType());
        }
        if (doc.hasXlink()) {
            docElem.setAttribute("href", doc.getURI().toString(), xlinkNS);
            if (!doc.getXlinkTitle().equals(doc.getURI().toString())) {
                docElem.setAttribute("title", doc.getXlinkTitle(), xlinkNS);
            }
        }
        if ((inline = doc.getInlineContent()) != null) {
            docElem.addContent(inline);
        }
        return docElem;
    }

    private Location readLocation(Element locationElem) {
        if (locationElem == null) {
            return null;
        }
        String latitude = locationElem.getAttributeValue("latitude");
        String longitude = locationElem.getAttributeValue("longitude");
        String elevation = locationElem.getAttributeValue("elevation");
        String latitude_units = locationElem.getAttributeValue("latitude_units");
        String longitude_units = locationElem.getAttributeValue("longitude_units");
        String elevation_units = locationElem.getAttributeValue("elevation_units");
        Location location = new Location(latitude, longitude, elevation, latitude_units, longitude_units, elevation_units);
        return location;
    }

    private Element writeLocation(Location l, String elemName) {
        Element locationElem = new Element(l.hasElevation() ? "location3D" : elemName, defNS);
        locationElem.setAttribute("latitude", Double.toString(l.getLatitude()));
        locationElem.setAttribute("longitude", Double.toString(l.getLongitude()));
        if (!l.isDefaultLatitudeUnits()) {
            locationElem.setAttribute("latitude_units", l.getLatitudeUnits());
        }
        if (!l.isDefaultLongitudeUnits()) {
            locationElem.setAttribute("longitude_units", l.getLongitudeUnits());
        }
        if (l.hasElevation()) {
            locationElem.setAttribute("elevation", Double.toString(l.getElevation()));
            if (!l.isDefaultElevationUnits()) {
                locationElem.setAttribute("elevation_units", l.getElevationUnits());
            }
        }
        return locationElem;
    }

    private QueryCapability readQC(Element qcElem) {
        int j;
        String name = qcElem.getAttributeValue("name");
        String version = qcElem.getAttributeValue("version");
        QueryCapability qc = new QueryCapability(this.docURI.toString(), name, version);
        qc.setQuery(this.readQuery(qcElem.getChild("query", defNS)));
        SelectService s2 = this.readSelectService(qcElem.getChild("selectService", defNS));
        if (null != s2) {
            qc.addUniqueSelector(s2);
            qc.setServiceSelector(s2);
        }
        List<Element> list = qcElem.getChildren("userInterface", defNS);
        for (j = 0; j < list.size(); ++j) {
            Element child = list.get(j);
            qc.addUserInterface(child);
        }
        this.readSelectors(qc, qcElem);
        list = qcElem.getChildren("compound", defNS);
        for (j = 0; j < list.size(); ++j) {
            Element compoundElem = list.get(j);
            List compound = this.readSelectors(qc, compoundElem);
            for (Selector sel : compound) {
                sel.setCompoundSelectors(compound);
            }
        }
        return qc;
    }

    private List readSelectors(QueryCapability qc, Element elem) {
        Selector s2;
        int j;
        ArrayList<SelectList> compound = new ArrayList<SelectList>();
        List<Element> list = elem.getChildren("selectList", defNS);
        for (j = 0; j < list.size(); ++j) {
            s2 = this.readSelectList(qc, list.get(j));
            if (null == s2) continue;
            qc.addUniqueSelector(s2);
            compound.add((SelectList)s2);
        }
        list = elem.getChildren("selectStation", defNS);
        for (j = 0; j < list.size(); ++j) {
            s2 = this.readSelectStation(list.get(j));
            if (null == s2) continue;
            qc.addUniqueSelector(s2);
            compound.add((SelectList)s2);
        }
        list = elem.getChildren("selectFromRange", defNS);
        for (j = 0; j < list.size(); ++j) {
            s2 = this.readSelectRange(list.get(j));
            if (null == s2) continue;
            qc.addUniqueSelector(s2);
            compound.add((SelectList)s2);
        }
        list = elem.getChildren("selectFromDateRange", defNS);
        for (j = 0; j < list.size(); ++j) {
            s2 = this.readSelectRangeDate(list.get(j));
            if (null == s2) continue;
            qc.addUniqueSelector(s2);
            compound.add((SelectList)s2);
        }
        list = elem.getChildren("selectFromGeoRegion", defNS);
        for (j = 0; j < list.size(); ++j) {
            s2 = this.readSelectGeoRegion(list.get(j));
            if (null == s2) continue;
            qc.addUniqueSelector(s2);
            compound.add((SelectList)s2);
        }
        return compound;
    }

    public Document writeQC(QueryCapability qc) {
        Element rootElem = new Element("queryCapability", defNS);
        Document doc = new Document(rootElem);
        if (null != qc.getName()) {
            rootElem.setAttribute("name", qc.getName());
        }
        rootElem.setAttribute("version", qc.getVersion());
        rootElem.addContent(this.writeQuery(qc.getQuery()));
        Selector s2 = qc.getServiceSelector();
        Element elem = this.writeSelectService((SelectService)s2);
        if (elem != null) {
            rootElem.addContent(elem);
        }
        ArrayList selectors = qc.getSelectors();
        for (int i = 0; i < selectors.size(); ++i) {
            s2 = (Selector)selectors.get(i);
            if (s2 instanceof SelectList) {
                rootElem.addContent(this.writeSelectList((SelectList)s2));
                continue;
            }
            if (s2 instanceof SelectRange) {
                rootElem.addContent(this.writeSelectRange((SelectRange)s2));
                continue;
            }
            if (s2 instanceof SelectRangeDate) {
                rootElem.addContent(this.writeSelectRangeDate((SelectRangeDate)s2));
                continue;
            }
            if (s2 instanceof SelectGeoRegion) {
                rootElem.addContent(this.writeSelectGeoRegion((SelectGeoRegion)s2));
                continue;
            }
            if (s2 instanceof SelectService || !(s2 instanceof SelectStation)) continue;
            rootElem.addContent(this.writeSelectStation((SelectStation)s2));
        }
        return doc;
    }

    private Query readQuery(Element s2) {
        String base = s2.getAttributeValue("base");
        URI uriResolved = null;
        if (base != null) {
            try {
                uriResolved = this.docURI.resolve(base);
            }
            catch (Exception e) {
                this.factory.appendFatalErr(" ** Invalid query base = " + base + " " + e.getMessage() + "\n");
            }
        }
        return new Query(base, uriResolved, null);
    }

    private Element writeQuery(Query q) {
        Element elem = new Element("query", defNS);
        elem.setAttribute("base", q.getBase());
        return elem;
    }

    private void readSelector(Element elem, Selector s2) {
        s2.setTitle(elem.getAttributeValue("title"));
        s2.setId(elem.getAttributeValue("id"));
        s2.setTemplate(elem.getAttributeValue("template"));
        s2.setRequired(elem.getAttributeValue("required"));
        s2.setMultiple(elem.getAttributeValue("multiple"));
        Element descElem = elem.getChild("description", defNS);
        if (descElem != null) {
            s2.setDescription(this.readDocumentation(descElem));
        }
    }

    private void writeSelector(Element elem, Selector s2) {
        if (s2.getId() != null) {
            elem.setAttribute("id", s2.getId());
        }
        if (s2.getTitle() != null) {
            elem.setAttribute("title", s2.getTitle());
        }
        if (s2.getTemplate() != null) {
            elem.setAttribute("template", s2.getTemplate());
        }
        if (!s2.isRequired()) {
            elem.setAttribute("required", "false");
        }
        if (s2.isMultiple()) {
            elem.setAttribute("multiple", "true");
        }
        if (s2.getDescription() != null) {
            elem.addContent(this.writeDocumentation(s2.getDescription(), "description"));
        }
    }

    private SelectList readSelectList(QueryCapability qc, Element elem) {
        SelectList slist = new SelectList();
        this.readSelector(elem, slist);
        List<Element> choices = elem.getChildren("choice", defNS);
        for (int j = 0; j < choices.size(); ++j) {
            ListChoice choice = this.readChoice(qc, slist, choices.get(j));
            slist.addChoice(choice);
        }
        return slist;
    }

    private Element writeSelectList(SelectList s2) {
        Element elem = new Element("selectList", defNS);
        this.writeSelector(elem, s2);
        ArrayList choices = s2.getChoices();
        for (int i = 0; i < choices.size(); ++i) {
            elem.addContent(this.writeChoice((ListChoice)choices.get(i)));
        }
        return elem;
    }

    private SelectRange readSelectRange(Element elem) {
        String min2 = elem.getAttributeValue("min");
        String max = elem.getAttributeValue("max");
        String units = elem.getAttributeValue("units");
        String modulo = elem.getAttributeValue("modulo");
        String resolution = elem.getAttributeValue("resolution");
        String selectType = elem.getAttributeValue("selectType");
        SelectRange sr = new SelectRange(min2, max, units, modulo, resolution, selectType);
        this.readSelector(elem, sr);
        return sr;
    }

    private Element writeSelectRange(SelectRange s2) {
        Element elem = new Element("selectFromRange", defNS);
        this.writeSelector(elem, s2);
        if (s2.getMin() != null) {
            elem.setAttribute("min", s2.getMin());
        }
        if (s2.getMax() != null) {
            elem.setAttribute("max", s2.getMax());
        }
        if (s2.getUnits() != null) {
            elem.setAttribute("units", s2.getUnits());
        }
        if (s2.isModulo()) {
            elem.setAttribute("modulo", "true");
        }
        if (s2.getResolution() != null) {
            elem.setAttribute("resolution", s2.getResolution());
        }
        if (s2.getSelectType() != null) {
            elem.setAttribute("selectType", s2.getSelectType());
        }
        return elem;
    }

    private SelectRangeDate readSelectRangeDate(Element elem) {
        String start = elem.getAttributeValue("start");
        String end = elem.getAttributeValue("end");
        String duration = elem.getAttributeValue("duration");
        String resolution = elem.getAttributeValue("resolution");
        String selectType = elem.getAttributeValue("selectType");
        SelectRangeDate srd = new SelectRangeDate(start, end, duration, resolution, selectType);
        this.readSelector(elem, srd);
        return srd;
    }

    private Element writeSelectRangeDate(SelectRangeDate s2) {
        Element elem = new Element("selectFromDateRange", defNS);
        this.writeSelector(elem, s2);
        if (s2.getStart() != null) {
            elem.setAttribute("start", s2.getStart());
        }
        if (s2.getEnd() != null) {
            elem.setAttribute("end", s2.getEnd());
        }
        if (s2.getDuration() != null) {
            elem.setAttribute("duration", s2.getDuration());
        }
        if (s2.getResolution() != null) {
            elem.setAttribute("resolution", s2.getResolution());
        }
        if (s2.getSelectType() != null) {
            elem.setAttribute("selectType", s2.getSelectType());
        }
        return elem;
    }

    private SelectGeoRegion readSelectGeoRegion(Element elem) {
        Element geoBB = elem.getChild("geoBoundingBox", defNS);
        if (geoBB == null) {
            this.factory.appendErr("No geoBoundingBox in selectFromGeoRegion");
            return null;
        }
        Location lowerLeft = this.readLocation(geoBB.getChild("lowerLeft", defNS));
        Location upperRight = this.readLocation(geoBB.getChild("upperRight", defNS));
        SelectGeoRegion sr = new SelectGeoRegion(lowerLeft, upperRight);
        this.readSelector(elem, sr);
        return sr;
    }

    private Element writeSelectGeoRegion(SelectGeoRegion s2) {
        Element elem = new Element("selectFromGeoRegion", defNS);
        this.writeSelector(elem, s2);
        Element geoBB = new Element("geoBoundingBox", defNS);
        elem.addContent(geoBB);
        if (s2.getLowerLeft() != null) {
            geoBB.addContent(this.writeLocation(s2.getLowerLeft(), "lowerLeft"));
        }
        if (s2.getUpperRight() != null) {
            geoBB.addContent(this.writeLocation(s2.getUpperRight(), "upperRight"));
        }
        return elem;
    }

    private SelectService readSelectService(Element elem) {
        if (elem == null) {
            return null;
        }
        SelectService ss = new SelectService(null, null);
        this.readSelector(elem, ss);
        List<Element> choices = elem.getChildren("serviceType", defNS);
        for (int j = 0; j < choices.size(); ++j) {
            Element choice = choices.get(j);
            String name = choice.getText();
            String title = choice.getAttributeValue("title");
            String dataFormatType = choice.getAttributeValue("dataFormatType");
            String returns = choice.getAttributeValue("returns");
            String value = choice.getAttributeValue("value");
            ss.addServiceChoice(name, title, dataFormatType, returns, value);
        }
        return ss;
    }

    private Element writeSelectService(SelectService ss) {
        if (ss == null) {
            return null;
        }
        Element elem = new Element("selectService", defNS);
        this.writeSelector(elem, ss);
        ArrayList choices = ss.getChoices();
        for (int i = 0; i < choices.size(); ++i) {
            SelectService.ServiceChoice s2 = (SelectService.ServiceChoice)choices.get(i);
            Element selem = new Element("serviceType", defNS);
            if (s2.getTitle() != null) {
                selem.setAttribute("title", s2.getTitle());
            }
            if (s2.getDataFormat() != null) {
                selem.setAttribute("dataFormatType", s2.getDataFormat());
            }
            if (s2.getReturns() != null) {
                selem.setAttribute("returns", s2.getReturns());
            }
            if (s2.getValue2() != null) {
                selem.setAttribute("value", s2.getValue2());
            }
            selem.addContent(s2.getService());
            elem.addContent(selem);
        }
        return elem;
    }

    private SelectStation readSelectStation(Element elem) {
        SelectStation ss = new SelectStation();
        this.readSelector(elem, ss);
        List<Element> stations = elem.getChildren("station", defNS);
        for (int j = 0; j < stations.size(); ++j) {
            Station station = this.readStation(ss, stations.get(j));
            ss.addStation(station);
        }
        return ss;
    }

    private Element writeSelectStation(SelectStation s2) {
        Element elem = new Element("selectStation", defNS);
        this.writeSelector(elem, s2);
        ArrayList stations = s2.getStations();
        for (int i = 0; i < stations.size(); ++i) {
            elem.addContent(this.writeStation((Station)stations.get(i)));
        }
        return elem;
    }

    private Station readStation(Selector parent, Element elem) {
        String name = elem.getAttributeValue("name");
        String value = elem.getAttributeValue("value");
        Station station = new Station(parent, name, value, null);
        Element locationElem = elem.getChild("location", defNS);
        if (null == locationElem) {
            locationElem = elem.getChild("location3D", defNS);
        }
        station.setLocation(this.readLocation(locationElem));
        Element descElem = elem.getChild("description", defNS);
        if (descElem != null) {
            station.setDescription(this.readDocumentation(descElem));
        }
        return station;
    }

    private Element writeStation(Station c) {
        Element elem = new Element("station", defNS);
        elem.setAttribute("name", c.getName());
        elem.setAttribute("value", c.getValue());
        if (c.getDescription() != null) {
            elem.addContent(this.writeDocumentation(c.getDescription(), "description"));
        }
        elem.addContent(this.writeLocation(c.getLocation(), "location"));
        return elem;
    }

    @Override
    public void writeXML(QueryCapability qc, OutputStream os) throws IOException {
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        fmt.output(this.writeQC(qc), os);
    }
}

