/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.ImmutableEnvelope;
import org.apache.sis.internal.storage.AbstractFeatureSet;
import org.apache.sis.internal.storage.MetadataBuilder;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.FeatureSet;
import org.apache.sis.storage.event.StoreListeners;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.referencing.operation.TransformException;

abstract class AggregatedFeatureSet
extends AbstractFeatureSet {
    private ImmutableEnvelope envelope;
    private boolean isEnvelopeComputed;

    protected AggregatedFeatureSet(StoreListeners storeListeners) {
        super(storeListeners);
    }

    abstract Collection<FeatureSet> dependencies();

    private boolean getEnvelopes(List<Envelope> list) throws DataStoreException {
        for (FeatureSet featureSet : this.dependencies()) {
            if (featureSet instanceof AggregatedFeatureSet) {
                if (((AggregatedFeatureSet)featureSet).getEnvelopes(list)) continue;
                return false;
            }
            Optional<Envelope> optional = featureSet.getEnvelope();
            if (!optional.isPresent()) {
                return false;
            }
            list.add(optional.get());
        }
        return true;
    }

    @Override
    public final synchronized Optional<Envelope> getEnvelope() throws DataStoreException {
        if (!this.isEnvelopeComputed) {
            ArrayList<Envelope> arrayList = new ArrayList<Envelope>();
            if (this.getEnvelopes(arrayList)) {
                try {
                    this.envelope = ImmutableEnvelope.castOrCopy(Envelopes.union(arrayList.toArray(new Envelope[arrayList.size()])));
                }
                catch (TransformException transformException) {
                    this.warning(transformException);
                }
            }
            this.isEnvelopeComputed = true;
        }
        return Optional.ofNullable(this.envelope);
    }

    @Override
    protected void createMetadata(MetadataBuilder metadataBuilder) throws DataStoreException {
        super.createMetadata(metadataBuilder);
        for (FeatureSet featureSet : this.dependencies()) {
            CharSequence[] charSequenceArray;
            DefaultFeatureType defaultFeatureType = featureSet.getType();
            Metadata metadata = featureSet.getMetadata();
            if (defaultFeatureType == null) {
                charSequenceArray = null;
            } else {
                CharSequence[] charSequenceArray2 = new CharSequence[1];
                charSequenceArray = charSequenceArray2;
                charSequenceArray2[0] = defaultFeatureType.getName().toInternationalString();
            }
            metadataBuilder.addSource(metadata, ScopeCode.FEATURE_TYPE, charSequenceArray);
        }
    }

    @Override
    protected synchronized void clearCache() {
        this.isEnvelopeComputed = false;
        this.envelope = null;
        super.clearCache();
    }
}

