/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import java.lang.reflect.Array;
import java.util.function.Function;
import javax.measure.Quantity;
import javax.measure.Unit;
import org.apache.sis.internal.referencing.Formulas;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.referencing.provider.Affine;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.io.wkt.ElementKind;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.math.Statistics;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.Units;
import org.apache.sis.parameter.DefaultParameterValue;
import org.apache.sis.parameter.Parameterized;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.DefaultCoordinateSystemAxis;
import org.apache.sis.referencing.datum.AbstractDatum;
import org.apache.sis.referencing.datum.DefaultEllipsoid;
import org.apache.sis.referencing.datum.DefaultGeodeticDatum;
import org.apache.sis.referencing.datum.DefaultPrimeMeridian;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Static;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;

public final class WKTUtilities
extends Static {
    private WKTUtilities() {
    }

    public static String toType(Class<?> clazz, Class<?> clazz2) {
        int n;
        StringBuilder stringBuilder;
        if (clazz2 != clazz && (stringBuilder = ReferencingUtilities.toPropertyName(clazz, clazz2)) != null && CharSequences.regionMatches(stringBuilder, n = stringBuilder.length() - 2, "CS")) {
            stringBuilder.setLength(n);
            if ("time".contentEquals(stringBuilder)) {
                return "temporal";
            }
            if (CharSequences.regionMatches(stringBuilder, 0, "cartesian")) {
                stringBuilder.setCharAt(0, 'C');
            }
            return stringBuilder.toString();
        }
        return null;
    }

    public static FormattableObject toFormattable(CoordinateReferenceSystem coordinateReferenceSystem) {
        if (coordinateReferenceSystem instanceof FormattableObject) {
            return (FormattableObject)((Object)coordinateReferenceSystem);
        }
        return AbstractCRS.castOrCopy(coordinateReferenceSystem);
    }

    public static FormattableObject toFormattable(CoordinateSystem coordinateSystem) {
        if (coordinateSystem instanceof FormattableObject) {
            return (FormattableObject)((Object)coordinateSystem);
        }
        return AbstractCS.castOrCopy(coordinateSystem);
    }

    public static FormattableObject toFormattable(CoordinateSystemAxis coordinateSystemAxis) {
        if (coordinateSystemAxis instanceof FormattableObject) {
            return (FormattableObject)((Object)coordinateSystemAxis);
        }
        return DefaultCoordinateSystemAxis.castOrCopy(coordinateSystemAxis);
    }

    public static FormattableObject toFormattable(Datum datum) {
        if (datum instanceof FormattableObject) {
            return (FormattableObject)((Object)datum);
        }
        return AbstractDatum.castOrCopy(datum);
    }

    public static FormattableObject toFormattable(GeodeticDatum geodeticDatum) {
        if (geodeticDatum instanceof FormattableObject) {
            return (FormattableObject)((Object)geodeticDatum);
        }
        return DefaultGeodeticDatum.castOrCopy(geodeticDatum);
    }

    public static FormattableObject toFormattable(Ellipsoid ellipsoid) {
        if (ellipsoid instanceof FormattableObject) {
            return (FormattableObject)((Object)ellipsoid);
        }
        return DefaultEllipsoid.castOrCopy(ellipsoid);
    }

    public static FormattableObject toFormattable(PrimeMeridian primeMeridian) {
        if (primeMeridian instanceof FormattableObject) {
            return (FormattableObject)((Object)primeMeridian);
        }
        return DefaultPrimeMeridian.castOrCopy(primeMeridian);
    }

    public static FormattableObject toFormattable(MathTransform mathTransform, boolean bl) {
        ParameterValueGroup parameterValueGroup;
        Matrix matrix;
        if (bl && (matrix = MathTransforms.getMatrix(mathTransform)) != null) {
            parameterValueGroup = Affine.parameters(matrix);
        } else if (mathTransform instanceof Parameterized) {
            parameterValueGroup = ((Parameterized)((Object)mathTransform)).getParameterValues();
        } else {
            matrix = MathTransforms.getMatrix(mathTransform);
            if (matrix == null) {
                return null;
            }
            parameterValueGroup = Affine.parameters(matrix);
        }
        return new FormattableObject(){

            @Override
            protected String formatTo(Formatter formatter) {
                WKTUtilities.appendParamMT(parameterValueGroup, formatter);
                return "Param_MT";
            }
        };
    }

    public static <Q extends Quantity<Q>> Unit<Q> toFormattable(Unit<Q> unit) {
        if (Units.isAngular(unit) && !unit.getConverterTo(Units.RADIAN).isLinear()) {
            unit = Units.DEGREE;
        }
        return unit;
    }

    public static void appendName(IdentifiedObject identifiedObject, Formatter formatter, ElementKind elementKind) {
        String string = IdentifiedObjects.getName(identifiedObject, formatter.getNameAuthority());
        if (string == null && (string = IdentifiedObjects.getName(identifiedObject, null)) == null) {
            string = Vocabulary.getResources(formatter.getLocale()).getString((short)208);
        }
        formatter.append(string, elementKind != null ? elementKind : ElementKind.NAME);
    }

    public static void appendParamMT(ParameterValueGroup parameterValueGroup, Formatter formatter) {
        if (parameterValueGroup != null) {
            WKTUtilities.appendName(parameterValueGroup.getDescriptor(), formatter, ElementKind.PARAMETER);
            WKTUtilities.append(parameterValueGroup, formatter);
        }
    }

    public static void append(GeneralParameterValue defaultParameterValue, Formatter formatter) {
        if (defaultParameterValue instanceof ParameterValueGroup) {
            boolean bl = true;
            for (GeneralParameterValue generalParameterValue : ((ParameterValueGroup)((Object)defaultParameterValue)).values()) {
                if (bl) {
                    formatter.newLine();
                    bl = false;
                }
                WKTUtilities.append(generalParameterValue, formatter);
            }
        }
        if (defaultParameterValue instanceof ParameterValue) {
            if (!(defaultParameterValue instanceof FormattableObject)) {
                defaultParameterValue = new DefaultParameterValue(defaultParameterValue);
            }
            formatter.append(defaultParameterValue);
            formatter.newLine();
        }
    }

    public static boolean isEPSG(GeneralParameterDescriptor generalParameterDescriptor, boolean bl) {
        String string;
        ReferenceIdentifier referenceIdentifier;
        if (generalParameterDescriptor != null && (referenceIdentifier = generalParameterDescriptor.getName()) != null && (string = referenceIdentifier.getCodeSpace()) != null) {
            return "EPSG".equalsIgnoreCase(string);
        }
        return bl;
    }

    public static int[] suggestFractionDigits(Vector[] vectorArray) {
        int n = 0;
        int n2 = vectorArray.length - 1;
        for (int i = 0; i <= n2; ++i) {
            int n3 = vectorArray[i].size();
            if (n3 <= n) continue;
            n = n3;
        }
        int[] nArray = new int[n];
        Statistics statistics = new Statistics(null);
        for (int i = 0; i < n; ++i) {
            boolean bl = true;
            for (Vector vector : vectorArray) {
                if (vector.size() <= i) continue;
                double d = vector.doubleValue(i);
                statistics.accept(d);
                if (!bl || Math.floor(d) == d || Double.isNaN(d)) continue;
                bl = false;
            }
            if (!bl) {
                nArray[i] = Numerics.suggestFractionDigits(statistics);
            }
            statistics.reset();
        }
        return nArray;
    }

    public static int[] suggestFractionDigits(CoordinateReferenceSystem coordinateReferenceSystem, Vector[] vectorArray) {
        int[] nArray = WKTUtilities.suggestFractionDigits(vectorArray);
        Ellipsoid ellipsoid = ReferencingUtilities.getEllipsoid(coordinateReferenceSystem);
        if (ellipsoid != null) {
            CoordinateSystem coordinateSystem = coordinateReferenceSystem.getCoordinateSystem();
            int n = Math.min(coordinateSystem.getDimension(), nArray.length);
            double d = Formulas.scaleComparedToEarth(ellipsoid);
            for (int i = 0; i < n; ++i) {
                double d2;
                Unit<?> unit = coordinateSystem.getAxis(i).getUnit();
                if (Units.isLinear(unit)) {
                    d2 = 0.01 * d;
                } else if (Units.isAngular(unit)) {
                    d2 = 1.5706706731410455E-9 * d;
                } else {
                    if (!Units.isTemporal(unit)) continue;
                    d2 = 60.0;
                }
                int n2 = DecimalFunctions.fractionDigitsForDelta(d2 /= Units.toStandardUnit(unit), false);
                if (n2 <= nArray[i]) continue;
                nArray[i] = n2;
            }
        }
        return nArray;
    }

    public static Object[] cornersAndCenter(Function<int[], Number> function, int[] nArray, int n) {
        int n2 = n * 2 + 1;
        int[] nArray2 = (int[])nArray.clone();
        int[] nArray3 = (int[])nArray.clone();
        for (int i = 0; i < nArray2.length; ++i) {
            if (nArray2[i] <= n2) continue;
            nArray2[i] = n2;
            nArray3[i] = n;
        }
        int[] nArray4 = new int[nArray2.length];
        int[] nArray5 = new int[nArray2.length];
        Object[] objectArray = new int[nArray2.length];
        int n3 = 0;
        while (n3 < objectArray.length) {
            objectArray[n3++] = nArray2[nArray2.length - n3];
        }
        Object[] objectArray2 = (Object[])Array.newInstance(Number.class, objectArray);
        objectArray = null;
        block6: while (true) {
            int n4;
            if (objectArray == null) {
                Object[] objectArray3 = objectArray2;
                n4 = nArray2.length;
                while (--n4 >= 1) {
                    objectArray3 = (Object[])objectArray3[nArray5[n4]];
                }
                objectArray = (Number[])objectArray3;
            }
            objectArray[nArray5[0]] = (int)function.apply(nArray4);
            n3 = 0;
            block8: while (true) {
                int n5 = n3;
                nArray4[n5] = nArray4[n5] + 1;
                int n6 = n3;
                nArray5[n6] = nArray5[n6] + 1;
                n4 = nArray5[n6];
                if (n4 == nArray2[n3]) {
                    objectArray = null;
                    nArray4[n3] = 0;
                    nArray5[n3] = 0;
                    if (++n3 < nArray2.length) continue;
                    break block6;
                }
                switch (n4 - nArray3[n3]) {
                    case 0: {
                        continue block8;
                    }
                    case 1: {
                        nArray4[n3] = nArray[n3] - n;
                    }
                }
                break;
            }
        }
        Object object = objectArray2;
        Object[] objectArray4 = null;
        int n7 = nArray.length;
        while (--n7 >= 0) {
            int n8 = nArray3[n7];
            objectArray4 = object;
            if (n8 >= objectArray4.length) {
                return objectArray2;
            }
            object = objectArray4[n8];
            nArray4[n7] = nArray[n7] / 2;
        }
        assert (object == objectArray4[nArray3[0]]);
        if (object == null) {
            objectArray4[nArray3[0]] = function.apply(nArray4);
        }
        return objectArray2;
    }
}

