/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf.impl;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.sis.internal.netcdf.Axis;
import org.apache.sis.internal.netcdf.AxisType;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.Dimension;
import org.apache.sis.internal.netcdf.Grid;
import org.apache.sis.internal.netcdf.Resources;
import org.apache.sis.internal.netcdf.impl.DimensionInfo;
import org.apache.sis.internal.netcdf.impl.VariableInfo;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.util.ArraysExt;

final class GridInfo
extends Grid {
    private final DimensionInfo[] domain;
    private final VariableInfo[] range;

    GridInfo(DimensionInfo[] dimensionInfoArray, VariableInfo[] variableInfoArray) {
        this.domain = dimensionInfoArray;
        this.range = variableInfoArray;
    }

    @Override
    protected Grid forDimensions(Dimension[] dimensionArray) {
        int n = 0;
        for (DimensionInfo dimensionInfo : this.domain) {
            do {
                if (n < dimensionArray.length) continue;
                return null;
            } while (!dimensionInfo.equals(dimensionArray[n++]));
        }
        return this;
    }

    private String getFilename() {
        for (VariableInfo variableInfo : this.range) {
            String string = variableInfo.getFilename();
            if (string == null) continue;
            return string;
        }
        return null;
    }

    @Override
    public String getName() {
        return GridInfo.listNames(this.range, this.range.length, " ");
    }

    @Override
    public int getSourceDimensions() {
        return this.domain.length;
    }

    @Override
    public int getTargetDimensions() {
        return this.range.length;
    }

    @Override
    protected List<Dimension> getDimensions() {
        return UnmodifiableArrayList.wrap(this.domain);
    }

    @Override
    protected boolean containsAllNamedAxes(String[] stringArray) {
        if (stringArray != null) {
            block0: for (String string : stringArray) {
                for (VariableInfo variableInfo : this.range) {
                    if (string.equalsIgnoreCase(variableInfo.getName())) continue block0;
                }
                return false;
            }
        }
        return true;
    }

    @Override
    protected Axis[] createAxes(Decoder decoder) throws IOException, DataStoreException {
        TreeMap<VariableInfo, Integer> treeMap = new TreeMap<VariableInfo, Integer>();
        for (int i = 0; i < this.range.length; ++i) {
            VariableInfo variableInfo = this.range[i];
            if (treeMap.put(variableInfo, i) == null) continue;
            throw new DataStoreContentException(Resources.format((short)7, this.getFilename(), variableInfo.getName()));
        }
        Axis[] axisArray = new Axis[this.range.length];
        for (Map.Entry entry : treeMap.entrySet()) {
            int n = (Integer)entry.getValue();
            VariableInfo variableInfo = (VariableInfo)entry.getKey();
            int n2 = 0;
            DimensionInfo[] dimensionInfoArray = variableInfo.dimensions;
            int[] nArray = new int[dimensionInfoArray.length];
            int[] nArray2 = new int[dimensionInfoArray.length];
            block2: for (DimensionInfo dimensionInfo : dimensionInfoArray) {
                for (int i = 0; i < this.domain.length; ++i) {
                    if (this.domain[i] != dimensionInfo) continue;
                    nArray[n2] = i;
                    nArray2[n2++] = dimensionInfo.length;
                    continue block2;
                }
            }
            axisArray[n] = new Axis(AxisType.abbreviation(variableInfo), variableInfo.getAttributeAsString("positive"), ArraysExt.resize(nArray, n2), ArraysExt.resize(nArray2, n2), variableInfo);
        }
        return axisArray;
    }

    public int hashCode() {
        return Arrays.hashCode(this.domain) ^ Arrays.hashCode(this.range);
    }

    public boolean equals(Object object) {
        if (object instanceof GridInfo) {
            GridInfo gridInfo = (GridInfo)object;
            return Arrays.equals(this.domain, gridInfo.domain) && Arrays.equals(this.range, gridInfo.range);
        }
        return false;
    }
}

