/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.sis.internal.netcdf.Axis;
import org.apache.sis.internal.netcdf.GridCacheValue;
import org.apache.sis.internal.netcdf.Resources;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.operation.builder.LocalizationGridBuilder;
import org.apache.sis.referencing.operation.matrix.Matrix3;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.storage.DataStoreReferencingException;
import org.apache.sis.util.ArraysExt;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

public final class Linearizer {
    private final CommonCRS datum;
    final Type type;
    private CoordinateReferenceSystem targetCRS;
    private boolean axisSwap;

    public Linearizer(CommonCRS commonCRS, Type type) {
        this.datum = commonCRS;
        this.type = type;
    }

    final String name() {
        return this.type.name();
    }

    final CoordinateReferenceSystem getTargetCRS() {
        return this.targetCRS;
    }

    final boolean axisSwap() {
        return this.axisSwap;
    }

    public String toString() {
        return Strings.toString(this.getClass(), new Object[]{"type", this.type, "targetCRS", IdentifiedObjects.getName(this.targetCRS, null)});
    }

    private MathTransform gridToTargetCRS(LocalizationGridBuilder localizationGridBuilder, int n, int n2) throws TransformException {
        switch (this.type) {
            default: {
                throw new AssertionError((Object)this.type);
            }
            case UTM: 
        }
        Object object = localizationGridBuilder.getSourceEnvelope(false);
        double[] dArray = localizationGridBuilder.getControlPoint((int)Math.round(object.getMedian(0)), (int)Math.round(object.getMedian(1)));
        ProjectedCRS projectedCRS = this.datum.universal(Math.signum(dArray[n2]), dArray[n]);
        assert (ReferencingUtilities.startsWithNorthEast(projectedCRS.getBaseCRS().getCoordinateSystem()));
        MathTransform mathTransform = projectedCRS.getConversionFromBase().getMathTransform();
        this.targetCRS = projectedCRS;
        boolean bl = this.axisSwap = n2 < n;
        if (!this.axisSwap) {
            object = new Matrix3();
            ((Matrix3)object).m11 = 0.0;
            ((Matrix3)object).m00 = 0.0;
            ((Matrix3)object).m10 = 1.0;
            ((Matrix3)object).m01 = 1.0;
            mathTransform = MathTransforms.concatenate(MathTransforms.linear((Matrix)object), mathTransform);
        }
        return mathTransform;
    }

    static void setCandidatesOnGrid(Axis[] axisArray, Set<Linearizer> set, LocalizationGridBuilder localizationGridBuilder) throws TransformException {
        int n = -1;
        int n2 = -1;
        int n3 = axisArray.length;
        while (--n3 >= 0) {
            switch (axisArray[n3].abbreviation) {
                case '\u03bb': {
                    n = n3;
                    break;
                }
                case '\u03c6': {
                    n2 = n3;
                }
            }
        }
        if ((n | n2) >= 0) {
            HashMap<String, MathTransform> hashMap = new HashMap<String, MathTransform>();
            for (Linearizer linearizer : set) {
                MathTransform mathTransform = linearizer.gridToTargetCRS(localizationGridBuilder, n, n2);
                hashMap.put(linearizer.name(), mathTransform);
            }
            localizationGridBuilder.addLinearizers(hashMap, false, Math.min(n, n2), Math.max(n, n2));
        }
    }

    static void replaceInCompoundCRS(SingleCRS[] singleCRSArray, List<GridCacheValue> list, Matrix matrix) throws DataStoreReferencingException {
        Matrix matrix2 = null;
        block0: for (GridCacheValue gridCacheValue : list) {
            CoordinateReferenceSystem coordinateReferenceSystem = gridCacheValue.linearizationTarget;
            int n = 0;
            for (int i = 0; i < singleCRSArray.length; ++i) {
                SingleCRS singleCRS = singleCRSArray[i];
                int[] nArray = AxisDirections.indicesOfColinear(singleCRS.getCoordinateSystem(), coordinateReferenceSystem.getCoordinateSystem());
                if (nArray != null) {
                    if (gridCacheValue.axisSwap) {
                        ArraysExt.swap(nArray, 0, 1);
                    }
                    for (int j = 0; j < nArray.length; ++j) {
                        if (nArray[j] == j) continue;
                        int n2 = nArray[j] + n;
                        int n3 = j + n;
                        if (matrix2 == null) {
                            matrix2 = matrix.clone();
                        }
                        int n4 = matrix2.getNumCol();
                        while (--n4 >= 0) {
                            matrix.setElement(n3, n4, matrix2.getElement(n2, n4));
                        }
                    }
                    singleCRSArray[i] = (ProjectedCRS)coordinateReferenceSystem;
                    continue block0;
                }
                n += singleCRS.getCoordinateSystem().getDimension();
            }
            throw new DataStoreReferencingException(Resources.format((short)26, IdentifiedObjects.getName(coordinateReferenceSystem, null)));
        }
    }

    public static enum Type {
        UTM;

    }
}

