/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.sql;

import java.util.Collections;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.metadata.iso.DefaultIdentifier;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.citation.DefaultCitation;
import org.apache.sis.metadata.iso.citation.DefaultOrganisation;
import org.apache.sis.metadata.iso.citation.DefaultResponsibleParty;
import org.apache.sis.metadata.sql.MetadataSource;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.iso.Types;
import org.apache.sis.xml.NilReason;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.PresentationForm;
import org.opengis.metadata.citation.Role;
import org.opengis.util.CodeList;

final class MetadataFallback
extends MetadataSource {
    static final MetadataFallback INSTANCE = new MetadataFallback();

    private MetadataFallback() {
    }

    @Override
    public String search(Object object) {
        ArgumentChecks.ensureNonNull("metadata", object);
        return null;
    }

    @Override
    public <T> T lookup(Class<T> clazz, String string) {
        Object object;
        ArgumentChecks.ensureNonNull("type", clazz);
        ArgumentChecks.ensureNonEmpty("identifier", string);
        if (CodeList.class.isAssignableFrom(clazz)) {
            object = MetadataFallback.getCodeList(clazz, string);
        } else {
            object = null;
            if (clazz == Citation.class) {
                object = MetadataFallback.createCitation(string);
            }
            if (object == null) {
                return NilReason.MISSING.createNilObject(clazz);
            }
        }
        return clazz.cast(object);
    }

    static Citation createCitation(String string) {
        String string2;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        PresentationForm presentationForm = null;
        String string9 = null;
        switch (string) {
            case "ISO 19115-1": {
                string2 = "Geographic Information \u2014 Metadata Part 1: Fundamentals";
                string4 = "ISO 19115-1:2014";
                string5 = "19115-1";
                string6 = "ISO";
                string7 = "2014";
                string8 = "International Organization for Standardization";
                presentationForm = PresentationForm.DOCUMENT_DIGITAL;
                break;
            }
            case "ISO 19115-2": {
                string2 = "Geographic Information \u2014 Metadata Part 2: Extensions for imagery and gridded data";
                string4 = "ISO 19115-2:2019";
                string5 = "19115-2";
                string6 = "ISO";
                string7 = "2019";
                string9 = "ISO 19115-1";
                presentationForm = PresentationForm.DOCUMENT_DIGITAL;
                break;
            }
            case "WMS": {
                string2 = "Web Map Server";
                string3 = "WMS";
                string7 = "1.3";
                string4 = "1.3";
                string5 = "WMS";
                string6 = "OGC";
                string9 = "OGC";
                presentationForm = PresentationForm.DOCUMENT_DIGITAL;
                break;
            }
            case "OGC": {
                string2 = "OGC Naming Authority";
                string5 = "OGC";
                string8 = "Open Geospatial Consortium";
                presentationForm = PresentationForm.DOCUMENT_DIGITAL;
                break;
            }
            case "IOGP": {
                string2 = "IOGP Surveying and Positioning Guidance Note 7";
                string5 = "IOGP";
                string9 = "EPSG";
                presentationForm = PresentationForm.DOCUMENT_DIGITAL;
                break;
            }
            case "EPSG": {
                string2 = "EPSG Geodetic Parameter Dataset";
                string3 = "EPSG Dataset";
                string5 = "EPSG";
                string6 = "IOGP";
                string8 = "International Association of Oil & Gas producers";
                presentationForm = PresentationForm.TABLE_DIGITAL;
                break;
            }
            case "SIS": {
                string2 = "Apache Spatial Information System";
                string5 = string;
                string6 = "Apache";
                break;
            }
            case "ISBN": {
                string2 = "International Standard Book Number";
                string3 = string;
                break;
            }
            case "ISSN": {
                string2 = "International Standard Serial Number";
                string3 = string;
                break;
            }
            case "Proj4": {
                string2 = "Proj";
                string5 = "Proj4";
                string6 = "OSGeo";
                break;
            }
            case "IHO S-57": {
                string5 = "S-57";
                string2 = "S-57";
                string6 = "IHO";
                string7 = "3.1";
                presentationForm = PresentationForm.DOCUMENT_DIGITAL;
                break;
            }
            default: {
                return null;
            }
        }
        Object object = new DefaultCitation(string2);
        if (string3 != null) {
            ((DefaultCitation)object).setAlternateTitles(Collections.singleton(Types.toInternationalString(string3)));
        }
        if (string4 != null) {
            ((DefaultCitation)object).setEdition(Types.toInternationalString(string4));
        }
        if (string5 != null) {
            ((DefaultCitation)object).setIdentifiers(Collections.singleton(new DefaultIdentifier(string6, string5, string7)));
        }
        if (presentationForm != null) {
            ((DefaultCitation)object).setPresentationForms(Collections.singleton(presentationForm));
        }
        if (string8 != null) {
            DefaultResponsibleParty defaultResponsibleParty = new DefaultResponsibleParty(Role.PRINCIPAL_INVESTIGATOR);
            defaultResponsibleParty.setParties(Collections.singleton(new DefaultOrganisation(string8, null, null, null)));
            ((DefaultCitation)object).setCitedResponsibleParties(Collections.singleton(defaultResponsibleParty));
        }
        if (string9 != null) {
            ((DefaultCitation)object).setCitedResponsibleParties(MetadataFallback.createCitation(string9).getCitedResponsibleParties());
        }
        ((ISOMetadata)object).transitionTo(ModifiableMetadata.State.FINAL);
        return object;
    }

    @Override
    public void close() {
    }
}

