/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.util.Characters;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.spatial.DimensionNameType;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.operation.Matrix;
import org.opengis.util.FactoryException;

final class GridExtentCRS {
    private GridExtentCRS() {
    }

    private static Map<String, ?> properties(Object object) {
        return Collections.singletonMap("name", object);
    }

    private static CoordinateSystemAxis axis(CSFactory cSFactory, String string, String string2, AxisDirection axisDirection) throws FactoryException {
        return cSFactory.createCoordinateSystemAxis(GridExtentCRS.properties(string), string2, axisDirection, Units.UNITY);
    }

    private static String abbreviation(int n) {
        StringBuilder stringBuilder = new StringBuilder(4).append('x').append(n);
        int n2 = stringBuilder.length();
        while (--n2 >= 1) {
            stringBuilder.setCharAt(n2, Characters.toSuperScript(stringBuilder.charAt(n2)));
        }
        return stringBuilder.toString();
    }

    static EngineeringCRS build(Matrix matrix, DimensionNameType[] dimensionNameTypeArray, Locale locale) throws FactoryException {
        Object object;
        int n;
        int n2 = matrix.getNumRow() - 1;
        int n3 = Math.min(matrix.getNumCol() - 1, dimensionNameTypeArray.length);
        CoordinateSystemAxis[] coordinateSystemAxisArray = new CoordinateSystemAxis[n2];
        CSFactory cSFactory = DefaultFactories.forBuildin(CSFactory.class);
        for (n = 0; n < n3; ++n) {
            AxisDirection axisDirection;
            String string;
            object = dimensionNameTypeArray[n];
            if (object == null) continue;
            int n4 = -1;
            double d = 0.0;
            for (int i = 0; i < n2; ++i) {
                double d2 = matrix.getElement(i, n);
                if (d2 == 0.0) continue;
                if (n4 >= 0 || coordinateSystemAxisArray[i] != null || Math.abs(d2) != 1.0) {
                    return null;
                }
                n4 = i;
                d = d2;
            }
            if (n4 < 0) {
                return null;
            }
            if (object == DimensionNameType.COLUMN || object == DimensionNameType.SAMPLE) {
                string = "x";
                axisDirection = AxisDirection.COLUMN_POSITIVE;
            } else if (object == DimensionNameType.ROW || object == DimensionNameType.LINE) {
                string = "y";
                axisDirection = AxisDirection.ROW_POSITIVE;
            } else if (object == DimensionNameType.VERTICAL) {
                string = "z";
                axisDirection = AxisDirection.UP;
            } else if (object == DimensionNameType.TIME) {
                string = "t";
                axisDirection = AxisDirection.FUTURE;
            } else {
                string = GridExtentCRS.abbreviation(n4);
                axisDirection = AxisDirection.OTHER;
            }
            int n5 = n2;
            while (--n5 >= 0) {
                CoordinateSystemAxis coordinateSystemAxis = coordinateSystemAxisArray[n5];
                if (coordinateSystemAxis == null) continue;
                if (axisDirection.equals(AxisDirections.absolute(coordinateSystemAxis.getDirection()))) {
                    axisDirection = AxisDirection.OTHER;
                }
                if (!string.equals(coordinateSystemAxis.getAbbreviation())) continue;
                string = GridExtentCRS.abbreviation(n4);
            }
            if (d < 0.0) {
                axisDirection = AxisDirections.opposite(axisDirection);
            }
            String string2 = Types.toString(Types.getCodeTitle(object), locale);
            coordinateSystemAxisArray[n4] = GridExtentCRS.axis(cSFactory, string2, string, axisDirection);
        }
        for (n = 0; n < n2; ++n) {
            if (coordinateSystemAxisArray[n] != null) continue;
            object = Vocabulary.getResources(locale).getString((short)64, n);
            String string = GridExtentCRS.abbreviation(n);
            coordinateSystemAxisArray[n] = GridExtentCRS.axis(cSFactory, (String)object, string, AxisDirection.OTHER);
        }
        Map<String, ?> map = GridExtentCRS.properties("Grid extent");
        switch (n2) {
            case 2: {
                object = cSFactory.createAffineCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1]);
                break;
            }
            case 3: {
                object = cSFactory.createAffineCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1], coordinateSystemAxisArray[2]);
                break;
            }
            default: {
                object = new AbstractCS(map, coordinateSystemAxisArray);
            }
        }
        return DefaultFactories.forBuildin(CRSFactory.class).createEngineeringCRS(GridExtentCRS.properties(object.getName()), CommonCRS.Engineering.GRID.datum(), (CoordinateSystem)object);
    }
}

