/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.collection;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import org.apache.sis.internal.util.SetOfUnknownSize;
import org.apache.sis.math.FunctionProperty;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.collection.DerivedIterator;
import org.apache.sis.util.resources.Errors;

class DerivedSet<S, E>
extends SetOfUnknownSize<E>
implements CheckedContainer<E>,
Serializable {
    private static final long serialVersionUID = 6309535868745970619L;
    protected final Set<S> storage;
    protected final ObjectConverter<S, E> converter;

    static <S, E> Set<E> create(Set<S> set, ObjectConverter<S, E> objectConverter) {
        Set<FunctionProperty> set2 = objectConverter.properties();
        if (set2.contains((Object)FunctionProperty.INVERTIBLE)) {
            if (FunctionProperty.isBijective(set2)) {
                return new Bijective<S, E>(set, objectConverter);
            }
            return new Invertible<S, E>(set, objectConverter);
        }
        return new DerivedSet<S, E>(set, objectConverter);
    }

    private DerivedSet(Set<S> set, ObjectConverter<S, E> objectConverter) {
        this.storage = set;
        this.converter = objectConverter;
    }

    @Override
    public final Class<E> getElementType() {
        return this.converter.getTargetClass();
    }

    @Override
    public final Iterator<E> iterator() {
        return new DerivedIterator<S, E>(this.storage.iterator(), this.converter);
    }

    @Override
    public boolean isEmpty() {
        return this.storage.isEmpty() || !this.iterator().hasNext();
    }

    @Override
    public boolean add(E e) throws UnsupportedOperationException {
        return this.add(e, this.converter.inverse().apply(e));
    }

    final boolean add(E e, S s2) {
        if (s2 == null) {
            throw new UnconvertibleObjectException(Errors.format((short)45, "element", e));
        }
        return this.storage.add(s2);
    }

    private static final class Bijective<S, E>
    extends Invertible<S, E> {
        private static final long serialVersionUID = -7601944988804380342L;

        Bijective(Set<S> set, ObjectConverter<S, E> objectConverter) {
            super(set, objectConverter);
        }

        @Override
        public int size() {
            return this.storage.size();
        }

        @Override
        public boolean isEmpty() {
            return this.storage.isEmpty();
        }
    }

    private static class Invertible<S, E>
    extends DerivedSet<S, E> {
        private static final long serialVersionUID = -5336633027232952482L;
        private final ObjectConverter<E, S> inverse;

        Invertible(Set<S> set, ObjectConverter<S, E> objectConverter) {
            super(set, objectConverter);
            this.inverse = objectConverter.inverse();
        }

        @Override
        public final boolean add(E e) throws UnsupportedOperationException {
            return this.add(e, this.inverse.apply(e));
        }

        @Override
        public final boolean contains(Object object) {
            Class clazz = this.getElementType();
            return clazz.isInstance(object) && this.storage.contains(this.inverse.apply(clazz.cast(object)));
        }

        @Override
        public final boolean remove(Object object) throws UnsupportedOperationException {
            Class clazz = this.getElementType();
            return clazz.isInstance(object) && this.storage.remove(this.inverse.apply(clazz.cast(object)));
        }
    }
}

