/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.sis.internal.referencing.LazySet;
import org.apache.sis.internal.storage.StoreMetadata;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.ProbeProviderPair;
import org.apache.sis.storage.ProbeResult;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.UnsupportedStorageException;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;

final class DataStoreRegistry {
    private final ServiceLoader<DataStoreProvider> loader;

    public DataStoreRegistry() {
        this.loader = DefaultFactories.createServiceLoader(DataStoreProvider.class);
    }

    public DataStoreRegistry(ClassLoader classLoader) {
        ArgumentChecks.ensureNonNull("loader", classLoader);
        this.loader = ServiceLoader.load(DataStoreProvider.class, classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DataStoreProvider> providers() {
        ServiceLoader<DataStoreProvider> serviceLoader = this.loader;
        synchronized (serviceLoader) {
            final Iterator<DataStoreProvider> iterator = this.loader.iterator();
            return new LazySet<DataStoreProvider>(new Iterator<DataStoreProvider>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean hasNext() {
                    ServiceLoader serviceLoader = DataStoreRegistry.this.loader;
                    synchronized (serviceLoader) {
                        return iterator.hasNext();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public DataStoreProvider next() {
                    ServiceLoader serviceLoader = DataStoreRegistry.this.loader;
                    synchronized (serviceLoader) {
                        return (DataStoreProvider)iterator.next();
                    }
                }
            });
        }
    }

    public String probeContentType(Object object) throws DataStoreException {
        ArgumentChecks.ensureNonNull("storage", object);
        ProbeProviderPair probeProviderPair = this.lookup(object, false);
        return probeProviderPair != null ? probeProviderPair.probe.getMimeType() : null;
    }

    public DataStore open(Object object) throws UnsupportedStorageException, DataStoreException {
        ArgumentChecks.ensureNonNull("storage", object);
        return this.lookup((Object)object, (boolean)true).store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProbeProviderPair lookup(Object object, boolean bl) throws DataStoreException {
        Object object2;
        StorageConnector storageConnector = object instanceof StorageConnector ? (StorageConnector)object : new StorageConnector(object);
        String string = storageConnector.getFileExtension();
        Boolean bl2 = string != null && !string.isEmpty() ? Boolean.TRUE : null;
        LinkedList<ProbeProviderPair> linkedList = new LinkedList<ProbeProviderPair>();
        Object object3 = null;
        try {
            block9: do {
                Object object4;
                DataStoreProvider dataStoreProvider;
                ServiceLoader<DataStoreProvider> serviceLoader = this.loader;
                synchronized (serviceLoader) {
                    object2 = this.loader.iterator();
                    dataStoreProvider = object2.hasNext() ? object2.next() : null;
                }
                while (dataStoreProvider != null) {
                    boolean bl3 = true;
                    if (bl2 != null) {
                        object4 = dataStoreProvider.getClass().getAnnotation(StoreMetadata.class);
                        boolean bl4 = bl3 = (object4 != null && ArraysExt.containsIgnoreCase(object4.fileSuffixes(), string)) == bl2;
                    }
                    if (bl3) {
                        object4 = dataStoreProvider.probeContent(storageConnector);
                        if (((ProbeResult)object4).isSupported()) {
                            object3 = new ProbeProviderPair(dataStoreProvider, (ProbeResult)object4);
                            break block9;
                        }
                        if (ProbeResult.INSUFFICIENT_BYTES.equals(object4)) {
                            linkedList.add(new ProbeProviderPair(dataStoreProvider, (ProbeResult)object4));
                        } else if (ProbeResult.UNDETERMINED.equals(object4) && object3 == null) {
                            object3 = new ProbeProviderPair(dataStoreProvider, (ProbeResult)object4);
                        }
                    }
                    object4 = this.loader;
                    synchronized (object4) {
                        dataStoreProvider = object2.hasNext() ? object2.next() : null;
                    }
                }
                while (!linkedList.isEmpty() && storageConnector.prefetch()) {
                    Iterator iterator = linkedList.iterator();
                    while (iterator.hasNext()) {
                        object4 = (ProbeProviderPair)iterator.next();
                        ((ProbeProviderPair)object4).probe = ((ProbeProviderPair)object4).provider.probeContent(storageConnector);
                        if (((ProbeProviderPair)object4).probe.isSupported()) {
                            object3 = object4;
                            break block9;
                        }
                        if (ProbeResult.INSUFFICIENT_BYTES.equals(((ProbeProviderPair)object4).probe)) continue;
                        if (object3 == null && ProbeResult.UNDETERMINED.equals(((ProbeProviderPair)object4).probe)) {
                            object3 = object4;
                        }
                        iterator.remove();
                    }
                }
            } while (bl2 != null && !(bl2 = Boolean.valueOf(bl2 == false)).booleanValue());
            if (bl && object3 != null) {
                ((ProbeProviderPair)object3).store = ((ProbeProviderPair)object3).provider.open(storageConnector);
                storageConnector = null;
            }
        }
        finally {
            if (storageConnector != null && storageConnector != object) {
                storageConnector.closeAllExcept(null);
            }
        }
        if (bl && object3 == null) {
            object2 = storageConnector.getStorageName();
            throw new UnsupportedStorageException(null, 14, object2);
        }
        return object3;
    }
}

