/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.StoreUtilities;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.IllegalNameException;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.event.StoreEvent;
import org.apache.sis.storage.event.StoreListener;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Localized;
import org.apache.sis.util.logging.WarningListener;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.identification.Identification;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.GenericName;
import org.opengis.util.ScopedName;

public abstract class DataStore
implements Resource,
Localized,
AutoCloseable {
    protected final DataStoreProvider provider;
    private final String name;
    private Locale locale;
    protected final StoreListeners listeners;

    protected DataStore() {
        this.provider = null;
        this.name = null;
        this.locale = Locale.getDefault(Locale.Category.DISPLAY);
        this.listeners = new StoreListeners(null, this);
    }

    protected DataStore(DataStoreProvider dataStoreProvider, StorageConnector storageConnector) throws DataStoreException {
        ArgumentChecks.ensureNonNull("connector", storageConnector);
        this.provider = dataStoreProvider;
        this.name = storageConnector.getStorageName();
        this.locale = Locale.getDefault(Locale.Category.DISPLAY);
        this.listeners = new StoreListeners(null, this);
    }

    protected DataStore(DataStore dataStore, StorageConnector storageConnector) throws DataStoreException {
        StoreListeners storeListeners;
        ArgumentChecks.ensureNonNull("connector", storageConnector);
        if (dataStore != null) {
            storeListeners = dataStore.listeners;
            this.provider = dataStore.provider;
            this.locale = dataStore.locale;
        } else {
            storeListeners = null;
            this.provider = null;
            this.locale = Locale.getDefault(Locale.Category.DISPLAY);
        }
        this.listeners = new StoreListeners(storeListeners, this);
        this.name = storageConnector.getStorageName();
    }

    public DataStoreProvider getProvider() {
        return this.provider;
    }

    public abstract Optional<ParameterValueGroup> getOpenParameters();

    public synchronized void setLocale(Locale locale) {
        ArgumentChecks.ensureNonNull("locale", locale);
        this.locale = locale;
    }

    @Override
    public synchronized Locale getLocale() {
        return this.locale;
    }

    public String getDisplayName() {
        return this.name;
    }

    @Override
    public Optional<GenericName> getIdentifier() throws DataStoreException {
        Metadata metadata = this.getMetadata();
        if (metadata != null) {
            Citation citation = null;
            for (Identification object : metadata.getIdentificationInfo()) {
                Citation citation2 = object.getCitation();
                if (citation2 == null) continue;
                if (citation != null && citation != citation2) {
                    return Optional.empty();
                }
                citation = citation2;
            }
            if (citation != null) {
                Object object = null;
                for (Identifier identifier : citation.getIdentifiers()) {
                    if (identifier instanceof GenericName) {
                        return Optional.of((GenericName)((Object)identifier));
                    }
                    if (object != null || !(identifier instanceof ReferenceIdentifier)) continue;
                    object = (ReferenceIdentifier)identifier;
                }
                if (object != null) {
                    return Optional.of(new NamedIdentifier((ReferenceIdentifier)object));
                }
            }
        }
        return Optional.empty();
    }

    @Override
    public abstract Metadata getMetadata() throws DataStoreException;

    public Resource findResource(String string) throws DataStoreException {
        ArgumentChecks.ensureNonEmpty("identifier", string);
        Resource resource = this.findResource(string, this, new IdentityHashMap<Resource, Boolean>());
        if (resource != null) {
            return resource;
        }
        throw new IllegalNameException(StoreUtilities.resourceNotFound(this, string));
    }

    private Resource findResource(String string, Resource resource, Map<Resource, Boolean> map) throws DataStoreException {
        if (resource != null && map.put(resource, Boolean.TRUE) == null) {
            GenericName genericName = resource.getIdentifier().orElse(null);
            if (genericName != null) {
                do {
                    if (!string.equals(genericName.toString())) continue;
                    return resource;
                } while (genericName instanceof ScopedName && genericName != (genericName = ((ScopedName)genericName).tail()));
            }
            if (resource instanceof Aggregate) {
                Resource resource2 = null;
                for (Resource resource3 : ((Aggregate)resource).components()) {
                    Resource resource4 = this.findResource(string, resource3, map);
                    if (resource4 == null) continue;
                    if (resource2 == null) {
                        resource2 = resource4;
                        continue;
                    }
                    throw new IllegalNameException(Resources.forLocale(this.getLocale()).getString((short)23, this.getDisplayName(), string));
                }
                return resource2;
            }
        }
        return null;
    }

    @Override
    public <T extends StoreEvent> void addListener(Class<T> clazz, StoreListener<? super T> storeListener) {
        this.listeners.addListener(clazz, storeListener);
    }

    @Override
    public <T extends StoreEvent> void removeListener(Class<T> clazz, StoreListener<? super T> storeListener) {
        this.listeners.removeListener(clazz, storeListener);
    }

    @Deprecated
    public void addWarningListener(WarningListener<? super DataStore> warningListener) throws IllegalArgumentException {
        this.listeners.addWarningListener(warningListener);
    }

    @Deprecated
    public void removeWarningListener(WarningListener<? super DataStore> warningListener) throws NoSuchElementException {
        this.listeners.removeWarningListener(warningListener);
    }

    @Override
    public abstract void close() throws DataStoreException;

    public String toString() {
        return Strings.bracket(this.getClass(), (Object)this.getDisplayName());
    }
}

