/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.wkt;

import java.io.IOException;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import javax.measure.Unit;
import org.apache.sis.internal.referencing.ReferencingFactoryContainer;
import org.apache.sis.internal.util.StandardDateFormat;
import org.apache.sis.io.CompoundFormat;
import org.apache.sis.io.wkt.AbstractParser;
import org.apache.sis.io.wkt.Colors;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.Element;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.io.wkt.GeodeticObjectParser;
import org.apache.sis.io.wkt.KeywordCase;
import org.apache.sis.io.wkt.KeywordStyle;
import org.apache.sis.io.wkt.Symbols;
import org.apache.sis.io.wkt.Transliterator;
import org.apache.sis.io.wkt.UnparsableObjectException;
import org.apache.sis.io.wkt.Warnings;
import org.apache.sis.measure.UnitFormat;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.util.Factory;

public class WKTFormat
extends CompoundFormat<Object> {
    private static final long serialVersionUID = -2909110214650709560L;
    public static final int SINGLE_LINE = -1;
    private Symbols symbols;
    private Colors colors;
    private Convention convention = Convention.DEFAULT;
    private Citation authority;
    private KeywordCase keywordCase;
    private KeywordStyle keywordStyle;
    private Transliterator transliterator;
    private byte indentation;
    private int listSizeLimit;
    private Map<String, Element> fragments;
    private transient Map<Object, Object> sharedValues;
    private transient Formatter formatter;
    private transient AbstractParser parser;
    private transient ReferencingFactoryContainer factories;
    private transient Warnings warnings;

    public WKTFormat(Locale locale, TimeZone timeZone) {
        super(locale, timeZone);
        this.symbols = Symbols.getDefault();
        this.keywordCase = KeywordCase.DEFAULT;
        this.keywordStyle = KeywordStyle.DEFAULT;
        this.indentation = (byte)2;
        this.listSizeLimit = Integer.MAX_VALUE;
    }

    private Map<String, Element> fragments() {
        if (this.fragments == null) {
            this.fragments = new TreeMap<String, Element>();
        }
        return this.fragments;
    }

    private ReferencingFactoryContainer factories() {
        if (this.factories == null) {
            this.factories = new ReferencingFactoryContainer();
        }
        return this.factories;
    }

    @Override
    public Locale getLocale(Locale.Category category) {
        if (category == Locale.Category.FORMAT) {
            return this.symbols.getLocale();
        }
        return super.getLocale(category);
    }

    public Symbols getSymbols() {
        return this.symbols;
    }

    public void setSymbols(Symbols symbols) {
        ArgumentChecks.ensureNonNull("symbols", symbols);
        if (!symbols.equals(this.symbols)) {
            this.symbols = symbols.immutable();
            this.formatter = null;
            this.parser = null;
        }
    }

    public Transliterator getTransliterator() {
        Transliterator transliterator = this.transliterator;
        if (transliterator == null) {
            transliterator = this.convention == Convention.INTERNAL ? Transliterator.IDENTITY : Transliterator.DEFAULT;
        }
        return transliterator;
    }

    public void setTransliterator(Transliterator transliterator) {
        if (this.transliterator != transliterator) {
            this.transliterator = transliterator;
            this.updateFormatter(this.formatter);
            this.parser = null;
        }
    }

    public KeywordCase getKeywordCase() {
        return this.keywordCase;
    }

    public void setKeywordCase(KeywordCase keywordCase) {
        ArgumentChecks.ensureNonNull("keywordCase", (Object)keywordCase);
        this.keywordCase = keywordCase;
        this.updateFormatter(this.formatter);
    }

    public KeywordStyle getKeywordStyle() {
        return this.keywordStyle;
    }

    public void setKeywordStyle(KeywordStyle keywordStyle) {
        ArgumentChecks.ensureNonNull("keywordStyle", (Object)keywordStyle);
        this.keywordStyle = keywordStyle;
        this.updateFormatter(this.formatter);
    }

    public Colors getColors() {
        return this.colors;
    }

    public void setColors(Colors colors) {
        if (colors != null) {
            colors = colors.immutable();
        }
        this.colors = colors;
        this.updateFormatter(this.formatter);
    }

    public Convention getConvention() {
        return this.convention;
    }

    public void setConvention(Convention convention) {
        ArgumentChecks.ensureNonNull("convention", (Object)convention);
        if (this.convention != convention) {
            this.convention = convention;
            this.updateFormatter(this.formatter);
            this.parser = null;
        }
    }

    public Citation getNameAuthority() {
        Citation citation = this.authority;
        if (citation == null) {
            citation = this.convention.getNameAuthority();
        }
        return citation;
    }

    public void setNameAuthority(Citation citation) {
        this.authority = citation;
        this.updateFormatter(this.formatter);
    }

    private void updateFormatter(Formatter formatter) {
        if (formatter != null) {
            byte by;
            byte by2;
            switch (this.keywordCase) {
                case LOWER_CASE: {
                    by2 = -1;
                    break;
                }
                case UPPER_CASE: {
                    by2 = 1;
                    break;
                }
                case CAMEL_CASE: {
                    by2 = 0;
                    break;
                }
                default: {
                    by2 = this.convention.toUpperCase ? (byte)1 : 0;
                }
            }
            switch (this.keywordStyle) {
                case SHORT: {
                    by = -1;
                    break;
                }
                case LONG: {
                    by = 1;
                    break;
                }
                default: {
                    by = this.convention.majorVersion() == 1 ? (byte)-1 : 0;
                }
            }
            formatter.configure(this.convention, this.authority, this.colors, by2, by, this.indentation, this.listSizeLimit);
            if (this.transliterator != null) {
                formatter.transliterator = this.transliterator;
            }
        }
    }

    public int getIndentation() {
        return this.indentation;
    }

    public void setIndentation(int n) {
        ArgumentChecks.ensureBetween("indentation", -1, 127, n);
        this.indentation = (byte)n;
        this.updateFormatter(this.formatter);
    }

    public int getMaximumListElements() {
        return this.listSizeLimit;
    }

    public void setMaximumListElements(int n) {
        ArgumentChecks.ensureStrictlyPositive("limit", n);
        this.listSizeLimit = n;
        this.updateFormatter(this.formatter);
    }

    private void ensureValidFactoryType(Class<?> clazz) throws IllegalArgumentException {
        ArgumentChecks.ensureNonNull("type", clazz);
        if (clazz != CRSFactory.class && clazz != CSFactory.class && clazz != DatumFactory.class && clazz != MathTransformFactory.class && clazz != CoordinateOperationFactory.class) {
            throw new IllegalArgumentException(Errors.getResources(this.getLocale()).getString((short)45, "type", clazz));
        }
    }

    public <T extends Factory> T getFactory(Class<T> clazz) {
        this.ensureValidFactoryType(clazz);
        return this.factories().getFactory(clazz);
    }

    public <T extends Factory> void setFactory(Class<T> clazz, T t) {
        this.ensureValidFactoryType(clazz);
        if (this.factories().setFactory(clazz, t)) {
            this.parser = null;
        }
    }

    @Override
    public final Class<Object> getValueType() {
        return Object.class;
    }

    public Set<String> getFragmentNames() {
        return this.fragments().keySet();
    }

    public void addFragment(String string, String string2) throws IllegalArgumentException, ParseException {
        ArgumentChecks.ensureNonEmpty("wkt", string2);
        ArgumentChecks.ensureNonEmpty("name", string);
        int n = 112;
        if (CharSequences.isUnicodeIdentifier(string)) {
            if (this.sharedValues == null) {
                this.sharedValues = new HashMap<Object, Object>();
            }
            ParsePosition parsePosition = new ParsePosition(0);
            Element element = new Element(this.parser(), string2, parsePosition, this.sharedValues);
            int n2 = CharSequences.skipLeadingWhitespaces(string2, parsePosition.getIndex(), string2.length());
            if (n2 < string2.length()) {
                throw new UnparsableObjectException(this.getLocale(), 135, new Object[]{string + " = " + element.keyword + "[\u2026]", CharSequences.token(string2, n2)}, n2);
            }
            if (this.fragments.putIfAbsent(string, element) == null) {
                return;
            }
            n = 27;
        }
        throw new IllegalArgumentException(Errors.getResources(this.getLocale()).getString((short)n, string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object parse(CharSequence charSequence, ParsePosition parsePosition) throws ParseException {
        this.warnings = null;
        this.sharedValues = null;
        ArgumentChecks.ensureNonEmpty("wkt", charSequence);
        ArgumentChecks.ensureNonNull("pos", parsePosition);
        AbstractParser abstractParser = this.parser();
        Object object = null;
        try {
            Object object2 = object = abstractParser.parseObject(charSequence.toString(), parsePosition);
            this.warnings = abstractParser.getAndClearWarnings(object);
            return object2;
        }
        catch (Throwable throwable) {
            this.warnings = abstractParser.getAndClearWarnings(object);
            throw throwable;
        }
    }

    private AbstractParser parser() {
        AbstractParser abstractParser = this.parser;
        if (abstractParser == null) {
            this.parser = abstractParser = new Parser(this.symbols, this.fragments(), (NumberFormat)this.getFormat(Number.class), (DateFormat)this.getFormat(Date.class), (UnitFormat)this.getFormat(Unit.class), this.convention, this.transliterator != null ? this.transliterator : Transliterator.DEFAULT, this.getLocale(), this.factories());
        }
        return abstractParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void format(Object object, Appendable appendable) throws IOException {
        this.warnings = null;
        ArgumentChecks.ensureNonNull("object", object);
        ArgumentChecks.ensureNonNull("toAppendTo", appendable);
        StringBuffer stringBuffer = appendable instanceof StringBuffer ? (StringBuffer)appendable : new StringBuffer(500);
        Formatter formatter = this.formatter;
        if (formatter == null) {
            formatter = new Formatter(this.getLocale(), this.symbols, (NumberFormat)this.getFormat(Number.class), (DateFormat)this.getFormat(Date.class), (UnitFormat)this.getFormat(Unit.class));
            this.updateFormatter(formatter);
            this.formatter = formatter;
        }
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            boolean bl;
            try {
                formatter.setBuffer(stringBuffer);
                bl = formatter.appendElement(object) || formatter.appendValue(object);
            }
            finally {
                this.warnings = formatter.getWarnings();
                formatter.setBuffer(null);
                formatter.clear();
            }
            if (this.warnings != null) {
                this.warnings.setRoot(object);
            }
            if (!bl) {
                throw new ClassCastException(Errors.getResources(this.getLocale()).getString((short)42, "object", object.getClass()));
            }
            if (stringBuffer != appendable) {
                appendable.append(stringBuffer);
            }
        }
    }

    @Override
    protected Format createFormat(Class<?> clazz) {
        if (clazz == Number.class) {
            return this.symbols.createNumberFormat();
        }
        if (clazz == Date.class) {
            return new StandardDateFormat(this.symbols.getLocale(), this.getTimeZone());
        }
        Format format = super.createFormat(clazz);
        if (format instanceof UnitFormat) {
            ((UnitFormat)format).setStyle(UnitFormat.Style.NAME);
        }
        return format;
    }

    public Warnings getWarnings() {
        Warnings warnings = this.warnings;
        if (warnings != null) {
            warnings.publish();
        }
        return warnings;
    }

    @Override
    public WKTFormat clone() {
        WKTFormat wKTFormat = (WKTFormat)super.clone();
        wKTFormat.formatter = null;
        wKTFormat.parser = null;
        wKTFormat.warnings = null;
        return wKTFormat;
    }

    private static final class Parser
    extends GeodeticObjectParser {
        Parser(Symbols symbols, Map<String, Element> map, NumberFormat numberFormat, DateFormat dateFormat, UnitFormat unitFormat, Convention convention, Transliterator transliterator, Locale locale, ReferencingFactoryContainer referencingFactoryContainer) {
            super(symbols, map, numberFormat, dateFormat, unitFormat, convention, transliterator, locale, referencingFactoryContainer);
        }

        @Override
        String getPublicFacade() {
            return WKTFormat.class.getName();
        }

        @Override
        String getFacadeMethod() {
            return "parse";
        }
    }
}

