/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.measure.Unit;
import javax.measure.quantity.Angle;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.referencing.provider.AbstractProvider;
import org.apache.sis.internal.referencing.provider.DatumShiftGridCompressed;
import org.apache.sis.internal.referencing.provider.DatumShiftGridFile;
import org.apache.sis.internal.referencing.provider.DatumShiftGridLoader;
import org.apache.sis.internal.system.DataDirectory;
import org.apache.sis.measure.Units;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.transform.InterpolatedTransform;
import org.apache.sis.util.collection.Cache;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Messages;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.FactoryException;

@XmlTransient
public final class NTv2
extends AbstractProvider {
    private static final long serialVersionUID = -4027618007780159180L;
    private static final ParameterDescriptor<Path> FILE;
    public static final ParameterDescriptorGroup PARAMETERS;

    public NTv2() {
        super(2, 2, PARAMETERS);
    }

    public Class<Transformation> getOperationType() {
        return Transformation.class;
    }

    @Override
    public MathTransform createMathTransform(MathTransformFactory mathTransformFactory, ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException, FactoryException {
        Parameters parameters = Parameters.castOrWrap(parameterValueGroup);
        return InterpolatedTransform.createGeodeticTransformation(mathTransformFactory, NTv2.getOrLoad(parameters.getMandatoryValue(FILE)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DatumShiftGridFile<Angle, Angle> getOrLoad(Path path) throws FactoryException {
        DatumShiftGridFile<Object, Object> datumShiftGridFile;
        block12: {
            Path path2 = DataDirectory.DATUM_CHANGES.resolve(path).toAbsolutePath();
            datumShiftGridFile = DatumShiftGridFile.CACHE.peek(path2);
            if (datumShiftGridFile == null) {
                Cache.Handler<DatumShiftGridFile<?, ?>> handler = DatumShiftGridFile.CACHE.lock(path2);
                try {
                    datumShiftGridFile = handler.peek();
                    if (datumShiftGridFile != null) break block12;
                    try (SeekableByteChannel seekableByteChannel = Files.newByteChannel(path2, new OpenOption[0]);){
                        DatumShiftGridLoader.log(NTv2.class, path);
                        Loader loader = new Loader(seekableByteChannel, path);
                        datumShiftGridFile = loader.readGrid();
                        loader.reportWarnings();
                    }
                    catch (IOException | RuntimeException | NoninvertibleTransformException exception) {
                        throw DatumShiftGridLoader.canNotLoad("NTv2", path, exception);
                    }
                    datumShiftGridFile = datumShiftGridFile.useSharedData();
                }
                finally {
                    handler.putAndUnlock(datumShiftGridFile);
                }
            }
        }
        return datumShiftGridFile.castTo(Angle.class, Angle.class);
    }

    static {
        ParameterBuilder parameterBuilder = NTv2.builder();
        FILE = ((ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier("8656")).addName("Latitude and longitude difference file")).create(Path.class, null);
        PARAMETERS = ((ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier("9615")).addName("NTv2")).createGroup(FILE);
    }

    private static final class Loader
    extends DatumShiftGridLoader {
        private static final int RECORD_LENGTH = 16;
        private static final int KEY_LENGTH = 8;
        private static final int STRING_TYPE = 0;
        private static final int INTEGER_TYPE = 1;
        private static final int DOUBLE_TYPE = 2;
        private static final Map<String, Integer> TYPES;
        private final Map<String, Object> header = new LinkedHashMap<String, Object>();
        private boolean hasUnrecognized;
        private int remainingGrids;

        Loader(ReadableByteChannel readableByteChannel, Path path) throws IOException, FactoryException {
            super(readableByteChannel, ByteBuffer.allocate(4096), path);
            this.ensureBufferContains(16);
            if (Loader.isLittleEndian(this.buffer.getInt(8))) {
                this.buffer.order(ByteOrder.LITTLE_ENDIAN);
            }
            this.readHeader(11, "NUM_OREC");
            this.remainingGrids = (Integer)this.get("NUM_FILE");
            if (this.remainingGrids < 1) {
                throw new FactoryException(Errors.format((short)144, "NUM_FILE", this.remainingGrids));
            }
        }

        final DatumShiftGridFile<Angle, Angle> readGrid() throws IOException, FactoryException, NoninvertibleTransformException {
            double d;
            Unit<Angle> unit;
            if (--this.remainingGrids < 0) {
                throw new FactoryException(Errors.format((short)12, this.file));
            }
            Object[] objectArray = this.header.keySet().toArray();
            this.readHeader((Integer)this.get("NUM_SREC"), "NUM_SREC");
            String string = (String)this.get("GS_TYPE");
            if (string.equalsIgnoreCase("SECONDS")) {
                unit = Units.ARC_SECOND;
                d = 1.0E-4;
            } else if (string.equalsIgnoreCase("MINUTES")) {
                unit = Units.ARC_MINUTE;
                d = 1.6666666666666667E-6;
            } else if (string.equalsIgnoreCase("DEGREES")) {
                unit = Units.DEGREE;
                d = 2.777777777777778E-8;
            } else {
                throw new FactoryException(Errors.format((short)144, "GS_TYPE", string));
            }
            double d2 = (Double)this.get("S_LAT");
            double d3 = (Double)this.get("N_LAT");
            double d4 = (Double)this.get("E_LONG");
            double d5 = (Double)this.get("W_LONG");
            double d6 = (Double)this.get("LAT_INC");
            double d7 = (Double)this.get("LONG_INC");
            Integer n = (Integer)this.header.get("GS_COUNT");
            int n2 = Math.toIntExact(Math.round((d5 - d4) / d7 + 1.0));
            int n3 = Math.toIntExact(Math.round((d3 - d2) / d6 + 1.0));
            int n4 = Math.multiplyExact(n2, n3);
            if (n != null && n4 != n) {
                throw new FactoryException(Errors.format((short)144, "GS_COUNT", n));
            }
            DatumShiftGridFile.Float<Angle, Angle> float_ = new DatumShiftGridFile.Float<Angle, Angle>(2, unit, unit, true, -d4, d2, -d7, d6, n2, n3, PARAMETERS, this.file);
            float[] fArray = float_.offsets[0];
            float[] fArray2 = float_.offsets[1];
            for (int i = 0; i < n4; ++i) {
                this.ensureBufferContains(16);
                fArray2[i] = (float)((double)this.buffer.getFloat() / d6);
                fArray[i] = (float)((double)this.buffer.getFloat() / d7);
                double d8 = Math.min((double)this.buffer.getFloat() / d6, (double)this.buffer.getFloat() / d7);
                if (!(d8 > 0.0) || d8 >= float_.accuracy) continue;
                float_.accuracy = d8;
            }
            double d9 = Math.max(d7, d6);
            if (Double.isNaN(float_.accuracy)) {
                float_.accuracy = Units.DEGREE.getConverterTo(unit).convert(8.999280057595393E-8) / d9;
            }
            this.header.keySet().retainAll(Arrays.asList(objectArray));
            return DatumShiftGridCompressed.compress(float_, null, d / d9);
        }

        private static boolean isLittleEndian(int n) {
            return Integer.compareUnsigned(n, Integer.reverseBytes(n)) > 0;
        }

        private String readString(int n, int n2) {
            byte[] byArray = this.buffer.array();
            while (n2 > n && byArray[n + n2 - 1] <= 32) {
                --n2;
            }
            return new String(byArray, n, n2, StandardCharsets.US_ASCII).trim();
        }

        private void readHeader(int n, String string) throws IOException, FactoryException {
            int n2 = this.buffer.position();
            for (int i = 0; i < n; ++i) {
                Object object;
                this.ensureBufferContains(16);
                String string2 = this.readString(n2, 8).toUpperCase(Locale.US);
                n2 += 8;
                Integer n3 = TYPES.get(string2);
                if (n3 == null) {
                    object = null;
                    this.hasUnrecognized = true;
                } else {
                    switch (n3) {
                        case 0: {
                            object = this.readString(n2, 8);
                            break;
                        }
                        case 1: {
                            int n4 = this.buffer.getInt(n2);
                            if (string2.equals(string)) {
                                n = n4;
                            }
                            object = n4;
                            break;
                        }
                        case 2: {
                            object = this.buffer.getDouble(n2);
                            break;
                        }
                        default: {
                            throw new AssertionError(n3);
                        }
                    }
                }
                Object object2 = this.header.put(string2, object);
                if (object2 != null && !object2.equals(object)) {
                    throw new FactoryException(Errors.format((short)75, string2));
                }
                this.buffer.position(n2 += 8);
            }
        }

        private Object get(String string) throws FactoryException {
            Object object = this.header.get(string);
            if (object != null) {
                return object;
            }
            throw new FactoryException(Errors.format((short)120, this.file, string));
        }

        void reportWarnings() {
            if (this.hasUnrecognized) {
                StringBuilder stringBuilder = new StringBuilder();
                for (Map.Entry<String, Object> entry : this.header.entrySet()) {
                    if (entry.getValue() != null) continue;
                    if (stringBuilder.length() != 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(entry.getKey());
                }
                LogRecord logRecord = Messages.getResources(null).getLogRecord(Level.WARNING, (short)30, this.file, stringBuilder.toString());
                logRecord.setLoggerName("org.apache.sis.referencing.operation");
                Logging.log(NTv2.class, "createMathTransform", logRecord);
            }
        }

        static {
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>(32);
            Integer n = 0;
            Integer n2 = 1;
            Integer n3 = 2;
            hashMap.put("NUM_OREC", n2);
            hashMap.put("NUM_SREC", n2);
            hashMap.put("NUM_FILE", n2);
            hashMap.put("GS_TYPE", n);
            hashMap.put("VERSION", n);
            hashMap.put("SYSTEM_F", n);
            hashMap.put("SYSTEM_T", n);
            hashMap.put("MAJOR_F", n3);
            hashMap.put("MINOR_F", n3);
            hashMap.put("MAJOR_T", n3);
            hashMap.put("MINOR_T", n3);
            hashMap.put("SUB_NAME", n);
            hashMap.put("PARENT", n);
            hashMap.put("CREATED", n);
            hashMap.put("UPDATED", n);
            hashMap.put("S_LAT", n3);
            hashMap.put("N_LAT", n3);
            hashMap.put("E_LONG", n3);
            hashMap.put("W_LONG", n3);
            hashMap.put("LAT_INC", n3);
            hashMap.put("LONG_INC", n3);
            hashMap.put("GS_COUNT", n2);
            TYPES = hashMap;
        }
    }
}

