/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.factory.GeodeticAuthorityFactory;
import org.apache.sis.referencing.factory.IdentifiedObjectFinder;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.logging.Logging;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.util.FactoryException;

public final class DefinitionVerifier {
    private static final AxesConvention[] VARIANTS = new AxesConvention[]{AxesConvention.NORMALIZED, AxesConvention.DISPLAY_ORIENTED, AxesConvention.RIGHT_HANDED};
    public final CoordinateReferenceSystem authoritative;
    private short resourceKey;
    private Object[] arguments;
    private static final int METHOD = 0;
    private static final int CONVERSION = 1;
    private static final int CS = 2;
    private static final int DATUM = 3;
    private static final int PRIME_MERIDIAN = 4;
    private static final int OTHER = 5;

    private DefinitionVerifier(CoordinateReferenceSystem coordinateReferenceSystem) {
        this.authoritative = coordinateReferenceSystem;
    }

    public static void withAuthority(CoordinateReferenceSystem coordinateReferenceSystem, String string, Class<?> clazz, String string2) throws FactoryException {
        LogRecord logRecord;
        DefinitionVerifier definitionVerifier = DefinitionVerifier.withAuthority(coordinateReferenceSystem, null, false);
        if (definitionVerifier != null && (logRecord = definitionVerifier.warning(true)) != null) {
            logRecord.setLoggerName(string);
            Logging.log(clazz, string2, logRecord);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DefinitionVerifier withAuthority(CoordinateReferenceSystem coordinateReferenceSystem, CRSAuthorityFactory cRSAuthorityFactory, boolean bl) throws FactoryException {
        DefinitionVerifier definitionVerifier;
        IdentifiedObject identifiedObject;
        CoordinateReferenceSystem coordinateReferenceSystem2;
        Citation citation = cRSAuthorityFactory != null ? cRSAuthorityFactory.getAuthority() : null;
        String string = IdentifiedObjects.toString(IdentifiedObjects.getIdentifier(coordinateReferenceSystem, citation));
        if (string != null) {
            try {
                if (cRSAuthorityFactory != null) {
                    coordinateReferenceSystem2 = cRSAuthorityFactory.createCoordinateReferenceSystem(string);
                }
                coordinateReferenceSystem2 = CRS.forCode(string);
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                DefinitionVerifier definitionVerifier2 = new DefinitionVerifier(coordinateReferenceSystem);
                definitionVerifier2.arguments = new String[]{noSuchAuthorityCodeException.getLocalizedMessage()};
                return definitionVerifier2;
            }
        } else {
            if (!bl) return null;
            IdentifiedObjectFinder identifiedObjectFinder = cRSAuthorityFactory instanceof GeodeticAuthorityFactory ? ((GeodeticAuthorityFactory)((Object)cRSAuthorityFactory)).newIdentifiedObjectFinder() : IdentifiedObjects.newFinder(Citations.getIdentifier(citation));
            identifiedObjectFinder.setIgnoringAxes(true);
            identifiedObject = identifiedObjectFinder.findSingleton(coordinateReferenceSystem);
            if (!(identifiedObject instanceof CoordinateReferenceSystem)) return null;
            coordinateReferenceSystem2 = (CoordinateReferenceSystem)identifiedObject;
        }
        int n = 0;
        identifiedObject = AbstractCRS.castOrCopy(coordinateReferenceSystem2);
        AbstractCRS abstractCRS = identifiedObject;
        while (!abstractCRS.equals(coordinateReferenceSystem, ComparisonMode.APPROXIMATE)) {
            if (n < VARIANTS.length) {
                abstractCRS = ((AbstractCRS)identifiedObject).forConvention(VARIANTS[n++]);
                continue;
            }
            if (string == null) {
                return null;
            }
            n = -1;
            break;
        }
        if (n > 0) {
            definitionVerifier = new DefinitionVerifier(abstractCRS);
            if (string != null) {
                definitionVerifier.resourceKey = (short)72;
                definitionVerifier.arguments = new String[2];
            }
        } else {
            definitionVerifier = new DefinitionVerifier(coordinateReferenceSystem2);
            if (n != 0) {
                definitionVerifier.resourceKey = (short)73;
                definitionVerifier.arguments = new Object[3];
                definitionVerifier.arguments[2] = DefinitionVerifier.diffCode(CRS.getSingleComponents(coordinateReferenceSystem2).iterator(), CRS.getSingleComponents(coordinateReferenceSystem).iterator());
            }
        }
        if (definitionVerifier.arguments == null) return definitionVerifier;
        definitionVerifier.arguments[0] = IdentifiedObjects.getName(coordinateReferenceSystem, null);
        definitionVerifier.arguments[1] = IdentifiedObjects.getIdentifierOrName(coordinateReferenceSystem2);
        return definitionVerifier;
    }

    private static int diffCode(Iterator<SingleCRS> iterator, Iterator<SingleCRS> iterator2) {
        while (iterator.hasNext() && iterator2.hasNext()) {
            IdentifiedObject identifiedObject;
            IdentifiedObject identifiedObject2;
            SingleCRS singleCRS;
            SingleCRS singleCRS2 = iterator.next();
            if (Utilities.equalsApproximately(singleCRS2, singleCRS = iterator2.next())) continue;
            if (singleCRS2 instanceof GeneralDerivedCRS && singleCRS instanceof GeneralDerivedCRS && !Utilities.equalsApproximately(identifiedObject2 = ((GeneralDerivedCRS)singleCRS2).getConversionFromBase(), identifiedObject = ((GeneralDerivedCRS)singleCRS).getConversionFromBase())) {
                return Utilities.equalsApproximately(identifiedObject2.getMethod(), identifiedObject.getMethod()) ? 1 : 0;
            }
            if (!Utilities.equalsApproximately(singleCRS2.getCoordinateSystem(), singleCRS.getCoordinateSystem())) {
                return 2;
            }
            identifiedObject2 = singleCRS2.getDatum();
            if (Utilities.equalsApproximately(identifiedObject2, identifiedObject = singleCRS.getDatum())) break;
            if (identifiedObject2 instanceof GeodeticDatum && identifiedObject instanceof GeodeticDatum && !Utilities.equalsApproximately(((GeodeticDatum)identifiedObject2).getPrimeMeridian(), ((GeodeticDatum)identifiedObject).getPrimeMeridian())) {
                return 4;
            }
            return 3;
        }
        return 5;
    }

    public LogRecord warning(boolean bl) {
        if (this.arguments != null) {
            if (this.resourceKey != 0) {
                return Resources.forLocale(null).getLogRecord(Level.WARNING, this.resourceKey, this.arguments);
            }
            if (bl) {
                return new LogRecord(Level.FINE, (String)this.arguments[0]);
            }
        }
        return null;
    }
}

