/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf;

import java.util.HashMap;
import java.util.Set;
import org.apache.sis.internal.netcdf.Axis;
import org.apache.sis.internal.netcdf.SatelliteGroundTrack;
import org.apache.sis.internal.netcdf.Variable;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.referencing.operation.builder.LocalizationGridBuilder;
import org.apache.sis.util.logging.Logging;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public enum Linearizer {
    MERCATOR("Mercator (Spherical)"),
    GROUND_TRACK(null);

    private String projection;
    private MathTransform transform;

    private Linearizer(String string2) {
        this.projection = string2;
    }

    private synchronized MathTransform transform() {
        String string = this.projection;
        if (string != null) {
            this.projection = null;
            MathTransformFactory mathTransformFactory = DefaultFactories.forClass(MathTransformFactory.class);
            if (mathTransformFactory != null) {
                try {
                    ParameterValueGroup parameterValueGroup = mathTransformFactory.getDefaultParameters(string);
                    parameterValueGroup.parameter("semi_major").setValue(6371007.0);
                    parameterValueGroup.parameter("semi_minor").setValue(6371007.0);
                    this.transform = mathTransformFactory.createParameterizedTransform(parameterValueGroup);
                }
                catch (FactoryException factoryException) {
                    Linearizer.warning(factoryException);
                }
            }
        }
        return this.transform;
    }

    static void applyTo(Set<Linearizer> set, MathTransformFactory mathTransformFactory, LocalizationGridBuilder localizationGridBuilder, Axis ... axisArray) {
        int n = -1;
        int n2 = -1;
        int n3 = axisArray.length;
        while (--n3 >= 0) {
            switch (axisArray[n3].abbreviation) {
                case '\u03bb': {
                    n = n3;
                    break;
                }
                case '\u03c6': {
                    n2 = n3;
                }
            }
        }
        if (n >= 0 && n2 >= 0) {
            HashMap<String, MathTransform> hashMap = new HashMap<String, MathTransform>();
            for (Linearizer linearizer : set) {
                MathTransform mathTransform;
                switch (linearizer) {
                    default: {
                        mathTransform = linearizer.transform();
                        break;
                    }
                    case GROUND_TRACK: {
                        int n4 = axisArray[n2].getMainDirection();
                        n4 ^= 1;
                        try {
                            mathTransform = SatelliteGroundTrack.create(mathTransformFactory, localizationGridBuilder, n, n4);
                        }
                        catch (TransformException | FactoryException exception) {
                            mathTransform = null;
                            Linearizer.warning(exception);
                        }
                        break;
                    }
                }
                if (mathTransform == null) continue;
                hashMap.put(linearizer.name(), mathTransform);
            }
            localizationGridBuilder.addLinearizers(hashMap, n, n2);
        }
    }

    private static void warning(Exception exception) {
        Logging.unexpectedException(Logging.getLogger("org.apache.sis.storage.netcdf"), Variable.class, "getGridGeometry", exception);
    }
}

